/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.api.DelegationState;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class ResolveTaskAssigneeCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;

    public ResolveTaskAssigneeCmd(String taskId, Map<String, Object> variables) {
        super(taskId);
        this.variables = variables;
    }

    public ResolveTaskAssigneeCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.variables != null) {
            task.setVariables(this.variables);
        }
        if (this.transientVariables != null) {
            task.setTransientVariables(this.transientVariables);
        }
        task.setDelegationState(DelegationState.RESOLVED);
        CommandContextUtil.getTaskServiceConfiguration().getInternalHistoryTaskManager().recordTaskInfoChange(task, this.getClock().getCurrentTime());
        return null;
    }

    protected Clock getClock() {
        return CommandContextUtil.getTaskServiceConfiguration().getClock();
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot resolve a suspended task";
    }
}

