/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.common;

import com.a1bpm.model.ExtA1UserRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.condition.PanguGroovyConditionCmd;
import org.flowable.uc.ConditionScriptService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class UserOperateUtils {
    public List<String> operateUser(List<ExtA1UserRule> extA1UserRules, DelegateExecution execution) {
        ArrayList<String> users = new ArrayList();
        if (extA1UserRules != null) {
            for (ExtA1UserRule extA1UserRule : extA1UserRules) {
                this.operateUsers(extA1UserRule, users, execution);
            }
        }
        users = users.stream().distinct().collect(Collectors.toList());
        return users;
    }

    public void operateUsers(ExtA1UserRule extA1UserRule, List<String> users, DelegateExecution execution) {
        String logicCal = extA1UserRule.getLogicCal();
        if (extA1UserRule.getRuleId().equals("spec")) {
            this.genareateSpecUsers(extA1UserRule, users);
        } else if (extA1UserRule.getPluginType().equals("position")) {
            this.genareatePositionUsers(extA1UserRule, users);
        } else if (extA1UserRule.getPluginType().equals("org")) {
            this.genareateOrgUsers(extA1UserRule, users);
        } else if (extA1UserRule.getPluginType().equals("job")) {
            this.genareateJobUsers(extA1UserRule, users);
        } else if (extA1UserRule.getPluginType().equals("role")) {
            this.genareateRoleUsers(extA1UserRule, users);
        } else if (extA1UserRule.getPluginType().equals("script")) {
            this.genareateScriptUsers(extA1UserRule, users, execution);
        }
    }

    private List<String> genareateScriptUsers(ExtA1UserRule extA1UserRule, List<String> users, DelegateExecution delegateExecution) {
        String logicCal;
        String pluginVal = extA1UserRule.getPluginVal();
        Object o = null;
        try {
            o = this.managementService().executeCommand(new PanguGroovyConditionCmd(pluginVal, delegateExecution, delegateExecution.getVariables(), null, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (o instanceof List) {
            List list = (List)o;
            for (Object obj : list) {
                if (!(obj instanceof String)) continue;
                String str = (String)obj;
                userIds.add(str);
            }
        }
        if ((logicCal = extA1UserRule.getLogicCal()).equals("or") || logicCal.equals("")) {
            users.addAll(userIds);
        } else if (logicCal.equals("exclude")) {
            users.removeAll(userIds);
        }
        return users;
    }

    public static ConditionScriptService getConditionScriptService() {
        ApplicationContext applicationContext;
        Map sqlListeners;
        Map beansMap = CommandContextUtil.getProcessEngineConfiguration().getBeans();
        SpringBeanFactoryProxyMap springBeanFactoryProxyMap = (SpringBeanFactoryProxyMap)beansMap;
        BeanFactory beanFactory = springBeanFactoryProxyMap.getBeanFactory();
        if (beanFactory instanceof ApplicationContext && (sqlListeners = (applicationContext = (ApplicationContext)beanFactory).getBeansOfType(ConditionScriptService.class)) != null) {
            Map stringObjectMap = sqlListeners;
            for (Map.Entry entry : stringObjectMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof ConditionScriptService)) continue;
                ConditionScriptService conditionScriptService = (ConditionScriptService)value;
                return conditionScriptService;
            }
        }
        return null;
    }

    private List<String> genareateRoleUsers(ExtA1UserRule extA1UserRule, List<String> users) {
        String ruleVal = extA1UserRule.getSpecId();
        ConditionScriptService conditionScriptService = UserOperateUtils.getConditionScriptService();
        if (StringUtils.isNotEmpty((CharSequence)ruleVal)) {
            List<String> JobCodeList = Arrays.asList(ruleVal.split(","));
            List userIds = conditionScriptService.getUcUserByRoleCodeIds(JobCodeList);
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            String logicCal = extA1UserRule.getLogicCal();
            if (logicCal.equals("or") || logicCal.equals("")) {
                users.addAll(userIds);
            } else if (logicCal.equals("exclude")) {
                users.removeAll(userIds);
            }
        }
        return users;
    }

    private List<String> genareateJobUsers(ExtA1UserRule extA1UserRule, List<String> users) {
        String ruleVal = extA1UserRule.getSpecId();
        ConditionScriptService conditionScriptService = UserOperateUtils.getConditionScriptService();
        if (StringUtils.isNotEmpty((CharSequence)ruleVal)) {
            List<String> JobCodeList = Arrays.asList(ruleVal.split(","));
            List userIds = conditionScriptService.getUcUserByJobCodeIds(JobCodeList);
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            String logicCal = extA1UserRule.getLogicCal();
            if (logicCal.equals("or") || logicCal.equals("")) {
                users.addAll(userIds);
            } else if (logicCal.equals("exclude")) {
                users.removeAll(userIds);
            }
        }
        return users;
    }

    public List<String> genareateSpecUsers(ExtA1UserRule extA1UserRule, List<String> users) {
        String ruleVal = extA1UserRule.getSpecId();
        if (StringUtils.isNotEmpty((CharSequence)ruleVal)) {
            List<String> list = Arrays.asList(ruleVal.split(","));
            String logicCal = extA1UserRule.getLogicCal();
            if (logicCal.equals("or") || logicCal.equals("")) {
                users.addAll(list);
            } else if (logicCal.equals("exclude")) {
                users.removeAll(list);
            }
        }
        return users;
    }

    private List<String> genareatePositionUsers(ExtA1UserRule extA1UserRule, List<String> users) {
        String ruleVal = extA1UserRule.getSpecId();
        ConditionScriptService conditionScriptService = UserOperateUtils.getConditionScriptService();
        if (StringUtils.isNotEmpty((CharSequence)ruleVal)) {
            List<String> postCodeList = Arrays.asList(ruleVal.split(","));
            List userIds = conditionScriptService.getUcUserByPostCodeIds(postCodeList);
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            String logicCal = extA1UserRule.getLogicCal();
            if (logicCal.equals("or") || logicCal.equals("")) {
                users.addAll(userIds);
            } else if (logicCal.equals("exclude")) {
                users.removeAll(userIds);
            }
        }
        return users;
    }

    public ManagementService managementService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        ManagementService managementService = currentEngineConfiguration.getManagementService();
        return managementService;
    }

    private List<String> genareateOrgUsers(ExtA1UserRule extA1UserRule, List<String> users) {
        String ruleVal = extA1UserRule.getSpecId();
        ConditionScriptService conditionScriptService = UserOperateUtils.getConditionScriptService();
        if (StringUtils.isNotEmpty((CharSequence)ruleVal)) {
            List<String> orgCodesList = Arrays.asList(ruleVal.split(","));
            List userIds = conditionScriptService.getUcUserByOrgCodeList(orgCodesList);
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            String logicCal = extA1UserRule.getLogicCal();
            if (logicCal.equals("or") || logicCal.equals("")) {
                users.addAll(userIds);
            } else if (logicCal.equals("exclude")) {
                users.removeAll(userIds);
            }
        }
        return users;
    }
}

