/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.el;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtil {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy-MM");

    public static String format(Object value) {
        String formattedString = null;
        if (value instanceof Date) {
            Date date = (Date)value;
            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
            DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)CommandContextUtil.getProcessEngineConfiguration().getClock().getCurrentTimeZone());
            formattedString = fmt.print((ReadableInstant)new DateTime((Object)date, dateTimeZone));
        } else {
            formattedString = value.toString();
        }
        return formattedString;
    }

    public static String getCurrentDate(Object value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(value.toString());
        return dateFormat.format(new Date());
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, null);
    }

    public static String formatDate(Date date, String defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        return dateFormat.format(date);
    }
}

