/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.TaskService;
import org.flowable.engine.api.BizBpmApi;
import org.flowable.engine.batch.task.BatchTaskManager;
import org.flowable.engine.batch.task.TaskDataEntity;
import org.flowable.engine.batch.task.TaskEntityDocumentImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.jobexecutor.AbstractProcessInstanceMigrationJobHandler;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.migration.ProcessInstanceBatchMigrationResult;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class BatchCompleteTaskJobHandler
extends AbstractProcessInstanceMigrationJobHandler {
    public static final String TYPE = "process-task-batch-complete-status";
    ObjectMapper objectMapper = new ObjectMapper();

    public String getType() {
        return TYPE;
    }

    public String getDes() {
        return "\u4efb\u52a1\u6279\u91cf\u5b8c\u6210\u63d2\u4ef6";
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        BatchService batchService = CommandContextUtil.getBatchService(commandContext);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        TaskService taskService = processEngineConfiguration.getTaskService();
        BatchTaskManager batchTaskManager = processEngineConfiguration.getBatchTaskManager();
        String batchPartId = BatchCompleteTaskJobHandler.getBatchPartIdFromHandlerCfg(configuration);
        BatchPart batchPart = batchService.getBatchPart(batchPartId);
        if (batchPart == null) {
            return;
        }
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        String batchDocumentJson = batch.getBatchDocumentJson();
        TaskEntityDocumentImpl taskEntityDocument = (TaskEntityDocumentImpl)JSON.parseObject((String)batchDocumentJson, TaskEntityDocumentImpl.class);
        List<TaskDataEntity> taskIdList = taskEntityDocument.getTaskId();
        String userId = taskEntityDocument.getUserId();
        String userName = taskEntityDocument.getUserName();
        String exceptionMessage = null;
        if (taskIdList != null) {
            try {
                ApplicationContext applicationContext;
                Map beansOfType;
                BizBpmApi bizBpmApi = null;
                Map beansMap = CommandContextUtil.getProcessEngineConfiguration().getBeans();
                SpringBeanFactoryProxyMap springBeanFactoryProxyMap = (SpringBeanFactoryProxyMap)beansMap;
                BeanFactory beanFactory = springBeanFactoryProxyMap.getBeanFactory();
                if (beanFactory instanceof ApplicationContext && (beansOfType = (applicationContext = (ApplicationContext)beanFactory).getBeansOfType(BizBpmApi.class)) != null) {
                    for (Map.Entry entry : beansOfType.entrySet()) {
                        Object value = entry.getValue();
                        if (!(value instanceof BizBpmApi)) continue;
                        bizBpmApi = (BizBpmApi)value;
                    }
                }
                if (bizBpmApi != null) {
                    for (TaskDataEntity td : taskIdList) {
                        String taskId = td.getId();
                        if (!StringUtils.isNotEmpty((CharSequence)taskId)) continue;
                        Map<String, Object> variables = taskService.getVariables(taskId);
                        Object form_data = variables.get("form_Data");
                        JsonNode jsonNode = this.objectMapper.readTree(form_data.toString());
                        variables.put("formData", jsonNode.toString());
                        bizBpmApi.completeTaskBatch(taskId, "agree", null, null, null, null, userId, userName, "agree", "", "", "50", td.getTaskTitle(), variables, null);
                    }
                }
            }
            catch (Exception e) {
                exceptionMessage = e.getMessage();
            }
        }
        String resultAsJsonString = BatchCompleteTaskJobHandler.prepareResultAsJsonString(exceptionMessage);
        if (exceptionMessage != null) {
            batchService.completeBatchPart(batchPartId, ProcessInstanceBatchMigrationResult.RESULT_FAIL, resultAsJsonString);
        } else {
            batchService.completeBatchPart(batchPartId, ProcessInstanceBatchMigrationResult.RESULT_SUCCESS, resultAsJsonString);
        }
    }

    protected static String prepareResultAsJsonString(String exceptionMessage) {
        ObjectNode objectNode = BatchCompleteTaskJobHandler.getObjectMapper().createObjectNode();
        if (exceptionMessage == null) {
            objectNode.put("resultStatus", ProcessInstanceBatchMigrationResult.RESULT_SUCCESS);
        } else {
            objectNode.put("resultStatus", ProcessInstanceBatchMigrationResult.RESULT_FAIL);
            objectNode.put("resultMessage", exceptionMessage);
        }
        return objectNode.toString();
    }
}

