/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.jobexecutor.AbstractProcessInstanceMigrationJobHandler;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.migration.ProcessInstanceBatchMigrationResult;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class ProcessInstanceMigrationStatusJobHandler
extends AbstractProcessInstanceMigrationJobHandler {
    public static final String TYPE = "process-migration-status";

    public String getType() {
        return TYPE;
    }

    public String getDes() {
        return "BPM\u6d41\u7a0b\u5b9e\u4f8b\u8fc1\u79fb";
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        BatchService batchService = CommandContextUtil.getBatchService(commandContext);
        String batchId = ProcessInstanceMigrationStatusJobHandler.getBatchIdFromHandlerCfg(configuration);
        Batch batch = batchService.getBatch(batchId);
        List batchParts = batchService.findBatchPartsByBatchId(batchId);
        int completedBatchParts = 0;
        int failedBatchParts = 0;
        for (BatchPart batchPart : batchParts) {
            if (batchPart.getCompleteTime() == null) continue;
            ++completedBatchParts;
            if (!ProcessInstanceBatchMigrationResult.RESULT_FAIL.equals(batchPart.getStatus())) continue;
            ++failedBatchParts;
        }
        if (completedBatchParts == batchParts.size()) {
            this.updateBatchStatus(batch, ProcessInstanceBatchMigrationResult.STATUS_COMPLETED, batchService);
            job.setRepeat(null);
        } else if (batchParts.size() == 0) {
            this.updateBatchStatus(batch, "No batch parts", batchService);
            job.setRepeat(null);
        } else {
            int completedPercentage = completedBatchParts / batchParts.size() * 100;
            this.updateBatchStatus(batch, completedPercentage + "% completed, " + failedBatchParts + " failed", batchService);
        }
    }

    protected void updateBatchStatus(Batch batch, String status, BatchService batchService) {
        ((BatchEntity)batch).setStatus(ProcessInstanceBatchMigrationResult.STATUS_COMPLETED);
        batchService.updateBatch(batch);
    }
}

