/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.flowable.engine.impl.jobexecutor.TimerChangeProcessDefinitionSuspensionStateJobHandler;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class TimerSuspendProcessDefinitionHandler
extends TimerChangeProcessDefinitionSuspensionStateJobHandler {
    public static final String TYPE = "suspend-processdefinition";

    public String getType() {
        return TYPE;
    }

    public String getDes() {
        return "\u6302\u8d77\u6d41\u7a0b\u5b9a\u4e49";
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        boolean suspendProcessInstances = false;
        try {
            JsonNode configNode = processEngineConfiguration.getObjectMapper().readTree(configuration);
            suspendProcessInstances = TimerSuspendProcessDefinitionHandler.getIncludeProcessInstances(configNode);
        }
        catch (Exception e) {
            throw new FlowableException("Error reading json value " + configuration, (Throwable)e);
        }
        String processDefinitionId = job.getProcessDefinitionId();
        SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionId, null, suspendProcessInstances, null, job.getTenantId());
        suspendProcessDefinitionCmd.execute(commandContext);
    }
}

