/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ReceiveTask;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.ProcessInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.dynamic.AbstractDynamicStateManager;
import org.flowable.engine.impl.dynamic.MoveExecutionEntityContainer;
import org.flowable.engine.impl.dynamic.ProcessInstanceChangeState;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.jobexecutor.ProcessInstanceMigrationJobHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.runtime.ChangeActivityStateBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.migration.ActivityMigrationMapping;
import org.flowable.engine.migration.ProcessInstanceBatchMigrationResult;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationManager;
import org.flowable.engine.migration.ProcessInstanceMigrationValidationResult;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class ProcessInstanceMigrationManagerImpl
extends AbstractDynamicStateManager
implements ProcessInstanceMigrationManager {
    Predicate<ExecutionEntity> isSubProcessExecution = executionEntity -> executionEntity.getCurrentFlowElement() instanceof SubProcess;
    Predicate<ExecutionEntity> isBoundaryEventExecution = executionEntity -> executionEntity.getCurrentFlowElement() instanceof BoundaryEvent;
    Predicate<ExecutionEntity> isCallActivityExecution = executionEntity -> executionEntity.getCurrentFlowElement() instanceof CallActivity;
    Predicate<ExecutionEntity> isActiveExecution = DelegateExecution::isActive;
    Predicate<ExecutionEntity> executionHasCurrentActivityId = executionEntity -> executionEntity.getCurrentActivityId() != null;

    @Override
    public ProcessInstanceMigrationValidationResult validateMigrateProcessInstancesOfProcessDefinition(String procDefKey, int procDefVer, String procDefTenantId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ProcessDefinition processDefinition = this.resolveProcessDefinition(procDefKey, procDefVer, procDefTenantId, commandContext);
        return this.validateMigrateProcessInstancesOfProcessDefinition(processDefinition.getId(), document, commandContext);
    }

    @Override
    public ProcessInstanceMigrationValidationResult validateMigrateProcessInstancesOfProcessDefinition(String processDefinitionId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ProcessInstanceMigrationValidationResult validationResult = new ProcessInstanceMigrationValidationResult();
        ProcessDefinition processDefinition = this.resolveProcessDefinition(document, commandContext);
        if (processDefinition == null) {
            validationResult.addValidationMessage("Cannot find the process definition to migrate to " + this.printProcessDefinitionIdentifierMessage(document));
        } else {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId());
            if (bpmnModel == null) {
                validationResult.addValidationMessage("Cannot find the Bpmn model of the process definition to migrate to, with " + this.printProcessDefinitionIdentifierMessage(document));
            } else {
                BpmnModel newModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId());
                ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
                List<ProcessInstance> processInstances = executionEntityManager.findProcessInstanceByQueryCriteria(new ProcessInstanceQueryImpl().processDefinitionId(processDefinitionId));
                for (ProcessInstance processInstance : processInstances) {
                    this.doValidateProcessInstanceMigration(processInstance.getId(), processDefinition.getTenantId(), newModel, document, validationResult, commandContext);
                }
            }
        }
        return validationResult;
    }

    @Override
    public ProcessInstanceMigrationValidationResult validateMigrateProcessInstance(String processInstanceId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ProcessInstanceMigrationValidationResult validationResult = new ProcessInstanceMigrationValidationResult();
        ProcessDefinition processDefinition = this.resolveProcessDefinition(document, commandContext);
        if (processDefinition == null) {
            validationResult.addValidationMessage("Cannot find the process definition to migrate to, with " + this.printProcessDefinitionIdentifierMessage(document));
        } else {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId());
            if (bpmnModel == null) {
                validationResult.addValidationMessage("Cannot find the Bpmn model of the process definition to migrate to, with " + this.printProcessDefinitionIdentifierMessage(document));
            } else {
                this.doValidateProcessInstanceMigration(processInstanceId, processDefinition.getTenantId(), bpmnModel, document, validationResult, commandContext);
            }
        }
        return validationResult;
    }

    protected void doValidateProcessInstanceMigration(String processInstanceId, String tenantId, BpmnModel newModel, ProcessInstanceMigrationDocument document, ProcessInstanceMigrationValidationResult validationResult, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity processInstanceExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        if (processInstanceExecution == null) {
            validationResult.addValidationMessage("Cannot find process instance with id:'" + processInstanceId + "'");
            return;
        }
        this.doValidateActivityMappings(processInstanceId, document.getActivityMigrationMappings(), newModel, document, validationResult, commandContext);
    }

    protected void doValidateActivityMappings(String processInstanceId, List<ActivityMigrationMapping> activityMappings, BpmnModel newModel, ProcessInstanceMigrationDocument document, ProcessInstanceMigrationValidationResult validationResult, CommandContext commandContext) {
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity processInstanceExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        BpmnModel currentModel = ProcessDefinitionUtil.getBpmnModel(processInstanceExecution.getProcessDefinitionId());
        HashMap<String, ActivityMigrationMapping> mainProcessActivityMappingByFromActivityId = new HashMap<String, ActivityMigrationMapping>();
        HashMap<String, HashMap<String, ActivityMigrationMapping>> subProcessActivityMappingsByCallActivityIdAndFromActivityId = new HashMap<String, HashMap<String, ActivityMigrationMapping>>();
        for (ActivityMigrationMapping activityMigrationMapping : activityMappings) {
            ProcessInstanceMigrationManagerImpl.splitMigrationMappingByCallActivitySubProcessScope(activityMigrationMapping, mainProcessActivityMappingByFromActivityId, subProcessActivityMappingsByCallActivityIdAndFromActivityId);
        }
        List<ExecutionEntity> activeMainProcessExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        List mappableMainProcessExecutions = activeMainProcessExecutions.stream().filter(this.executionHasCurrentActivityId).filter(this.isActiveExecution).filter(this.isSubProcessExecution.negate()).filter(this.isBoundaryEventExecution.negate()).collect(Collectors.toList());
        for (ExecutionEntity execution : mappableMainProcessExecutions) {
            FlowElement callActivityFlowElement;
            BpmnModel mappingModel;
            ActivityMigrationMapping mapping;
            block22: {
                String executionActivityId = execution.getCurrentActivityId();
                FlowElement executionFlowElement = execution.getCurrentFlowElement();
                if (!mainProcessActivityMappingByFromActivityId.containsKey(executionActivityId)) {
                    FlowElement currentModelFlowElement;
                    Optional<String> flowElementMultiInstanceParentId;
                    if (executionFlowElement instanceof CallActivity) {
                        if (subProcessActivityMappingsByCallActivityIdAndFromActivityId.containsKey(executionActivityId)) {
                            List<ExecutionEntity> subProcessChildExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getSubProcessInstance().getId());
                            Set childSubProcessExecutionActivityIds = subProcessChildExecutions.stream().map(Execution::getActivityId).collect(Collectors.toSet());
                            Set<String> mappedSubProcessActivityIds = subProcessActivityMappingsByCallActivityIdAndFromActivityId.get(executionActivityId).keySet();
                            childSubProcessExecutionActivityIds.removeAll(mappedSubProcessActivityIds);
                            boolean childrenFullyMapped = childSubProcessExecutionActivityIds.isEmpty();
                            if (childrenFullyMapped) continue;
                            FlowElement newModelFlowElement = newModel.getFlowElement(executionActivityId);
                            if (newModelFlowElement == null) {
                                validationResult.addValidationMessage(String.format("Incomplete migration mapping for call activity. The call activity '%s' does not exist in the new model. Running subProcess activities '%s' should also be mapped for migration (or the call activity itself)", executionActivityId, childSubProcessExecutionActivityIds));
                                continue;
                            }
                            if (newModelFlowElement instanceof CallActivity) {
                                if (!this.referToSameCalledElement((CallActivity)executionFlowElement, (CallActivity)newModelFlowElement)) {
                                    validationResult.addValidationMessage(String.format("Incomplete migration mapping for call activity. The call activity '%s' called element is different in the new model. Running subProcess activities '%s' should also be mapped for migration (or the call activity itself)", executionActivityId, childSubProcessExecutionActivityIds));
                                }
                                if (!(((CallActivity)executionFlowElement).hasMultiInstanceLoopCharacteristics() ^ ((CallActivity)newModelFlowElement).hasMultiInstanceLoopCharacteristics())) continue;
                                validationResult.addValidationMessage(String.format("Incomplete migration mapping for call activity. The Call activity '%s' loop characteristics is different in new model. Running subProcess activities '%s' should also be mapped for migration (or the call activity itself)", executionActivityId, childSubProcessExecutionActivityIds));
                                continue;
                            }
                            validationResult.addValidationMessage(String.format("Incomplete migration mapping for call activity. Activity '%s' is not a Call Activity in the new model.Running subProcess activities '%s' should also be mapped for migration (or the call activity itself)", executionActivityId, childSubProcessExecutionActivityIds));
                            continue;
                        }
                        FlowElement newModelFlowElement = newModel.getFlowElement(executionActivityId);
                        if (newModelFlowElement == null) {
                            validationResult.addValidationMessage("Call activity '" + executionActivityId + "' does not exist in the new model. It must be mapped explicitly for migration (or all its child activities)");
                            continue;
                        }
                        if (newModelFlowElement instanceof CallActivity) {
                            if (!this.referToSameCalledElement((CallActivity)executionFlowElement, (CallActivity)newModelFlowElement)) {
                                validationResult.addValidationMessage("Call activity '" + executionActivityId + "' has a different called element in the new model. It must be mapped explicitly for migration (or all its child activities)");
                            }
                            if (!(((CallActivity)executionFlowElement).hasMultiInstanceLoopCharacteristics() ^ ((CallActivity)newModelFlowElement).hasMultiInstanceLoopCharacteristics())) continue;
                            validationResult.addValidationMessage("Call activity '" + executionActivityId + "' has a different loop characteristics is different in new model. It must be mapped explicitly for migration (or all its child activities)");
                            continue;
                        }
                        validationResult.addValidationMessage("Call activity '" + executionActivityId + "' is not a Call Activity in the new model. It must be mapped explicitly for migration (or all its child activities)");
                        continue;
                    }
                    if (!(this.isActivityIdInProcessDefinitionModel(executionActivityId, newModel) || (flowElementMultiInstanceParentId = this.getFlowElementMultiInstanceParentId(currentModelFlowElement = currentModel.getFlowElement(executionActivityId))).isPresent() && mainProcessActivityMappingByFromActivityId.containsKey(flowElementMultiInstanceParentId.get()))) {
                        validationResult.addValidationMessage("Process instance (id:'" + processInstanceId + "') has a running Activity (id:'" + executionActivityId + "') that is not mapped for migration (Or its Multi-Instance parent)");
                        continue;
                    }
                }
                if (!mainProcessActivityMappingByFromActivityId.containsKey(executionActivityId)) continue;
                mapping = mainProcessActivityMappingByFromActivityId.get(executionActivityId);
                mappingModel = newModel;
                if (mapping.isToCallActivity()) {
                    callActivityFlowElement = newModel.getFlowElement(mapping.getToCallActivityId());
                    if (callActivityFlowElement instanceof CallActivity) {
                        CallActivity callActivity = (CallActivity)callActivityFlowElement;
                        String procDefKey = callActivity.getCalledElement();
                        if (this.isExpression(procDefKey)) {
                            Expression expression = expressionManager.createExpression(procDefKey);
                            try {
                                procDefKey = expression.getValue((VariableContainer)processInstanceExecution).toString();
                            }
                            catch (FlowableException e) {
                                procDefKey = document.getProcessInstanceVariables().getOrDefault(procDefKey.substring(2, procDefKey.length() - 1), procDefKey).toString();
                            }
                        }
                        try {
                            ProcessDefinition mappingProcDef = this.resolveProcessDefinition(procDefKey, mapping.getCallActivityProcessDefinitionVersion(), document.getMigrateToProcessDefinitionTenantId(), commandContext);
                            mappingModel = ProcessDefinitionUtil.getBpmnModel(mappingProcDef.getId());
                            break block22;
                        }
                        catch (FlowableException e) {
                            validationResult.addValidationMessage(e.getMessage() + " for call activity element with id '" + mapping.getToCallActivityId() + "' in the process definition with id '" + mappingModel.getMainProcess().getId() + "'");
                            continue;
                        }
                    }
                    validationResult.addValidationMessage("There's no call activity element with id '" + mapping.getToCallActivityId() + "' in the process definition with id '" + mappingModel.getMainProcess().getId() + "'");
                    continue;
                }
            }
            if (mapping.isToParentProcess()) {
                callActivityFlowElement = newModel.getFlowElement(mapping.getToCallActivityId());
                throw new UnsupportedOperationException("Not implemented yet!!!");
            }
            List<String> toActivityIds = mapping.getToActivityIds();
            for (String targetActivityId : toActivityIds) {
                if (!this.isActivityIdInProcessDefinitionModel(targetActivityId, mappingModel)) {
                    validationResult.addValidationMessage("Invalid mapping for '" + execution.getCurrentActivityId() + "' to '" + targetActivityId + "', cannot be found in the process definition with id '" + mappingModel.getMainProcess().getId() + "'");
                    continue;
                }
                FlowElement targetFlowElement = mappingModel.getFlowElement(targetActivityId);
                Optional<String> targetFlowElementMultiInstanceParentId = this.getFlowElementMultiInstanceParentId(targetFlowElement);
                if (!targetFlowElementMultiInstanceParentId.isPresent()) continue;
                validationResult.addValidationMessage("Invalid mapping for '" + execution.getCurrentActivityId() + "' to '" + targetActivityId + "', cannot migrate arbitrarily inside a Multi Instance container '" + targetFlowElementMultiInstanceParentId.get() + "' inside process definition with id '" + mappingModel.getMainProcess().getId() + "'");
            }
        }
    }

    @Override
    public Batch batchMigrateProcessInstancesOfProcessDefinition(String procDefKey, int procDefVer, String procDefTenantId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ProcessDefinition processDefinition = this.resolveProcessDefinition(procDefKey, procDefVer, procDefTenantId, commandContext);
        return this.batchMigrateProcessInstancesOfProcessDefinition(processDefinition.getId(), document, commandContext);
    }

    @Override
    public Batch batchMigrateProcessInstancesOfProcessDefinition(String sourceProcDefId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ProcessDefinition targetProcessDefinition = this.resolveProcessDefinition(document, commandContext);
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        List<ProcessInstance> processInstances = executionEntityManager.findProcessInstanceByQueryCriteria(new ProcessInstanceQueryImpl().processDefinitionId(sourceProcDefId));
        BatchService batchService = CommandContextUtil.getBatchService(commandContext);
        Batch batch = batchService.createBatchBuilder().batchType("processMigration").searchKey(sourceProcDefId).searchKey2(targetProcessDefinition.getId()).status(ProcessInstanceBatchMigrationResult.STATUS_IN_PROGRESS).batchDocumentJson(document.asJsonString()).create();
        JobService jobService = CommandContextUtil.getJobService(commandContext);
        for (ProcessInstance processInstance : processInstances) {
            BatchPart batchPart = batchService.createBatchPart(batch, ProcessInstanceBatchMigrationResult.STATUS_WAITING, processInstance.getId(), null, "bpmn");
            JobEntity job = jobService.createJob();
            job.setJobHandlerType("process-migration");
            job.setProcessInstanceId(processInstance.getId());
            job.setJobHandlerConfiguration(ProcessInstanceMigrationJobHandler.getHandlerCfgForBatchPartId(batchPart.getId()));
            jobService.createAsyncJob(job, false);
            jobService.scheduleAsyncJob(job);
        }
        if (!processInstances.isEmpty()) {
            TimerJobService timerJobService = CommandContextUtil.getTimerJobService(commandContext);
            TimerJobEntity timerJob = timerJobService.createTimerJob();
            timerJob.setJobType("timer");
            timerJob.setRevision(1);
            timerJob.setJobHandlerType("process-migration-status");
            timerJob.setJobHandlerConfiguration(ProcessInstanceMigrationJobHandler.getHandlerCfgForBatchId(batch.getId()));
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            BusinessCalendar businessCalendar = processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
            timerJob.setDuedate(businessCalendar.resolveDuedate(processEngineConfiguration.getBatchStatusTimeCycleConfig()));
            timerJob.setRepeat(processEngineConfiguration.getBatchStatusTimeCycleConfig());
            timerJobService.scheduleTimerJob(timerJob);
        }
        return batch;
    }

    @Override
    public void migrateProcessInstancesOfProcessDefinition(String procDefKey, int procDefVer, String procDefTenantId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ProcessDefinition processDefinition = this.resolveProcessDefinition(procDefKey, procDefVer, procDefTenantId, commandContext);
        this.migrateProcessInstancesOfProcessDefinition(processDefinition.getId(), document, commandContext);
    }

    @Override
    public void migrateProcessInstancesOfProcessDefinition(String processDefinitionId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ProcessDefinition processDefinition = this.resolveProcessDefinition(document, commandContext);
        if (processDefinition == null) {
            throw new FlowableException("Cannot find the process definition to migrate to, identified by " + this.printProcessDefinitionIdentifierMessage(document));
        }
        ProcessInstanceQueryImpl processInstanceQueryByProcessDefinitionId = new ProcessInstanceQueryImpl().processDefinitionId(processDefinitionId);
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        List<ProcessInstance> processInstances = executionEntityManager.findProcessInstanceByQueryCriteria(processInstanceQueryByProcessDefinitionId);
        for (ProcessInstance processInstance : processInstances) {
            this.doMigrateProcessInstance(processInstance, processDefinition, document, commandContext);
        }
    }

    @Override
    public void migrateProcessInstance(String processInstanceId, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity processExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        if (processExecution == null) {
            throw new FlowableException("Cannot find the process to migrate, with id" + processInstanceId);
        }
        ProcessDefinition procDefToMigrateTo = this.resolveProcessDefinition(document, commandContext);
        this.doMigrateProcessInstance(processExecution, procDefToMigrateTo, document, commandContext);
    }

    protected void doMigrateProcessInstance(ProcessInstance processInstance, ProcessDefinition procDefToMigrateTo, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        this.LOGGER.debug("Start migration of process instance with Id:'" + processInstance.getId() + "' to process definition identified by " + this.printProcessDefinitionIdentifierMessage(document));
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        List<ChangeActivityStateBuilderImpl> changeActivityStateBuilders = this.prepareChangeStateBuilders((ExecutionEntity)processInstance, procDefToMigrateTo, document, commandContext);
        this.LOGGER.debug("Updating Process definition reference of process root execution with id:'{}' to '{}'", (Object)processInstance.getId(), (Object)procDefToMigrateTo.getId());
        ((ExecutionEntity)processInstance).setProcessDefinitionId(procDefToMigrateTo.getId());
        this.LOGGER.debug("Resolve activity executions to migrate");
        ArrayList<MoveExecutionEntityContainer> moveExecutionEntityContainerList = new ArrayList<MoveExecutionEntityContainer>();
        for (ChangeActivityStateBuilderImpl builder : changeActivityStateBuilders) {
            moveExecutionEntityContainerList.addAll(this.resolveMoveExecutionEntityContainers(builder, Optional.of(procDefToMigrateTo.getId()), document.getProcessInstanceVariables(), commandContext));
        }
        ProcessInstanceChangeState processInstanceChangeState = new ProcessInstanceChangeState().setProcessInstanceId(processInstance.getId()).setProcessDefinitionToMigrateTo(procDefToMigrateTo).setMoveExecutionEntityContainers(moveExecutionEntityContainerList).setProcessInstanceVariables(document.getProcessInstanceVariables()).setLocalVariables(document.getActivitiesLocalVariables());
        this.doMoveExecutionState(processInstanceChangeState, commandContext);
        this.LOGGER.debug("Updating Process definition of unchanged call activity");
        List<ExecutionEntity> callActivities = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstance.getId()).stream().filter(executionEntity -> executionEntity.getCurrentFlowElement() instanceof CallActivity).collect(Collectors.toList());
        callActivities.forEach(executionEntity -> executionEntity.setProcessDefinitionId(procDefToMigrateTo.getId()));
        this.LOGGER.debug("Updating process definition reference in activity instances");
        CommandContextUtil.getActivityInstanceEntityManager().updateActivityInstancesProcessDefinitionId(procDefToMigrateTo.getId(), processInstance.getId());
        this.LOGGER.debug("Updating Process definition reference in history");
        this.changeProcessDefinitionReferenceOfHistory(processInstance, procDefToMigrateTo, commandContext);
        this.LOGGER.debug("Process migration ended for process instance with Id:'{}'", (Object)processInstance.getId());
    }

    @Override
    protected Map<String, List<ExecutionEntity>> resolveActiveEmbeddedSubProcesses(String processInstanceId, CommandContext commandContext) {
        return Collections.emptyMap();
    }

    @Override
    protected boolean isDirectFlowElementExecutionMigration(FlowElement currentFlowElement, FlowElement newFlowElement) {
        return (currentFlowElement instanceof UserTask && newFlowElement instanceof UserTask || currentFlowElement instanceof ReceiveTask && newFlowElement instanceof ReceiveTask) && ((Task)currentFlowElement).getLoopCharacteristics() == null && !this.getFlowElementMultiInstanceParentId(currentFlowElement).isPresent() && ((Task)newFlowElement).getLoopCharacteristics() == null && !this.getFlowElementMultiInstanceParentId(newFlowElement).isPresent();
    }

    protected List<ChangeActivityStateBuilderImpl> prepareChangeStateBuilders(ExecutionEntity processInstanceExecution, ProcessDefinition procDefToMigrateTo, ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        ArrayList<String> executionIds;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        String procDefTenantId = procDefToMigrateTo.getTenantId();
        if (!this.isSameTenant(processInstanceExecution.getTenantId(), procDefTenantId)) {
            throw new FlowableException("Tenant mismatch between Process Instance ('" + processInstanceExecution.getTenantId() + "') and Process Definition ('" + procDefTenantId + "') to migrate to");
        }
        ArrayList<ChangeActivityStateBuilderImpl> changeActivityStateBuilders = new ArrayList<ChangeActivityStateBuilderImpl>();
        ChangeActivityStateBuilderImpl mainProcessChangeActivityStateBuilder = new ChangeActivityStateBuilderImpl();
        mainProcessChangeActivityStateBuilder.processInstanceId(processInstanceExecution.getId());
        changeActivityStateBuilders.add(mainProcessChangeActivityStateBuilder);
        Map<String, List<ExecutionEntity>> filteredExecutionsByActivityId = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceExecution.getId()).stream().filter(executionEntity -> executionEntity.getCurrentActivityId() != null).filter(executionEntity -> !(executionEntity.getCurrentFlowElement() instanceof SubProcess)).filter(executionEntity -> !(executionEntity.getCurrentFlowElement() instanceof BoundaryEvent)).collect(Collectors.groupingBy(DelegateExecution::getCurrentActivityId));
        this.LOGGER.debug("Preparing ActivityChangeState builder for '{}' distinct activities", (Object)filteredExecutionsByActivityId.size());
        HashMap<String, ActivityMigrationMapping> mainProcessActivityMappingByFromActivityId = new HashMap<String, ActivityMigrationMapping>();
        HashMap<String, HashMap<String, ActivityMigrationMapping>> subProcessActivityMappingsByCallActivityIdAndFromActivityId = new HashMap<String, HashMap<String, ActivityMigrationMapping>>();
        for (ActivityMigrationMapping activityMigrationMapping : document.getActivityMigrationMappings()) {
            ProcessInstanceMigrationManagerImpl.splitMigrationMappingByCallActivitySubProcessScope(activityMigrationMapping, mainProcessActivityMappingByFromActivityId, subProcessActivityMappingsByCallActivityIdAndFromActivityId);
        }
        Set mappedFromActivities = mainProcessActivityMappingByFromActivityId.keySet();
        Map<Boolean, List<String>> partitionedExecutionActivityIds = filteredExecutionsByActivityId.keySet().stream().collect(Collectors.partitioningBy(mappedFromActivities::contains));
        List<String> executionActivityIdsToAutoMap = partitionedExecutionActivityIds.get(false);
        List<String> executionActivityIdsToMapExplicitly = partitionedExecutionActivityIds.get(true);
        BpmnModel newModel = ProcessDefinitionUtil.getBpmnModel(procDefToMigrateTo.getId());
        BpmnModel currentModel = ProcessDefinitionUtil.getBpmnModel(processInstanceExecution.getProcessDefinitionId());
        this.LOGGER.debug("Process AutoMapping for '{}' activity executions", (Object)executionActivityIdsToAutoMap.size());
        for (String executionActivityId : executionActivityIdsToAutoMap) {
            FlowElement newModelFlowElement;
            FlowElement currentModelFlowElement = currentModel.getFlowElement(executionActivityId);
            if (currentModelFlowElement instanceof CallActivity) {
                boolean runningChildrenNotFullyMapped = false;
                if (subProcessActivityMappingsByCallActivityIdAndFromActivityId.containsKey(executionActivityId)) {
                    Set<String> mappedSubProcessActivityIds = subProcessActivityMappingsByCallActivityIdAndFromActivityId.get(executionActivityId).keySet();
                    List callActivityExecutions = filteredExecutionsByActivityId.get(executionActivityId).stream().filter(DelegateExecution::isActive).collect(Collectors.toList());
                    for (ExecutionEntity callActivityExecution : callActivityExecutions) {
                        List<ExecutionEntity> subProcessChildExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(callActivityExecution.getSubProcessInstance().getId());
                        Set childSubProcessExecutionActivityIds = subProcessChildExecutions.stream().map(Execution::getActivityId).collect(Collectors.toSet());
                        childSubProcessExecutionActivityIds.removeAll(mappedSubProcessActivityIds);
                        if (childSubProcessExecutionActivityIds.isEmpty()) continue;
                        runningChildrenNotFullyMapped = true;
                        break;
                    }
                }
                if (subProcessActivityMappingsByCallActivityIdAndFromActivityId.containsKey(executionActivityId) && !runningChildrenNotFullyMapped) continue;
                newModelFlowElement = newModel.getFlowElement(executionActivityId);
                if (newModelFlowElement == null) {
                    throw new FlowableException("Call activity '" + executionActivityId + "' does not exist in the new model. It must be mapped explicitly for migration (or all its child activities)");
                }
                if (newModelFlowElement instanceof CallActivity) {
                    if (!this.referToSameCalledElement((CallActivity)currentModelFlowElement, (CallActivity)newModelFlowElement)) {
                        throw new FlowableException("Call activity '" + executionActivityId + "' has a different called element in the new model. It must be mapped explicitly for migration (or all its child activities)");
                    }
                    if (!(((CallActivity)currentModelFlowElement).hasMultiInstanceLoopCharacteristics() ^ ((CallActivity)newModelFlowElement).hasMultiInstanceLoopCharacteristics())) continue;
                    throw new FlowableException("Call activity '" + executionActivityId + "' loop characteristics differs in new model. It must be mapped explicitly for migration (or all its child activities)");
                }
                throw new FlowableException("Call activity '" + executionActivityId + "' is not a Call Activity in the new model. It must be mapped explicitly for migration (or all its child activities)");
            }
            Optional<String> flowElementMultiInstanceParentId = this.getFlowElementMultiInstanceParentId(currentModelFlowElement);
            if (flowElementMultiInstanceParentId.isPresent() && mappedFromActivities.contains(flowElementMultiInstanceParentId.get())) {
                if (!executionActivityIdsToMapExplicitly.contains(flowElementMultiInstanceParentId.get())) {
                    executionActivityIdsToMapExplicitly.add(flowElementMultiInstanceParentId.get());
                }
                List miRootExecutions = (List)executionEntityManager.findInactiveExecutionsByActivityIdAndProcessInstanceId(flowElementMultiInstanceParentId.get(), processInstanceExecution.getId());
                filteredExecutionsByActivityId.put(flowElementMultiInstanceParentId.get(), miRootExecutions);
                continue;
            }
            this.LOGGER.debug("Checking execution(s) - activityId:'{}", (Object)executionActivityId);
            if (this.isActivityIdInProcessDefinitionModel(executionActivityId, newModel)) {
                newModelFlowElement = newModel.getFlowElement(executionActivityId);
                Optional<String> newFlowElementMIParentId = this.getFlowElementMultiInstanceParentId(newModelFlowElement);
                if (newFlowElementMIParentId.isPresent()) {
                    throw new FlowableException("Cannot autoMap activity migration for '" + executionActivityId + "'. Cannot migrate arbitrarily inside a Multi Instance container '" + newFlowElementMIParentId.get());
                }
                this.LOGGER.debug("Auto mapping activity '{}'", (Object)executionActivityId);
                List<ExecutionEntity> executionEntities = filteredExecutionsByActivityId.get(executionActivityId);
                if (executionEntities.size() > 1) {
                    executionIds = executionEntities.stream().map(Entity::getId).collect(Collectors.toList());
                    mainProcessChangeActivityStateBuilder.moveExecutionsToSingleActivityId(executionIds, executionActivityId);
                    continue;
                }
                mainProcessChangeActivityStateBuilder.moveExecutionToActivityId(executionEntities.get(0).getId(), executionActivityId);
                continue;
            }
            throw new FlowableException("Migration Activity mapping missing for activity definition Id:'" + executionActivityId + "' or its MI Parent");
        }
        List<ActivityMigrationMapping> activityMigrationMappings = document.getActivityMigrationMappings();
        this.LOGGER.debug("Process explicit mapping for '{}' activity executions", (Object)executionActivityIdsToMapExplicitly.size());
        for (ActivityMigrationMapping activityMapping : activityMigrationMappings) {
            String fromCallActivityId;
            ChangeActivityStateBuilderImpl subProcessChangeActivityStateBuilder;
            ExecutionEntity subProcessInstanceExecution;
            List callActivityExecutions;
            String toActivityId;
            String fromActivityId;
            if (activityMapping instanceof ActivityMigrationMapping.OneToOneMapping) {
                fromActivityId = ((ActivityMigrationMapping.OneToOneMapping)activityMapping).getFromActivityId();
                toActivityId = ((ActivityMigrationMapping.OneToOneMapping)activityMapping).getToActivityId();
                String newAssignee = ((ActivityMigrationMapping.OneToOneMapping)activityMapping).getWithNewAssignee();
                String fromCallActivityId2 = activityMapping.getFromCallActivityId();
                if (activityMapping.isToParentProcess() && !executionActivityIdsToMapExplicitly.contains(fromCallActivityId2)) {
                    callActivityExecutions = filteredExecutionsByActivityId.get(fromCallActivityId2).stream().filter(DelegateExecution::isActive).collect(Collectors.toList());
                    for (ExecutionEntity callActivityExecution : callActivityExecutions) {
                        subProcessInstanceExecution = executionEntityManager.findSubProcessInstanceBySuperExecutionId(callActivityExecution.getId());
                        subProcessChangeActivityStateBuilder = new ChangeActivityStateBuilderImpl();
                        subProcessChangeActivityStateBuilder.processInstanceId(subProcessInstanceExecution.getId());
                        subProcessChangeActivityStateBuilder.moveActivityIdToParentActivityId(fromActivityId, toActivityId, newAssignee);
                        changeActivityStateBuilders.add(subProcessChangeActivityStateBuilder);
                    }
                    continue;
                }
                if (!executionActivityIdsToMapExplicitly.contains(fromActivityId)) continue;
                if (activityMapping.isToCallActivity()) {
                    mainProcessChangeActivityStateBuilder.moveActivityIdToSubProcessInstanceActivityId(fromActivityId, toActivityId, activityMapping.getToCallActivityId(), activityMapping.getCallActivityProcessDefinitionVersion(), newAssignee);
                } else {
                    mainProcessChangeActivityStateBuilder.moveActivityIdTo(fromActivityId, toActivityId, newAssignee);
                }
                executionActivityIdsToMapExplicitly.remove(fromActivityId);
                continue;
            }
            if (activityMapping instanceof ActivityMigrationMapping.OneToManyMapping) {
                fromActivityId = ((ActivityMigrationMapping.OneToManyMapping)activityMapping).getFromActivityId();
                List<String> toActivityIds = activityMapping.getToActivityIds();
                fromCallActivityId = activityMapping.getFromCallActivityId();
                if (activityMapping.isToParentProcess() && !executionActivityIdsToMapExplicitly.contains(fromCallActivityId)) {
                    List callActivityExecutions2 = filteredExecutionsByActivityId.get(fromCallActivityId).stream().filter(DelegateExecution::isActive).collect(Collectors.toList());
                    for (ExecutionEntity callActivityExecution : callActivityExecutions2) {
                        ExecutionEntity subProcessInstanceExecution2 = executionEntityManager.findSubProcessInstanceBySuperExecutionId(callActivityExecution.getId());
                        ChangeActivityStateBuilderImpl subProcessChangeActivityStateBuilder2 = new ChangeActivityStateBuilderImpl();
                        subProcessChangeActivityStateBuilder2.processInstanceId(subProcessInstanceExecution2.getId());
                        subProcessChangeActivityStateBuilder2.moveSingleActivityIdToParentActivityIds(fromActivityId, toActivityIds);
                        changeActivityStateBuilders.add(subProcessChangeActivityStateBuilder2);
                    }
                    continue;
                }
                if (!executionActivityIdsToMapExplicitly.contains(fromActivityId)) continue;
                if (activityMapping.isToCallActivity()) {
                    mainProcessChangeActivityStateBuilder.moveSingleActivityIdToSubProcessInstanceActivityIds(fromActivityId, toActivityIds, activityMapping.getToCallActivityId(), activityMapping.getCallActivityProcessDefinitionVersion());
                } else {
                    mainProcessChangeActivityStateBuilder.moveSingleActivityIdToActivityIds(fromActivityId, toActivityIds);
                }
                executionActivityIdsToMapExplicitly.remove(fromActivityId);
                continue;
            }
            if (activityMapping instanceof ActivityMigrationMapping.ManyToOneMapping) {
                List<String> fromActivityIds = activityMapping.getFromActivityIds();
                toActivityId = ((ActivityMigrationMapping.ManyToOneMapping)activityMapping).getToActivityId();
                fromCallActivityId = activityMapping.getFromCallActivityId();
                String newAssignee = ((ActivityMigrationMapping.ManyToOneMapping)activityMapping).getWithNewAssignee();
                if (activityMapping.isToParentProcess() && !executionActivityIdsToMapExplicitly.contains(fromCallActivityId)) {
                    callActivityExecutions = filteredExecutionsByActivityId.get(fromCallActivityId).stream().filter(DelegateExecution::isActive).collect(Collectors.toList());
                    for (ExecutionEntity callActivityExecution : callActivityExecutions) {
                        subProcessInstanceExecution = executionEntityManager.findSubProcessInstanceBySuperExecutionId(callActivityExecution.getId());
                        subProcessChangeActivityStateBuilder = new ChangeActivityStateBuilderImpl();
                        subProcessChangeActivityStateBuilder.processInstanceId(subProcessInstanceExecution.getId());
                        subProcessChangeActivityStateBuilder.moveActivityIdsToParentActivityId(fromActivityIds, toActivityId, newAssignee);
                        changeActivityStateBuilders.add(subProcessChangeActivityStateBuilder);
                    }
                    continue;
                }
                executionIds = new ArrayList();
                for (String activityId : fromActivityIds) {
                    if (!executionActivityIdsToMapExplicitly.contains(activityId)) continue;
                    List<ExecutionEntity> executionEntities = filteredExecutionsByActivityId.get(activityId);
                    executionIds.addAll(executionEntities.stream().map(Entity::getId).collect(Collectors.toList()));
                    executionActivityIdsToMapExplicitly.remove(activityId);
                }
                if (activityMapping.isToCallActivity()) {
                    mainProcessChangeActivityStateBuilder.moveActivityIdsToSubProcessInstanceActivityId(fromActivityIds, toActivityId, activityMapping.getToCallActivityId(), activityMapping.getCallActivityProcessDefinitionVersion(), newAssignee);
                    continue;
                }
                mainProcessChangeActivityStateBuilder.moveExecutionsToSingleActivityId(executionIds, toActivityId, newAssignee);
                continue;
            }
            throw new FlowableException("Unknown Activity Mapping or not implemented yet!!!");
        }
        if (!executionActivityIdsToMapExplicitly.isEmpty()) {
            throw new FlowableException("Migration Activity mapping missing for activity definition Ids:'" + Arrays.toString(executionActivityIdsToMapExplicitly.toArray()) + "'");
        }
        return changeActivityStateBuilders;
    }

    protected boolean isSameTenant(String tenantId1, String tenantId2) {
        if (tenantId1 != null && tenantId2 != null) {
            return tenantId1.equals(tenantId2);
        }
        return tenantId1 == null && tenantId2 == null;
    }

    protected void changeProcessDefinitionReferenceOfHistory(ProcessInstance processInstance, ProcessDefinition processDefinition, CommandContext commandContext) {
        HistoryLevel currentHistoryLevel = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoryLevel();
        if (currentHistoryLevel.isAtLeast(HistoryLevel.ACTIVITY)) {
            HistoryManager historyManager = CommandContextUtil.getHistoryManager(commandContext);
            historyManager.updateProcessDefinitionIdInHistory((ProcessDefinitionEntity)processDefinition, (ExecutionEntity)processInstance);
        }
    }

    protected ProcessDefinition resolveProcessDefinition(ProcessInstanceMigrationDocument document, CommandContext commandContext) {
        if (document.getMigrateToProcessDefinitionId() != null) {
            ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
            return (ProcessDefinition)processDefinitionEntityManager.findById(document.getMigrateToProcessDefinitionId());
        }
        return this.resolveProcessDefinition(document.getMigrateToProcessDefinitionKey(), document.getMigrateToProcessDefinitionVersion(), document.getMigrateToProcessDefinitionTenantId(), commandContext);
    }

    protected boolean isActivityIdInProcessDefinitionModel(String activityId, BpmnModel bpmnModel) {
        return bpmnModel.getFlowElement(activityId) != null;
    }

    protected String printProcessDefinitionIdentifierMessage(ProcessInstanceMigrationDocument document) {
        String id = document.getMigrateToProcessDefinitionId();
        String key = document.getMigrateToProcessDefinitionKey();
        Integer version = document.getMigrateToProcessDefinitionVersion();
        String tenantId = document.getMigrateToProcessDefinitionTenantId();
        return id != null ? "[id:'" + id + "']" : "[key:'" + key + "', version:'" + version + "', tenantId:'" + tenantId + "']";
    }

    @Override
    protected boolean isSubProcessAncestorOfAnyExecution(String subProcessId, List<ExecutionEntity> currentExecutions) {
        return false;
    }

    @Override
    protected boolean isSubProcessContainerOfAnyFlowElement(String subProcessId, Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements) {
        return false;
    }

    protected boolean referToSameCalledElement(CallActivity callActivity1, CallActivity callActivity2) {
        String calledElement2;
        String calledElement1 = callActivity1.getCalledElement();
        return calledElement1.equals(calledElement2 = callActivity2.getCalledElement()) && !this.isExpression(calledElement1);
    }

    protected static void splitMigrationMappingByCallActivitySubProcessScope(ActivityMigrationMapping activityMigrationMapping, HashMap<String, ActivityMigrationMapping> mainProcessActivityMappingByFromActivityId, HashMap<String, HashMap<String, ActivityMigrationMapping>> subProcessActivityMappingsByCallActivityIdAndFromActivityId) {
        HashMap mapToFill = activityMigrationMapping.isToParentProcess() ? subProcessActivityMappingsByCallActivityIdAndFromActivityId.computeIfAbsent(activityMigrationMapping.getFromCallActivityId(), k -> new HashMap()) : mainProcessActivityMappingByFromActivityId;
        for (String fromActivityId : activityMigrationMapping.getFromActivityIds()) {
            mapToFill.put(fromActivityId, activityMigrationMapping);
        }
    }
}

