/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.innermapper.A1FlowTaskTrajectoryEntry;
import org.flowable.common.engine.impl.innermapper.PanguFlowInstanceEntity;
import org.flowable.common.engine.impl.innermapper.nodeoperate.A1FlowProcessInstanceDao;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.common.engine.impl.util.ThreadMapUtil;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.ExecutionQueryImpl;
import org.flowable.engine.impl.ProcessInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.AbstractCustomSqlExecution;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.history.UpdateA1FlowTaskTrajectory;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.data.ExecutionDataManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.entitylink.api.EntityLinkService;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.identitylink.service.IdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.data.impl.cachematcher.IdentityLinksByProcessInstanceMatcher;
import org.flowable.job.service.JobService;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableByteArrayRef;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEntityManagerImpl
extends AbstractEntityManager<ExecutionEntity>
implements ExecutionEntityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionEntityManagerImpl.class);
    protected ExecutionDataManager executionDataManager;
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinkByProcessInstanceMatcher = new IdentityLinksByProcessInstanceMatcher();

    public ExecutionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, ExecutionDataManager executionDataManager) {
        super(processEngineConfiguration);
        this.executionDataManager = executionDataManager;
    }

    @Override
    protected DataManager<ExecutionEntity> getDataManager() {
        return this.executionDataManager;
    }

    @Override
    public void delete(ExecutionEntity entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(ExecutionEntity entity, boolean fireDeleteEvent) {
        super.delete(entity, fireDeleteEvent);
        entity.setDeleted(true);
    }

    @Override
    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return this.executionDataManager.findSubProcessInstanceBySuperExecutionId(superExecutionId);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.executionDataManager.findChildExecutionsByParentExecutionId(parentExecutionId);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        return this.executionDataManager.findChildExecutionsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByParentExecutionAndActivityIds(String parentExecutionId, Collection<String> activityIds) {
        return this.executionDataManager.findExecutionsByParentExecutionAndActivityIds(parentExecutionId, activityIds);
    }

    @Override
    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return this.executionDataManager.findExecutionCountByQueryCriteria(executionQuery);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return this.executionDataManager.findExecutionsByQueryCriteria(executionQuery);
    }

    @Override
    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.executionDataManager.findProcessInstanceCountByQueryCriteria(executionQuery);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.executionDataManager.findProcessInstanceByQueryCriteria(executionQuery);
    }

    @Override
    public ExecutionEntity findByRootProcessInstanceId(String rootProcessInstanceId) {
        List<ExecutionEntity> executions = this.executionDataManager.findExecutionsByRootProcessInstanceId(rootProcessInstanceId);
        return this.processExecutionTree(rootProcessInstanceId, executions);
    }

    protected ExecutionEntity processExecutionTree(String rootProcessInstanceId, List<ExecutionEntity> executions) {
        ExecutionEntity rootExecution = null;
        HashMap<String, ExecutionEntity> executionMap = new HashMap<String, ExecutionEntity>(executions.size());
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.getId().equals(rootProcessInstanceId)) {
                rootExecution = executionEntity;
            }
            executionMap.put(executionEntity.getId(), executionEntity);
        }
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.getRootProcessInstanceId() != null) {
                executionEntity.setRootProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getRootProcessInstanceId()));
            }
            if (executionEntity.getProcessInstanceId() != null) {
                executionEntity.setProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getProcessInstanceId()));
            }
            if (executionEntity.getParentId() != null) {
                ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getParentId());
                executionEntity.setParent(parentExecutionEntity);
                parentExecutionEntity.addChildExecution(executionEntity);
            }
            if (executionEntity.getSuperExecution() == null) continue;
            ExecutionEntity superExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getSuperExecutionId());
            executionEntity.setSuperExecution(superExecutionEntity);
            superExecutionEntity.setSubProcessInstance(executionEntity);
        }
        return rootExecution;
    }

    @Override
    public List<ProcessInstance> findProcessInstanceAndVariablesByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.executionDataManager.findProcessInstanceAndVariablesByQueryCriteria(executionQuery);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByProcessInstanceId(String processInstanceId) {
        return this.executionDataManager.findInactiveExecutionsByProcessInstanceId(processInstanceId);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByActivityIdAndProcessInstanceId(String activityId, String processInstanceId) {
        return this.executionDataManager.findInactiveExecutionsByActivityIdAndProcessInstanceId(activityId, processInstanceId);
    }

    @Override
    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap) {
        return this.executionDataManager.findExecutionsByNativeQuery(parameterMap);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap) {
        return this.executionDataManager.findProcessInstanceByNativeQuery(parameterMap);
    }

    @Override
    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.executionDataManager.findExecutionCountByNativeQuery(parameterMap);
    }

    @Override
    public ExecutionEntity createProcessInstanceExecution(ProcessDefinition processDefinition, String predefinedProcessInstanceId, String businessKey, String processInstanceName, String callbackId, String callbackType, String tenantId, String initiatorVariableName, String startActivityId) {
        ExecutionEntity processInstanceExecution = (ExecutionEntity)this.executionDataManager.create();
        if (CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally()) {
            ((CountingExecutionEntity)((Object)processInstanceExecution)).setCountEnabled(true);
        }
        if (predefinedProcessInstanceId != null) {
            processInstanceExecution.setId(predefinedProcessInstanceId);
        }
        processInstanceExecution.setProcessDefinitionId(processDefinition.getId());
        processInstanceExecution.setProcessDefinitionKey(processDefinition.getKey());
        processInstanceExecution.setProcessDefinitionName(processDefinition.getName());
        processInstanceExecution.setProcessDefinitionVersion(processDefinition.getVersion());
        processInstanceExecution.setDeploymentId(processDefinition.getDeploymentId());
        processInstanceExecution.setBusinessKey(businessKey);
        processInstanceExecution.setName(processInstanceName);
        if (callbackId != null) {
            processInstanceExecution.setCallbackId(callbackId);
        }
        if (callbackType != null) {
            processInstanceExecution.setCallbackType(callbackType);
        }
        processInstanceExecution.setScope(true);
        if (tenantId != null) {
            processInstanceExecution.setTenantId(tenantId);
        }
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        processInstanceExecution.setStartActivityId(startActivityId);
        processInstanceExecution.setStartTime(CommandContextUtil.getProcessEngineConfiguration().getClock().getCurrentTime());
        processInstanceExecution.setStartUserId(authenticatedUserId);
        this.insert(processInstanceExecution, false);
        if (initiatorVariableName != null) {
            processInstanceExecution.setVariable(initiatorVariableName, authenticatedUserId);
        }
        processInstanceExecution.setProcessInstanceId(processInstanceExecution.getId());
        processInstanceExecution.setRootProcessInstanceId(processInstanceExecution.getId());
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            processEngineConfiguration.getIdentityLinkInterceptor().handleCreateProcessInstance(processInstanceExecution);
        }
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, processInstanceExecution));
        }
        return processInstanceExecution;
    }

    @Override
    public ExecutionEntity createChildExecution(ExecutionEntity parentExecutionEntity) {
        ExecutionEntity childExecution = (ExecutionEntity)this.executionDataManager.create();
        this.inheritCommonProperties(parentExecutionEntity, childExecution);
        childExecution.setParent(parentExecutionEntity);
        childExecution.setProcessDefinitionId(parentExecutionEntity.getProcessDefinitionId());
        childExecution.setProcessDefinitionKey(parentExecutionEntity.getProcessDefinitionKey());
        childExecution.setProcessInstanceId(parentExecutionEntity.getProcessInstanceId() != null ? parentExecutionEntity.getProcessInstanceId() : parentExecutionEntity.getId());
        childExecution.setScope(false);
        parentExecutionEntity.addChildExecution(childExecution);
        this.insert(childExecution, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Child execution {} created with parent {}", (Object)childExecution, (Object)parentExecutionEntity.getId());
        }
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, childExecution));
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, childExecution));
        }
        return childExecution;
    }

    @Override
    public ExecutionEntity createSubprocessInstance(ProcessDefinition processDefinition, ExecutionEntity superExecutionEntity, String businessKey, String activityId) {
        FlowableEventDispatcher flowableEventDispatcher;
        ExecutionEntity subProcessInstance = (ExecutionEntity)this.executionDataManager.create();
        this.inheritCommonProperties(superExecutionEntity, subProcessInstance);
        subProcessInstance.setProcessDefinitionId(processDefinition.getId());
        subProcessInstance.setProcessDefinitionKey(processDefinition.getKey());
        subProcessInstance.setProcessDefinitionName(processDefinition.getName());
        subProcessInstance.setSuperExecution(superExecutionEntity);
        subProcessInstance.setRootProcessInstanceId(superExecutionEntity.getRootProcessInstanceId());
        subProcessInstance.setScope(true);
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        subProcessInstance.setStartActivityId(activityId);
        subProcessInstance.setStartUserId(authenticatedUserId);
        subProcessInstance.setBusinessKey(businessKey);
        this.insert(subProcessInstance, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Child execution {} created with super execution {}", (Object)subProcessInstance, (Object)superExecutionEntity.getId());
        }
        subProcessInstance.setProcessInstanceId(subProcessInstance.getId());
        superExecutionEntity.setSubProcessInstance(subProcessInstance);
        if (this.processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            this.processEngineConfiguration.getIdentityLinkInterceptor().handleCreateSubProcessInstance(subProcessInstance, superExecutionEntity);
        }
        if ((flowableEventDispatcher = this.processEngineConfiguration.getEventDispatcher()) != null && flowableEventDispatcher.isEnabled()) {
            flowableEventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, subProcessInstance));
        }
        return subProcessInstance;
    }

    protected void inheritCommonProperties(ExecutionEntity parentExecutionEntity, ExecutionEntity childExecution) {
        if (parentExecutionEntity instanceof CountingExecutionEntity) {
            CountingExecutionEntity countingParentExecutionEntity = (CountingExecutionEntity)((Object)parentExecutionEntity);
            ((CountingExecutionEntity)((Object)childExecution)).setCountEnabled(countingParentExecutionEntity.isCountEnabled());
        }
        childExecution.setRootProcessInstanceId(parentExecutionEntity.getRootProcessInstanceId());
        childExecution.setActive(true);
        childExecution.setStartTime(this.processEngineConfiguration.getClock().getCurrentTime());
        if (parentExecutionEntity.getTenantId() != null) {
            childExecution.setTenantId(parentExecutionEntity.getTenantId());
        }
    }

    public static ManagementService managementService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        ManagementService managementService = currentEngineConfiguration.getManagementService();
        return managementService;
    }

    private void updateEnd(ExecutionEntity processInstanceExecution) {
        Object userIdObj = ThreadMapUtil.get((String)"userId");
        final Object statusObj = ThreadMapUtil.get((String)"status");
        Object userNameObj = ThreadMapUtil.get((String)"userName");
        String userId = "";
        String userName = "";
        if (userIdObj != null) {
            userId = (String)userIdObj;
        }
        if (userNameObj != null) {
            userName = (String)userNameObj;
        }
        A1FlowTaskTrajectoryEntry a1FlowTaskTrajectoryEntry = new A1FlowTaskTrajectoryEntry();
        a1FlowTaskTrajectoryEntry.setEndStatus(Integer.valueOf(0));
        a1FlowTaskTrajectoryEntry.setUserName(userName);
        a1FlowTaskTrajectoryEntry.setUserId(userId);
        a1FlowTaskTrajectoryEntry.setProcId(processInstanceExecution.getId());
        UpdateA1FlowTaskTrajectory.updateEnd(this.processEngineConfiguration, processInstanceExecution.getId());
        final String processInstanceId = processInstanceExecution.getId();
        ManagementService managementService = ExecutionEntityManagerImpl.managementService();
        AbstractCustomSqlExecution<A1FlowProcessInstanceDao, Integer> customSqlExecution = new AbstractCustomSqlExecution<A1FlowProcessInstanceDao, Integer>(A1FlowProcessInstanceDao.class){

            public Integer execute(A1FlowProcessInstanceDao a1FlowTaskManualProcessingDao) {
                PanguFlowInstanceEntity panguFlowInstanceEntity = a1FlowTaskManualProcessingDao.listByProcId(processInstanceId);
                if (panguFlowInstanceEntity != null) {
                    panguFlowInstanceEntity.setStatus(statusObj != null ? String.valueOf(statusObj) : "invalid");
                    panguFlowInstanceEntity.setEndTime(new Date());
                    return a1FlowTaskManualProcessingDao.updateStatus(panguFlowInstanceEntity);
                }
                return 0;
            }
        };
        managementService.executeCustomSql(customSqlExecution);
    }

    @Override
    public void updateExecutionTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.executionDataManager.updateExecutionTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List<String> processInstanceIds = this.executionDataManager.findProcessInstanceIdsByProcessDefinitionId(processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstanceCascade((ExecutionEntity)this.findById(processInstanceId), deleteReason, cascade);
        }
        if (cascade) {
            this.getHistoryManager().recordDeleteHistoricProcessInstancesByProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity superExecution;
        ExecutionEntity processInstanceExecution = (ExecutionEntity)this.findById(processInstanceId);
        if (processInstanceExecution == null) {
            throw new FlowableObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        this.updateEnd(processInstanceExecution);
        this.deleteProcessInstanceCascade(processInstanceExecution, deleteReason, cascade);
        if (processInstanceExecution.getSuperExecutionId() != null && (superExecution = processInstanceExecution.getSuperExecution()) != null && superExecution.getCurrentFlowElement() instanceof FlowNode && ((FlowNode)superExecution.getCurrentFlowElement()).getBehavior() instanceof SubProcessActivityBehavior) {
            SubProcessActivityBehavior subProcessActivityBehavior = (SubProcessActivityBehavior)((FlowNode)superExecution.getCurrentFlowElement()).getBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, processInstanceExecution);
                superExecution.setSubProcessInstance(null);
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (Exception e) {
                throw new FlowableException("Could not complete parent process instance for call activity with process instance execution " + processInstanceExecution.getId(), (Throwable)e);
            }
        }
    }

    protected void deleteProcessInstanceCascade(ExecutionEntity execution, String deleteReason, boolean deleteHistory) {
        ExecutionEntity processInstanceExecutionEntity;
        if (deleteReason == null) {
            deleteReason = "process instance deleted";
        }
        this.getActivityInstanceEntityManager().deleteActivityInstancesByProcessInstanceId(execution.getId());
        List<ExecutionEntity> childExecutions = this.collectChildren(execution.getProcessInstance());
        for (ExecutionEntity subExecutionEntity : childExecutions) {
            if (subExecutionEntity.isMultiInstanceRoot()) {
                for (ExecutionEntity executionEntity : subExecutionEntity.getExecutions()) {
                    if (executionEntity.getSubProcessInstance() == null) continue;
                    this.deleteProcessInstanceCascade(executionEntity.getSubProcessInstance(), deleteReason, deleteHistory);
                    if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled()) continue;
                    FlowElement callActivityElement = executionEntity.getCurrentFlowElement();
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(callActivityElement.getId(), callActivityElement.getName(), executionEntity.getId(), executionEntity.getProcessInstanceId(), executionEntity.getProcessDefinitionId(), "callActivity", deleteReason));
                }
                continue;
            }
            if (subExecutionEntity.getSubProcessInstance() == null) continue;
            this.deleteProcessInstanceCascade(subExecutionEntity.getSubProcessInstance(), deleteReason, deleteHistory);
            if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled()) continue;
            FlowElement callActivityElement = subExecutionEntity.getCurrentFlowElement();
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(callActivityElement.getId(), callActivityElement.getName(), subExecutionEntity.getId(), subExecutionEntity.getProcessInstanceId(), subExecutionEntity.getProcessDefinitionId(), "callActivity", deleteReason));
        }
        TaskHelper.deleteTasksByProcessInstanceId(execution.getId(), deleteReason, deleteHistory);
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createCancelledEvent(execution.getProcessInstanceId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), deleteReason));
        }
        if ((processInstanceExecutionEntity = execution.getProcessInstance()) == null) {
            return;
        }
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            ExecutionEntity childExecutionEntity = childExecutions.get(i);
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, deleteHistory);
        }
        this.deleteExecutionAndRelatedData(execution, deleteReason, deleteHistory);
        if (deleteHistory) {
            this.getHistoryManager().recordProcessInstanceDeleted(execution.getId(), execution.getProcessDefinitionId());
        }
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceExecutionEntity, deleteReason, null, this.getClock().getCurrentTime());
        processInstanceExecutionEntity.setDeleted(true);
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean deleteHistory, boolean cancel, FlowElement cancelActivity) {
        if (!deleteHistory && executionEntity.isActive() && executionEntity.getCurrentFlowElement() != null && !executionEntity.isMultiInstanceRoot() && !(executionEntity.getCurrentFlowElement() instanceof BoundaryEvent)) {
            CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd(executionEntity, deleteReason);
        }
        this.deleteRelatedDataForExecution(executionEntity, deleteReason);
        this.delete(executionEntity);
        if (cancel) {
            this.dispatchActivityCancelled(executionEntity, cancelActivity != null ? cancelActivity : executionEntity.getCurrentFlowElement());
        }
        if (executionEntity.isProcessInstanceType() && executionEntity.getCallbackId() != null) {
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            ProcessInstanceHelper processInstanceHelper = CommandContextUtil.getProcessInstanceHelper(commandContext);
            if (cancel) {
                processInstanceHelper.callCaseInstanceStateChangeCallbacks(commandContext, executionEntity, "running", "cancelled");
            } else {
                processInstanceHelper.callCaseInstanceStateChangeCallbacks(commandContext, executionEntity, "running", "completed");
            }
        }
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean deleteHistory) {
        this.deleteExecutionAndRelatedData(executionEntity, deleteReason, deleteHistory, false, null);
    }

    @Override
    public void deleteProcessInstanceExecutionEntity(String processInstanceId, String currentFlowElementId, String deleteReason, boolean cascade, boolean cancel, boolean fireEvents) {
        ExecutionEntity processInstanceEntity = (ExecutionEntity)this.findById(processInstanceId);
        if (processInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        if (processInstanceEntity.isDeleted()) {
            return;
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (executionEntity.getSubProcessInstance() == null || executionEntity.isEnded()) continue;
            this.deleteProcessInstanceCascade(executionEntity.getSubProcessInstance(), deleteReason, cascade);
            if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled() || !fireEvents) continue;
            FlowElement callActivityElement = executionEntity.getCurrentFlowElement();
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(callActivityElement.getId(), callActivityElement.getName(), executionEntity.getId(), processInstanceId, executionEntity.getProcessDefinitionId(), "callActivity", deleteReason));
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (!executionEntity.isEventScope()) continue;
            this.deleteExecutionAndRelatedData(executionEntity, null, cascade);
        }
        this.deleteChildExecutions(processInstanceEntity, deleteReason, cancel);
        this.deleteExecutionAndRelatedData(processInstanceEntity, deleteReason, cascade);
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled() && fireEvents) {
            if (!cancel) {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_COMPLETED, processInstanceEntity));
            } else {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createCancelledEvent(processInstanceEntity.getId(), processInstanceEntity.getId(), processInstanceEntity.getProcessDefinitionId(), deleteReason));
            }
        }
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceEntity, deleteReason, currentFlowElementId, this.getClock().getCurrentTime());
        processInstanceEntity.setDeleted(true);
    }

    @Override
    public void deleteChildExecutions(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        this.deleteChildExecutions(executionEntity, null, null, deleteReason, cancel, null);
    }

    @Override
    public void deleteChildExecutions(ExecutionEntity executionEntity, Collection<String> executionIdsNotToDelete, Collection<String> executionIdsNotToSendCancelledEventFor, String deleteReason, boolean cancel, FlowElement cancelActivity) {
        List<ExecutionEntity> childExecutions = this.collectChildren(executionEntity, executionIdsNotToDelete);
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            ExecutionEntity childExecutionEntity = childExecutions.get(i);
            if (childExecutionEntity.isEnded() || executionIdsNotToDelete != null && (executionIdsNotToDelete == null || executionIdsNotToDelete.contains(childExecutionEntity.getId()))) continue;
            if (childExecutionEntity.isProcessInstanceType()) {
                this.deleteProcessInstanceExecutionEntity(childExecutionEntity.getId(), cancelActivity != null ? cancelActivity.getId() : null, deleteReason, true, cancel, true);
            } else if (cancel && (childExecutionEntity.isActive() || childExecutionEntity.isMultiInstanceRoot()) && (executionIdsNotToSendCancelledEventFor == null || !executionIdsNotToSendCancelledEventFor.contains(childExecutionEntity.getId()))) {
                this.dispatchExecutionCancelled(childExecutionEntity, cancelActivity != null ? cancelActivity : childExecutionEntity.getCurrentFlowElement());
            }
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, false);
        }
    }

    @Override
    public List<ExecutionEntity> collectChildren(ExecutionEntity executionEntity) {
        return this.collectChildren(executionEntity, null);
    }

    protected List<ExecutionEntity> collectChildren(ExecutionEntity executionEntity, Collection<String> executionIdsToExclude) {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>();
        this.collectChildren(executionEntity, childExecutions, executionIdsToExclude != null ? executionIdsToExclude : Collections.emptyList());
        return childExecutions;
    }

    protected void collectChildren(ExecutionEntity executionEntity, List<ExecutionEntity> collectedChildExecution, Collection<String> executionIdsToExclude) {
        ExecutionEntity subProcessInstance;
        List<? extends ExecutionEntity> childExecutions = executionEntity.getExecutions();
        if (childExecutions != null && childExecutions.size() > 0) {
            Collections.sort(childExecutions, ExecutionEntity.EXECUTION_ENTITY_START_TIME_ASC_COMPARATOR);
            for (ExecutionEntity executionEntity2 : childExecutions) {
                if (executionIdsToExclude.contains(executionEntity2.getId())) continue;
                if (!executionEntity2.isDeleted()) {
                    collectedChildExecution.add(executionEntity2);
                }
                this.collectChildren(executionEntity2, collectedChildExecution, executionIdsToExclude);
            }
        }
        if ((subProcessInstance = executionEntity.getSubProcessInstance()) != null && !executionIdsToExclude.contains(subProcessInstance.getId())) {
            if (!subProcessInstance.isDeleted()) {
                collectedChildExecution.add(subProcessInstance);
            }
            this.collectChildren(subProcessInstance, collectedChildExecution, executionIdsToExclude);
        }
    }

    protected void dispatchExecutionCancelled(ExecutionEntity execution, FlowElement cancelActivity) {
        FlowElement currentFlowElement;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        for (ExecutionEntity subExecution : executionEntityManager.findChildExecutionsByParentExecutionId(execution.getId())) {
            this.dispatchExecutionCancelled(subExecution, cancelActivity);
        }
        ExecutionEntity subProcessInstance = CommandContextUtil.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, cancelActivity);
        }
        if ((currentFlowElement = execution.getCurrentFlowElement()) instanceof FlowNode) {
            if (execution.isMultiInstanceRoot()) {
                this.dispatchMultiInstanceActivityCancelled(execution, cancelActivity);
            } else {
                this.dispatchActivityCancelled(execution, cancelActivity);
            }
        }
    }

    protected void dispatchActivityCancelled(ExecutionEntity execution, FlowElement cancelActivity) {
        try {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.getActivityType((FlowNode)execution.getCurrentFlowElement()), cancelActivity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dispatchMultiInstanceActivityCancelled(ExecutionEntity execution, FlowElement cancelActivity) {
        try {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createMultiInstanceActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.getActivityType((FlowNode)execution.getCurrentFlowElement()), cancelActivity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getActivityType(FlowNode flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }

    @Override
    public ExecutionEntity findFirstScope(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isScope()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    @Override
    public ExecutionEntity findFirstMultiInstanceRoot(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isMultiInstanceRoot()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    @Override
    public void deleteRelatedDataForExecution(ExecutionEntity executionEntity, String deleteReason) {
        executionEntity.setEnded(true);
        executionEntity.setActive(false);
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        boolean enableExecutionRelationshipCounts = CountingEntityUtil.isExecutionRelatedEntityCountEnabled(executionEntity);
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher();
        boolean eventDispatcherEnabled = eventDispatcher != null && eventDispatcher.isEnabled();
        this.deleteIdentityLinks(executionEntity, commandContext, eventDispatcherEnabled);
        this.deleteEntityLinks(executionEntity, commandContext, eventDispatcherEnabled);
        this.deleteVariables(executionEntity, commandContext, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteUserTasks(executionEntity, deleteReason, commandContext, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteJobs(executionEntity, commandContext, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteEventSubScriptions(executionEntity, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteActivityInstances(executionEntity, commandContext);
    }

    protected void deleteActivityInstances(ExecutionEntity executionEntity, CommandContext commandContext) {
        if (executionEntity.isProcessInstanceType()) {
            CommandContextUtil.getActivityInstanceEntityManager(commandContext).deleteActivityInstancesByProcessInstanceId(executionEntity.getId());
        }
    }

    protected void deleteIdentityLinks(ExecutionEntity executionEntity, CommandContext commandContext, boolean eventDispatcherEnabled) {
        if (executionEntity.isProcessInstanceType()) {
            IdentityLinkService identityLinkService = CommandContextUtil.getIdentityLinkService(commandContext);
            boolean deleteIdentityLinks = true;
            if (eventDispatcherEnabled) {
                List identityLinks = identityLinkService.findIdentityLinksByProcessInstanceId(executionEntity.getId());
                for (IdentityLinkEntity identityLink : identityLinks) {
                    this.fireEntityDeletedEvent((Entity)identityLink);
                }
                boolean bl = deleteIdentityLinks = !identityLinks.isEmpty();
            }
            if (deleteIdentityLinks) {
                identityLinkService.deleteIdentityLinksByProcessInstanceId(executionEntity.getId());
            }
        }
    }

    protected void deleteEntityLinks(ExecutionEntity executionEntity, CommandContext commandContext, boolean eventDispatcherEnabled) {
        if (this.processEngineConfiguration.isEnableEntityLinks() && executionEntity.isProcessInstanceType()) {
            EntityLinkService entityLinkService = CommandContextUtil.getEntityLinkService(commandContext);
            boolean deleteEntityLinks = true;
            if (eventDispatcherEnabled) {
                List entityLinks = entityLinkService.findEntityLinksByScopeIdAndType(executionEntity.getId(), "bpmn", "child");
                for (EntityLink entityLink : entityLinks) {
                    this.fireEntityDeletedEvent((Entity)((EntityLinkEntity)entityLink));
                }
                boolean bl = deleteEntityLinks = !entityLinks.isEmpty();
            }
            if (deleteEntityLinks) {
                entityLinkService.deleteEntityLinksByScopeIdAndType(executionEntity.getId(), "bpmn");
            }
        }
    }

    protected void deleteVariables(ExecutionEntity executionEntity, CommandContext commandContext, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        Collection executionVariables;
        if ((!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getVariableCount() > 0) && !(executionVariables = executionEntity.getVariableInstancesLocal().values()).isEmpty()) {
            ArrayList<VariableByteArrayRef> variableByteArrayRefs = new ArrayList<VariableByteArrayRef>();
            for (VariableInstance variableInstance : executionVariables) {
                FlowableEventDispatcher eventDispatcher;
                if (!(variableInstance instanceof VariableInstanceEntity)) continue;
                VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
                if (variableInstanceEntity.getByteArrayRef() != null && variableInstanceEntity.getByteArrayRef().getId() != null) {
                    variableByteArrayRefs.add(variableInstanceEntity.getByteArrayRef());
                }
                if (!eventDispatcherEnabled || (eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext)) == null) continue;
                eventDispatcher.dispatchEvent((FlowableEvent)EventUtil.createVariableDeleteEvent(variableInstanceEntity));
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, variableInstance));
            }
            for (VariableByteArrayRef variableByteArrayRef : variableByteArrayRefs) {
                this.getByteArrayEntityManager().deleteByteArrayById(variableByteArrayRef.getId());
            }
            CommandContextUtil.getVariableService(commandContext).deleteVariablesByExecutionId(executionEntity.getId());
        }
    }

    protected void deleteUserTasks(ExecutionEntity executionEntity, String deleteReason, CommandContext commandContext, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTaskCount() > 0) {
            TaskHelper.deleteTasksForExecution(executionEntity, CommandContextUtil.getTaskService(commandContext).findTasksByExecutionId(executionEntity.getId()), deleteReason);
        }
    }

    protected void deleteJobs(ExecutionEntity executionEntity, CommandContext commandContext, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTimerJobCount() > 0) {
            CommandContextUtil.getTimerJobService().deleteTimerJobsByExecutionId(executionEntity.getId());
        }
        JobService jobService = CommandContextUtil.getJobService();
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getJobCount() > 0) {
            jobService.deleteJobsByExecutionId(executionEntity.getId());
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getSuspendedJobCount() > 0) {
            jobService.deleteSuspendedJobsByExecutionId(executionEntity.getId());
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getDeadLetterJobCount() > 0) {
            jobService.deleteDeadLetterJobsByExecutionId(executionEntity.getId());
        }
    }

    protected void deleteEventSubScriptions(ExecutionEntity executionEntity, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getEventSubscriptionCount() > 0) {
            EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService();
            boolean deleteEventSubscriptions = true;
            if (eventDispatcherEnabled) {
                List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsByExecution(executionEntity.getId());
                for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                    this.fireEntityDeletedEvent((Entity)eventSubscription);
                    if (!"message".equals(eventSubscription.getEventType())) continue;
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createMessageEvent(FlowableEngineEventType.ACTIVITY_MESSAGE_CANCELLED, eventSubscription.getActivityId(), eventSubscription.getEventName(), null, eventSubscription.getExecutionId(), eventSubscription.getProcessInstanceId(), eventSubscription.getProcessDefinitionId()));
                }
                boolean bl = deleteEventSubscriptions = !eventSubscriptions.isEmpty();
            }
            if (deleteEventSubscriptions) {
                eventSubscriptionService.deleteEventSubscriptionsByExecutionId(executionEntity.getId());
            }
        }
    }

    @Override
    public void updateProcessInstanceLockTime(String processInstanceId) {
        Date expirationTime = this.getClock().getCurrentTime();
        int lockMillis = this.getAsyncExecutor().getAsyncJobLockTimeInMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(expirationTime);
        lockCal.add(14, lockMillis);
        Date lockDate = lockCal.getTime();
        this.executionDataManager.updateProcessInstanceLockTime(processInstanceId, lockDate, expirationTime);
    }

    @Override
    public void clearProcessInstanceLockTime(String processInstanceId) {
        this.executionDataManager.clearProcessInstanceLockTime(processInstanceId);
    }

    @Override
    public String updateProcessInstanceBusinessKey(ExecutionEntity executionEntity, String businessKey) {
        if (executionEntity.isProcessInstanceType() && businessKey != null) {
            executionEntity.setBusinessKey(businessKey);
            this.getHistoryManager().updateProcessBusinessKeyInHistory(executionEntity);
            if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, executionEntity));
            }
            return businessKey;
        }
        return null;
    }

    public ExecutionDataManager getExecutionDataManager() {
        return this.executionDataManager;
    }

    public void setExecutionDataManager(ExecutionDataManager executionDataManager) {
        this.executionDataManager = executionDataManager;
    }
}

