/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import com.a1bpm.model.ExtA1SignNode;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.innermapper.nodeoperate.A1ProcessInstanceLogDao;
import org.flowable.common.engine.impl.innermapper.nodeoperate.A1ProcessInstanceModelDao;
import org.flowable.common.engine.impl.innermapper.nodeoperate.A1ProcessInstanceModelEntity;
import org.flowable.common.engine.impl.innermapper.nodeoperate.A1ProcessInstanceModelLogEntity;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.common.engine.impl.util.io.BytesStreamSource;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.addnode.A1BpmnAutoLayout;
import org.flowable.engine.addnode.NodeElementModel;
import org.flowable.engine.addnode.SignNodeInfo;
import org.flowable.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ClassDelegate;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.BpmnParser;
import org.flowable.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.AbstractCustomSqlExecution;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.repository.ProcessDefinition;

public class ProcessDefinitionUtil {
    public static final String CALLED_ELEMENT_TYPE_KEY = "key";
    public static final String CALLED_ELEMENT_TYPE_ID = "id";

    public static ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcessDefinition(processDefinitionId, false);
    }

    public static ProcessDefinition getProcessDefinition(String processDefinitionId, boolean checkCacheOnly) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (checkCacheOnly) {
            ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)processEngineConfiguration.getProcessDefinitionCache().get(processDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getProcessDefinition();
            }
            return null;
        }
        return processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId);
    }

    public static Process getProcess(String processDefinitionId) {
        if (Context.getCommandContext() == null) {
            throw new FlowableException("Cannot get process model: no current command context is active");
        }
        if (CommandContextUtil.getProcessEngineConfiguration() == null) {
            return Flowable5Util.getFlowable5CompatibilityHandler().getProcessDefinitionProcessObject(processDefinitionId);
        }
        DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getProcess();
    }

    public static BpmnModel getBpmnModel(String processDefinitionId) {
        if (CommandContextUtil.getProcessEngineConfiguration() == null) {
            return Flowable5Util.getFlowable5CompatibilityHandler().getProcessDefinitionBpmnModel(processDefinitionId);
        }
        DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getBpmnModel();
    }

    public static BpmnModel getBpmnModel(String processDefinitionId, String processInstanceId) {
        if (StringUtils.isNotEmpty((CharSequence)processInstanceId)) {
            DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = CommandContextUtil.getProcessEngineConfiguration().getProcessDefinitionCache();
            ProcessDefinitionCacheEntry processDefinitionCacheEntry = (ProcessDefinitionCacheEntry)processDefinitionCache.get(processDefinitionId, processInstanceId);
            List<A1ProcessInstanceModelEntity> a1ProcessInstanceModelEntities = ProcessDefinitionUtil.get(CommandContextUtil.getProcessEngineConfiguration(), processInstanceId);
            if (processDefinitionCacheEntry != null) {
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
                BpmnModel bpmnModel1 = processDefinitionCacheEntry.getBpmnModel();
                bpmnModel1.addExtA1Buttons(bpmnModel.getExtA1Buttons());
                bpmnModel1.addExtA1Properties(bpmnModel.getExtA1Properties());
                bpmnModel1.addExtA1CommonScript(bpmnModel.getExtA1CommonScripts());
                bpmnModel1.addExtA1UserRule(bpmnModel.getExtA1UserRule());
                bpmnModel1.addExtA1Global(bpmnModel.getExtA1Globals());
                bpmnModel1.addExtA1Conditions(bpmnModel.getExtA1Conditions());
                bpmnModel1.addExtA1UserProperty(bpmnModel.getExtA1UserProperty());
                bpmnModel1.addExtA1Attribute(bpmnModel.getExtA1Attributes());
                bpmnModel1.addExtA1GlobalForm(bpmnModel.getExtA1GlobalForms());
                bpmnModel1.addExtA1SignNodes(bpmnModel.getExtA1SignNodes());
                return bpmnModel1;
            }
            return ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        }
        return ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
    }

    public static BpmnModel getBpmnModelFromCache(String processDefinitionId) {
        ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)CommandContextUtil.getProcessEngineConfiguration().getProcessDefinitionCache().get(processDefinitionId);
        if (cacheEntry != null) {
            return cacheEntry.getBpmnModel();
        }
        return null;
    }

    public static boolean isProcessDefinitionSuspended(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition = ProcessDefinitionUtil.getProcessDefinitionFromDatabase(processDefinitionId);
        return processDefinition.isSuspended();
    }

    public static ProcessDefinitionEntity getProcessDefinitionFromDatabase(String processDefinitionId) {
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)processDefinitionEntityManager.findById(processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("No process definition found with id " + processDefinitionId);
        }
        return processDefinition;
    }

    public static void addProcessDefinitionInstanceFromDatabase(String processDefinitionId, String processInstanceId, List<NodeElementModel> nodes) {
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        List<A1ProcessInstanceModelEntity> a1ProcessInstanceModelLogEntities = ProcessDefinitionUtil.get(CommandContextUtil.getProcessEngineConfiguration(), processInstanceId);
        BpmnModel bpmnModel = null;
        if (a1ProcessInstanceModelLogEntities.size() > 0) {
            byte[] modelEditorXml = a1ProcessInstanceModelLogEntities.get(0).getModelEditorXml();
            BytesStreamSource inputStreamProvider = new BytesStreamSource(modelEditorXml);
            bpmnModel = bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)inputStreamProvider, false, false);
        } else {
            bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        }
        BpmnModel orginBpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        byte[] bytes = bpmnXMLConverter.convertToXML(bpmnModel);
        BytesStreamSource inputStreamProvider = new BytesStreamSource(bytes);
        BpmnModel newBpmnModel = bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)inputStreamProvider, false, false);
        bytes = bpmnXMLConverter.convertToXML(newBpmnModel);
        ProcessDefinitionUtil.fillBehavior(orginBpmnModel, newBpmnModel);
        ArrayList<SequenceFlow> genareateFlows = new ArrayList<SequenceFlow>();
        FlowElement nextFlowElement = null;
        boolean isContainer = false;
        if (nodes != null && nodes.size() > 0) {
            FlowNode addNodeInfo;
            NodeElementModel userTask;
            int i;
            for (int i2 = 0; i2 < nodes.size(); ++i2) {
                NodeElementModel nel = nodes.get(i2);
                FlowNode addNodeInfo2 = (FlowNode)nel.getAddNodeInfo();
                addNodeInfo2.setBehavior(nel.getBehavior());
                Object firstAddNodeInfo = null;
                SignNodeInfo signNodeInfo = nel.getSignNodeInfo();
                if (signNodeInfo != null && nel.getNodeType() != NodeElementModel.NodeType.USERTASK) {
                    ExtA1SignNode extA1SignNode = new ExtA1SignNode(UUID.randomUUID().toString().replace("-", ""), addNodeInfo2.getId(), signNodeInfo.getSignType(), signNodeInfo.getSignScale(), signNodeInfo.getAll(), signNodeInfo.getPass(), signNodeInfo.getUnPass(), null, null, signNodeInfo.getDoUserId());
                    newBpmnModel.addExtA1SignNode(extA1SignNode);
                }
                if ((nextFlowElement = newBpmnModel.getMainProcess().getFlowElement(nel.getNextNodeId(), true)).getParentContainer() instanceof SubProcess) {
                    isContainer = true;
                    nextFlowElement.getParentContainer().addFlowElement((FlowElement)addNodeInfo2);
                    continue;
                }
                newBpmnModel.getMainProcess().addFlowElement((FlowElement)addNodeInfo2);
            }
            Map flowElementMap = newBpmnModel.getMainProcess().getFlowElementMap();
            Collection flowElementMaps = newBpmnModel.getMainProcess().getFlowElements();
            if (isContainer) {
                flowElementMap = nextFlowElement.getParentContainer().getFlowElementMap();
                flowElementMaps = nextFlowElement.getParentContainer().getFlowElements();
            }
            for (i = 0; i < nodes.size(); ++i) {
                userTask = nodes.get(i);
                addNodeInfo = (FlowNode)userTask.getAddNodeInfo();
                SequenceFlow generateSequenceFlow = null;
                if (i == nodes.size() - 1) {
                    generateSequenceFlow = ProcessDefinitionUtil.generateSequenceFlow(addNodeInfo.getId() + "_a1_" + userTask.getNextNodeId(), addNodeInfo.getId(), userTask.getNextNodeId());
                    if (isContainer) {
                        generateSequenceFlow.setTargetFlowElement(nextFlowElement.getParentContainer().getFlowElement(userTask.getNextNodeId()));
                    } else {
                        generateSequenceFlow.setTargetFlowElement(newBpmnModel.getMainProcess().getFlowElement(userTask.getNextNodeId(), true));
                    }
                    addNodeInfo.setOutgoingFlows(Arrays.asList(generateSequenceFlow));
                } else {
                    generateSequenceFlow = ProcessDefinitionUtil.generateSequenceFlow(addNodeInfo.getId() + "_a1_" + nodes.get(i + 1).getAddNodeInfo().getId(), addNodeInfo.getId(), nodes.get(i + 1).getAddNodeInfo().getId());
                    generateSequenceFlow.setTargetFlowElement(nodes.get(i + 1).getAddNodeInfo());
                    addNodeInfo.setOutgoingFlows(Arrays.asList(generateSequenceFlow));
                }
                if (isContainer) {
                    nextFlowElement.getParentContainer().addFlowElement((FlowElement)generateSequenceFlow);
                } else {
                    newBpmnModel.getMainProcess().addFlowElement((FlowElement)generateSequenceFlow);
                }
                genareateFlows.add(generateSequenceFlow);
            }
            for (i = 0; i < nodes.size(); ++i) {
                if (i == 0) {
                    userTask = nodes.get(i);
                    addNodeInfo = (FlowNode)userTask.getAddNodeInfo();
                    FlowNode preNodeInfo = null;
                    preNodeInfo = isContainer ? (FlowNode)nextFlowElement.getParentContainer().getFlowElement(userTask.getPreNodeId()) : (FlowNode)newBpmnModel.getMainProcess().getFlowElement(userTask.getPreNodeId(), true);
                    List outgoingFlows = preNodeInfo.getOutgoingFlows();
                    for (SequenceFlow s : outgoingFlows) {
                        String targetRef = s.getTargetRef();
                        if (!targetRef.equals(nodes.get(0).getNextNodeId())) continue;
                        if (isContainer) {
                            nextFlowElement.getParentContainer().removeFlowElement(s.getId());
                            continue;
                        }
                        newBpmnModel.getMainProcess().removeFlowElement(s.getId());
                    }
                    SequenceFlow generateSequenceFlow = null;
                    preNodeInfo.setOutgoingFlows(null);
                    generateSequenceFlow = ProcessDefinitionUtil.generateSequenceFlow(userTask.getPreNodeId() + "_a1_" + addNodeInfo.getId(), userTask.getPreNodeId(), addNodeInfo.getId());
                    if (isContainer) {
                        generateSequenceFlow.setTargetFlowElement(nextFlowElement.getParentContainer().getFlowElement(addNodeInfo.getId()));
                    } else {
                        generateSequenceFlow.setTargetFlowElement(newBpmnModel.getMainProcess().getFlowElement(addNodeInfo.getId(), true));
                    }
                    preNodeInfo.setOutgoingFlows(Arrays.asList(generateSequenceFlow));
                    if (isContainer) {
                        nextFlowElement.getParentContainer().removeFlowElement(preNodeInfo.getId());
                        nextFlowElement.getParentContainer().addFlowElement((FlowElement)preNodeInfo);
                        nextFlowElement.getParentContainer().addFlowElement((FlowElement)generateSequenceFlow);
                    } else {
                        newBpmnModel.getMainProcess().removeFlowElement(preNodeInfo.getId());
                        newBpmnModel.getMainProcess().addFlowElement((FlowElement)preNodeInfo);
                        newBpmnModel.getMainProcess().addFlowElement((FlowElement)generateSequenceFlow);
                    }
                }
                if (i != nodes.size() - 1) continue;
                NodeElementModel lastNode = nodes.get(i);
                String nextNodeId = lastNode.getNextNodeId();
                FlowNode flowNode = ProcessDefinitionUtil.getNodeById(newBpmnModel, nextFlowElement, isContainer, nextNodeId);
                List incomingFlows = flowNode.getIncomingFlows();
                for (SequenceFlow s : incomingFlows) {
                    String sourceRef = s.getSourceRef();
                    if (!sourceRef.equals(lastNode.getNextNodeId())) continue;
                    if (isContainer) {
                        nextFlowElement.getParentContainer().removeFlowElement(s.getId());
                        continue;
                    }
                    newBpmnModel.getMainProcess().removeFlowElement(s.getId());
                }
            }
        }
        A1ProcessInstanceModelEntity a1ProcessInstanceModelEntity = new A1ProcessInstanceModelEntity();
        a1ProcessInstanceModelEntity.setMiComplete("0");
        a1ProcessInstanceModelEntity.setProcDefId(processDefinitionId);
        a1ProcessInstanceModelEntity.setProcId(processInstanceId);
        ProcessDefinitionUtil.insertLog(processDefinitionId, processInstanceId, nodes);
        List<A1ProcessInstanceModelEntity> a1ProcessInstanceModelEntities = ProcessDefinitionUtil.get(CommandContextUtil.getProcessEngineConfiguration(), processInstanceId);
        A1BpmnAutoLayout bpmnAutoLayout = new A1BpmnAutoLayout(newBpmnModel);
        bpmnAutoLayout.execute();
        ProcessDefinitionUtil.updateProcessInstanceBpmnModel(processDefinitionId, processInstanceId, newBpmnModel);
        bytes = bpmnXMLConverter.convertToXML(newBpmnModel);
        a1ProcessInstanceModelEntity.setModelEditorXml(bytes);
        String nodesInfo = JSON.toJSONString(nodes);
        a1ProcessInstanceModelEntity.setExtJson(nodesInfo);
        ProcessDefinitionUtil.insert(CommandContextUtil.getProcessEngineConfiguration(), a1ProcessInstanceModelEntity);
        ProcessDefinitionUtil.updateBpmnModel(CommandContextUtil.getProcessEngineConfiguration());
    }

    private static FlowNode getNodeById(BpmnModel newBpmnModel, FlowElement nextFlowElement, boolean isContainer, String nextNodeId) {
        FlowNode nodeInfo = isContainer ? (FlowNode)nextFlowElement.getParentContainer().getFlowElement(nextNodeId) : (FlowNode)newBpmnModel.getMainProcess().getFlowElement(nextNodeId, true);
        return nodeInfo;
    }

    private static void insertLog(String processDefinitionId, String processInstanceId, List<NodeElementModel> nodes) {
        for (NodeElementModel nem : nodes) {
            A1ProcessInstanceModelLogEntity a1ProcessInstanceModelLogEntity = new A1ProcessInstanceModelLogEntity();
            a1ProcessInstanceModelLogEntity.setNodeId(nem.getAddNodeInfo().getId());
            a1ProcessInstanceModelLogEntity.setName(nem.getAddNodeInfo().getName());
            a1ProcessInstanceModelLogEntity.setNextNodeId(nem.getNextNodeId());
            a1ProcessInstanceModelLogEntity.setPreNodeId(nem.getPreNodeId());
            a1ProcessInstanceModelLogEntity.setProcDefId(processDefinitionId);
            a1ProcessInstanceModelLogEntity.setProcId(processInstanceId);
            a1ProcessInstanceModelLogEntity.setNodeType(nem.getNodeType().getName());
            a1ProcessInstanceModelLogEntity.setNodeInfo("");
            ProcessDefinitionUtil.insertLog(CommandContextUtil.getProcessEngineConfiguration(), a1ProcessInstanceModelLogEntity);
        }
    }

    public static SequenceFlow generateSequenceFlow(String id, String source, String target) {
        SequenceFlow sequenceFlow = new SequenceFlow();
        sequenceFlow.setId(id);
        sequenceFlow.setSourceRef(source);
        sequenceFlow.setTargetRef(target);
        return sequenceFlow;
    }

    private static List<String> fillBehavior(BpmnModel bpmnModel, BpmnModel newBpmnModel) {
        Process newmainProcess = newBpmnModel.getMainProcess();
        ArrayList<String> results = new ArrayList<String>();
        List flowElementList = newmainProcess.getFlowElementList();
        Process oldmainProcess = bpmnModel.getMainProcess();
        for (FlowElement fe : flowElementList) {
            FlowElement oldFlowElement = oldmainProcess.getFlowElement(fe.getId(), true);
            if (oldFlowElement == null || !(oldFlowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)oldFlowElement;
            FlowNode newFlowNode = (FlowNode)fe;
            newFlowNode.setBehavior(flowNode.getBehavior());
            String id = flowNode.getId();
            results.add(id);
        }
        return results;
    }

    public static void updateProcessInstanceBpmnModel(String processDefinitionId, String processInstanceId, BpmnModel bpmnModel) {
        DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = CommandContextUtil.getProcessEngineConfiguration().getProcessDefinitionCache();
        ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)processDefinitionCache.get(processDefinitionId, processInstanceId);
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
        ProcessDefinitionCacheEntry newCacheEntry = new ProcessDefinitionCacheEntry(processDefinition, bpmnModel, bpmnModel.getProcessById(processDefinition.getKey()));
        processDefinitionCache.addProcessInstanceId(processInstanceId, (Object)newCacheEntry);
    }

    public static void updateProcessInstanceBpmnModel(ProcessEngineConfigurationImpl processEngineConfiguration, String processDefinitionId, String processInstanceId, BpmnModel bpmnModel) {
        DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = processEngineConfiguration.getProcessDefinitionCache();
        ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)processDefinitionCache.get(processDefinitionId, processInstanceId);
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
        ProcessDefinitionCacheEntry newCacheEntry = new ProcessDefinitionCacheEntry(processDefinition, bpmnModel, bpmnModel.getProcessById(processDefinition.getKey()));
        processEngineConfiguration.getDeploymentManager().getProcessDefinitionCache().addProcessInstanceId(processInstanceId, (Object)newCacheEntry);
    }

    public static void insert(ProcessEngineConfigurationImpl processEngineConfiguration, final A1ProcessInstanceModelEntity a1ProcessInstanceModelEntity) {
        ManagementService managementService = processEngineConfiguration.getManagementService();
        AbstractCustomSqlExecution<A1ProcessInstanceModelDao, Integer> update = new AbstractCustomSqlExecution<A1ProcessInstanceModelDao, Integer>(A1ProcessInstanceModelDao.class){

            public Integer execute(A1ProcessInstanceModelDao a1ProcessInstanceModelDao) {
                return a1ProcessInstanceModelDao.updateMiComplete(a1ProcessInstanceModelEntity);
            }
        };
        AbstractCustomSqlExecution<A1ProcessInstanceModelDao, Integer> customSqlExecution = new AbstractCustomSqlExecution<A1ProcessInstanceModelDao, Integer>(A1ProcessInstanceModelDao.class){

            public Integer execute(A1ProcessInstanceModelDao a1ProcessInstanceModelDao) {
                return a1ProcessInstanceModelDao.insert(a1ProcessInstanceModelEntity);
            }
        };
        managementService.executeCustomSql(update);
        managementService.executeCustomSql(customSqlExecution);
    }

    public static void insertLog(ProcessEngineConfigurationImpl processEngineConfiguration, final A1ProcessInstanceModelLogEntity a1ProcessInstanceModelLogEntity) {
        ManagementService managementService = processEngineConfiguration.getManagementService();
        AbstractCustomSqlExecution<A1ProcessInstanceLogDao, Integer> customSqlExecution = new AbstractCustomSqlExecution<A1ProcessInstanceLogDao, Integer>(A1ProcessInstanceLogDao.class){

            public Integer execute(A1ProcessInstanceLogDao a1ProcessInstanceLogDao) {
                return a1ProcessInstanceLogDao.insert(a1ProcessInstanceModelLogEntity);
            }
        };
        managementService.executeCustomSql(customSqlExecution);
    }

    public static List<A1ProcessInstanceModelLogEntity> listLog(ProcessEngineConfigurationImpl processEngineConfiguration, final String procId) {
        ManagementService managementService = processEngineConfiguration.getManagementService();
        List<A1ProcessInstanceModelLogEntity> o = managementService.executeCustomSql(new AbstractCustomSqlExecution<A1ProcessInstanceLogDao, List<A1ProcessInstanceModelLogEntity>>(A1ProcessInstanceLogDao.class){

            public List<A1ProcessInstanceModelLogEntity> execute(A1ProcessInstanceLogDao a1ProcessInstanceLogDao) {
                return a1ProcessInstanceLogDao.listA1ProcessInstanceModelLogEntity(procId);
            }
        });
        return o;
    }

    public static List<A1ProcessInstanceModelEntity> get(ProcessEngineConfigurationImpl processEngineConfiguration, final String processInstanceId) {
        ManagementService managementService = processEngineConfiguration.getManagementService();
        AbstractCustomSqlExecution<A1ProcessInstanceModelDao, List<A1ProcessInstanceModelEntity>> customSqlExecution = new AbstractCustomSqlExecution<A1ProcessInstanceModelDao, List<A1ProcessInstanceModelEntity>>(A1ProcessInstanceModelDao.class){

            public List<A1ProcessInstanceModelEntity> execute(A1ProcessInstanceModelDao a1ProcessInstanceModelDao) {
                return a1ProcessInstanceModelDao.listByProcId(processInstanceId);
            }
        };
        return managementService.executeCustomSql(customSqlExecution);
    }

    public static BpmnModel getBpmnModel(ProcessEngineConfigurationImpl processEngineConfiguration, String processDefinitionId, String processInstanceId) {
        if (StringUtils.isNotEmpty((CharSequence)processInstanceId)) {
            DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = CommandContextUtil.getProcessEngineConfiguration().getProcessDefinitionCache();
            ProcessDefinitionCacheEntry processDefinitionCacheEntry = (ProcessDefinitionCacheEntry)processDefinitionCache.get(processDefinitionId, processInstanceId);
            return processDefinitionCacheEntry == null ? ProcessDefinitionUtil.getBpmnModel(processDefinitionId) : processDefinitionCacheEntry.getBpmnModel();
        }
        return ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
    }

    public static void updateBpmnModel(ProcessEngineConfigurationImpl processEngineConfiguration) {
        List<A1ProcessInstanceModelEntity> all = ProcessDefinitionUtil.getAll(processEngineConfiguration);
        for (A1ProcessInstanceModelEntity api : all) {
            byte[] modelEditorXml = api.getModelEditorXml();
            BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
            BytesStreamSource inputStreamProvider = new BytesStreamSource(modelEditorXml);
            BpmnModel bpmnModel = bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)inputStreamProvider, false, false);
            RepositoryService repositoryService = processEngineConfiguration.getRepositoryService();
            BpmnModel oldBpmnModel = repositoryService.getBpmnModel(api.getProcDefId());
            Process newProcess = bpmnModel.getMainProcess();
            Collection flowElements = newProcess.getFlowElements();
            ArrayList<Object> list = new ArrayList<FlowElement>(flowElements);
            BpmnParser bpmnParser = processEngineConfiguration.getBpmnParser();
            BpmnParse parse = bpmnParser.createParse();
            parse.setCurrentProcess(bpmnModel.getMainProcess());
            parse.processFlowElements(list);
            List<A1ProcessInstanceModelLogEntity> a1ProcessInstanceModelLogEntities = ProcessDefinitionUtil.listLog(processEngineConfiguration, api.getProcId());
            for (A1ProcessInstanceModelLogEntity ai : a1ProcessInstanceModelLogEntities) {
                FlowNode newFlowNode;
                String nodeId = ai.getNodeId();
                List flowElementList = newProcess.getFlowElementList();
                ArrayList<SubProcess> subFlowElements = new ArrayList<SubProcess>();
                for (FlowElement fe : flowElementList) {
                    FlowElement flowElement = newProcess.getFlowElement(fe.getId(), true);
                    if (flowElement != null && flowElement instanceof FlowNode) {
                        FlowNode flowNode = (FlowNode)flowElement;
                        newFlowNode = (FlowNode)fe;
                        ProcessDefinitionUtil.fillBehavior(processEngineConfiguration, ai, nodeId, newFlowNode);
                    }
                    if (flowElement == null || !(flowElement instanceof SubProcess)) continue;
                    SubProcess subProcess = (SubProcess)flowElement;
                    subFlowElements.add(subProcess);
                }
                if (subFlowElements.size() > 0) {
                    for (int i = 0; i < subFlowElements.size(); ++i) {
                        SubProcess subFlowElement = (SubProcess)subFlowElements.get(i);
                        flowElements = subFlowElement.getFlowElements();
                        list = new ArrayList(flowElements);
                        parse.setCurrentProcess(bpmnModel.getMainProcess());
                        parse.processFlowElements(list);
                        for (FlowElement flowElement : list) {
                            if (flowElement == null || !(flowElement instanceof FlowNode)) continue;
                            newFlowNode = (FlowNode)flowElement;
                            ProcessDefinitionUtil.fillBehavior(processEngineConfiguration, ai, nodeId, newFlowNode);
                        }
                    }
                }
                ProcessDefinitionUtil.updateProcessInstanceBpmnModel(processEngineConfiguration, api.getProcDefId(), api.getProcId(), bpmnModel);
            }
        }
    }

    private static void fillBehavior(ProcessEngineConfigurationImpl processEngineConfiguration, A1ProcessInstanceModelLogEntity ai, String nodeId, FlowNode newFlowNode) {
        if (newFlowNode != null && newFlowNode.getBehavior() == null && newFlowNode.getId().equals(nodeId)) {
            ActivityBehaviorFactory activityBehaviorFactory = processEngineConfiguration.getActivityBehaviorFactory();
            if (ai.getNodeType().equals(NodeElementModel.NodeType.USERTASK.getName())) {
                UserTaskActivityBehavior userTaskActivityBehavior1 = activityBehaviorFactory.createUserTaskActivityBehavior((UserTask)newFlowNode);
                newFlowNode.setBehavior((Object)userTaskActivityBehavior1);
            } else if (ai.getNodeType().equals(NodeElementModel.NodeType.SEQUENTIAL.getName())) {
                UserTaskActivityBehavior userTaskActivityBehavior1 = activityBehaviorFactory.createUserTaskActivityBehavior((UserTask)newFlowNode);
                ParallelMultiInstanceBehavior parallelMultiInstanceBehavior = activityBehaviorFactory.createParallelMultiInstanceBehavior((Activity)newFlowNode, userTaskActivityBehavior1);
                newFlowNode.setBehavior((Object)parallelMultiInstanceBehavior);
                parallelMultiInstanceBehavior.setCollectionElementVariable("PANGUELEMENTASSIGNEE");
                ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
                Expression expression = expressionManager.createExpression("PANGUASSIGNEES");
                parallelMultiInstanceBehavior.setCollectionExpression(expression);
            } else if (ai.getNodeType().equals(NodeElementModel.NodeType.SERVICETASK.getName())) {
                ServiceTask serviceTask = (ServiceTask)newFlowNode;
                serviceTask.setImplementation("org.flowable.engine.impl.util.ServiceTaskInAddOperate");
                serviceTask.setTriggerable(false);
                ClassDelegate serviceTaskDelegateExpressionActivityBehavior = activityBehaviorFactory.createClassDelegateServiceTask(serviceTask);
                serviceTask.setBehavior((Object)serviceTaskDelegateExpressionActivityBehavior);
            } else if (ai.getNodeType().equals(NodeElementModel.NodeType.PARALLEL.getName())) {
                UserTaskActivityBehavior userTaskActivityBehavior1 = activityBehaviorFactory.createUserTaskActivityBehavior((UserTask)newFlowNode);
                SequentialMultiInstanceBehavior parallelMultiInstanceBehavior = activityBehaviorFactory.createSequentialMultiInstanceBehavior((Activity)newFlowNode, userTaskActivityBehavior1);
                newFlowNode.setBehavior((Object)parallelMultiInstanceBehavior);
                parallelMultiInstanceBehavior.setCollectionElementVariable("PANGUELEMENTASSIGNEE");
                ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
                Expression expression = expressionManager.createExpression("PANGUASSIGNEES");
                parallelMultiInstanceBehavior.setCollectionExpression(expression);
            } else if (ai.getNodeType().equals(NodeElementModel.NodeType.CALLACTIVITY.getName())) {
                CallActivity callActivity = (CallActivity)newFlowNode;
                callActivity.setCalledElementType(CALLED_ELEMENT_TYPE_KEY);
                callActivity.setCalledElement("paita0508");
                CallActivityBehavior callActivityBehavior = activityBehaviorFactory.createCallActivityBehavior(callActivity);
                newFlowNode.setBehavior((Object)callActivityBehavior);
            } else if (ai.getNodeType().equals(NodeElementModel.NodeType.SUBPROCESS.getName())) {
                // empty if block
            }
        }
    }

    public static List<A1ProcessInstanceModelEntity> getAll(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ManagementService managementService = processEngineConfiguration.getManagementService();
        AbstractCustomSqlExecution<A1ProcessInstanceModelDao, List<A1ProcessInstanceModelEntity>> customSqlExecution = new AbstractCustomSqlExecution<A1ProcessInstanceModelDao, List<A1ProcessInstanceModelEntity>>(A1ProcessInstanceModelDao.class){

            public List<A1ProcessInstanceModelEntity> execute(A1ProcessInstanceModelDao a1ProcessInstanceModelDao) {
                return a1ProcessInstanceModelDao.listAll();
            }
        };
        return managementService.executeCustomSql(customSqlExecution);
    }
}

