/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import com.a1bpm.model.ExtA1CommonScript;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.innermapper.A1FlowTaskTrajectoryEntry;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.common.engine.impl.util.ThreadMapUtil;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.eumns.ChangeActivityEnumType;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.UpdateA1FlowTaskTrajectory;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EntityLinkUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.condition.PanguGroovyConditionCmd;
import org.flowable.identitylink.service.event.impl.FlowableIdentityLinkEventBuilder;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.api.history.HistoricTaskLogEntryType;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.impl.BaseHistoricTaskLogEntryBuilderImpl;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.event.impl.FlowableVariableEventBuilder;
import org.flowable.variable.service.impl.persistence.entity.VariableByteArrayRef;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class TaskForceHelper {
    public static void getMultiInstanceChildExecution(DelegateExecution executionEntity, List<DelegateExecution> ids) {
        Object multiInstanceRootExecution = null;
        for (DelegateExecution currentExecution = executionEntity; currentExecution != null && currentExecution.getParent() != null; currentExecution = currentExecution.getParent()) {
            ids.add(currentExecution);
        }
    }

    public static void completeTask(TaskEntity taskEntity, Map<String, Object> variables, Map<String, Object> transientVariables, boolean localScope, CommandContext commandContext) {
        if (taskEntity.getDelegationState() != null && taskEntity.getDelegationState() == DelegationState.PENDING) {
            throw new FlowableException("A delegated task cannot be completed, but should be resolved instead.");
        }
        if (StringUtils.isNotEmpty((CharSequence)taskEntity.getOwner())) {
            taskEntity.setDelegationState(DelegationState.RESOLVED);
            CommandContextUtil.getTaskServiceConfiguration().getInternalHistoryTaskManager().recordTaskInfoChange(taskEntity, TaskForceHelper.getClock().getCurrentTime());
        }
        if (variables != null) {
            if (localScope) {
                taskEntity.setVariablesLocal(variables);
            } else if (taskEntity.getExecutionId() != null) {
                ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId());
                if (execution != null) {
                    execution.setVariables(variables);
                }
            } else {
                taskEntity.setVariables(variables);
            }
        }
        if (transientVariables != null) {
            if (localScope) {
                taskEntity.setTransientVariablesLocal(transientVariables);
            } else {
                taskEntity.setTransientVariables(transientVariables);
            }
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        if (processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            processEngineConfiguration.getIdentityLinkInterceptor().handleCompleteTask(taskEntity);
        }
        TaskForceHelper.logUserTaskCompleted(taskEntity);
        TaskForceHelper.handlerScript(taskEntity);
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            if (variables != null) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityWithVariablesEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity, variables, localScope));
            } else {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity));
            }
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId());
        List endEventList = bpmnModel.getMainProcess().findFlowElementsOfType(EndEvent.class);
        String taskDefinitionKey = taskEntity.getTaskDefinitionKey();
        FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(taskDefinitionKey, true);
        if (endEventList.size() > 0) {
            flowElement.setNextId(((EndEvent)endEventList.get(0)).getId());
            TaskForceHelper.deleteTask(taskEntity, null, false, true, true);
            if (taskEntity.getExecutionId() != null) {
                ExecutionEntity executionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(taskEntity.getExecutionId());
                CommandContextUtil.getAgenda(commandContext).planTriggerExecutionOperation(executionEntity);
            }
        }
    }

    private static void getNextNode(BpmnModel bpmnModel, List<SequenceFlow> outgoingFlows, List<String> outs) {
        for (SequenceFlow sf : outgoingFlows) {
            String targetRef = sf.getTargetRef();
            FlowElement flowElement1 = bpmnModel.getMainProcess().getFlowElement(targetRef, true);
            if (flowElement1 instanceof Gateway) {
                List outgoingFlows1 = ((Gateway)flowElement1).getOutgoingFlows();
                for (SequenceFlow sf2 : outgoingFlows1) {
                    FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(sf2.getTargetRef(), true);
                    if (flowElement instanceof Gateway) {
                        TaskForceHelper.getNextNode(bpmnModel, ((Gateway)flowElement).getOutgoingFlows(), outs);
                    }
                    outs.add(sf2.getTargetRef());
                }
            }
            outs.add(targetRef);
        }
    }

    private static void update(List<A1FlowTaskTrajectoryEntry> a1FlowTaskTrajectoryEntries, String nodeId, String opinion, ChangeActivityEnumType enumType) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        if (enumType == null) {
            enumType = ChangeActivityEnumType.AGREE;
        }
        for (A1FlowTaskTrajectoryEntry at : a1FlowTaskTrajectoryEntries) {
            if (!StringUtils.isNotEmpty((CharSequence)nodeId) || !StringUtils.isNotEmpty((CharSequence)at.getNodeRunId()) || !at.getNodeRunId().equals(nodeId)) continue;
            at.setOpinion(StringUtils.isNotEmpty((CharSequence)opinion) ? opinion : "\u4f5c\u5e9f");
            at.setStatusVal(enumType == null ? enumType.getMsg() : enumType.getMsg());
            at.setStatus(enumType == null ? enumType.getCode() : enumType.getCode());
            at.setEndStatus(Integer.valueOf(0));
            at.setUserId((String)ThreadMapUtil.get((String)"currentUser"));
            at.setUserName((String)ThreadMapUtil.get((String)"currentUserName"));
            UpdateA1FlowTaskTrajectory.update(CommandContextUtil.getProcessEngineConfiguration(commandContext), at);
            break;
        }
    }

    public static TaskService taskService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        TaskService taskService = currentEngineConfiguration.getTaskService();
        return taskService;
    }

    public static RuntimeService runtimeService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RuntimeService runtimeService = currentEngineConfiguration.getRuntimeService();
        return runtimeService;
    }

    public static ManagementService managementService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        ManagementService managementService = currentEngineConfiguration.getManagementService();
        return managementService;
    }

    public static RepositoryService repositoryService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RepositoryService repositoryService = currentEngineConfiguration.getRepositoryService();
        return repositoryService;
    }

    public static HistoryService historyService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        HistoryService historyService = currentEngineConfiguration.getHistoryService();
        return historyService;
    }

    private static void handlerScript(TaskEntity task) {
        String previous;
        Map<String, ExtA1CommonScript> extA1CommonScriptMap;
        ExtA1CommonScript extA1CommonScript;
        BpmnModel bpmnModel = TaskForceHelper.repositoryService().getBpmnModel(task.getProcessDefinitionId());
        List extA1CommonScripts = bpmnModel.getExtA1CommonScripts();
        if (extA1CommonScripts.size() > 0 && (extA1CommonScript = (extA1CommonScriptMap = extA1CommonScripts.stream().collect(Collectors.toMap(ExtA1CommonScript::getNodeId, a -> a, (k1, k2) -> k1))).get(task.getTaskDefinitionKey())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{previous = extA1CommonScript.getComplete()})) {
            TaskForceHelper.managementService().executeCommand(new PanguGroovyConditionCmd(previous, null, task.getVariables(), (DelegateTask)task, 2));
        }
    }

    protected static void logUserTaskCompleted(TaskEntity taskEntity) {
        TaskServiceConfiguration taskServiceConfiguration = CommandContextUtil.getTaskServiceConfiguration();
        if (taskServiceConfiguration.isEnableHistoricTaskLogging()) {
            BaseHistoricTaskLogEntryBuilderImpl taskLogEntryBuilder = new BaseHistoricTaskLogEntryBuilderImpl((TaskInfo)taskEntity);
            ObjectNode data = taskServiceConfiguration.getObjectMapper().createObjectNode();
            taskLogEntryBuilder.timeStamp(taskServiceConfiguration.getClock().getCurrentTime());
            taskLogEntryBuilder.userId(Authentication.getAuthenticatedUserId());
            taskLogEntryBuilder.data(data.toString());
            taskLogEntryBuilder.type(HistoricTaskLogEntryType.USER_TASK_COMPLETED.name());
            taskServiceConfiguration.getInternalHistoryTaskManager().recordHistoryUserTaskLog((HistoricTaskLogEntryBuilder)taskLogEntryBuilder);
        }
    }

    public static void changeTaskAssignee(TaskEntity taskEntity, String assignee) {
        if (taskEntity.getAssignee() != null && !taskEntity.getAssignee().equals(assignee) || taskEntity.getAssignee() == null && assignee != null) {
            CommandContextUtil.getTaskService().changeTaskAssignee(taskEntity, assignee);
            TaskForceHelper.fireAssignmentEvents(taskEntity);
            if (taskEntity.getId() != null) {
                TaskForceHelper.addAssigneeIdentityLinks(taskEntity);
            }
        }
    }

    public static void changeTaskOwner(TaskEntity taskEntity, String owner) {
        if (taskEntity.getOwner() != null && !taskEntity.getOwner().equals(owner) || taskEntity.getOwner() == null && owner != null) {
            CommandContextUtil.getTaskService().changeTaskOwner(taskEntity, owner);
            if (taskEntity.getId() != null) {
                TaskForceHelper.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
            }
        }
    }

    public static void insertTask(TaskEntity taskEntity, ExecutionEntity execution, boolean fireCreateEvent, boolean addEntityLinks) {
        if (execution != null && execution.getTenantId() != null) {
            taskEntity.setTenantId(execution.getTenantId());
        }
        if (execution != null) {
            execution.getTasks().add(taskEntity);
            taskEntity.setExecutionId(execution.getId());
            taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
            taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        }
        TaskForceHelper.insertTask(taskEntity, fireCreateEvent);
        if (execution != null) {
            if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
                countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() + 1);
            }
            if (addEntityLinks) {
                EntityLinkUtil.copyExistingEntityLinks(execution.getProcessInstanceId(), taskEntity.getId(), "task");
                EntityLinkUtil.createNewEntityLink(execution.getProcessInstanceId(), taskEntity.getId(), "task");
            }
        }
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher != null && eventDispatcher.isEnabled() && taskEntity.getAssignee() != null) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity));
        }
        CommandContextUtil.getActivityInstanceEntityManager().recordTaskCreated(taskEntity, execution);
    }

    public static void insertTask(TaskEntity taskEntity, boolean fireCreateEvent) {
        if (taskEntity.getOwner() != null) {
            TaskForceHelper.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
        }
        if (taskEntity.getAssignee() != null) {
            TaskForceHelper.addAssigneeIdentityLinks(taskEntity);
        }
        CommandContextUtil.getTaskService().insertTask(taskEntity, fireCreateEvent);
    }

    public static void addAssigneeIdentityLinks(TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            processEngineConfiguration.getIdentityLinkInterceptor().handleAddAssigneeIdentityLinkToTask(taskEntity, taskEntity.getAssignee());
        }
    }

    public static void addOwnerIdentityLink(TaskEntity taskEntity, String owner) {
        if (owner == null && taskEntity.getOwner() == null) {
            return;
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            processEngineConfiguration.getIdentityLinkInterceptor().handleAddOwnerIdentityLinkToTask(taskEntity, owner);
        }
    }

    public static void deleteTasksForExecution(ExecutionEntity executionEntity, Collection<TaskEntity> taskEntities, String deleteReason) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        for (TaskEntity taskEntity : taskEntities) {
            TaskForceHelper.internalDeleteTask(taskEntity, deleteReason, false, false, true, true);
        }
        CommandContextUtil.getTaskService(commandContext).deleteTasksByExecutionId(executionEntity.getId());
    }

    public static void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean fireTaskListener, boolean fireEvents) {
        TaskForceHelper.internalDeleteTask(task, deleteReason, cascade, true, fireTaskListener, fireEvents);
    }

    protected static void internalDeleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean executeTaskDelete, boolean fireTaskListener, boolean fireEvents) {
        if (!task.isDeleted()) {
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext);
            boolean bl = fireEvents = fireEvents && eventDispatcher != null && eventDispatcher.isEnabled();
            if (fireTaskListener) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(task, "delete");
            }
            task.setDeleted(true);
            TaskForceHelper.handleRelatedEntities(commandContext, task, deleteReason, cascade, fireTaskListener, fireEvents, eventDispatcher);
            TaskForceHelper.handleTaskHistory(commandContext, task, deleteReason, cascade);
            if (executeTaskDelete) {
                TaskForceHelper.executeTaskDelete(task, commandContext);
            }
            if (fireEvents) {
                TaskForceHelper.fireTaskDeletedEvent(task, commandContext, eventDispatcher);
            }
        }
    }

    protected static void handleRelatedEntities(CommandContext commandContext, TaskEntity task, String deleteReason, boolean cascade, boolean fireTaskListener, boolean fireEvents, FlowableEventDispatcher eventDispatcher) {
        boolean isTaskRelatedEntityCountEnabled = CountingEntityUtil.isTaskRelatedEntityCountEnabled(task);
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getSubTaskCount() > 0) {
            org.flowable.task.service.TaskService taskService = CommandContextUtil.getTaskService(commandContext);
            List subTasks = taskService.findTasksByParentTaskId(task.getId());
            for (Task subTask : subTasks) {
                TaskForceHelper.internalDeleteTask((TaskEntity)subTask, deleteReason, cascade, true, fireTaskListener, fireEvents);
            }
        }
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getIdentityLinkCount() > 0) {
            boolean deleteIdentityLinks = true;
            if (fireEvents) {
                List identityLinks = CommandContextUtil.getIdentityLinkService(commandContext).findIdentityLinksByTaskId(task.getId());
                for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableIdentityLinkEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)identityLinkEntity));
                }
                boolean bl = deleteIdentityLinks = !identityLinks.isEmpty();
            }
            if (deleteIdentityLinks) {
                CommandContextUtil.getIdentityLinkService(commandContext).deleteIdentityLinksByTaskId(task.getId());
            }
        }
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getVariableCount() > 0) {
            Map taskVariables = task.getVariableInstanceEntities();
            ArrayList<VariableByteArrayRef> variableByteArrayRefs = new ArrayList<VariableByteArrayRef>();
            for (VariableInstanceEntity variableInstanceEntity : taskVariables.values()) {
                if (fireEvents) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)variableInstanceEntity));
                }
                if (variableInstanceEntity.getByteArrayRef() == null || variableInstanceEntity.getByteArrayRef().getId() == null) continue;
                variableByteArrayRefs.add(variableInstanceEntity.getByteArrayRef());
            }
            for (VariableByteArrayRef variableByteArrayRef : variableByteArrayRefs) {
                CommandContextUtil.getByteArrayEntityManager(commandContext).deleteByteArrayById(variableByteArrayRef.getId());
            }
            if (!taskVariables.isEmpty()) {
                CommandContextUtil.getVariableService(commandContext).deleteVariablesByTaskId(task.getId());
            }
        }
    }

    protected static void handleTaskHistory(CommandContext commandContext, TaskEntity task, String deleteReason, boolean cascade) {
        if (cascade) {
            TaskForceHelper.deleteHistoricTask(task.getId());
            TaskForceHelper.deleteHistoricTaskEventLogEntries(task.getId());
        } else {
            ExecutionEntity execution = null;
            if (task.getExecutionId() != null) {
                execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(task.getExecutionId());
            }
            CommandContextUtil.getHistoryManager(commandContext).recordTaskEnd(task, execution, deleteReason, commandContext.getCurrentEngineConfiguration().getClock().getCurrentTime());
        }
    }

    public static ProcessEngineConfigurationImpl currentEngineConfiguration() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl currentEngineConfiguration = (ProcessEngineConfigurationImpl)commandContext.getCurrentEngineConfiguration();
        return currentEngineConfiguration;
    }

    protected static void executeTaskDelete(TaskEntity task, CommandContext commandContext) {
        CountingExecutionEntity countingExecutionEntity;
        CommandContextUtil.getTaskService(commandContext).deleteTask(task, false);
        if (task.getExecutionId() != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(countingExecutionEntity = (CountingExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(task.getExecutionId()))) {
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() - 1);
        }
    }

    protected static void fireTaskDeletedEvent(TaskEntity task, CommandContext commandContext, FlowableEventDispatcher eventDispatcher) {
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            CommandContextUtil.getEventDispatcher(commandContext).dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, task));
        }
    }

    public static void deleteTask(String taskId, String deleteReason, boolean cascade) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        TaskEntity task = CommandContextUtil.getTaskService(commandContext).getTask(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new FlowableException("The task cannot be deleted because is part of a running process");
            }
            if (task.getScopeId() != null && "cmmn".equals(task.getScopeType())) {
                throw new FlowableException("The task cannot be deleted because is part of a running case");
            }
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.deleteTask(taskId, deleteReason, cascade);
                return;
            }
            TaskForceHelper.deleteTask(task, deleteReason, cascade, true, true);
        } else if (cascade) {
            TaskForceHelper.deleteHistoricTask(taskId);
            TaskForceHelper.deleteHistoricTaskEventLogEntries(taskId);
        }
    }

    public static void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        List tasks = CommandContextUtil.getTaskService().findTasksByProcessInstanceId(processInstanceId);
        List<A1FlowTaskTrajectoryEntry> a1FlowTaskTrajectoryEntries = UpdateA1FlowTaskTrajectory.listA1FlowTaskTrajectoryEntryOrderByCreateDesc(TaskForceHelper.currentEngineConfiguration(), processInstanceId);
        block0: for (TaskEntity task : tasks) {
            FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher();
            if (eventDispatcher == null || !eventDispatcher.isEnabled() || task.isCanceled()) continue;
            task.setCanceled(true);
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(task.getExecutionId());
            if (execution != null) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(execution.getActivityId(), task.getName(), task.getExecutionId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", deleteReason));
            }
            for (A1FlowTaskTrajectoryEntry ate : a1FlowTaskTrajectoryEntries) {
                if (ate == null || !StringUtils.isNotEmpty((CharSequence)ate.getNodeRunId()) || !ate.getNodeRunId().equals(task.getId())) continue;
                ate.setStatus("invalid");
                ate.setEndTime(new Date());
                ate.setOpinion("\u4f5c\u5e9f");
                ate.setStatusVal("\u4f5c\u5e9f");
                ate.setEndStatus(Integer.valueOf(0));
                UpdateA1FlowTaskTrajectory.update(TaskForceHelper.currentEngineConfiguration(), ate);
                continue block0;
            }
        }
    }

    public static void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (CommandContextUtil.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
            List taskInstances = historicTaskService.findHistoricTasksByProcessInstanceId(processInstanceId);
            for (HistoricTaskInstanceEntity historicTaskInstanceEntity : taskInstances) {
                TaskForceHelper.deleteHistoricTask(historicTaskInstanceEntity.getId());
            }
        }
    }

    public static void deleteHistoricTask(String taskId) {
        if (CommandContextUtil.getHistoryManager().isHistoryEnabled()) {
            CommandContextUtil.getCommentEntityManager().deleteCommentsByTaskId(taskId);
            CommandContextUtil.getAttachmentEntityManager().deleteAttachmentsByTaskId(taskId);
            HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
            HistoricTaskInstanceEntity historicTaskInstance = historicTaskService.getHistoricTask(taskId);
            if (historicTaskInstance != null) {
                if (historicTaskInstance.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(CommandContextUtil.getCommandContext(), historicTaskInstance.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.deleteHistoricTask(taskId);
                    return;
                }
                List subTasks = historicTaskService.findHistoricTasksByParentTaskId(historicTaskInstance.getId());
                for (HistoricTaskInstance subTask : subTasks) {
                    TaskForceHelper.deleteHistoricTask(subTask.getId());
                }
                CommandContextUtil.getHistoricDetailEntityManager().deleteHistoricDetailsByTaskId(taskId);
                CommandContextUtil.getHistoricVariableService().deleteHistoricVariableInstancesByTaskId(taskId);
                CommandContextUtil.getHistoricIdentityLinkService().deleteHistoricIdentityLinksByTaskId(taskId);
                historicTaskService.deleteHistoricTask(historicTaskInstance);
            }
        }
    }

    public static void deleteHistoricTaskEventLogEntries(String taskId) {
        TaskServiceConfiguration taskServiceConfiguration = CommandContextUtil.getTaskServiceConfiguration();
        if (taskServiceConfiguration.isEnableHistoricTaskLogging()) {
            CommandContextUtil.getHistoricTaskService().deleteHistoricTaskLogEntriesForTaskId(taskId);
        }
    }

    public static boolean isFormFieldValidationEnabled(VariableContainer variableContainer, ProcessEngineConfigurationImpl processEngineConfiguration, String formFieldValidationExpression) {
        if (StringUtils.isNotEmpty((CharSequence)formFieldValidationExpression)) {
            Boolean formFieldValidation = TaskForceHelper.getBoolean(formFieldValidationExpression);
            if (formFieldValidation != null) {
                return formFieldValidation;
            }
            if (variableContainer != null) {
                ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
                Boolean formFieldValidationValue = TaskForceHelper.getBoolean(expressionManager.createExpression(formFieldValidationExpression).getValue(variableContainer));
                if (formFieldValidationValue == null) {
                    throw new FlowableException("Unable to resolve formFieldValidationExpression to boolean value");
                }
                return formFieldValidationValue;
            }
            throw new FlowableException("Unable to resolve formFieldValidationExpression without variable container");
        }
        return true;
    }

    protected static Boolean getBoolean(Object booleanObject) {
        if (booleanObject instanceof Boolean) {
            return (Boolean)booleanObject;
        }
        if (booleanObject instanceof String) {
            if ("true".equalsIgnoreCase((String)booleanObject)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase((String)booleanObject)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected static void fireAssignmentEvents(TaskEntity taskEntity) {
        CommandContextUtil.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "assignment");
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity));
        }
    }

    protected static Clock getClock() {
        return CommandContextUtil.getTaskServiceConfiguration().getClock();
    }
}

