/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.de.odysseus.el.tree.Node;
import org.flowable.common.engine.impl.de.odysseus.el.tree.RecursivelyNode;
import org.flowable.common.engine.impl.javax.el.ValueExpression;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.el.JuelExpression;
import org.flowable.engine.impl.el.UelExpressionCondition;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ConditionUtil {
    static ObjectMapper mapper = new ObjectMapper();

    public static List<Node> searchNode(SequenceFlow sequenceFlow, DelegateExecution execution) {
        String conditionExpression = null;
        if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(sequenceFlow.getId(), execution.getProcessDefinitionId());
            conditionExpression = ConditionUtil.getActiveValue(sequenceFlow.getConditionExpression(), "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = sequenceFlow.getConditionExpression();
        }
        if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
            Expression expression;
            if (!conditionExpression.contains("<![CDATA[")) {
                conditionExpression = conditionExpression.replaceAll("&lt", "<");
                conditionExpression = conditionExpression.replaceAll("&gt", ">");
            }
            if ((expression = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression)) instanceof JuelExpression) {
                JuelExpression juelExpression = (JuelExpression)expression;
                ValueExpression valueExpression = juelExpression.getValueExpression();
                List nodeList = RecursivelyNode.search((ValueExpression)valueExpression);
                return nodeList;
            }
        }
        return null;
    }

    public static boolean hasTrueCondition(SequenceFlow sequenceFlow, DelegateExecution execution) {
        boolean result = false;
        Object form_data = execution.getVariable("form_Data");
        if (form_data != null) {
            JsonNode jsonNode = (JsonNode)form_data;
            try {
                String jsonString = mapper.writeValueAsString((Object)jsonNode);
                Map map = (Map)mapper.readValue(jsonString, Map.class);
                execution.setTransientVariables(map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String conditionExpression = null;
        if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(sequenceFlow.getId(), execution.getProcessDefinitionId());
            conditionExpression = ConditionUtil.getActiveValue(sequenceFlow.getConditionExpression(), "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = sequenceFlow.getConditionExpression();
        }
        if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
            try {
                if (!conditionExpression.contains("<![CDATA[")) {
                    conditionExpression = conditionExpression.replaceAll("&lt", "<");
                    conditionExpression = conditionExpression.replaceAll("&gt", ">");
                }
                Expression expression = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression);
                UelExpressionCondition condition = new UelExpressionCondition(expression);
                result = condition.evaluate(sequenceFlow.getId(), execution);
            }
            catch (Exception exception) {}
        } else {
            result = true;
        }
        return result;
    }

    protected static String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

