/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.migration;

import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.migration.ProcessInstanceBatchMigrationPartResult;

public class ProcessInstanceBatchMigrationResult {
    public static String STATUS_IN_PROGRESS = "inProgress";
    public static String STATUS_WAITING = "waiting";
    public static String STATUS_COMPLETED = "completed";
    public static String RESULT_SUCCESS = "success";
    public static String RESULT_FAIL = "fail";
    protected String batchId;
    protected String status;
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected List<ProcessInstanceBatchMigrationPartResult> allMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();
    protected List<ProcessInstanceBatchMigrationPartResult> succesfulMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();
    protected List<ProcessInstanceBatchMigrationPartResult> failedMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();
    protected List<ProcessInstanceBatchMigrationPartResult> waitingMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSourceProcessDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    }

    public String getTargetProcessDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
    }

    public List<ProcessInstanceBatchMigrationPartResult> getAllMigrationParts() {
        return this.allMigrationParts;
    }

    public void addMigrationPart(ProcessInstanceBatchMigrationPartResult migrationPart) {
        if (this.allMigrationParts == null) {
            this.allMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();
        }
        this.allMigrationParts.add(migrationPart);
        if (!STATUS_COMPLETED.equals(migrationPart.getStatus())) {
            if (this.waitingMigrationParts == null) {
                this.waitingMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();
            }
            this.waitingMigrationParts.add(migrationPart);
        } else if (RESULT_SUCCESS.equals(migrationPart.getResult())) {
            if (this.succesfulMigrationParts == null) {
                this.succesfulMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();
            }
            this.succesfulMigrationParts.add(migrationPart);
        } else {
            if (this.failedMigrationParts == null) {
                this.failedMigrationParts = new ArrayList<ProcessInstanceBatchMigrationPartResult>();
            }
            this.failedMigrationParts.add(migrationPart);
        }
    }

    public List<ProcessInstanceBatchMigrationPartResult> getSuccessfulMigrationParts() {
        return this.succesfulMigrationParts;
    }

    public List<ProcessInstanceBatchMigrationPartResult> getFailedMigrationParts() {
        return this.failedMigrationParts;
    }

    public List<ProcessInstanceBatchMigrationPartResult> getWaitingMigrationParts() {
        return this.waitingMigrationParts;
    }
}

