










CREATE TABLE A1_APPROVAL (
  id INTEGER NOT NULL ,
  approval_content NVARCHAR2(255)  ,
  approval_type INTEGER ,
  flow_type INTEGER  ,
  status INTEGER  ,
  USER_ID INTEGER  ,
  primary key (id)
) ;



-- ----------------------------
-- Table structure for A1_APPROVAL_FLOW
-- ----------------------------
CREATE TABLE A1_APPROVAL_FLOW (
  id number(20) NOT NULL ,
  flow_id NVARCHAR2(255) ,
  flow_key NVARCHAR2(255) ,
  approval_id INTEGER ,
  primary key (id)
) ;

CREATE TABLE A1_DE_MODEL (
  ID number(20) NOT NULL  ,
  NAME NVARCHAR2(64)  NOT NULL ,
  MODEL_KEY NVARCHAR2(400)  ,
  DESCRIPTION NVARCHAR2(200)   ,
  MODEL_COMMENT INTEGER  ,
  LAST_UPDATED TIMESTAMP(6)   ,
  CREATED      TIMESTAMP(6)   ,
  CREATED_BY NVARCHAR2(255)   ,
  LAST_UPDATED_BY NVARCHAR2(64)   ,
  VERSION INTEGER DEFAULT '0' ,
  MODEL_EDITOR_XML BLOB ,
  TYPE_ID NVARCHAR2(64)   ,
  STATUS NVARCHAR2(255)  DEFAULT '0' ,
  MODEL_TYPE INTEGER  ,
  DESIGNER NVARCHAR2(64)  ,
  DEF_ID NVARCHAR2(64)   ,
  DEF_KEY NVARCHAR2(64)   ,
  DEPLOY_ID NVARCHAR2(64)  ,
  MAIN_PROCESS number(4)  ,
  REASON NVARCHAR2(255)   ,
  TENANT_ID NVARCHAR2(255)  ,
  TYPE_KEY NVARCHAR2(255)  ,
  THUMBNAIL BLOB,
  form_Json BLOB ,
  primary key (ID)
)  ;


CREATE TABLE A1_FLOW_INSTANCE (
  ID number(20) NOT NULL  ,
  PROC_DEF_NAME NVARCHAR2(64)   ,
  SUBJECT NVARCHAR2(255)   ,
  STATUS NVARCHAR2(64)   ,
  BIZ_KEY NVARCHAR2(64)   ,
  CREATE_TIME TIMESTAMP(6)  ,
  END_TIME  TIMESTAMP(6)  ,
  PROC_DEF_id NVARCHAR2(64)   ,
  PROC_ID NVARCHAR2(64)  ,
  model_Id number(20)  ,
  title NVARCHAR2(255)   ,
  primary key (ID)
)  ;



CREATE TABLE A1_FLOW_TASK_MANUAL_PROCESSING (
  ID number(20) NOT NULL  ,
  PROC_DEF_id NVARCHAR2(64)   ,
  PROC_ID NVARCHAR2(64)   ,
  task_ID NVARCHAR2(64)   ,
  TASK_KEY NVARCHAR2(64)  ,
  STATUS NVARCHAR2(64)  DEFAULT '0' ,
  CREATE_TIME TIMESTAMP(6)  ,
  primary key (ID)
)  ;

CREATE TABLE A1_FLOW_TASK_TRAJECTORY (
  ID number(20) NOT NULL  ,
  PROC_DEF_id NVARCHAR2(64)   ,
  PROC_ID NVARCHAR2(64)   ,
  task_ID NVARCHAR2(64)   ,
  FROM_NODE_ID NVARCHAR2(64)   ,
  TO_NODE_ID NVARCHAR2(64)   ,
  STATUS NVARCHAR2(64)  ,
  OPINION NVARCHAR2(64)   ,
  STATUS_VAL NVARCHAR2(64)   ,
  INNER_STATUS NVARCHAR2(64)   ,
  ACTIVITY_INSTANCE_ID NVARCHAR2(64)   ,
  NODE_TYPE NVARCHAR2(64),
  END_STATUS INTEGER  ,
  USER_NAME NVARCHAR2(255)  ,
  USER_ID NVARCHAR2(64)   ,
  SUSPENSION_STATE INTEGER  ,
  TASK_USER_TYPE NVARCHAR2(64),
  NODE_RUN_ID NVARCHAR2(64)  ,
  CREATE_TIME TIMESTAMP(6) ,
  title NVARCHAR2(255)   ,
  pre_node_id NVARCHAR2(255)  ,
  primary key (ID)
)  ;

-- ----------------------------
-- Records of A1_FLOW_TASK_TRAJECTORY
-- ----------------------------






CREATE TABLE A1_SCRIPT_COMMON_MODEL (
  ID number(20) NOT NULL  ,
  NAME NVARCHAR2(64)  NOT NULL ,
  SCRIPT NVARCHAR2(255)  DEFAULT '0' ,
  CATEGORY NVARCHAR2(255)   ,
  MEMO NVARCHAR2(255)   ,
  STATUS NVARCHAR2(255)  DEFAULT '0' ,
  IS_DELETED   NUMBER(1,0) DEFAULT (0) CHECK (IS_DELETED IN (1,0)) ,
  primary key (ID)
)  ;


INSERT INTO A1_SCRIPT_COMMON_MODEL VALUES (7, '获取当前日期（指定格式）', 'return commonScript.getCurrentDate();', '6', '获取当前日期，按指定格式输出', '6', 0);
INSERT INTO A1_SCRIPT_COMMON_MODEL VALUES (8, '登录人id', 'return commonScript.getCurrentUserId();', '7', '获取登录人id', '6', 0);
INSERT INTO A1_SCRIPT_COMMON_MODEL VALUES (9, '获取当前登录人信息', 'return commonScript.getUserInfo();', '6', '获取当前登录人信息', '6', 0);
INSERT INTO A1_SCRIPT_COMMON_MODEL VALUES (15, '2', '2', '9', '2', '9', 1);


CREATE TABLE A1_SCRIPT_TYPE (
  ID number(20) NOT NULL  ,
  CATEGORY NVARCHAR2(64)  NOT NULL ,
  STATUS NVARCHAR2(255)  DEFAULT '0' ,
  TYPE NVARCHAR2(255)  ,
  primary key (ID)
)  ;



CREATE TABLE A1_USER_ORG_CODE (
  ID number(20) NOT NULL  ,
  NAME NVARCHAR2(64)  NOT NULL ,
  CODE NVARCHAR2(64)  NOT NULL ,
  TYPE NVARCHAR2(64)   ,
  DESCRIPTION NVARCHAR2(200)   ,
  ORDER_ID INTEGER  ,
  PARENT_ID number(20) ,
  primary key (ID)
)  ;


INSERT INTO A1_USER_ORG_CODE VALUES (1, '用户', 'user', 'idm_user', '用户', 1, NULL);
INSERT INTO A1_USER_ORG_CODE VALUES (2, '组', 'group', 'idm_role', '组', 1, NULL);
INSERT INTO A1_USER_ORG_CODE VALUES (3, '用户', 'users', 'users', '用户', 1, NULL);


CREATE TABLE ACT_CMMN_DEPLOYMENT (
  ID_ NVARCHAR2(255)  NOT NULL,
  NAME_ NVARCHAR2(255)  ,
  CATEGORY_ NVARCHAR2(255)  ,
  KEY_ NVARCHAR2(255)  ,
  DEPLOY_TIME_ TIMESTAMP(6) ,
  PARENT_DEPLOYMENT_ID_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;
CREATE TABLE ACT_CMMN_CASEDEF (
  ID_ NVARCHAR2(255)  NOT NULL,
  REV_ INTEGER NOT NULL,
  NAME_ NVARCHAR2(255)  ,
  KEY_ NVARCHAR2(255)  NOT NULL,
  VERSION_ INTEGER NOT NULL,
  CATEGORY_ NVARCHAR2(255)  ,
  DEPLOYMENT_ID_ NVARCHAR2(255)  ,
  RESOURCE_NAME_ NVARCHAR2(2000)  ,
  DESCRIPTION_ VARCHAR2(2000)  ,
  HAS_GRAPHICAL_NOTATION_ NUMBER(1) ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  DGRM_RESOURCE_NAME_ VARCHAR2(2000)  ,
  HAS_START_FORM_KEY_ NUMBER(1) ,
  primary key (ID_)
) ;





CREATE TABLE ACT_CMMN_DATABASECHANGELOG (
  ID NVARCHAR2(255)  NOT NULL,
  AUTHOR NVARCHAR2(255)  NOT NULL,
  FILENAME NVARCHAR2(255)  NOT NULL,
  DATEEXECUTED TIMESTAMP(6) NOT NULL,
  ORDEREXECUTED INTEGER NOT NULL,
  EXECTYPE NVARCHAR2(10)  NOT NULL,
  MD5SUM NVARCHAR2(35)  ,
  DESCRIPTION NVARCHAR2(255)  ,
  COMMENTS NVARCHAR2(255)  ,
  TAG NVARCHAR2(255)  ,
  LIQUIBASE NVARCHAR2(20)  ,
  CONTEXTS NVARCHAR2(255)  ,
  LABELS NVARCHAR2(255)  ,
  DEPLOYMENT_ID NVARCHAR2(10)
) ;



CREATE TABLE ACT_CMMN_DATABASECHANGELOGLOCK (
  ID INTEGER NOT NULL,
  LOCKED NUMBER(1) NOT NULL,
  LOCKGRANTED TIMESTAMP(6) ,
  LOCKEDBY NVARCHAR2(255)  ,
  primary key (ID)
) ;


INSERT INTO ACT_CMMN_DATABASECHANGELOGLOCK VALUES (1, '0', NULL, NULL);





CREATE TABLE ACT_CMMN_DEPLOYMENT_RESOURCE (
  ID_ NVARCHAR2(255)  NOT NULL,
  NAME_ NVARCHAR2(255)  ,
  DEPLOYMENT_ID_ NVARCHAR2(255)  ,
  RESOURCE_BYTES_ BLOB,
  GENERATED_ NUMBER(1) ,
  primary key (ID_)
) ;


CREATE TABLE ACT_CMMN_HI_CASE_INST (
  ID_ NVARCHAR2(255)  NOT NULL,
  REV_ INTEGER NOT NULL,
  BUSINESS_KEY_ NVARCHAR2(255)  ,
  NAME_ NVARCHAR2(255)  ,
  PARENT_ID_ NVARCHAR2(255)  ,
  CASE_DEF_ID_ NVARCHAR2(255)  ,
  STATE_ NVARCHAR2(255)  ,
  START_TIME_ TIMESTAMP(6) ,
  END_TIME_ TIMESTAMP(6) ,
  START_USER_ID_ NVARCHAR2(255)  ,
  CALLBACK_ID_ NVARCHAR2(255)  ,
  CALLBACK_TYPE_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;




CREATE TABLE ACT_CMMN_HI_MIL_INST (
  ID_ NVARCHAR2(255)  NOT NULL,
  REV_ INTEGER NOT NULL,
  NAME_ NVARCHAR2(255)  NOT NULL,
  TIME_STAMP_ TIMESTAMP(6) ,
  CASE_INST_ID_ NVARCHAR2(255)  NOT NULL,
  CASE_DEF_ID_ NVARCHAR2(255)  NOT NULL,
  ELEMENT_ID_ NVARCHAR2(255)  NOT NULL,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;


CREATE TABLE ACT_CMMN_HI_PLAN_ITEM_INST (
  ID_ NVARCHAR2(255)  NOT NULL,
  REV_ INTEGER NOT NULL,
  NAME_ NVARCHAR2(255)  ,
  STATE_ NVARCHAR2(255)  ,
  CASE_DEF_ID_ NVARCHAR2(255)  ,
  CASE_INST_ID_ NVARCHAR2(255)  ,
  STAGE_INST_ID_ NVARCHAR2(255)  ,
  IS_STAGE_ NUMBER(1) ,
  ELEMENT_ID_ NVARCHAR2(255)  ,
  ITEM_DEFINITION_ID_ NVARCHAR2(255)  ,
  ITEM_DEFINITION_TYPE_ NVARCHAR2(255)  ,
  CREATE_TIME_ TIMESTAMP(6) ,
  LAST_AVAILABLE_TIME_ TIMESTAMP(6) ,
  LAST_ENABLED_TIME_ TIMESTAMP(6) ,
  LAST_DISABLED_TIME_ TIMESTAMP(6) ,
  LAST_STARTED_TIME_ TIMESTAMP(6) ,
  LAST_SUSPENDED_TIME_ TIMESTAMP(6) ,
  COMPLETED_TIME_ TIMESTAMP(6) ,
  OCCURRED_TIME_ TIMESTAMP(6) ,
  TERMINATED_TIME_ TIMESTAMP(6) ,
  EXIT_TIME_ TIMESTAMP(6) ,
  ENDED_TIME_ TIMESTAMP(6) ,
  LAST_UPDATED_TIME_ TIMESTAMP(6) ,
  START_USER_ID_ NVARCHAR2(255)  ,
  REFERENCE_ID_ NVARCHAR2(255)  ,
  REFERENCE_TYPE_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  ENTRY_CRITERION_ID_ NVARCHAR2(255)  ,
  EXIT_CRITERION_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;





CREATE TABLE ACT_CMMN_RU_CASE_INST (
  ID_ NVARCHAR2(255)  NOT NULL,
  REV_ INTEGER NOT NULL,
  BUSINESS_KEY_ NVARCHAR2(255)  ,
  NAME_ NVARCHAR2(255)  ,
  PARENT_ID_ NVARCHAR2(255)  ,
  CASE_DEF_ID_ NVARCHAR2(255)  ,
  STATE_ NVARCHAR2(255)  ,
  START_TIME_ TIMESTAMP(6) ,
  START_USER_ID_ NVARCHAR2(255)  ,
  CALLBACK_ID_ NVARCHAR2(255)  ,
  CALLBACK_TYPE_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  LOCK_TIME_ TIMESTAMP(6) ,
  IS_COMPLETEABLE_ NUMBER(1) ,
  primary key (ID_)
) ;


CREATE TABLE ACT_CMMN_RU_MIL_INST (
  ID_ NVARCHAR2(255)  NOT NULL,
  NAME_ NVARCHAR2(255)  NOT NULL,
  TIME_STAMP_ TIMESTAMP(6) ,
  CASE_INST_ID_ NVARCHAR2(255)  NOT NULL,
  CASE_DEF_ID_ NVARCHAR2(255)  NOT NULL,
  ELEMENT_ID_ NVARCHAR2(255)  NOT NULL,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;


CREATE TABLE ACT_CMMN_RU_PLAN_ITEM_INST (
  ID_ NVARCHAR2(255)  NOT NULL,
  REV_ INTEGER NOT NULL,
  CASE_DEF_ID_ NVARCHAR2(255)  ,
  CASE_INST_ID_ NVARCHAR2(255)  ,
  STAGE_INST_ID_ NVARCHAR2(255)  ,
  IS_STAGE_ NUMBER(1) ,
  ELEMENT_ID_ NVARCHAR2(255)  ,
  NAME_ NVARCHAR2(255)  ,
  STATE_ NVARCHAR2(255)  ,
  CREATE_TIME_ TIMESTAMP(6) ,
  START_USER_ID_ NVARCHAR2(255)  ,
  REFERENCE_ID_ NVARCHAR2(255)  ,
  REFERENCE_TYPE_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  ITEM_DEFINITION_ID_ NVARCHAR2(255)  ,
  ITEM_DEFINITION_TYPE_ NVARCHAR2(255)  ,
  IS_COMPLETEABLE_ NUMBER(1) ,
  IS_COUNT_ENABLED_ NUMBER(1) ,
  VAR_COUNT_ INTEGER ,
  SENTRY_PART_INST_COUNT_ INTEGER ,
  LAST_AVAILABLE_TIME_ TIMESTAMP(6) ,
  LAST_ENABLED_TIME_ TIMESTAMP(6) ,
  LAST_DISABLED_TIME_ TIMESTAMP(6) ,
  LAST_STARTED_TIME_ TIMESTAMP(6) ,
  LAST_SUSPENDED_TIME_ TIMESTAMP(6) ,
  COMPLETED_TIME_ TIMESTAMP(6) ,
  OCCURRED_TIME_ TIMESTAMP(6) ,
  TERMINATED_TIME_ TIMESTAMP(6) ,
  EXIT_TIME_ TIMESTAMP(6) ,
  ENDED_TIME_ TIMESTAMP(6) ,
  ENTRY_CRITERION_ID_ NVARCHAR2(255)  ,
  EXIT_CRITERION_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;
CREATE TABLE ACT_CMMN_RU_SENTRY_PART_INST (
  ID_ NVARCHAR2(255)  NOT NULL,
  REV_ INTEGER NOT NULL,
  CASE_DEF_ID_ NVARCHAR2(255)  ,
  CASE_INST_ID_ NVARCHAR2(255)  ,
  PLAN_ITEM_INST_ID_ NVARCHAR2(255)  ,
  ON_PART_ID_ NVARCHAR2(255)  ,
  IF_PART_ID_ NVARCHAR2(255)  ,
  TIME_STAMP_ TIMESTAMP(6) ,
  primary key (ID_)
) ;


CREATE TABLE ACT_EVT_LOG (
  LOG_NR_ number(20) NOT NULL ,
  TYPE_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  TIME_STAMP_ TIMESTAMP(6),
  USER_ID_ NVARCHAR2(255)  ,
  DATA_ BLOB,
  LOCK_OWNER_ NVARCHAR2(255)  ,
  LOCK_TIME_ TIMESTAMP(6) NULL ,
  IS_PROCESSED_ number(4) DEFAULT '0',
  primary key (LOG_NR_)
) ;
-- ----------------------------
-- Table structure for ACT_FO_DATABASECHANGELOG
-- ----------------------------
CREATE TABLE ACT_FO_DATABASECHANGELOG (
  ID NVARCHAR2(255)  NOT NULL,
  AUTHOR NVARCHAR2(255)  NOT NULL,
  FILENAME NVARCHAR2(255)  NOT NULL,
  DATEEXECUTED TIMESTAMP(6) NOT NULL,
  ORDEREXECUTED INTEGER NOT NULL,
  EXECTYPE NVARCHAR2(10)  NOT NULL,
  MD5SUM NVARCHAR2(35)  ,
  DESCRIPTION NVARCHAR2(255)  ,
  COMMENTS NVARCHAR2(255)  ,
  TAG NVARCHAR2(255)  ,
  LIQUIBASE NVARCHAR2(20)  ,
  CONTEXTS NVARCHAR2(255)  ,
  LABELS NVARCHAR2(255)  ,
  DEPLOYMENT_ID NVARCHAR2(10)
) ;

-- ----------------------------
-- Table structure for ACT_FO_DATABASECHANGELOGLOCK
-- ----------------------------
CREATE TABLE ACT_FO_DATABASECHANGELOGLOCK (
  ID INTEGER NOT NULL,
  LOCKED NUMBER(1) NOT NULL,
  LOCKGRANTED TIMESTAMP(6) ,
  LOCKEDBY NVARCHAR2(255)  ,
  primary key (ID)
) ;

-- ----------------------------
-- Records of ACT_FO_DATABASECHANGELOGLOCK
-- ----------------------------
INSERT INTO ACT_FO_DATABASECHANGELOGLOCK VALUES (1, '0', NULL, NULL);
CREATE TABLE ACT_GE_BYTEARRAY (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  NAME_ NVARCHAR2(255)  ,
  DEPLOYMENT_ID_ NVARCHAR2(64)  ,
  BYTES_ BLOB,
  GENERATED_ number(4) ,
  primary key (ID_)
) ;



CREATE TABLE ACT_GE_PROPERTY (
  NAME_ NVARCHAR2(64)  NOT NULL ,
  VALUE_ NVARCHAR2(1000)  ,
  REV_ INTEGER ,
  primary key (NAME_)
) ;

-- ----------------------------
-- Records of ACT_GE_PROPERTY
-- ----------------------------
INSERT INTO ACT_GE_PROPERTY VALUES ('batch.schema.version', '6.5.0.2', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('cfg.execution-related-entities-count', 'true', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('cfg.task-related-entities-count', 'false', 2);
INSERT INTO ACT_GE_PROPERTY VALUES ('common.schema.version', '6.5.0.2', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('entitylink.schema.version', '6.5.0.2', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('eventsubscription.schema.version', '6.5.0.2', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('identitylink.schema.version', '6.5.0.2', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('job.schema.version', '6.5.0.2', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('next.dbid', '2630001', 1053);
INSERT INTO ACT_GE_PROPERTY VALUES ('pangu.custom.Id', '[{\"desc\":\"定时器模块\",\"muduleId\":\"JOB\",\"mudulePre\":\"PANGU-JOB-\",\"muduleStrategy\":\"1\"},{\"desc\":\"变量模块\",\"muduleId\":\"VAR\",\"mudulePre\":\"PANGU-VAR-\",\"muduleStrategy\":\"1\"},{\"desc\":\"任务模块模块\",\"muduleId\":\"TSK\",\"mudulePre\":\"PANGU-TSK-\",\"muduleStrategy\":\"1\"},{\"desc\":\"案例引擎模块\",\"muduleId\":\"CAS\",\"mudulePre\":\"PANGU-CAS-\",\"muduleStrategy\":\"1\"},{\"desc\":\"BPM引擎模块\",\"muduleId\":\"PRC\",\"mudulePre\":\"PANGU-PRC-\",\"muduleStrategy\":\"1\"},{\"desc\":\"事件订阅模块\",\"muduleId\":\"ESU\",\"mudulePre\":\"PANGU-ESU-\",\"muduleStrategy\":\"2\"}]', 8);
INSERT INTO ACT_GE_PROPERTY VALUES ('pangu.form.schema.version', 'pangu', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('schema.history', 'upgrade(6.5.0.1->6.5.0.2)', 2);
INSERT INTO ACT_GE_PROPERTY VALUES ('schema.version', '6.5.0.2', 2);
INSERT INTO ACT_GE_PROPERTY VALUES ('task.schema.version', '6.5.0.2', 1);
INSERT INTO ACT_GE_PROPERTY VALUES ('variable.schema.version', '6.5.0.2', 1);




-- ----------------------------
-- Table structure for ACT_HI_ACTINST
-- ----------------------------
CREATE TABLE ACT_HI_ACTINST (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER DEFAULT '1',
  PROC_DEF_ID_ NVARCHAR2(64)  NOT NULL,
  PROC_INST_ID_ NVARCHAR2(64)  NOT NULL,
  EXECUTION_ID_ NVARCHAR2(64)  NOT NULL,
  ACT_ID_ NVARCHAR2(255)  NOT NULL,
  TASK_ID_ NVARCHAR2(64)  ,
  CALL_PROC_INST_ID_ NVARCHAR2(64)  ,
  ACT_NAME_ NVARCHAR2(255)  ,
  ACT_TYPE_ NVARCHAR2(255)  NOT NULL,
  ASSIGNEE_ NVARCHAR2(255)  ,
  START_TIME_ TIMESTAMP(6) NOT NULL,
  END_TIME_ TIMESTAMP(6) ,
  DURATION_ number(20) ,
  DELETE_REASON_ NVARCHAR2(2000)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;



-- ----------------------------
-- Table structure for ACT_HI_ATTACHMENT
-- ----------------------------
CREATE TABLE ACT_HI_ATTACHMENT (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  USER_ID_ NVARCHAR2(255)  ,
  NAME_ NVARCHAR2(255)  ,
  DESCRIPTION_ NVARCHAR2(2000)  ,
  TYPE_ NVARCHAR2(255)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  URL_ NVARCHAR2(2000)  ,
  CONTENT_ID_ NVARCHAR2(64)  ,
  TIME_ TIMESTAMP(6) ,
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_HI_COMMENT
-- ----------------------------
CREATE TABLE ACT_HI_COMMENT (
  ID_ NVARCHAR2(64)  NOT NULL,
  TYPE_ NVARCHAR2(255)  ,
  TIME_ TIMESTAMP(6) NOT NULL,
  USER_ID_ NVARCHAR2(255)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  ACTION_ NVARCHAR2(255)  ,
  MESSAGE_ NVARCHAR2(2000)  ,
  FULL_MSG_ BLOB,
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_HI_DETAIL
-- ----------------------------
CREATE TABLE ACT_HI_DETAIL (
  ID_ NVARCHAR2(64)  NOT NULL,
  TYPE_ NVARCHAR2(255)  NOT NULL,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  ACT_INST_ID_ NVARCHAR2(64)  ,
  NAME_ NVARCHAR2(255)  NOT NULL,
  VAR_TYPE_ NVARCHAR2(255)  ,
  REV_ INTEGER ,
  TIME_ TIMESTAMP(6) NOT NULL,
  BYTEARRAY_ID_ NVARCHAR2(64)  ,
  DOUBLE_ NUMBER(*,10) ,
  LONG_ number(20) ,
  TEXT_ NVARCHAR2(2000)  ,
  TEXT2_ NVARCHAR2(2000)  ,
  primary key (ID_)
) ;



CREATE TABLE ACT_HI_ENTITYLINK (
  ID_ NVARCHAR2(64)  NOT NULL ,
  LINK_TYPE_ NVARCHAR2(255)  ,
  CREATE_TIME_ TIMESTAMP(6) ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  REF_SCOPE_ID_ NVARCHAR2(255)  ,
  REF_SCOPE_TYPE_ NVARCHAR2(255)  ,
  REF_SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  HIERARCHY_TYPE_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;
CREATE TABLE ACT_HI_IDENTITYLINK (
  ID_ NVARCHAR2(64)  NOT NULL ,
  GROUP_ID_ NVARCHAR2(255)  ,
  TYPE_ NVARCHAR2(255)  ,
  USER_ID_ NVARCHAR2(255)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  CREATE_TIME_ TIMESTAMP(6) ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;


CREATE TABLE ACT_HI_PROCINST (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER DEFAULT '1',
  PROC_INST_ID_ NVARCHAR2(64)  NOT NULL,
  BUSINESS_KEY_ NVARCHAR2(255)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  NOT NULL,
  START_TIME_ TIMESTAMP(6) NOT NULL,
  END_TIME_ TIMESTAMP(6) ,
  DURATION_ number(20) ,
  START_USER_ID_ NVARCHAR2(255)  ,
  START_ACT_ID_ NVARCHAR2(255)  ,
  END_ACT_ID_ NVARCHAR2(255)  ,
  SUPER_PROCESS_INSTANCE_ID_ NVARCHAR2(64)  ,
  DELETE_REASON_ NVARCHAR2(2000)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  NAME_ NVARCHAR2(255)  ,
  CALLBACK_ID_ NVARCHAR2(255)  ,
  CALLBACK_TYPE_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;


CREATE TABLE ACT_HI_TASKINST (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER DEFAULT '1',
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  TASK_DEF_ID_ NVARCHAR2(64)  ,
  TASK_DEF_KEY_ NVARCHAR2(255)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  NAME_ NVARCHAR2(255)  ,
  PARENT_TASK_ID_ NVARCHAR2(64)  ,
  DESCRIPTION_ NVARCHAR2(2000)  ,
  OWNER_ NVARCHAR2(255)  ,
  ASSIGNEE_ NVARCHAR2(255)  ,
  START_TIME_ TIMESTAMP(6) NOT NULL,
  CLAIM_TIME_ TIMESTAMP(6) ,
  END_TIME_ TIMESTAMP(6) ,
  DURATION_ number(20) ,
  DELETE_REASON_ NVARCHAR2(2000)  ,
  PRIORITY_ INTEGER ,
  DUE_DATE_ TIMESTAMP(6) ,
  FORM_KEY_ NVARCHAR2(255)  ,
  CATEGORY_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  LAST_UPDATED_TIME_ TIMESTAMP(6) ,
  primary key (ID_)
) ;

CREATE TABLE ACT_HI_TSK_LOG (
  ID_ number(20) NOT NULL ,
  TYPE_ NVARCHAR2(64)  ,
  TASK_ID_ NVARCHAR2(64)  NOT NULL,
  TIME_STAMP_ TIMESTAMP(6),
  USER_ID_ NVARCHAR2(255)  ,
  DATA_ NVARCHAR2(2000)  ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;
CREATE TABLE ACT_HI_VARINST (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER DEFAULT '1',
  PROC_INST_ID_ NVARCHAR2(64)  ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  NAME_ NVARCHAR2(255)  NOT NULL,
  VAR_TYPE_ NVARCHAR2(100)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  BYTEARRAY_ID_ NVARCHAR2(64)  ,
  DOUBLE_ NUMBER(*,10) ,
  LONG_ number(20) ,
  TEXT_ NVARCHAR2(2000)  ,
  TEXT2_ NVARCHAR2(2000)  ,
  CREATE_TIME_ TIMESTAMP(6) ,
  LAST_UPDATED_TIME_ TIMESTAMP(6) ,
  primary key (ID_)
) ;

CREATE TABLE ACT_ID_BYTEARRAY (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  NAME_ NVARCHAR2(255)  ,
  BYTES_ BLOB,
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_ID_GROUP
-- ----------------------------
CREATE TABLE ACT_ID_GROUP (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  NAME_ NVARCHAR2(255)  ,
  TYPE_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;

CREATE TABLE ACT_ID_INFO (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  USER_ID_ NVARCHAR2(64)  ,
  TYPE_ NVARCHAR2(64)  ,
  KEY_ NVARCHAR2(255)  ,
  VALUE_ NVARCHAR2(255)  ,
  PASSWORD_ BLOB,
  PARENT_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_ID_MEMBERSHIP
-- ----------------------------
CREATE TABLE ACT_ID_MEMBERSHIP (
  USER_ID_ NVARCHAR2(64)  NOT NULL ,
  GROUP_ID_ NVARCHAR2(64)  NOT NULL ,
  primary key (USER_ID_,GROUP_ID_)
) ;


CREATE TABLE ACT_ID_PRIV (
  ID_ NVARCHAR2(64)  NOT NULL,
  NAME_ NVARCHAR2(255)  NOT NULL,
  primary key (ID_)
) ;


CREATE TABLE ACT_ID_PRIV_MAPPING (
  ID_ NVARCHAR2(64)  NOT NULL,
  PRIV_ID_ NVARCHAR2(64)  NOT NULL,
  USER_ID_ NVARCHAR2(255)  ,
  GROUP_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_ID_PROPERTY
-- ----------------------------
CREATE TABLE ACT_ID_PROPERTY (
  NAME_ NVARCHAR2(64)  NOT NULL ,
  VALUE_ NVARCHAR2(300)  ,
  REV_ INTEGER ,
  primary key (NAME_)
) ;
INSERT INTO ACT_ID_PROPERTY VALUES ('schema.version', '6.5.0.2', 1);
CREATE TABLE ACT_ID_TOKEN (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  TOKEN_VALUE_ NVARCHAR2(255)  ,
  TOKEN_DATE_ TIMESTAMP(6),
  IP_ADDRESS_ NVARCHAR2(255)  ,
  USER_AGENT_ NVARCHAR2(255)  ,
  USER_ID_ NVARCHAR2(255)  ,
  TOKEN_DATA_ NVARCHAR2(2000)  ,
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_ID_USER
-- ----------------------------
CREATE TABLE ACT_ID_USER (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  FIRST_ NVARCHAR2(255)  ,
  LAST_ NVARCHAR2(255)  ,
  DISPLAY_NAME_ NVARCHAR2(255)  ,
  EMAIL_ NVARCHAR2(255)  ,
  PWD_ NVARCHAR2(255)  ,
  PICTURE_ID_ NVARCHAR2(64)  ,
  TENANT_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;
CREATE TABLE ACT_PROCDEF_INFO (
  ID_ NVARCHAR2(64)  NOT NULL,
  PROC_DEF_ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  INFO_JSON_ID_ NVARCHAR2(64)  ,
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_RE_DEPLOYMENT
-- ----------------------------
CREATE TABLE ACT_RE_DEPLOYMENT (
  ID_ NVARCHAR2(64)  NOT NULL ,
  NAME_ NVARCHAR2(255)  ,
  CATEGORY_ NVARCHAR2(255)  ,
  KEY_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  DEPLOY_TIME_ TIMESTAMP(6) NULL ,
  DERIVED_FROM_ NVARCHAR2(64)  ,
  DERIVED_FROM_ROOT_ NVARCHAR2(64)  ,
  PARENT_DEPLOYMENT_ID_ NVARCHAR2(255)  ,
  ENGINE_VERSION_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;

CREATE TABLE ACT_RE_MODEL (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  NAME_ NVARCHAR2(255)  ,
  KEY_ NVARCHAR2(255)  ,
  CATEGORY_ NVARCHAR2(255)  ,
  CREATE_TIME_ TIMESTAMP(6)  ,
  LAST_UPDATE_TIME_ TIMESTAMP(6)  ,
  VERSION_ INTEGER ,
  META_INFO_ NVARCHAR2(2000)  ,
  DEPLOYMENT_ID_ NVARCHAR2(64)  ,
  EDITOR_SOURCE_VALUE_ID_ NVARCHAR2(64)  ,
  EDITOR_SOURCE_EXTRA_VALUE_ID_ NVARCHAR2(64)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;

CREATE TABLE ACT_RE_PROCDEF (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  CATEGORY_ NVARCHAR2(255)  ,
  NAME_ NVARCHAR2(255)  ,
  KEY_ NVARCHAR2(255)  NOT NULL,
  VERSION_ INTEGER NOT NULL,
  DEPLOYMENT_ID_ NVARCHAR2(64)  ,
  RESOURCE_NAME_ NVARCHAR2(2000)  ,
  DGRM_RESOURCE_NAME_ NVARCHAR2(2000)  ,
  DESCRIPTION_ NVARCHAR2(2000)  ,
  HAS_START_FORM_KEY_ number(4) ,
  HAS_GRAPHICAL_NOTATION_ number(4) ,
  SUSPENSION_STATE_ INTEGER ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  ENGINE_VERSION_ NVARCHAR2(255)  ,
  DERIVED_FROM_ NVARCHAR2(64)  ,
  DERIVED_FROM_ROOT_ NVARCHAR2(64)  ,
  DERIVED_VERSION_ INTEGER DEFAULT '0'  NOT NULL ,
  primary key (ID_)
) ;

CREATE TABLE ACT_RE_PROCDEF_INSTANCE (
  ID number(20) NOT NULL  ,
  PROC_INST_ID NVARCHAR2(64)  NOT NULL ,
  PROC_DEF_ID NVARCHAR2(400)  ,
  MI_COMPLETE NVARCHAR2(2)  ,
  CREATE_TIME TIMESTAMP(6),
  primary key (ID)
)  ;


CREATE TABLE ACT_RE_PROCDEF_INSTANCE_MODEL (
  ID number(20) NOT NULL  ,
  PROC_INST_ID NVARCHAR2(64)  NOT NULL ,
  PROC_DEF_ID NVARCHAR2(400)   ,
  MI_COMPLETE NVARCHAR2(2) ,
  CREATE_TIME TIMESTAMP(6),
  MODEL_EDITOR_XML BLOB ,
  primary key (ID)
)  ;

CREATE TABLE ACT_RU_ACTINST (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER DEFAULT '1',
  PROC_DEF_ID_ NVARCHAR2(64)  NOT NULL,
  PROC_INST_ID_ NVARCHAR2(64)  NOT NULL,
  EXECUTION_ID_ NVARCHAR2(64)  NOT NULL,
  ACT_ID_ NVARCHAR2(255)  NOT NULL,
  TASK_ID_ NVARCHAR2(64)  ,
  CALL_PROC_INST_ID_ NVARCHAR2(64)  ,
  ACT_NAME_ NVARCHAR2(255)  ,
  ACT_TYPE_ NVARCHAR2(255)  NOT NULL,
  ASSIGNEE_ NVARCHAR2(255)  ,
  START_TIME_ TIMESTAMP(6) NOT NULL,
  END_TIME_ TIMESTAMP(6) ,
  DURATION_ number(20) ,
  DELETE_REASON_ NVARCHAR2(2000)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;

CREATE TABLE ACT_RU_DEADLETTER_JOB (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  TYPE_ NVARCHAR2(255)  NOT NULL,
  EXCLUSIVE_ NUMBER(1,0) CHECK (EXCLUSIVE_ IN (1,0)),
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROCESS_INSTANCE_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  ELEMENT_ID_ NVARCHAR2(255)  ,
  ELEMENT_NAME_ NVARCHAR2(255)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  EXCEPTION_STACK_ID_ NVARCHAR2(64)  ,
  EXCEPTION_MSG_ NVARCHAR2(2000)  ,
  DUEDATE_ TIMESTAMP(6) NULL ,
  REPEAT_ NVARCHAR2(255)  ,
  HANDLER_TYPE_ NVARCHAR2(255)  ,
  HANDLER_CFG_ NVARCHAR2(2000)  ,
  CUSTOM_VALUES_ID_ NVARCHAR2(64)  ,
  CREATE_TIME_ TIMESTAMP(6) NULL ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;

CREATE TABLE ACT_RU_ENTITYLINK (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  CREATE_TIME_ TIMESTAMP(6) ,
  LINK_TYPE_ NVARCHAR2(255)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  REF_SCOPE_ID_ NVARCHAR2(255)  ,
  REF_SCOPE_TYPE_ NVARCHAR2(255)  ,
  REF_SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  HIERARCHY_TYPE_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;

CREATE TABLE ACT_RU_EVENT_SUBSCR (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  EVENT_TYPE_ NVARCHAR2(255)  NOT NULL,
  EVENT_NAME_ NVARCHAR2(255)  ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  ACTIVITY_ID_ NVARCHAR2(64)  ,
  CONFIGURATION_ NVARCHAR2(255)  ,
  CREATED_ timestamp NOT NULL ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  SUB_SCOPE_ID_ NVARCHAR2(64)  ,
  SCOPE_ID_ NVARCHAR2(64)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(64)  ,
  SCOPE_TYPE_ NVARCHAR2(64)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;


CREATE TABLE ACT_RU_EXECUTION (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  BUSINESS_KEY_ NVARCHAR2(255)  ,
  PARENT_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  SUPER_EXEC_ NVARCHAR2(64)  ,
  ROOT_PROC_INST_ID_ NVARCHAR2(64)  ,
  ACT_ID_ NVARCHAR2(255)  ,
  IS_ACTIVE_ number(4) ,
  IS_CONCURRENT_ number(4) ,
  IS_SCOPE_ number(4) ,
  IS_EVENT_SCOPE_ number(4) ,
  IS_MI_ROOT_ number(4) ,
  SUSPENSION_STATE_ INTEGER ,
  CACHED_ENT_STATE_ INTEGER ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  NAME_ NVARCHAR2(255)  ,
  START_ACT_ID_ NVARCHAR2(255)  ,
  START_TIME_ TIMESTAMP(6) ,
  START_USER_ID_ NVARCHAR2(255)  ,
  LOCK_TIME_ timestamp NULL ,
  IS_COUNT_ENABLED_ number(4) ,
  EVT_SUBSCR_COUNT_ INTEGER ,
  TASK_COUNT_ INTEGER ,
  JOB_COUNT_ INTEGER ,
  TIMER_JOB_COUNT_ INTEGER ,
  SUSP_JOB_COUNT_ INTEGER ,
  DEADLETTER_JOB_COUNT_ INTEGER ,
  VAR_COUNT_ INTEGER ,
  ID_LINK_COUNT_ INTEGER ,
  CALLBACK_ID_ NVARCHAR2(255)  ,
  CALLBACK_TYPE_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;
CREATE TABLE ACT_RU_HISTORY_JOB (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  LOCK_EXP_TIME_ timestamp NULL ,
  LOCK_OWNER_ NVARCHAR2(255)  ,
  RETRIES_ INTEGER ,
  EXCEPTION_STACK_ID_ NVARCHAR2(64)  ,
  EXCEPTION_MSG_ NVARCHAR2(2000)  ,
  HANDLER_TYPE_ NVARCHAR2(255)  ,
  HANDLER_CFG_ NVARCHAR2(2000)  ,
  CUSTOM_VALUES_ID_ NVARCHAR2(64)  ,
  ADV_HANDLER_CFG_ID_ NVARCHAR2(64)  ,
  CREATE_TIME_ timestamp NULL ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;


CREATE TABLE ACT_RU_IDENTITYLINK (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  GROUP_ID_ NVARCHAR2(255)  ,
  TYPE_ NVARCHAR2(255)  ,
  USER_ID_ NVARCHAR2(255)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;

CREATE TABLE ACT_RU_JOB (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  TYPE_ NVARCHAR2(255)  NOT NULL,
  LOCK_EXP_TIME_ timestamp NULL ,
  LOCK_OWNER_ NVARCHAR2(255)  ,
  EXCLUSIVE_ NUMBER(1,0) CHECK (EXCLUSIVE_ IN (1,0)) ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROCESS_INSTANCE_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  ELEMENT_ID_ NVARCHAR2(255)  ,
  ELEMENT_NAME_ NVARCHAR2(255)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  RETRIES_ INTEGER ,
  EXCEPTION_STACK_ID_ NVARCHAR2(64)  ,
  EXCEPTION_MSG_ NVARCHAR2(2000)  ,
  DUEDATE_ timestamp NULL ,
  REPEAT_ NVARCHAR2(255)  ,
  HANDLER_TYPE_ NVARCHAR2(255)  ,
  HANDLER_CFG_ NVARCHAR2(2000)  ,
  CUSTOM_VALUES_ID_ NVARCHAR2(64)  ,
  CREATE_TIME_ timestamp NULL ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_RU_SUSPENDED_JOB
-- ----------------------------
CREATE TABLE ACT_RU_SUSPENDED_JOB (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  TYPE_ NVARCHAR2(255)  NOT NULL,
  EXCLUSIVE_ NUMBER(1,0) CHECK (EXCLUSIVE_ IN (1,0)),
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROCESS_INSTANCE_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  ELEMENT_ID_ NVARCHAR2(255)  ,
  ELEMENT_NAME_ NVARCHAR2(255)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  RETRIES_ INTEGER ,
  EXCEPTION_STACK_ID_ NVARCHAR2(64)  ,
  EXCEPTION_MSG_ NVARCHAR2(2000)  ,
  DUEDATE_ timestamp NULL ,
  REPEAT_ NVARCHAR2(255)  ,
  HANDLER_TYPE_ NVARCHAR2(255)  ,
  HANDLER_CFG_ NVARCHAR2(2000)  ,
  CUSTOM_VALUES_ID_ NVARCHAR2(64)  ,
  CREATE_TIME_ timestamp NULL ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;

CREATE TABLE ACT_RU_TASK (
  ID_ NVARCHAR2(64)  NOT NULL ,
  REV_ INTEGER ,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  TASK_DEF_ID_ NVARCHAR2(64)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  NAME_ NVARCHAR2(255)  ,
  PARENT_TASK_ID_ NVARCHAR2(64)  ,
  DESCRIPTION_ NVARCHAR2(2000)  ,
  TASK_DEF_KEY_ NVARCHAR2(255)  ,
  OWNER_ NVARCHAR2(255)  ,
  ASSIGNEE_ NVARCHAR2(255)  ,
  DELEGATION_ NVARCHAR2(64)  ,
  PRIORITY_ INTEGER ,
  CREATE_TIME_ timestamp NULL ,
  DUE_DATE_ TIMESTAMP(6) ,
  CATEGORY_ NVARCHAR2(255)  ,
  SUSPENSION_STATE_ INTEGER ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  FORM_KEY_ NVARCHAR2(255)  ,
  CLAIM_TIME_ TIMESTAMP(6) ,
  IS_COUNT_ENABLED_ number(4) ,
  VAR_COUNT_ INTEGER ,
  ID_LINK_COUNT_ INTEGER ,
  SUB_TASK_COUNT_ INTEGER ,
  primary key (ID_)
) ;

CREATE TABLE ACT_RU_TIMER_JOB (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  TYPE_ NVARCHAR2(255)  NOT NULL,
  LOCK_EXP_TIME_ timestamp NULL ,
  LOCK_OWNER_ NVARCHAR2(255)  ,
  EXCLUSIVE_ NUMBER(1,0) CHECK (EXCLUSIVE_ IN (1,0)),
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROCESS_INSTANCE_ID_ NVARCHAR2(64)  ,
  PROC_DEF_ID_ NVARCHAR2(64)  ,
  ELEMENT_ID_ NVARCHAR2(255)  ,
  ELEMENT_NAME_ NVARCHAR2(255)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  RETRIES_ INTEGER ,
  EXCEPTION_STACK_ID_ NVARCHAR2(64)  ,
  EXCEPTION_MSG_ NVARCHAR2(2000)  ,
  DUEDATE_ timestamp NULL ,
  REPEAT_ NVARCHAR2(255)  ,
  HANDLER_TYPE_ NVARCHAR2(255)  ,
  HANDLER_CFG_ NVARCHAR2(2000)  ,
  CUSTOM_VALUES_ID_ NVARCHAR2(64)  ,
  CREATE_TIME_ timestamp NULL ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for ACT_RU_VARIABLE
-- ----------------------------
CREATE TABLE ACT_RU_VARIABLE (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  TYPE_ NVARCHAR2(255)  NOT NULL,
  NAME_ NVARCHAR2(255)  NOT NULL,
  EXECUTION_ID_ NVARCHAR2(64)  ,
  PROC_INST_ID_ NVARCHAR2(64)  ,
  TASK_ID_ NVARCHAR2(64)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SUB_SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  BYTEARRAY_ID_ NVARCHAR2(64)  ,
  DOUBLE_ NUMBER(*,10) ,
  LONG_ number(20) ,
  TEXT_ NVARCHAR2(2000)  ,
  TEXT2_ NVARCHAR2(2000)  ,
  primary key (ID_)
) ;

CREATE TABLE DATABASECHANGELOG (
  ID NVARCHAR2(255)  NOT NULL,
  AUTHOR NVARCHAR2(255)  NOT NULL,
  FILENAME NVARCHAR2(255)  NOT NULL,
  DATEEXECUTED TIMESTAMP(6) NOT NULL,
  ORDEREXECUTED INTEGER NOT NULL,
  EXECTYPE NVARCHAR2(10)  NOT NULL,
  MD5SUM NVARCHAR2(35)  ,
  DESCRIPTION NVARCHAR2(255)  ,
  COMMENTS NVARCHAR2(255)  ,
  TAG NVARCHAR2(255)  ,
  LIQUIBASE NVARCHAR2(20)  ,
  CONTEXTS NVARCHAR2(255)  ,
  LABELS NVARCHAR2(255)  ,
  DEPLOYMENT_ID NVARCHAR2(10)
) ;


-- ----------------------------
-- Table structure for DATABASECHANGELOGLOCK
-- ----------------------------
CREATE TABLE DATABASECHANGELOGLOCK (
  ID INTEGER NOT NULL,
  LOCKED NUMBER(1) NOT NULL,
  LOCKGRANTED TIMESTAMP(6) ,
  LOCKEDBY NVARCHAR2(255)  ,
  primary key (ID)
) ;


INSERT INTO DATABASECHANGELOGLOCK VALUES (1, '0', NULL, NULL);


CREATE TABLE FLW_RU_BATCH (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  TYPE_ NVARCHAR2(64)  NOT NULL,
  SEARCH_KEY_ NVARCHAR2(255)  ,
  SEARCH_KEY2_ NVARCHAR2(255)  ,
  CREATE_TIME_ TIMESTAMP(6) NOT NULL,
  COMPLETE_TIME_ TIMESTAMP(6) ,
  STATUS_ NVARCHAR2(255)  ,
  BATCH_DOC_ID_ NVARCHAR2(64)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;

-- ----------------------------
-- Table structure for FLW_RU_BATCH_PART
-- ----------------------------
CREATE TABLE FLW_RU_BATCH_PART (
  ID_ NVARCHAR2(64)  NOT NULL,
  REV_ INTEGER ,
  BATCH_ID_ NVARCHAR2(64)  ,
  TYPE_ NVARCHAR2(64)  NOT NULL,
  SCOPE_ID_ NVARCHAR2(64)  ,
  SUB_SCOPE_ID_ NVARCHAR2(64)  ,
  SCOPE_TYPE_ NVARCHAR2(64)  ,
  SEARCH_KEY_ NVARCHAR2(255)  ,
  SEARCH_KEY2_ NVARCHAR2(255)  ,
  CREATE_TIME_ TIMESTAMP(6) NOT NULL,
  COMPLETE_TIME_ TIMESTAMP(6) ,
  STATUS_ NVARCHAR2(255)  ,
  RESULT_DOC_ID_ NVARCHAR2(64)  ,
  TENANT_ID_ NVARCHAR2(255)  DEFAULT '',
  primary key (ID_)
) ;



CREATE TABLE PANGU_BPM_AGENT_DEF (
  ID NVARCHAR2(255)  NOT NULL ,
  SETTING_ID NVARCHAR2(64)   ,
  FLOW_KEY NVARCHAR2(64)  ,
  FLOW_NAME NVARCHAR2(64)   ,
  NODE_ID NVARCHAR2(64)   ,
  NODE_NAME NVARCHAR2(128)  ,
  primary key (ID)
)  ;
CREATE TABLE PANGU_BPM_AGENT_SETTING (
  ID NVARCHAR2(255)  NOT NULL ,
  SUBJECT NVARCHAR2(64)  ,
  AUTH_ID NVARCHAR2(64)   ,
  AUTH_NAME NVARCHAR2(64)   ,
  START_DATE timestamp NOT NULL ,
  END_DATE timestamp NOT NULL ,
  CREATE_BY NVARCHAR2(64)  ,
  CREATE_TIME timestamp NOT NULL ,
  IS_ENABLED number(4)  ,
  AGENT_ID NVARCHAR2(64)  ,
  AGENT_NAME NVARCHAR2(64)  ,
  TYPE INTEGER  ,
  UPDATE_BY NVARCHAR2(64)   ,
  UPDATE_TIME timestamp NOT NULL ,
  TENANT_ID NVARCHAR2(64)   ,
  OPINION NVARCHAR2(64)   ,
  primary key (ID)
)  ;

CREATE TABLE PANGU_BPM_COMMU_RECEIVER (
  ID NVARCHAR2(255)  NOT NULL ,
  COMMU_ID NVARCHAR2(64)  ,
  COMMU NVARCHAR2(64)   ,
  BATCH_ID NVARCHAR2(64)   ,
  TITLE NVARCHAR2(255)   ,
  RECEIVER_ID NVARCHAR2(64)   ,
  RECEIVER NVARCHAR2(64)  ,
  IS_READ number(4)  ,
  OPINION NVARCHAR2(64)   ,
  STATUS NVARCHAR2(64)  DEFAULT '0' ,
  RECEIVE_TIME  TIMESTAMP(6) ,
  READ_TIME  TIMESTAMP(6) ,
  COMMU_TIME  TIMESTAMP(6) ,
  PROC_DEF_id NVARCHAR2(64)  ,
  PROC_ID NVARCHAR2(64)   ,
  task_ID NVARCHAR2(64)   ,
  TYPE_KEY NVARCHAR2(64)  ,
  TYPE_TITLE NVARCHAR2(64)  ,
  primary key (ID)
)  ;


CREATE TABLE PANGU_BPM_JMS_TASK_COMMU_LOG (
  ID NVARCHAR2(255)  NOT NULL ,
  TASK_ID NVARCHAR2(255)  DEFAULT '' ,
  PROC_ID NVARCHAR2(255)   ,
  EXECUTION_ID NVARCHAR2(255)   ,
  CREATE_USER_ID NVARCHAR2(255)   ,
  CREATE_USER_NAME NVARCHAR2(255)  ,
  RECEIVER_USER_ID NVARCHAR2(255)   ,
  RECEIVER_USER_NAME NVARCHAR2(255)   ,
  USER_TYPE NVARCHAR2(255)   ,
  TEMPLATE_TYPE NVARCHAR2(255)   ,
  CREATE_TIME TIMESTAMP(6) ,
  CONTENT NVARCHAR2(255)  DEFAULT '' ,
  TYPE_KEY NVARCHAR2(255)   ,
  CONTENT_HTML NVARCHAR2(255)  DEFAULT '' ,
  NOTICE_TYPE NVARCHAR2(255)  DEFAULT '' ,
  IS_READ NUMBER(1,0) DEFAULT '0' CHECK (IS_READ IN (1,0)),
  primary key (ID)
) ;


CREATE TABLE PANGU_BPM_MSG_TEMPLATE (
  ID INTEGER NOT NULL ,
  NAME NVARCHAR2(255)  DEFAULT '',
  KEY_NAME NVARCHAR2(255)   ,
  TYPE_KEY NVARCHAR2(255)   ,
  IS_DEFAULT NVARCHAR2(255)  ,
  SUBJECT NVARCHAR2(255)   ,
  PLAIN NVARCHAR2(255)   ,
  HTML NVARCHAR2(255)   ,
  SUBJECT_TEMPLATE NVARCHAR2(255)   ,
  PLAIN_TEMPLATE NVARCHAR2(255)  ,
  HTML_TEMPLATE NVARCHAR2(255)   ,
  DISABLED  NUMBER(1,0) DEFAULT '0' CHECK (DISABLED IN (1,0)),
  primary key (ID)
) ;
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (1, '任务创建默认', 'taskcreate-default', 'taskcreate', '0', '任务创建通知', '任务创建：流程实例：${instSubject}，执行到${nodeName}', '任务创建：流程实例<a href=\\\"#\\\">${instSubject}</a>，执行到${nodeName}', '任务创建通知', '任务创建：流程实例：${instSubject}，执行到${nodeName}', '任务创建：流程实例<a href=\\\"#\\\">${instSubject}</a>，执行到${nodeName}', 0);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (2, '任务沟通默认', 'bpmcommusend-default', 'bpmcommusend', '1', '任务沟通', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', '任务沟通', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', '任务沟通提醒，${receiver}您好,任务：${taskSubject}需要与您交流，请给出意见。', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (3, '通知被代理人', 'bpmndelegate-default', 'bpmndelegate', '1', '通知被代理人', '代理通知，您的任务：${taskSubject}，代理给${agent}', '代理通知：<br />您的任务<a href=\\\"#\\\">${taskSubject}</a>，代理给${agent}', '通知被代理人', '代理通知，您的任务：${taskSubject}，代理给${agent}', '代理通知：<br />您的任务<a href=\\\"#\\\">${taskSubject}</a>，代理给${agent}', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (4, '任务沟通反馈信息', 'bpmcommufeedback-default', 'bpmcommufeedback', '1', '通知沟通人', '流程任务沟通 已经给出意见', '流程任务沟通 已经给出意见', '通知沟通人', '流程任务沟通 已经给出意见', '流程任务沟通 已经给出意见', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (5, '任务流转默认', 'bpmntasktrans-default', 'bpmntasktrans', '1', '任务流转默认', '${cause}', '任务流转通知：${instSubject}的${nodeName}任务，已经流转给你。', '任务流转默认', '${cause}', '任务流转通知：${instSubject}的${nodeName}任务，已经流转给你。', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (6, '任务创建默认', 'bpmhandto-default', 'bpmhandto', '1', '任务转交通知', '任务转交：流程实例：${instSubject}的${nodeName}任务，已经转交给你办理。', '任务转交：流程实例<a href=\\\"#\\\">${instSubject}</a>，需要你办理。', '任务转交通知', '任务转交：流程实例：${instSubject}的${nodeName}任务，已经转交给你办理。', '任务转交：流程实例<a href=\\\"#\\\">${instSubject}</a>，需要你办理。', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (7, '加签', 'bpmaddsigntask-default', 'addsigntask', '1', '加签通知', '加签通知，${sender}将任务：${taskSubject}转交给您', '加签通知：<br />${sender}邀请你参与会签任务<a href=\\\"#\\\">${taskSubject}</a>,加签原因:${cause}', '加签通知', '加签通知，${sender}将任务：${taskSubject}转交给您', '加签通知：<br />${sender}邀请你参与会签任务<a href=\\\"#\\\">${taskSubject}</a>,加签原因:${cause}', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (8, '任务完成默认', 'taskcomplete-default', 'taskcomplete', '1', '任务完成通知', '${nodeName}完成：流程实例: ${instSubject}完成.', '${nodeName}完成：流程实例: ${instSubject}完成.', '任务完成通知', '${nodeName}完成：流程实例: ${instSubject}完成.', '${nodeName}完成：流程实例: ${instSubject}完成.', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (9, '任务驳回默认', 'taskback-default', 'taskback', '1', '任务驳回通知', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', '任务驳回通知', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', '任务驳回：流程实例：${instSubject}，驳回原因:${cause}', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (10, '流程实例抄送', 'copyto-default', 'copyto', '1', '流程实例抄送', '流程实例抄送：流程${taskSubject}的${instId}实例，已经抄送给您。', NULL, '流程实例抄送', '流程实例抄送：流程${taskSubject}的${procId}实例，已经抄送给您。', '流程实例抄送：流程${taskSubject}的${procId}实例，已经抄送给您。', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (11, '流程结束默认', 'processend-default', 'processend', '1', '流程结束通知', '流程实例结束：${instSubject}，意见:${cause}。', '流程实例结束<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', '流程结束通知', '流程实例结束：${instSubject}，意见:${cause}。', '流程实例结束<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (12, '撤销流转默认', 'bpmtranscancel-default', 'bpmtranscancel', '1', '流转撤销通知', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', '流转撤销通知', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', '流转撤销：流程实例：${instSubject}的${nodeName}流转任务，已被撤销。', 0);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (13, '审批模板默认', 'bpmnapproval-default', 'bpmnapproval', '1', '审批提醒', '审批提醒，您有新的工作流需要审批：${taskSubject}。', '审批提醒：<br />您有新的工作流需要审批<a href=\\\"#\\\">${taskSubject}</a>', '审批提醒', '审批提醒，您有新的工作流需要审批：${taskSubject}。', '审批提醒：<br />您有新的工作流需要审批<a href=\\\"#\\\">${taskSubject}</a>', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (14, '驳回模板默认', 'bpmnback-default', 'bpmnback', '1', '驳回提醒', '驳回提醒，您的：${taskSubject}，请求被驳回，请处理!', '驳回提醒：<br />您的<a href=\\\"#\\\">${taskSubject}</a>请求被驳回，请处理!', '驳回提醒', '驳回提醒，您的：${taskSubject}，请求被驳回，请处理!', '驳回提醒：<br />您的<a href=\\\"#\\\">${taskSubject}</a>请求被驳回，请处理!', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (15, '撤销提醒默认', 'bpmnrecover-default', 'bpmnrecover', '1', '撤销提醒', '撤销提醒，审批任务${taskSubject}被撤销，撤销原因${cause} 原因通过cmd获取。', '撤销提醒：<br />审批任务${taskSubject}被撤销，撤销原因${cause}。', '撤销提醒', '撤销提醒，审批任务${taskSubject}被撤销，撤销原因${cause} 原因通过cmd获取。', '撤销提醒：<br />审批任务${taskSubject}被撤销，撤销原因${cause}。', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (16, '通知代理人', 'bpmnagent-default', 'bpmnagent', '1', '代理任务审批', '代理任务审批，您有新的代理任务需要审批：${taskSubject}，委托人${delegate}.', '代理任务审批：<br />您有新的代理任务需要审批<a href=\\\"#\\\">${taskSubject}</a>，委托人${delegate}.', '代理任务审批', '代理任务审批，您有新的代理任务需要审批：${taskSubject}，委托人${delegate}.', '代理任务审批：<br />您有新的代理任务需要审批<a href=\\\"#\\\">${taskSubject}</a>，委托人${delegate}.', 1);
INSERT INTO PANGU_BPM_MSG_TEMPLATE VALUES (17, '实例作废默认', 'bpmendprocess-defaultbpmendprocess-default', 'bpmendprocess', '1', '实例作废通知', '实例作废通知：${instSubject}，意见:${cause}。', '实例作废<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', '实例作废通知', '实例作废通知：${instSubject}，意见:${cause}。', '流程实例结束<a href=\\\"#\\\">${instSubject}</a>，意见:${cause}。', 1);

CREATE TABLE PANGU_BPM_SIMULATION_LOG (
  ID number(20) NOT NULL  ,
  BUSINESS_KEY NVARCHAR2(64)  NOT NULL ,
  PROC_INST_ID NVARCHAR2(64)   ,
  PROC_DEF_ID NVARCHAR2(64)   ,
  CREATE_TIME timestamp NOT NULL ,
  END_TIME timestamp NOT NULL ,
  RUN_LOG BLOB ,
  EXPECTION_INFO BLOB ,
  IS_COMPLETE NUMBER(1)  ,
  IS_DELETE NUMBER(1) ,
  primary key (ID)
)  ;


CREATE TABLE PANGU_BPM_SQL_LOG (
  ID INTEGER NOT NULL ,
  sql_content NVARCHAR2(2000)  ,
  sql_Id NVARCHAR2(255)  ,
  resource_ NVARCHAR2(255)  ,
  MY_Batis_Id NVARCHAR2(255)  ,
  cost_Time NVARCHAR2(255)  ,
  sql_command_type NVARCHAR2(255)  ,
  create_time timestamp ,
  primary key (ID)
) ;

CREATE TABLE PANGU_BPM_TASK_DELAYED (
  ID NVARCHAR2(255)  NOT NULL ,
  task_id NVARCHAR2(255)  DEFAULT '' ,
  proc_id NVARCHAR2(255)  ,
  execution_id NVARCHAR2(255)  ,
  create_user_id NVARCHAR2(255)  ,
  create_user_name NVARCHAR2(255)  ,
  type NVARCHAR2(255)   ,
  create_time TIMESTAMP(6) ,
  is_complete NUMBER(1,0) DEFAULT '0' CHECK (is_complete IN (1,0)),
  disabled NUMBER(1,0) DEFAULT '0' CHECK (disabled IN (1,0)),
  primary key (ID)
) ;

CREATE TABLE PANGU_BPM_TRANSFER_TASK_LOG (
  ID NVARCHAR2(255)  NOT NULL ,
  PREVIOUS_ASSIGNEE_ID NVARCHAR2(64)   ,
  PREVIOUS_ASSIGNEE_NAME NVARCHAR2(64)   ,
  NEW_ASSIGNEE_ID NVARCHAR2(64)   ,
  NEW_ASSIGNEE_NAME NVARCHAR2(64)  ,
  OPINION NVARCHAR2(64)  ,
  CREATE_TIME timestamp NOT NULL ,
  PROC_ID NVARCHAR2(64)  ,
  task_ID NVARCHAR2(64)   ,
  execution_ID NVARCHAR2(64)   ,
  PROC_DEF_id NVARCHAR2(64)  ,
  TYPE NVARCHAR2(64)   ,
  TYPE_ID NVARCHAR2(64)   ,
  end_TIME timestamp NULL  ,
  primary key (ID)
)  ;


-- ----------------------------
-- Table structure for PANGU_CMMN_MODEL
-- ----------------------------
CREATE TABLE PANGU_CMMN_MODEL (
  ID NVARCHAR2(255)  NOT NULL ,
  NAME NVARCHAR2(64)   ,
  MODEL_KEY NVARCHAR2(400)   ,
  DESCRIPTION NVARCHAR2(200)   ,
  MODEL_COMMENT INTEGER  ,
  CREATED timestamp NULL ,
  CREATED_BY NVARCHAR2(255)   ,
  LAST_UPDATED timestamp ,
  LAST_UPDATED_BY NVARCHAR2(64)  ,
  VERSION INTEGER DEFAULT '0' ,
  MODEL_EDITOR_XML BLOB ,
  TYPE_CODE NVARCHAR2(64)   ,
  STATUS NVARCHAR2(255)  DEFAULT '0' ,
  DEF_ID NVARCHAR2(64)   ,
  DEF_KEY NVARCHAR2(64)   ,
  DEPLOY_ID NVARCHAR2(64)   ,
  MAIN_PROCESS number(4)  ,
  REASON NVARCHAR2(255)   ,
  TENANT_ID NVARCHAR2(255)  ,
  primary key (ID)
)  ;




CREATE TABLE uc_user_under (
  id NVARCHAR2(64)  NOT NULL ,
  USER_CODE NVARCHAR2(64)   ,
  UNDER_USER_CODE NVARCHAR2(64)   ,
  ORG_CODE NVARCHAR2(64)   ,
  UPDATE_TIME TIMESTAMP(6)  ,
  IS_DELETED NUMBER(1,0) DEFAULT '0' CHECK (IS_DELETED IN (1,0)),
  VERSION INTEGER DEFAULT '0' ,
  primary key (id)
);

-- ----------------------------
-- Records of uc_user_under
-- ----------------------------
INSERT INTO uc_user_under VALUES ('677961485644726272', 'super', 'awef', 'bjgs', NULL, 0, 0);
INSERT INTO uc_user_under VALUES ('677961485644726273', 'super', 'awe', 'bjgs', NULL, 0, 0);
INSERT INTO uc_user_under VALUES ('677963619551412226', 'awef', 'super', 'bjgs', NULL, 0, 0);
INSERT INTO uc_user_under VALUES ('679040777522774016', 'awef', 'awef', 'beijingfengongsi', NULL, 0, 0);
INSERT INTO uc_user_under VALUES ('679040777522774017', 'awef', 'awe', 'beijingfengongsi', NULL, 0, 0);
INSERT INTO uc_user_under VALUES ('679040777522774018', 'awef', 'super', 'beijingfengongsi', NULL, 0, 0);


CREATE TABLE uc_user_role (
  id NVARCHAR2(255) NOT NULL,
  USER_CODE NVARCHAR2(255)  ,
  ROLE_CODE NVARCHAR2(255)  ,
  primary key (id)
) ;

-- ----------------------------
-- Records of uc_user_role
-- ----------------------------
INSERT INTO uc_user_role VALUES ('303db2f1-6978-4bb9-a083-8c8307e6a7a2', 'PG-03', 'XSJL');
INSERT INTO uc_user_role VALUES ('37e461a1-a0cc-4749-af57-f216f8393cc4', 'PG-02', 'XSZJ');
INSERT INTO uc_user_role VALUES ('44bb245d-9486-46e8-9078-49d3c557a75d', 'PG-01', 'XSRY');
INSERT INTO uc_user_role VALUES ('5c1ecbc1-1dae-46f4-97c1-71075b0dfe07', '010', 'shichangbu');
INSERT INTO uc_user_role VALUES ('678296162570076161', '012', '111');
INSERT INTO uc_user_role VALUES ('678296162570076162', 'super', '111');
INSERT INTO uc_user_role VALUES ('679792135653818368', '012', 'shichangbu');
INSERT INTO uc_user_role VALUES ('679792169153724417', '012', 'renshibu');
INSERT INTO uc_user_role VALUES ('679792169153724418', 'super', 'renshibu');
INSERT INTO uc_user_role VALUES ('9d93e93c-5720-4b25-b6e0-1f1f44c4540d', '001', 'shichangbu');
INSERT INTO uc_user_role VALUES ('aa5f8255-191d-462b-a93a-b9dc869ed777', '011', 'renshibu');

CREATE TABLE uc_user_org_post (
  ID NVARCHAR2(255)  NOT NULL ,
  USER_CODE NVARCHAR2(255)   ,
  ORG_CODE NVARCHAR2(255)   ,
  POST_CODE NVARCHAR2(255)   ,
  IS_DEFAULT number(1)  ,
  IS_LEADER NUMBER(1,0) DEFAULT '0' ,
  CREATE_TIME TIMESTAMP(6)  ,
  UPDATE_TIME TIMESTAMP(6)  ,
  CREATE_USER_NO NVARCHAR2(255)   ,
  UPDATE_USER_NO NVARCHAR2(255)  ,
  IS_REL_ACTIVE NUMBER(1,0) DEFAULT '0' CHECK (IS_REL_ACTIVE IN (1,0)),
  primary key (ID)
) ;




INSERT INTO uc_user_org_post VALUES ('171cb20d-6d4f-4765-8dbf-a7a6fc3c174a', 'PG-03', 'beijingfengongsi', 'shichangyingxiao', 1, 0, NULL, NULL, 'super', 'super', 1);
INSERT INTO uc_user_org_post VALUES ('2096b8c1-f2ef-4c3f-83e9-99887775f323', 'PG-02', 'beijingfengongsi', 'shichangyingxiao', 1, 0, NULL, NULL, 'super', 'super', 1);
INSERT INTO uc_user_org_post VALUES ('2c3bd557-8cd5-48d9-9eec-3fcca185d000', 'PG-01', 'beijingfengongsi', 'shichangyingxiao', 1, 0, NULL, NULL, 'super', 'super', 1);
INSERT INTO uc_user_org_post VALUES ('680896076600836096', '010', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030400', '010', 'beijingfengongsi', 'kaifang2', 1, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030401', '009', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030402', '009', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030403', '001', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030404', '001', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030405', '002', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030406', '002', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030407', '003', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030408', '003', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030409', '004', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030410', '004', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076605030411', '005', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076609224704', '005', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076609224705', '006', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076609224706', '006', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076609224707', '007', 'beijingfengongsi', 'shichangyingxiao', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076609224708', '007', 'beijingfengongsi', 'kaifang2', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076609224709', '011', 'beijingfengongsi', 'shichangyingxiao', 0, 0,NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896076609224710', '011', 'beijingfengongsi', 'kaifang2', 0, 0,NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896590587625472', '010', 'caiwu_genbumen', 'chuna', 1, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680896590587625473', '009', 'caiwu_genbumen', 'chuna', 0, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680897028661706752', '010', 'shanghaifengongsi', 'pangubpm_xiaoshoubu', 1, 0, NULL, NULL, NULL, NULL, 1);
INSERT INTO uc_user_org_post VALUES ('680897028665901056', '009', 'shanghaifengongsi', 'pangubpm_xiaoshoubu', 0, 0, NULL, NULL, NULL, NULL, 1);


CREATE TABLE PANGU_DMN_MODEL (
  ID NVARCHAR2(255)  NOT NULL ,
  NAME NVARCHAR2(255)   ,
  Model_KEY NVARCHAR2(255)   ,
  DESCRIPTION NVARCHAR2(255)  ,
  CATEGORY NVARCHAR2(255)   ,
  DMN_XML BLOB ,
  STATUS NVARCHAR2(20)   ,
  IS_MAIN number(4)  ,
  VERSION INTEGER  ,
  CREATE_TIME timestamp NOT NULL ,
  CREATE_BY NVARCHAR2(64)   ,
  UPDATE_TIME timestamp NOT NULL ,
  UPDATE_BY NVARCHAR2(64)   ,
  TENANT_ID NVARCHAR2(64)   ,
  primary key (ID)
)  ;

CREATE TABLE PANGU_FORM_BUSINESS_MODEL (
  ID NVARCHAR2(64)  NOT NULL ,
  DESCRIPTION NVARCHAR2(64)   ,
  MODEL_NAME NVARCHAR2(64)   ,
  TABLE_NAME NVARCHAR2(64)   ,
  GROUP_ID NVARCHAR2(64)   ,
  GROUP_NAME NVARCHAR2(64)  ,
  TYPE NVARCHAR2(64)   ,
  DS_KEY NVARCHAR2(64)   ,
  DS_NAME NVARCHAR2(64)   ,
  CREATE_BY NVARCHAR2(64)   ,
  CREATE_TIME timestamp NOT NULL,
  UPDATE_BY NVARCHAR2(64)  ,
  UPDATE_TIME timestamp  ,
  IS_CREATED_TABLE NUMBER(1)  ,
  IS_EXTERNAL NUMBER(1)  ,
  IS_DELETE NUMBER(1) ,
  primary key (ID)
)  ;

CREATE TABLE PANGU_FORM_BUS_DEFINITION (
  ID NVARCHAR2(255)  NOT NULL ,
  NAME NVARCHAR2(255)   ,
  FORM_KEY NVARCHAR2(255)   ,
  FORM_BUSINESS_ID NVARCHAR2(255)   ,
  FORM_DESC NVARCHAR2(255)   ,
  FORM_HTML BLOB ,
  STATUS NVARCHAR2(20)   ,
  FORM_TYPE NVARCHAR2(20)  ,
  GROUP_ID NVARCHAR2(255)   ,
  GROUP_NAME NVARCHAR2(255)   ,
  IS_MAIN number(4)  ,
  HIDE_MAIN number(4)  ,
  VERSION INTEGER  ,
  DEPLOYMENT_ID INTEGER  ,
  DEF_ID INTEGER  ,
  CREATE_TIME TIMESTAMP(6) ,
  CREATE_BY NVARCHAR2(64)   ,
  UPDATE_TIME TIMESTAMP(6) ,
  UPDATE_BY NVARCHAR2(64)   ,
  FORM_TAB_TITLE NVARCHAR2(200)   ,
  CLASSIFY NVARCHAR2(64)   ,
  PAGE_FORMS NVARCHAR2(2000)   ,
  PAGE_FORM_JSON BLOB ,
  SCOPE_TYPE NVARCHAR2(255)  ,
  primary key (ID)
)  ;
CREATE TABLE PANGU_FORM_DEFINITION (
  ID_ NVARCHAR2(255)  NOT NULL,
  NAME_ NVARCHAR2(255)  ,
  VERSION_ INTEGER ,
  KEY_ NVARCHAR2(255)  ,
  CATEGORY_ NVARCHAR2(255)  ,
  DEPLOYMENT_ID_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  ,
  RESOURCE_NAME_ NVARCHAR2(255)  ,
  DESCRIPTION_ NVARCHAR2(255)  ,
  SCOPE_TYPE NVARCHAR2(255)  ,
  primary key (ID_)
) ;


CREATE TABLE PANGU_FORM_RESOURCE (
  ID_ NVARCHAR2(255)  NOT NULL,
  NAME_ NVARCHAR2(255)  ,
  DEPLOYMENT_ID_ NVARCHAR2(255)  ,
  RESOURCE_BYTES_ BLOB,
  primary key (ID_)
) ;

CREATE TABLE PANGU_WORKBENCH_HOME_PORTAL (
  id NVARCHAR2(255)  NOT NULL ,
  content NVARCHAR2(255)  DEFAULT '' ,
  disabled NUMBER(1,0) DEFAULT '1' ,
  create_time TIMESTAMP(6) ,
  create_user_id NVARCHAR2(255)  ,
  create_user_name NVARCHAR2(255)  ,
  primary key (id)
) ;


CREATE TABLE PANGU_FORM_BUS_OBJECT (
  ID NVARCHAR2(255)  NOT NULL ,
  OBJ_KEY NVARCHAR2(255)   ,
  OBJ_NAME NVARCHAR2(255)   ,
  OBJ_DESC NVARCHAR2(255)   ,
  RELATION_JSON BLOB ,
  GROUP_ID NVARCHAR2(255) ,
  GROUP_NAME NVARCHAR2(255)   ,
  PERSISTENCE_TYPE NVARCHAR2(255)   ,
  CREATE_TIME TIMESTAMP(6),
  CREATE_BY NVARCHAR2(64)   ,
  UPDATE_TIME TIMESTAMP(6) ,
  UPDATE_BY NVARCHAR2(64)   ,
  VERSION INTEGER  ,
  IS_SAVE_INDEX number(1)  ,
  IS_DELETE number(1)  ,
  primary key (ID)
) ;
CREATE TABLE PANGU_FORM_DEFINITION_HISTORY (
  ID NVARCHAR2(255)  NOT NULL ,
  FORM_ID NVARCHAR2(255)   ,
  NAME NVARCHAR2(255)  ,
  FORM_DESC NVARCHAR2(255)   ,
  FORM_HTML BLOB ,
  CREATE_USER_ID NVARCHAR2(64)   ,
  CREATE_USER_NAME NVARCHAR2(64)   ,
  UPDATE_TIME TIMESTAMP(6) ,
  FORM_KEY NVARCHAR2(255)   ,
  VERSION INTEGER  ,
  CLASSIFY NVARCHAR2(64)   ,
  PAGE_FORMS NVARCHAR2(2000)   ,
  PAGE_FORM_JSON BLOB ,
  HIDE_MAIN number(4)  ,
  primary key (ID)
)  ;

-- ----------------------------
-- Table structure for PANGU_FORM_DEPLOYMENT
-- ----------------------------
CREATE TABLE PANGU_FORM_DEPLOYMENT (
  ID_ NVARCHAR2(255)  NOT NULL,
  NAME_ NVARCHAR2(255)  ,
  CATEGORY_ NVARCHAR2(255)  ,
  DEPLOY_TIME_ TIMESTAMP(6) ,
  TENANT_ID_ NVARCHAR2(255)  ,
  PARENT_DEPLOYMENT_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;

CREATE TABLE PANGU_FORM_INSTANCE (
  ID_ NVARCHAR2(255)  NOT NULL,
  FORM_DEFINITION_ID_ NVARCHAR2(255)  NOT NULL,
  TASK_ID_ NVARCHAR2(255)  ,
  PROC_INST_ID_ NVARCHAR2(255)  ,
  PROC_DEF_ID_ NVARCHAR2(255)  ,
  SUBMITTED_DATE_ TIMESTAMP(6) ,
  SUBMITTED_BY_ NVARCHAR2(255)  ,
  FORM_VALUES_ID_ NVARCHAR2(255)  ,
  TENANT_ID_ NVARCHAR2(255)  ,
  SCOPE_ID_ NVARCHAR2(255)  ,
  SCOPE_TYPE_ NVARCHAR2(255)  ,
  SCOPE_DEFINITION_ID_ NVARCHAR2(255)  ,
  primary key (ID_)
) ;


CREATE TABLE PANGU_WORKBENCH_WF_MODULE (
  id NVARCHAR2(255)  NOT NULL ,
  name NVARCHAR2(255)  DEFAULT '' ,
  code NVARCHAR2(255)  DEFAULT '' ,
  parent NVARCHAR2(255)  DEFAULT '' ,
  icon NVARCHAR2(255)  DEFAULT '' ,
  icon_class NVARCHAR2(255)  DEFAULT '' ,
  description NVARCHAR2(255)  DEFAULT '',
  node_Info_Type NVARCHAR2(255)  DEFAULT '' ,
  node_Info NVARCHAR2(255)  DEFAULT '' ,
  href NVARCHAR2(255)  DEFAULT '' ,
  model_key NVARCHAR2(255)  DEFAULT '' ,
  disabled NUMBER(1,0) DEFAULT '1',
  create_time TIMESTAMP(6) ,
  create_user_id NVARCHAR2(255)  ,
  create_user_name NVARCHAR2(255)  ,
  primary key (id)
)  ;


CREATE TABLE QRTZ_BLOB_TRIGGERS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  TRIGGER_NAME NVARCHAR2(200) NOT NULL,
  TRIGGER_GROUP NVARCHAR2(200) NOT NULL,
  BLOB_DATA blob,
  primary key (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) ;

-- ----------------------------
-- Table structure for QRTZ_CALENDARS
-- ----------------------------
CREATE TABLE QRTZ_CALENDARS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  CALENDAR_NAME NVARCHAR2(200) NOT NULL,
  CALENDAR blob NOT NULL,
  primary key (SCHED_NAME,CALENDAR_NAME)
) ;

-- ----------------------------
-- Table structure for QRTZ_CRON_TRIGGERS
-- ----------------------------
CREATE TABLE  QRTZ_CRON_TRIGGERS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  TRIGGER_NAME NVARCHAR2(200) NOT NULL,
  TRIGGER_GROUP NVARCHAR2(200) NOT NULL,
  CRON_EXPRESSION NVARCHAR2(120) NOT NULL,
  TIME_ZONE_ID NVARCHAR2(80) ,
  primary key (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)

) ;

-- ----------------------------
-- Table structure for QRTZ_FIRED_TRIGGERS
-- ----------------------------
CREATE TABLE QRTZ_FIRED_TRIGGERS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  ENTRY_ID NVARCHAR2(95) NOT NULL,
  TRIGGER_NAME NVARCHAR2(200) NOT NULL,
  TRIGGER_GROUP NVARCHAR2(200) NOT NULL,
  INSTANCE_NAME NVARCHAR2(200) NOT NULL,
  FIRED_TIME number (13) NOT NULL,
  SCHED_TIME number(13) NOT NULL,
  PRIORITY INTEGER NOT NULL,
  STATE NVARCHAR2(16) NOT NULL,
  JOB_NAME NVARCHAR2(200) ,
  JOB_GROUP NVARCHAR2(200) ,
  IS_NONCONCURRENT NVARCHAR2(1) ,
  REQUESTS_RECOVERY NVARCHAR2(1) ,
  primary key (SCHED_NAME,ENTRY_ID)
) ;

CREATE TABLE QRTZ_JOB_DETAILS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  JOB_NAME NVARCHAR2(200) NOT NULL,
  JOB_GROUP NVARCHAR2(200) NOT NULL,
  DESCRIPTION NVARCHAR2(250) ,
  JOB_CLASS_NAME NVARCHAR2(250) NOT NULL,
  IS_DURABLE NVARCHAR2(1) NOT NULL,
  IS_NONCONCURRENT NVARCHAR2(1) NOT NULL,
  IS_UPDATE_DATA NVARCHAR2(1) NOT NULL,
  REQUESTS_RECOVERY NVARCHAR2(1) NOT NULL,
  JOB_DATA blob,
  primary key (SCHED_NAME,JOB_NAME,JOB_GROUP)
) ;

-- ----------------------------
-- Table structure for QRTZ_LOCKS
-- ----------------------------
CREATE TABLE QRTZ_LOCKS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  LOCK_NAME NVARCHAR2(40) NOT NULL,
  primary key (SCHED_NAME,LOCK_NAME)
) ;


CREATE TABLE QRTZ_PAUSED_TRIGGER_GRPS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  TRIGGER_GROUP NVARCHAR2(200) NOT NULL,
  primary key (SCHED_NAME,TRIGGER_GROUP)
) ;


CREATE TABLE QRTZ_SCHEDULER_STATE (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  INSTANCE_NAME NVARCHAR2(200) NOT NULL,
  LAST_CHECKIN_TIME number(13) NOT NULL,
  CHECKIN_INTERVAL number(13) NOT NULL,
  primary key (SCHED_NAME,INSTANCE_NAME)
) ;

CREATE TABLE QRTZ_SIMPLE_TRIGGERS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  TRIGGER_NAME NVARCHAR2(200) NOT NULL,
  TRIGGER_GROUP NVARCHAR2(200) NOT NULL,
  REPEAT_COUNT number(7) ,
  REPEAT_INTERVAL number(10) NOT NULL,
  TIMES_TRIGGERED number(10) NOT NULL,
  primary key (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) ;

-- ----------------------------
-- Table structure for QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
CREATE TABLE QRTZ_SIMPROP_TRIGGERS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  TRIGGER_NAME NVARCHAR2(200) NOT NULL,
  TRIGGER_GROUP NVARCHAR2(200) NOT NULL,
  STR_PROP_1 NVARCHAR2(512) ,
  STR_PROP_2 NVARCHAR2(512) ,
  STR_PROP_3 NVARCHAR2(512) ,
  INT_PROP_1 INTEGER ,
  INT_PROP_2 INTEGER ,
  LONG_PROP_1 number(20) ,
  LONG_PROP_2 number(20) ,
  DEC_PROP_1 number(13,4) ,
  DEC_PROP_2 number(13,4) ,
  BOOL_PROP_1 NVARCHAR2(1) ,
  BOOL_PROP_2 NVARCHAR2(1) ,
  primary key (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) ;

-- ----------------------------
-- Table structure for QRTZ_TRIGGERS
-- ----------------------------
CREATE TABLE QRTZ_TRIGGERS (
  SCHED_NAME NVARCHAR2(120) NOT NULL,
  TRIGGER_NAME NVARCHAR2(200) NOT NULL,
  TRIGGER_GROUP NVARCHAR2(200) NOT NULL,
  JOB_NAME NVARCHAR2(200) NOT NULL,
  JOB_GROUP NVARCHAR2(200) NOT NULL,
  DESCRIPTION NVARCHAR2(250) ,
  NEXT_FIRE_TIME number(13) ,
  PREV_FIRE_TIME number(13) ,
  PRIORITY INTEGER ,
  TRIGGER_STATE NVARCHAR2(16) NOT NULL,
  TRIGGER_TYPE NVARCHAR2(8) NOT NULL,
  START_TIME number(13) NOT NULL,
  END_TIME number(13) ,
  CALENDAR_NAME NVARCHAR2(200) ,
  MISFIRE_INSTR number(2) ,
  JOB_DATA blob,
  primary key (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
) ;


CREATE TABLE approval (
  id INTEGER NOT NULL,
  approval_content NVARCHAR2(255)  ,
  approval_type INTEGER   ,
  flow_type INTEGER  ,
  flow_id NVARCHAR2(255)  ,
  primary key (id)
) ;


CREATE TABLE pangu_bpm_user_script (
  ID INTEGER NOT NULL ,
  class_Name NVARCHAR2(255)   ,
  class_Ins_Name NVARCHAR2(255)   ,
  method_Name NVARCHAR2(255)   ,
  method_Desc NVARCHAR2(255)   ,
  return_Type NVARCHAR2(255)   ,
  argument NVARCHAR2(1000)   ,
  enable  NUMBER(1,0) ,
  type NVARCHAR2(255) DEFAULT '0' ,
  primary key (ID)
) ;

INSERT INTO pangu_bpm_user_script VALUES (2, 'com.fastflow.modules.uc.service.ConditionScriptService', 'conditionScriptService', 'getUcUserByPostCode', '根据岗位code获取人员', 'java.util.List', '[{\n \"paraName\": \"arg0\",\n \"paraType\": \"java.lang.String\",\n \"paraDesc\": \"组织Code\",\n \"paraCtBindName\": \"code\",\n \"paraCtBindKey\": \"code\",\n  \"multiSelect\": false\n}]', 1, 0);


CREATE TABLE schedule_job (
  job_id number(20) NOT NULL  ,
  bean_name NVARCHAR2(200)  ,
  params NVARCHAR2(2000)  ,
  cron_expression NVARCHAR2(100) ,
  status number(4)  ,
  remark NVARCHAR2(255)  ,
  create_time TIMESTAMP(6)  ,
  primary key (job_id)
) ;


CREATE TABLE schedule_job_log (
  log_id number(20) NOT NULL  ,
  job_id number(20) NOT NULL ,
  bean_name NVARCHAR2(200)  ,
  params NVARCHAR2(2000)  ,
  status number(4) NOT NULL ,
  error NVARCHAR2(2000)  ,
  times INTEGER NOT NULL ,
  create_time TIMESTAMP(6)  ,
  primary key (log_id)
)  ;


CREATE TABLE sys_config (
  id number(20) NOT NULL ,
  param_key NVARCHAR2(50)  ,
  param_value NVARCHAR2(2000)  ,
  status number(4) DEFAULT '1' ,
  remark NVARCHAR2(500)  ,
  primary key (id)
) ;


CREATE TABLE sys_data_source (
  id_ NVARCHAR2(255)  NOT NULL ,
  key_ NVARCHAR2(255)   ,
  name_ NVARCHAR2(255)   ,
  desc_ NVARCHAR2(255)   ,
  db_type_ NVARCHAR2(64)   ,
  class_path_ NVARCHAR2(64)  ,
  attributes_json_ BLOB ,
  DELETED NUMBER(1,0) DEFAULT '0',
  primary key (id_)
)  ;


CREATE TABLE sys_data_source_def (
  id_ NVARCHAR2(255)  NOT NULL ,
  name_ NVARCHAR2(255)   ,
  class_path_ NVARCHAR2(255)   ,
  attributes_json_ BLOB ,
  DELETED NUMBER(1,0) CHECK (DELETED IN (1,0)),
  system NUMBER(1,0) CHECK (system IN (1,0)),
  primary key (id_)
)  ;


CREATE TABLE sys_dept (
  dept_id number(20) NOT NULL ,
  parent_id number(20) DEFAULT '0' ,
  name NVARCHAR2(50)  ,
  order_num INTEGER  ,
  del_flag number(4) DEFAULT '0',
  primary key (dept_id)
) ;


CREATE TABLE sys_dict (
  id NVARCHAR2(64)  NOT NULL ,
  name NVARCHAR2(64)  NOT NULL ,
  type_Key NVARCHAR2(64)   ,
  parent_id NVARCHAR2(64)  ,
  order_num INTEGER  ,
  status NVARCHAR2(255)  ,
  deleted NUMBER(1,0) CHECK (deleted IN (1,0)) ,
  type_group_Key NVARCHAR2(255)  ,
  level_ INTEGER  ,
  create_Time TIMESTAMP ,
  primary key (id)
)  ;


CREATE TABLE sys_log (
  id number(20) NOT NULL ,
  username NVARCHAR2(50)  ,
  operation NVARCHAR2(50)  ,
  method NVARCHAR2(200)  ,
  params NVARCHAR2(2000)  ,
  time number(20) NOT NULL ,
  ip NVARCHAR2(64)  ,
  create_date TIMESTAMP(6)  ,
  url NVARCHAR2(255) ,
  user_agent NVARCHAR2(255) ,
  type NVARCHAR2(255) ,
  primary key (id)
) ;

CREATE TABLE sys_menu (
  menu_id number(20) NOT NULL ,
  parent_id number(20) ,
  name NVARCHAR2(50)  ,
  url NVARCHAR2(200)  ,
  perms NVARCHAR2(500)  ,
  type INTEGER ,
  icon NVARCHAR2(50)  ,
  order_num INTEGER  ,
  deleted  NUMBER(1,0) CHECK (deleted IN (1,0)),
  menu_level INTEGER ,
  primary key (menu_id)
) ;

INSERT INTO sys_menu VALUES (14, 6, '日志列表', NULL, 'sys:schedule:log', 2, NULL, 0, 1, 3);
INSERT INTO sys_menu VALUES (27, 120, '参数管理', 'modules/sys/config.html', 'sys:config:list,sys:config:info,sys:config:save,sys:config:update,sys:config:delete', 1, 'fa fa-snowflake-o', 6, 0, 3);
INSERT INTO sys_menu VALUES (43, 46, '流程优化管理', 'a1bpmn/api/runtime/def/v1/def/cockpit', '', 1, 'fa fa-sitemap', 10, 0, 3);
INSERT INTO sys_menu VALUES (46, 158, '流程管理', '', '', 0, 'fa fa-rocket', 2, 0, 2);
INSERT INTO sys_menu VALUES (47, 46, '模型管理', 'modules/flowable/process.html', '', 1, 'fa fa-diamond', 0, 0, 3);
INSERT INTO sys_menu VALUES (48, 46, '实例管理', 'a1bpmn/api/runtime/instance/v1/getInstanceListVo', '', 1, 'fa fa-database', 6, 0, 3);
INSERT INTO sys_menu VALUES (100, 46, '待阅任务', 'a1bpmn/api/commu/listVo', '', 1, 'fa fa-toggle-off', 3, 0, 3);
INSERT INTO sys_menu VALUES (102, 46, '已阅任务', 'a1bpmn/api/commu/his/listVo', '', 1, 'fa fa-toggle-on', 4, 0, 3);
INSERT INTO sys_menu VALUES (103, 46, '委托设置', 'a1bpmn/api/agent/listVo', '', 1, 'fa fa-street-view', 5, 0, 3);
INSERT INTO sys_menu VALUES (107, 46, '我的任务', 'a1bpmn/api/runtime/task/v1/listVO', NULL, 1, 'fa fa-tasks', 1, 0, 3);
INSERT INTO sys_menu VALUES (108, 46, '已办任务', 'a1bpmn/api/history/task/v1/listVO', '', 1, 'fa fa-server', 2, 0, 3);
INSERT INTO sys_menu VALUES (110, 157, '业务表单', '', '', 0, 'fa fa-wpforms', 0, 0, 2);
INSERT INTO sys_menu VALUES (111, 110, '业务对象', 'form/bus/businessObject/list', '', 1, 'fa fa-moon-o', 1, 0, 3);
INSERT INTO sys_menu VALUES (112, 110, '业务实体', 'form/bus/businessTable/businessTableList', '', 1, 'fa fa-database', 0, 0, 3);
INSERT INTO sys_menu VALUES (113, 110, '表单管理', 'form/design/list', '', 0, 'fa fa-diamond', 0, 0, 3);
INSERT INTO sys_menu VALUES (120, 159, '开发', '', '', 0, 'fa fa-cog', 2, 0, 2);
INSERT INTO sys_menu VALUES (121, 46, '常用流程', 'a1bpmn/api/runtime/bpmOftenFlow/v1/listVo', NULL, 1, 'fa fa-share-alt', 7, 0, 3);
INSERT INTO sys_menu VALUES (122, 46, '常用脚本', 'a1bpmn/api/runtime/runtime/script/v1/listVO', NULL, 1, 'fa fa-random', 8, 0, 3);
INSERT INTO sys_menu VALUES (123, 46, '流程消息模板', 'a1bpmn/api/messageTemplate/listVO', '', 1, 'fa fa-envelope-o', 9, 0, 3);
INSERT INTO sys_menu VALUES (124, 120, '访问日志', 'modules/sys/log.html', 'sys:log:list', 1, 'fa fa-lastfm', 10, 0, 3);
INSERT INTO sys_menu VALUES (125, 46, '引擎SQL监控', 'modules/flowable/sqlLog.html', NULL, 1, 'fa fa-table', 11, 0, 3);
INSERT INTO sys_menu VALUES (126, 160, '用户中心', '', NULL, 0, 'fa fa-share-alt', 4, 0, 2);
INSERT INTO sys_menu VALUES (127, 126, '职务管理', 'modules/uc/ucOrgJob.html', '', 1, 'fa fa-book', 1, 0, 3);
INSERT INTO sys_menu VALUES (128, 126, '组织维度管理', 'modules/uc/ucDemension.html', NULL, 1, 'fa fa-heart', 2, 0, 3);
INSERT INTO sys_menu VALUES (129, 126, '组织管理', 'modules/uc/dept.html', '', 1, 'fa fa-truck', 3, 0, 3);
INSERT INTO sys_menu VALUES (130, 126, '岗位管理', 'modules/uc/ucOrgPost.html', NULL, 1, 'fa fa-location-arrow', 4, 0, 3);
INSERT INTO sys_menu VALUES (132, 126, '用户管理', 'modules/uc/user.html', '', 1, 'fa fa-asterisk', 1, 0, 3);
INSERT INTO sys_menu VALUES (133, 126, '角色管理', 'modules/uc/role.html', '', 1, 'fa fa-group', 1, 0, 3);
INSERT INTO sys_menu VALUES (134, 126, '用户组织参数管理', 'modules/uc/params.html', NULL, 1, 'fa fa-certificate', 1, 0, 3);
INSERT INTO sys_menu VALUES (135, 120, '菜单管理', 'modules/sys/menuList.html', NULL, 1, 'fa fa-navicon', 3, 0, 3);
INSERT INTO sys_menu VALUES (144, 46, '流程缓存监控', 'modules/flowable/cacheMonitor.html', NULL, 1, 'fa fa-bar-chart', 11, 0, 3);
INSERT INTO sys_menu VALUES (145, 161, '决策引擎', NULL, NULL, 0, 'fa fa-space-shuttle', 4, 0, 2);
INSERT INTO sys_menu VALUES (146, 145, '决策模型管理', 'modules/dmn/model.html', NULL, 1, 'fa fa-diamond', 2, 0, 3);
INSERT INTO sys_menu VALUES (147, 145, '决策引擎执行日志', 'modules/dmn/modelLog.html', NULL, 1, ' fa fa-snowflake-o', 2, 0, 3);
INSERT INTO sys_menu VALUES (149, 120, '分类标识', 'modules/data/category.html', NULL, 1, 'fa fa-sitemap', 1, 0, 3);
INSERT INTO sys_menu VALUES (150, 120, '分类管理', 'modules/data/categoryTree.html', NULL, 1, 'fa fa-sliders', 1, 0, 3);
INSERT INTO sys_menu VALUES (151, 120, '数据字典', 'modules/data/dict.html', NULL, 1, 'fa fa-database', 1, 0, 3);
INSERT INTO sys_menu VALUES (152, 120, '流水号', 'modules/data/serialNo.html', NULL, 1, 'fa fa-braille', 1, 0, 3);
INSERT INTO sys_menu VALUES (153, 120, '系统图标', 'modules/data/font.html', NULL, 1, 'fa fa-cogs', 1, 0, 3);
INSERT INTO sys_menu VALUES (155, 120, '连接池', 'modules/data/connectionPool.html', NULL, 1, 'fa fa-database', 1, 0, 3);
INSERT INTO sys_menu VALUES (156, 120, '数据源', 'modules/data/dataSource.html', NULL, 1, 'fa fa-database', 1, 0, 3);
INSERT INTO sys_menu VALUES (157, 0, '业务表单', NULL, NULL, 3, 'fa fa-wpforms', 3, 0, 1);
INSERT INTO sys_menu VALUES (158, 0, '流程', NULL, NULL, 3, 'fa fa-rocket', 1, 0, 1);
INSERT INTO sys_menu VALUES (159, 0, '开发', NULL, NULL, 3, 'fa fa-cog', 6, 0, 1);
INSERT INTO sys_menu VALUES (160, 0, '用户中心', NULL, NULL, 3, 'fa fa-street-view', 2, 0, 1);
INSERT INTO sys_menu VALUES (161, 0, 'DMN', NULL, NULL, 3, 'fa fa-tasks', 4, 0, 1);
INSERT INTO sys_menu VALUES (170, 0, '案例管理', NULL, NULL, 3, 'fa fa-plane', 5, 0, 1);
INSERT INTO sys_menu VALUES (171, 172, '案例模型管理', 'modules/cmmn/modeler.html', NULL, 1, 'fa fa-diamond', 1, 0, 3);
INSERT INTO sys_menu VALUES (172, 170, '案例管理', NULL, NULL, 2, NULL, 1, 0, 2);
INSERT INTO sys_menu VALUES (173, 172, '案例实例管理', 'modules/cmmn/instanceList.html', NULL, 1, 'fa fa-database', 2, 0, 3);
INSERT INTO sys_menu VALUES (174, 172, '历史案例实例管理', 'modules/cmmn/hisInstanceList.html', NULL, 1, 'fa fa-truck', 7, 0, 3);
INSERT INTO sys_menu VALUES (175, 172, '运行计划项管理', 'modules/cmmn/planItemList.html', NULL, 1, 'fa fa-server', 3, 0, 3);
INSERT INTO sys_menu VALUES (176, 172, '历史计划项管理', 'modules/cmmn/hisPlanItemList.html', NULL, 1, 'fa fa-wpforms', 8, 0, 3);
INSERT INTO sys_menu VALUES (177, 172, '历史里程碑管理', 'modules/cmmn/hiMilestoneList.html', NULL, 1, 'fa fa-th-list', 9, 0, 3);
INSERT INTO sys_menu VALUES (178, 172, '运行里程碑管理', 'modules/cmmn/runMilestoneList.html', NULL, 1, 'fa fa-laptop', 4, 0, 3);
INSERT INTO sys_menu VALUES (179, 172, '资源管理', 'modules/cmmn/deployment.html', NULL, 1, 'fa fa-home', 5, 0, 3);
INSERT INTO sys_menu VALUES (180, 172, '缓存监控', 'modules/cmmn/cacheMonitor.html', NULL, 1, 'fa fa-map-marker', 6, 0, 3);
INSERT INTO sys_menu VALUES (182, 46, '引擎内核监控', 'modules/flowable/cmdLog.html', NULL, 1, 'fa fa-bar-chart-o', 12, 0, 3);
INSERT INTO sys_menu VALUES (183, 46, '引擎数据链路', 'modules/flowable/dataLink.html', NULL, 1, 'fa fa-bars', 12, 0, 3);
INSERT INTO sys_menu VALUES (184, 46, '引擎主键生成策略', 'modules/flowable/idCustom.html', NULL, 1, 'fa fa-bolt', 12, 0, 3);

CREATE TABLE sys_oss (
  id number(20) NOT NULL ,
  url NVARCHAR2(200) ,
  create_date TIMESTAMP  ,
  primary key (id)
)  ;

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
CREATE TABLE sys_role (
  role_id number(20) NOT NULL ,
  role_name NVARCHAR2(100)  ,
  remark NVARCHAR2(100)  ,
  dept_id number(20)  ,
  create_time TIMESTAMP,
  primary key (role_id)
) ;


CREATE TABLE sys_role_dept (
  id number(20) NOT NULL ,
  role_id number(20)  ,
  dept_id number(20)  ,
  primary key (id)
)  ;

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
CREATE TABLE sys_role_menu (
  id number(20) NOT NULL ,
  role_id number(20)  ,
  menu_id number(20)  ,
  primary key (id)
) ;


INSERT INTO sys_role_menu VALUES (476, 9, 1);
INSERT INTO sys_role_menu VALUES (477, 9, 4);
INSERT INTO sys_role_menu VALUES (478, 9, 23);
INSERT INTO sys_role_menu VALUES (479, 9, 24);
INSERT INTO sys_role_menu VALUES (480, 9, 25);
INSERT INTO sys_role_menu VALUES (481, 9, 26);
INSERT INTO sys_role_menu VALUES (482, 9, 5);
INSERT INTO sys_role_menu VALUES (483, 9, 6);
INSERT INTO sys_role_menu VALUES (484, 9, 7);
INSERT INTO sys_role_menu VALUES (485, 9, 8);
INSERT INTO sys_role_menu VALUES (486, 9, 9);
INSERT INTO sys_role_menu VALUES (487, 9, 10);
INSERT INTO sys_role_menu VALUES (488, 9, 11);
INSERT INTO sys_role_menu VALUES (489, 9, 12);
INSERT INTO sys_role_menu VALUES (490, 9, 13);
INSERT INTO sys_role_menu VALUES (491, 9, 14);
INSERT INTO sys_role_menu VALUES (492, 9, 27);
INSERT INTO sys_role_menu VALUES (493, 9, 29);
INSERT INTO sys_role_menu VALUES (494, 9, 36);
INSERT INTO sys_role_menu VALUES (495, 9, 37);
INSERT INTO sys_role_menu VALUES (496, 9, 38);
INSERT INTO sys_role_menu VALUES (497, 9, 39);
INSERT INTO sys_role_menu VALUES (498, 9, 40);
INSERT INTO sys_role_menu VALUES (499, 9, 41);
INSERT INTO sys_role_menu VALUES (500, 9, 2);
INSERT INTO sys_role_menu VALUES (501, 9, 15);
INSERT INTO sys_role_menu VALUES (502, 9, 16);
INSERT INTO sys_role_menu VALUES (503, 9, 17);
INSERT INTO sys_role_menu VALUES (504, 9, 18);
INSERT INTO sys_role_menu VALUES (505, 9, 3);
INSERT INTO sys_role_menu VALUES (506, 9, 19);
INSERT INTO sys_role_menu VALUES (507, 9, 20);
INSERT INTO sys_role_menu VALUES (508, 9, 21);
INSERT INTO sys_role_menu VALUES (509, 9, 22);
INSERT INTO sys_role_menu VALUES (510, 9, 31);
INSERT INTO sys_role_menu VALUES (511, 9, 32);
INSERT INTO sys_role_menu VALUES (514, 9, 35);
INSERT INTO sys_role_menu VALUES (515, 9, 42);
INSERT INTO sys_role_menu VALUES (516, 9, 43);
INSERT INTO sys_role_menu VALUES (517, 9, 46);
INSERT INTO sys_role_menu VALUES (518, 9, 47);
INSERT INTO sys_role_menu VALUES (519, 9, 48);
INSERT INTO sys_role_menu VALUES (520, 9, 53);
INSERT INTO sys_role_menu VALUES (521, 9, 54);
INSERT INTO sys_role_menu VALUES (522, 9, 56);
INSERT INTO sys_role_menu VALUES (523, 9, 100);
INSERT INTO sys_role_menu VALUES (524, 9, 102);
INSERT INTO sys_role_menu VALUES (525, 9, 103);
INSERT INTO sys_role_menu VALUES (529, 11, 1);
INSERT INTO sys_role_menu VALUES (530, 11, 4);
INSERT INTO sys_role_menu VALUES (531, 11, 23);
INSERT INTO sys_role_menu VALUES (532, 11, 24);
INSERT INTO sys_role_menu VALUES (533, 11, 25);
INSERT INTO sys_role_menu VALUES (534, 11, 26);
INSERT INTO sys_role_menu VALUES (535, 11, 5);
INSERT INTO sys_role_menu VALUES (536, 11, 6);
INSERT INTO sys_role_menu VALUES (537, 11, 7);
INSERT INTO sys_role_menu VALUES (538, 11, 8);
INSERT INTO sys_role_menu VALUES (539, 11, 9);
INSERT INTO sys_role_menu VALUES (540, 11, 10);
INSERT INTO sys_role_menu VALUES (541, 11, 11);
INSERT INTO sys_role_menu VALUES (542, 11, 12);
INSERT INTO sys_role_menu VALUES (543, 11, 13);
INSERT INTO sys_role_menu VALUES (544, 11, 14);
INSERT INTO sys_role_menu VALUES (545, 11, 27);
INSERT INTO sys_role_menu VALUES (546, 11, 29);
INSERT INTO sys_role_menu VALUES (547, 11, 36);
INSERT INTO sys_role_menu VALUES (548, 11, 37);
INSERT INTO sys_role_menu VALUES (549, 11, 38);
INSERT INTO sys_role_menu VALUES (550, 11, 39);
INSERT INTO sys_role_menu VALUES (551, 11, 40);
INSERT INTO sys_role_menu VALUES (552, 11, 41);
INSERT INTO sys_role_menu VALUES (553, 11, 2);
INSERT INTO sys_role_menu VALUES (554, 11, 15);
INSERT INTO sys_role_menu VALUES (555, 11, 16);
INSERT INTO sys_role_menu VALUES (556, 11, 17);
INSERT INTO sys_role_menu VALUES (557, 11, 18);
INSERT INTO sys_role_menu VALUES (558, 11, 3);
INSERT INTO sys_role_menu VALUES (559, 11, 19);
INSERT INTO sys_role_menu VALUES (560, 11, 20);
INSERT INTO sys_role_menu VALUES (561, 11, 21);
INSERT INTO sys_role_menu VALUES (562, 11, 22);
INSERT INTO sys_role_menu VALUES (563, 11, 31);
INSERT INTO sys_role_menu VALUES (564, 11, 32);
INSERT INTO sys_role_menu VALUES (567, 11, 35);
INSERT INTO sys_role_menu VALUES (568, 11, 42);
INSERT INTO sys_role_menu VALUES (569, 11, 43);
INSERT INTO sys_role_menu VALUES (570, 11, 46);
INSERT INTO sys_role_menu VALUES (571, 11, 47);
INSERT INTO sys_role_menu VALUES (572, 11, 48);
INSERT INTO sys_role_menu VALUES (573, 11, 53);
INSERT INTO sys_role_menu VALUES (574, 11, 54);
INSERT INTO sys_role_menu VALUES (575, 11, 56);
INSERT INTO sys_role_menu VALUES (576, 11, 100);
INSERT INTO sys_role_menu VALUES (577, 11, 102);
INSERT INTO sys_role_menu VALUES (578, 11, 103);
INSERT INTO sys_role_menu VALUES (579, 12, 41);
INSERT INTO sys_role_menu VALUES (580, 12, 3);
INSERT INTO sys_role_menu VALUES (581, 12, 19);
INSERT INTO sys_role_menu VALUES (582, 12, 20);
INSERT INTO sys_role_menu VALUES (583, 12, 21);
INSERT INTO sys_role_menu VALUES (584, 12, 22);
INSERT INTO sys_role_menu VALUES (631, 13, 1);
INSERT INTO sys_role_menu VALUES (632, 13, 4);
INSERT INTO sys_role_menu VALUES (633, 13, 23);
INSERT INTO sys_role_menu VALUES (634, 13, 24);
INSERT INTO sys_role_menu VALUES (635, 13, 25);
INSERT INTO sys_role_menu VALUES (636, 13, 26);
INSERT INTO sys_role_menu VALUES (637, 13, 5);
INSERT INTO sys_role_menu VALUES (638, 13, 6);
INSERT INTO sys_role_menu VALUES (639, 13, 7);
INSERT INTO sys_role_menu VALUES (640, 13, 8);
INSERT INTO sys_role_menu VALUES (641, 13, 9);
INSERT INTO sys_role_menu VALUES (642, 13, 10);
INSERT INTO sys_role_menu VALUES (643, 13, 11);
INSERT INTO sys_role_menu VALUES (644, 13, 12);
INSERT INTO sys_role_menu VALUES (645, 13, 14);
INSERT INTO sys_role_menu VALUES (646, 13, 27);
INSERT INTO sys_role_menu VALUES (647, 13, 36);
INSERT INTO sys_role_menu VALUES (648, 13, 37);
INSERT INTO sys_role_menu VALUES (649, 13, 38);
INSERT INTO sys_role_menu VALUES (650, 13, 39);
INSERT INTO sys_role_menu VALUES (651, 13, 40);
INSERT INTO sys_role_menu VALUES (652, 13, 41);
INSERT INTO sys_role_menu VALUES (653, 13, 2);
INSERT INTO sys_role_menu VALUES (654, 13, 15);
INSERT INTO sys_role_menu VALUES (655, 13, 16);
INSERT INTO sys_role_menu VALUES (656, 13, 17);
INSERT INTO sys_role_menu VALUES (657, 13, 3);
INSERT INTO sys_role_menu VALUES (658, 13, 19);
INSERT INTO sys_role_menu VALUES (659, 13, 20);
INSERT INTO sys_role_menu VALUES (660, 13, 21);
INSERT INTO sys_role_menu VALUES (661, 13, 31);
INSERT INTO sys_role_menu VALUES (662, 13, 32);
INSERT INTO sys_role_menu VALUES (665, 13, 42);
INSERT INTO sys_role_menu VALUES (666, 13, 43);
INSERT INTO sys_role_menu VALUES (667, 13, 46);
INSERT INTO sys_role_menu VALUES (668, 13, 47);
INSERT INTO sys_role_menu VALUES (669, 13, 48);
INSERT INTO sys_role_menu VALUES (670, 13, 53);
INSERT INTO sys_role_menu VALUES (671, 13, 56);
INSERT INTO sys_role_menu VALUES (672, 13, 100);
INSERT INTO sys_role_menu VALUES (673, 13, 102);
INSERT INTO sys_role_menu VALUES (674, 13, 103);
INSERT INTO sys_role_menu VALUES (675, 13, 107);
INSERT INTO sys_role_menu VALUES (676, 13, 108);
INSERT INTO sys_role_menu VALUES (677, 8, 1);
INSERT INTO sys_role_menu VALUES (678, 8, 4);
INSERT INTO sys_role_menu VALUES (679, 8, 23);
INSERT INTO sys_role_menu VALUES (680, 8, 24);
INSERT INTO sys_role_menu VALUES (681, 8, 25);
INSERT INTO sys_role_menu VALUES (682, 8, 26);
INSERT INTO sys_role_menu VALUES (683, 8, 5);
INSERT INTO sys_role_menu VALUES (684, 8, 6);
INSERT INTO sys_role_menu VALUES (685, 8, 7);
INSERT INTO sys_role_menu VALUES (686, 8, 8);
INSERT INTO sys_role_menu VALUES (687, 8, 9);
INSERT INTO sys_role_menu VALUES (688, 8, 10);
INSERT INTO sys_role_menu VALUES (689, 8, 11);
INSERT INTO sys_role_menu VALUES (690, 8, 12);
INSERT INTO sys_role_menu VALUES (691, 8, 14);
INSERT INTO sys_role_menu VALUES (692, 8, 27);
INSERT INTO sys_role_menu VALUES (693, 8, 36);
INSERT INTO sys_role_menu VALUES (694, 8, 37);
INSERT INTO sys_role_menu VALUES (695, 8, 38);
INSERT INTO sys_role_menu VALUES (696, 8, 39);
INSERT INTO sys_role_menu VALUES (697, 8, 40);
INSERT INTO sys_role_menu VALUES (698, 8, 41);
INSERT INTO sys_role_menu VALUES (699, 8, 2);
INSERT INTO sys_role_menu VALUES (700, 8, 15);
INSERT INTO sys_role_menu VALUES (701, 8, 16);
INSERT INTO sys_role_menu VALUES (702, 8, 17);
INSERT INTO sys_role_menu VALUES (703, 8, 3);
INSERT INTO sys_role_menu VALUES (704, 8, 19);
INSERT INTO sys_role_menu VALUES (705, 8, 20);
INSERT INTO sys_role_menu VALUES (706, 8, 21);
INSERT INTO sys_role_menu VALUES (707, 8, 31);
INSERT INTO sys_role_menu VALUES (708, 8, 32);
INSERT INTO sys_role_menu VALUES (711, 8, 42);
INSERT INTO sys_role_menu VALUES (712, 8, 43);
INSERT INTO sys_role_menu VALUES (713, 8, 46);
INSERT INTO sys_role_menu VALUES (714, 8, 47);
INSERT INTO sys_role_menu VALUES (715, 8, 48);
INSERT INTO sys_role_menu VALUES (716, 8, 53);
INSERT INTO sys_role_menu VALUES (717, 8, 56);
INSERT INTO sys_role_menu VALUES (718, 8, 100);
INSERT INTO sys_role_menu VALUES (719, 8, 102);
INSERT INTO sys_role_menu VALUES (720, 8, 103);
INSERT INTO sys_role_menu VALUES (721, 8, 107);
INSERT INTO sys_role_menu VALUES (722, 8, 108);
INSERT INTO sys_role_menu VALUES (723, 6, 1);
INSERT INTO sys_role_menu VALUES (724, 6, 4);
INSERT INTO sys_role_menu VALUES (725, 6, 23);
INSERT INTO sys_role_menu VALUES (726, 6, 24);
INSERT INTO sys_role_menu VALUES (727, 6, 25);
INSERT INTO sys_role_menu VALUES (728, 6, 26);
INSERT INTO sys_role_menu VALUES (729, 6, 5);
INSERT INTO sys_role_menu VALUES (730, 6, 6);
INSERT INTO sys_role_menu VALUES (731, 6, 7);
INSERT INTO sys_role_menu VALUES (732, 6, 8);
INSERT INTO sys_role_menu VALUES (733, 6, 9);
INSERT INTO sys_role_menu VALUES (734, 6, 10);
INSERT INTO sys_role_menu VALUES (735, 6, 11);
INSERT INTO sys_role_menu VALUES (736, 6, 12);
INSERT INTO sys_role_menu VALUES (737, 6, 14);
INSERT INTO sys_role_menu VALUES (738, 6, 27);
INSERT INTO sys_role_menu VALUES (739, 6, 36);
INSERT INTO sys_role_menu VALUES (740, 6, 37);
INSERT INTO sys_role_menu VALUES (741, 6, 38);
INSERT INTO sys_role_menu VALUES (742, 6, 39);
INSERT INTO sys_role_menu VALUES (743, 6, 40);
INSERT INTO sys_role_menu VALUES (744, 6, 41);
INSERT INTO sys_role_menu VALUES (745, 6, 2);
INSERT INTO sys_role_menu VALUES (746, 6, 15);
INSERT INTO sys_role_menu VALUES (747, 6, 16);
INSERT INTO sys_role_menu VALUES (748, 6, 17);
INSERT INTO sys_role_menu VALUES (749, 6, 3);
INSERT INTO sys_role_menu VALUES (750, 6, 19);
INSERT INTO sys_role_menu VALUES (751, 6, 20);
INSERT INTO sys_role_menu VALUES (752, 6, 21);
INSERT INTO sys_role_menu VALUES (753, 6, 31);
INSERT INTO sys_role_menu VALUES (754, 6, 32);
INSERT INTO sys_role_menu VALUES (757, 6, 42);
INSERT INTO sys_role_menu VALUES (758, 6, 43);
INSERT INTO sys_role_menu VALUES (759, 6, 46);
INSERT INTO sys_role_menu VALUES (760, 6, 47);
INSERT INTO sys_role_menu VALUES (761, 6, 48);
INSERT INTO sys_role_menu VALUES (762, 6, 53);
INSERT INTO sys_role_menu VALUES (763, 6, 56);
INSERT INTO sys_role_menu VALUES (764, 6, 100);
INSERT INTO sys_role_menu VALUES (765, 6, 102);
INSERT INTO sys_role_menu VALUES (766, 6, 103);
INSERT INTO sys_role_menu VALUES (767, 6, 107);
INSERT INTO sys_role_menu VALUES (768, 6, 108);
INSERT INTO sys_role_menu VALUES (813, 7, 4);
INSERT INTO sys_role_menu VALUES (814, 7, 23);
INSERT INTO sys_role_menu VALUES (815, 7, 24);
INSERT INTO sys_role_menu VALUES (816, 7, 25);
INSERT INTO sys_role_menu VALUES (817, 7, 26);
INSERT INTO sys_role_menu VALUES (818, 7, 5);
INSERT INTO sys_role_menu VALUES (819, 7, 6);
INSERT INTO sys_role_menu VALUES (820, 7, 7);
INSERT INTO sys_role_menu VALUES (821, 7, 8);
INSERT INTO sys_role_menu VALUES (822, 7, 9);
INSERT INTO sys_role_menu VALUES (823, 7, 10);
INSERT INTO sys_role_menu VALUES (824, 7, 11);
INSERT INTO sys_role_menu VALUES (825, 7, 12);
INSERT INTO sys_role_menu VALUES (826, 7, 14);
INSERT INTO sys_role_menu VALUES (827, 7, 27);
INSERT INTO sys_role_menu VALUES (828, 7, 36);
INSERT INTO sys_role_menu VALUES (829, 7, 37);
INSERT INTO sys_role_menu VALUES (830, 7, 38);
INSERT INTO sys_role_menu VALUES (831, 7, 39);
INSERT INTO sys_role_menu VALUES (832, 7, 40);
INSERT INTO sys_role_menu VALUES (833, 7, 41);
INSERT INTO sys_role_menu VALUES (834, 7, 2);
INSERT INTO sys_role_menu VALUES (835, 7, 15);
INSERT INTO sys_role_menu VALUES (836, 7, 16);
INSERT INTO sys_role_menu VALUES (837, 7, 17);
INSERT INTO sys_role_menu VALUES (838, 7, 3);
INSERT INTO sys_role_menu VALUES (839, 7, 19);
INSERT INTO sys_role_menu VALUES (840, 7, 20);
INSERT INTO sys_role_menu VALUES (841, 7, 21);
INSERT INTO sys_role_menu VALUES (842, 7, 31);
INSERT INTO sys_role_menu VALUES (843, 7, 32);
INSERT INTO sys_role_menu VALUES (846, 7, 42);
INSERT INTO sys_role_menu VALUES (847, 7, 43);
INSERT INTO sys_role_menu VALUES (848, 7, 46);
INSERT INTO sys_role_menu VALUES (849, 7, 47);
INSERT INTO sys_role_menu VALUES (850, 7, 48);
INSERT INTO sys_role_menu VALUES (851, 7, 53);
INSERT INTO sys_role_menu VALUES (852, 7, 56);
INSERT INTO sys_role_menu VALUES (853, 7, 100);
INSERT INTO sys_role_menu VALUES (854, 7, 102);
INSERT INTO sys_role_menu VALUES (855, 7, 103);
INSERT INTO sys_role_menu VALUES (906, 14, 41);
INSERT INTO sys_role_menu VALUES (907, 14, 2);
INSERT INTO sys_role_menu VALUES (908, 14, 15);
INSERT INTO sys_role_menu VALUES (909, 14, 16);
INSERT INTO sys_role_menu VALUES (910, 14, 17);
INSERT INTO sys_role_menu VALUES (911, 14, 3);
INSERT INTO sys_role_menu VALUES (912, 14, 19);
INSERT INTO sys_role_menu VALUES (913, 14, 20);
INSERT INTO sys_role_menu VALUES (914, 14, 21);
INSERT INTO sys_role_menu VALUES (915, 14, 31);
INSERT INTO sys_role_menu VALUES (916, 14, 32);
INSERT INTO sys_role_menu VALUES (919, 14, 42);
INSERT INTO sys_role_menu VALUES (920, 14, 43);
INSERT INTO sys_role_menu VALUES (921, 14, 46);
INSERT INTO sys_role_menu VALUES (922, 14, 47);
INSERT INTO sys_role_menu VALUES (923, 14, 48);
INSERT INTO sys_role_menu VALUES (924, 14, 53);
INSERT INTO sys_role_menu VALUES (925, 14, 56);
INSERT INTO sys_role_menu VALUES (926, 14, 100);
INSERT INTO sys_role_menu VALUES (927, 14, 102);
INSERT INTO sys_role_menu VALUES (928, 14, 103);
INSERT INTO sys_role_menu VALUES (929, 14, 107);
INSERT INTO sys_role_menu VALUES (930, 14, 108);
INSERT INTO sys_role_menu VALUES (931, 14, 110);
INSERT INTO sys_role_menu VALUES (932, 14, 111);
INSERT INTO sys_role_menu VALUES (933, 14, 112);
INSERT INTO sys_role_menu VALUES (934, 14, 113);
INSERT INTO sys_role_menu VALUES (935, 14, 120);
INSERT INTO sys_role_menu VALUES (936, 14, 4);
INSERT INTO sys_role_menu VALUES (937, 14, 23);
INSERT INTO sys_role_menu VALUES (938, 14, 24);
INSERT INTO sys_role_menu VALUES (939, 14, 25);
INSERT INTO sys_role_menu VALUES (940, 14, 26);
INSERT INTO sys_role_menu VALUES (941, 14, 5);
INSERT INTO sys_role_menu VALUES (942, 14, 6);
INSERT INTO sys_role_menu VALUES (943, 14, 7);
INSERT INTO sys_role_menu VALUES (944, 14, 8);
INSERT INTO sys_role_menu VALUES (945, 14, 9);
INSERT INTO sys_role_menu VALUES (946, 14, 10);
INSERT INTO sys_role_menu VALUES (947, 14, 11);
INSERT INTO sys_role_menu VALUES (948, 14, 12);
INSERT INTO sys_role_menu VALUES (949, 14, 14);
INSERT INTO sys_role_menu VALUES (950, 14, 27);
INSERT INTO sys_role_menu VALUES (951, 14, 36);
INSERT INTO sys_role_menu VALUES (952, 14, 37);
INSERT INTO sys_role_menu VALUES (953, 14, 38);
INSERT INTO sys_role_menu VALUES (954, 14, 39);
INSERT INTO sys_role_menu VALUES (955, 14, 40);


CREATE TABLE sys_serialno (
  ID_ NVARCHAR2(255)  NOT NULL ,
  NAME_ NVARCHAR2(255)   ,
  ALIAS_ NVARCHAR2(255)   ,
  regulation_ NVARCHAR2(255)   ,
  gen_type_ decimal(10,0)  ,
  no_length_ decimal(10,0)  ,
  cur_date_ NVARCHAR2(255)   ,
  init_value_ decimal(10,0)  ,
  cur_value_ decimal(10,0)  ,
  step_ decimal(10,0)  ,
  DELETED NUMBER(1,0) CHECK (DELETED IN (1,0)),
  primary key (ID_)
)  ;

-- ----------------------------
-- Records of sys_serialno
-- ----------------------------
INSERT INTO sys_serialno VALUES ('1', '每天使用一组流水号', 'dayNo', '{yyyy}{MM}{DD}{NO}', 1, 5, NULL, 1, 0, 2, 0);
INSERT INTO sys_serialno VALUES ('682692501894594560', 'ccc', 'c', 'c', 1, 1, NULL, 1, 0, 1, 1);
INSERT INTO sys_serialno VALUES ('682693608511373312', '1', '1', '1', 1, 111, NULL, 111, 0, 1, 1);
INSERT INTO sys_serialno VALUES ('682698470624067584', '12121', '12121', '12122', 1, 1, NULL, 1, 0, 1, 1);
INSERT INTO sys_serialno VALUES ('682701400144084992', '88888', '121212', '12122', 2, 1, NULL, 1, 0, 1, 1);
INSERT INTO sys_serialno VALUES ('682702240028295168', '77', '77', '777', 2, 777, NULL, 777, 0, 777, 1);



-- ----------------------------
-- Table structure for sys_type
-- ----------------------------
CREATE TABLE sys_type (
  id_ number(20) NOT NULL  ,
  title_ NVARCHAR2(64)  NOT NULL ,
  type_key_ NVARCHAR2(64)   ,
  parent_id_ number(20) DEFAULT '-1' ,
  order_id_ INTEGER  ,
  status_ NVARCHAR2(255)   ,
  scope_id_ NVARCHAR2(64)   ,
  primary key (id_)
)  ;

-- ----------------------------
-- Records of sys_type
-- ----------------------------
INSERT INTO sys_type VALUES (20039, '所有数据', 'all', -1, NULL, '1', 'FORM');
INSERT INTO sys_type VALUES (20040, '默认分类', 'default', 20039, NULL, '1', 'FORM');
INSERT INTO sys_type VALUES (20041, '请假流程', 'renshi', 20039, NULL, '1', 'FORM');
INSERT INTO sys_type VALUES (20072, '请假流程', 'leave', 20074, NULL, '1', 'BPMN');
INSERT INTO sys_type VALUES (20073, '客户招待流程', 'fybx', 20074, NULL, '1', 'BPMN');
INSERT INTO sys_type VALUES (20074, '默认流程', 'all', -1, NULL, '1', 'BPMN');
INSERT INTO sys_type VALUES (20075, '客户招待流程', 'fybx_form', 20039, NULL, '1', 'FORM');
INSERT INTO sys_type VALUES (20076, '借款申请', 'jksq', 20074, NULL, '1', 'BPMN');
INSERT INTO sys_type VALUES (20077, '借款申请', 'jksq', 20039, NULL, '1', 'FORM');
INSERT INTO sys_type VALUES (20078, '默认分类', 'all', -1, NULL, '1', 'DMN');
INSERT INTO sys_type VALUES (20079, '请假流程决策', 'leave_dmn', 20078, NULL, '1', 'DMN');
INSERT INTO sys_type VALUES (20085, '444', 'qw', -1, NULL, '1', 'qw');
INSERT INTO sys_type VALUES (20086, '666', '5', -1, NULL, '0', '5');
INSERT INTO sys_type VALUES (66666, '66688888', '1', 20039, NULL, '0', NULL);
INSERT INTO sys_type VALUES (66667, '3', '2', 20040, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66668, '7', '7', 66666, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66669, '22', '2222', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66670, '77', '777', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66671, '888', '88', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66672, '999', '99', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66673, '1', '', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66674, '1212121', '212121', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66675, '1', '333', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66676, '11', '444', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66677, '4', '4', 20039, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66678, '599', '9995', 66677, NULL, '0', 'BPMN');
INSERT INTO sys_type VALUES (66679, '所有数据', 'all', -1, 1, '1', 'CMMN');
INSERT INTO sys_type VALUES (66680, 'RPA流程', 'rpa', 66679, 1, '1', 'CMMN');



CREATE TABLE sys_user (
  user_id number(20) NOT NULL ,
  username NVARCHAR2(50) NOT NULL ,
  password NVARCHAR2(100)  ,
  salt NVARCHAR2(20)  ,
  email NVARCHAR2(100)  ,
  mobile NVARCHAR2(100)  ,
  status number(4)  ,
  dept_id number(20)  ,
  create_time TIMESTAMP,
  realname NVARCHAR2(255) ,
  primary key (user_id)
)  ;
CREATE TABLE sys_user_role (
  id number(20) NOT NULL ,
  user_id number(20) ,
  role_id number(20)  ,
  primary key (id)
) ;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO sys_user_role VALUES (44, 12, 6);
INSERT INTO sys_user_role VALUES (48, 14, 7);
INSERT INTO sys_user_role VALUES (49, 15, 7);
INSERT INTO sys_user_role VALUES (50, 16, 7);
INSERT INTO sys_user_role VALUES (51, 17, 8);
INSERT INTO sys_user_role VALUES (52, 18, 9);
INSERT INTO sys_user_role VALUES (54, 19, 7);
INSERT INTO sys_user_role VALUES (55, 20, 7);
INSERT INTO sys_user_role VALUES (57, 21, 6);
INSERT INTO sys_user_role VALUES (58, 21, 8);
INSERT INTO sys_user_role VALUES (59, 22, 7);
INSERT INTO sys_user_role VALUES (60, 23, 12);
INSERT INTO sys_user_role VALUES (61, 13, 7);
INSERT INTO sys_user_role VALUES (62, 24, 8);
INSERT INTO sys_user_role VALUES (63, 25, 6);
INSERT INTO sys_user_role VALUES (64, 25, 7);
INSERT INTO sys_user_role VALUES (65, 25, 12);
INSERT INTO sys_user_role VALUES (74, 27, 8);
INSERT INTO sys_user_role VALUES (75, 29, 7);
INSERT INTO sys_user_role VALUES (76, 30, 6);
INSERT INTO sys_user_role VALUES (77, 30, 7);
INSERT INTO sys_user_role VALUES (78, 30, 8);
INSERT INTO sys_user_role VALUES (79, 30, 9);
INSERT INTO sys_user_role VALUES (80, 30, 11);
INSERT INTO sys_user_role VALUES (81, 30, 12);
INSERT INTO sys_user_role VALUES (82, 26, 8);
INSERT INTO sys_user_role VALUES (89, 6, 6);
INSERT INTO sys_user_role VALUES (90, 6, 7);
INSERT INTO sys_user_role VALUES (91, 6, 8);
INSERT INTO sys_user_role VALUES (92, 6, 9);
INSERT INTO sys_user_role VALUES (93, 6, 11);
INSERT INTO sys_user_role VALUES (94, 6, 12);
INSERT INTO sys_user_role VALUES (95, 6, 13);
INSERT INTO sys_user_role VALUES (96, 31, 8);
INSERT INTO sys_user_role VALUES (97, 32, 8);
INSERT INTO sys_user_role VALUES (103, 2, 7);
INSERT INTO sys_user_role VALUES (107, 3, 7);
INSERT INTO sys_user_role VALUES (108, 3, 8);
INSERT INTO sys_user_role VALUES (109, 3, 9);
INSERT INTO sys_user_role VALUES (110, 3, 11);
INSERT INTO sys_user_role VALUES (111, 3, 12);
INSERT INTO sys_user_role VALUES (112, 1, 6);
INSERT INTO sys_user_role VALUES (113, 1, 8);
INSERT INTO sys_user_role VALUES (114, 1, 12);
INSERT INTO sys_user_role VALUES (115, 1, 14);

CREATE TABLE uc_demension (
  id NVARCHAR2(64)  NOT NULL,
  DEM_NAME NVARCHAR2(64)  ,
  code NVARCHAR2(64)   ,
  IS_DEFAULT_val NUMBER(1,0) DEFAULT '0',
  DEM_DESC NVARCHAR2(512)   ,
  ORGAN_ID NVARCHAR2(64)   ,
  UPDATE_TIME TIMESTAMP(6) ,
  IS_DELETED NUMBER(1,0) DEFAULT '0',
  VERSION INTEGER ,
  primary key (id)
) ;

-- ----------------------------
-- Records of uc_demension
-- ----------------------------
INSERT INTO uc_demension VALUES ('678912394608508928', '人事维度', 'renshiweidu', 1, '', NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 8);
INSERT INTO uc_demension VALUES ('678915759061073920', '财务维度', 'caiwuweidu', 0, '财务维度', NULL,  to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 0);
INSERT INTO uc_demension VALUES ('683368151089414144', '1', '1', 0, '', NULL,  to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 1, 0);

CREATE TABLE uc_org (
  id NVARCHAR2(64)  NOT NULL ,
  DEPT_NAME NVARCHAR2(64)   ,
  EASY_NAME NVARCHAR2(64)   ,
  DEPT_CODE NVARCHAR2(64)   ,
  RANK_CODE NVARCHAR2(64)   ,
  RANK_NAME NVARCHAR2(64)   ,
  ZH_ID NVARCHAR2(64)   ,
  PHONE NVARCHAR2(64)   ,
  PARENT_ID NVARCHAR2(64)  ,
  ADDRESS NVARCHAR2(512)   ,
  ZN_MS NVARCHAR2(512)   ,
  BZ_HU NVARCHAR2(64)   ,
  PATH NVARCHAR2(512)   ,
  VERSION INTEGER DEFAULT '0' ,
  LEVEL_ NVARCHAR2(64)   ,
  SORT INTEGER  ,
  CREATE_BY NVARCHAR2(64)   ,
  CREATE_TIME TIMESTAMP(6) ,
  UPDATE_BY NVARCHAR2(64)  ,
  UPDATE_TIME TIMESTAMP(6) ,
  STATUS NUMBER(1,0) ,
  IS_DELETED NUMBER(1,0),
  DEM_ID NVARCHAR2(64)   ,
  primary key (id)
) ;

-- ----------------------------
-- Records of uc_org
-- ----------------------------
INSERT INTO uc_org VALUES ('678917977457819648', '盘古BPM', '盘古BPM', 'beijingfengongsi', NULL, NULL, NULL, '', 'renshiweidu', '', '', '', '.renshiweidu.beijingfengongsi', 0, '', NULL, NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 0, 'renshiweidu');
INSERT INTO uc_org VALUES ('679436474327760896', '盘古软件', '盘古软件', 'shanghaifengongsi', NULL, NULL, NULL, '', 'renshiweidu', '', '盘古软件', '', '.renshiweidu.shanghaifengongsi', 0, '', NULL, NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 0, 'renshiweidu');
INSERT INTO uc_org VALUES ('680896380327165952', '跟部门', '跟部门', 'caiwu_genbumen', NULL, NULL, NULL, NULL, 'caiwuweidu', '', '', '', '.caiwuweidu.caiwu_genbumen', 0, '2', NULL, NULL,  to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 0, 'caiwuweidu');

CREATE TABLE uc_org_job (
  id NVARCHAR2(64)  NOT NULL ,
  name NVARCHAR2(64)  NOT NULL ,
  code NVARCHAR2(64)  NOT NULL ,
  JOB_LEVEL NVARCHAR2(64)   ,
  DESCRIPTION NVARCHAR2(512)   ,
  UPDATE_TIME TIMESTAMP(6) ,
  IS_DELETED NUMBER(1,0),
  VERSION INTEGER  ,
  primary key (id)
) ;

-- ----------------------------
-- Records of uc_org_job
-- ----------------------------
INSERT INTO uc_org_job VALUES ('678555843632824320', '管理岗', 'glg', '2', '',to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 1);
INSERT INTO uc_org_job VALUES ('678907718349619200', '1', '1', '', '', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 1, 0);
INSERT INTO uc_org_job VALUES ('679448260544299008', '开发岗', 'kaifagang', '2', '', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 0);
INSERT INTO uc_org_job VALUES ('680895903774539776', '部门经理', 'bumenjingli', '3', '部门经理', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 0);
INSERT INTO uc_org_job VALUES ('680896732220882944', '项目经理', 'xiangmujingli', '1', '项目经理', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 0, 0);
INSERT INTO uc_org_job VALUES ('683362369572700160', '1', '2', '', '', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 1, 0);
CREATE TABLE uc_org_post (
  id NVARCHAR2(64)  NOT NULL ,
  ORG_ID NVARCHAR2(64)  NOT NULL ,
  JOB_ID NVARCHAR2(64)  NOT NULL ,
  POS_NAME NVARCHAR2(64)  NOT NULL ,
  code NVARCHAR2(64)  NOT NULL ,
  IS_CHARGE NUMBER(1,0),
  UPDATE_TIME TIMESTAMP(6) ,
  IS_DELETED NUMBER(1,0),
  VERSION INTEGER DEFAULT '0' ,
  primary key (id)
) ;

-- ----------------------------
-- Records of uc_org_post
-- ----------------------------
INSERT INTO uc_org_post VALUES ('678555986151079936', 'root', 'kfg', 'java开发', 'javaen', 0, NULL, 0, 0);
INSERT INTO uc_org_post VALUES ('678556378154926080', 'shgs', 'kfg', 'php开发', 'phpen', 0, NULL, 0, 0);
INSERT INTO uc_org_post VALUES ('678964127175016448', 'beijingfengongsi', 'glg', '研发工程师222', '研发工程师', 0, NULL, 1, 1);
INSERT INTO uc_org_post VALUES ('678967235624042496', 'beijingfengongsi', 'glg', '市场营销', 'shichangyingxiao', 0, NULL, 0, 0);
INSERT INTO uc_org_post VALUES ('678969254216728576', 'beijingfengongsi', 'glg', '333', '333', 0, NULL, 1, 0);
INSERT INTO uc_org_post VALUES ('679012379261927424', 'beijingfengongsi', 'glg', '2', '2', 0, NULL, 1, 0);
INSERT INTO uc_org_post VALUES ('679016071356743680', 'beijingfengongsi', 'glg', '2222', '222', 0, NULL, 1, 0);
INSERT INTO uc_org_post VALUES ('679016416099172352', 'beijingfengongsi', 'glg', '44', '444', 0, NULL, 1, 0);
INSERT INTO uc_org_post VALUES ('679075299295494144', 'beijingfengongsi', 'glg', '开发2部', 'kaifang2', 0, NULL, 0, 0);
INSERT INTO uc_org_post VALUES ('679075609049038848', 'beijingfengongsi', 'glg', '开发3部', 'kaifa3bu', 0, NULL, 0, 0);
INSERT INTO uc_org_post VALUES ('680896539463254016', 'caiwu_genbumen', 'glg', '出纳', 'chuna', 0, NULL, 0, 0);
INSERT INTO uc_org_post VALUES ('680896978984370176', 'shanghaifengongsi', 'glg', '盘古BPM-销售部', 'pangubpm_xiaoshoubu', 0, NULL, 0, 0);
INSERT INTO uc_org_post VALUES ('683371606843588608', 'beijingfengongsi', 'kaifagang', 'ccc', 'cccc', 0, NULL, 1, 0);
INSERT INTO uc_org_post VALUES ('683371657196208128', 'beijingfengongsi', 'kaifagang', 'ffff', 'ffffffff', 0, NULL, 1, 0);

CREATE TABLE uc_params (
  id NVARCHAR2(64)  NOT NULL ,
  NAME NVARCHAR2(64)   ,
  code NVARCHAR2(64)   ,
  TYPE NVARCHAR2(64)  ,
  CTL_TYPE NVARCHAR2(64)   ,
  JSON NVARCHAR2(512)   ,
  UPDATE_TIME TIMESTAMP(6) ,
  IS_DELETED NUMBER(1,0),
  VERSION INTEGER  ,
  primary key (id)
) ;

-- ----------------------------
-- Table structure for uc_role
-- ----------------------------
CREATE TABLE uc_role (
  id NVARCHAR2(64)  NOT NULL ,
  NAME NVARCHAR2(64)   ,
  code NVARCHAR2(64)   ,
  CREATE_BY NVARCHAR2(64)   ,
  UPDATE_BY NVARCHAR2(64)   ,
  CREATE_ORG_ID NVARCHAR2(64)   ,
  ENABLED NUMBER(1,0),
  DESCRIPTION NVARCHAR2(512)   ,
  UPDATE_TIME TIMESTAMP(6)  ,
  IS_DELETED NUMBER(1,0),
  VERSION INTEGER DEFAULT '0' ,
  create_Time TIMESTAMP(6) ,
  primary key (id)
);

-- ----------------------------
-- Records of uc_role
-- ----------------------------
INSERT INTO uc_role VALUES ('1', '111', '111', NULL, NULL, NULL, 1, '1111', null, 1, 5, null);
INSERT INTO uc_role VALUES ('678198539897012224', '666', '2', NULL, NULL, NULL, 1, '2', NULL, 1, 5, NULL);
INSERT INTO uc_role VALUES ('678571609396609024', '市场部', 'shichangbu', NULL, NULL, NULL, 1, '', NULL, 0, 1, NULL);
INSERT INTO uc_role VALUES ('678571648034537472', '人事部', 'renshibu', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO uc_role VALUES ('678900086754770944', 'ccc', 'cc', NULL, NULL, NULL, 1, '', NULL, 1, 0, NULL);
INSERT INTO uc_role VALUES ('680792205136232448', '技术部', 'jsb', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO uc_role VALUES ('682529352457388032', 'cc', NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, 0, NULL);
INSERT INTO uc_role VALUES ('683364228228186112', '1', '222', NULL, NULL, NULL, 1, '', NULL, 1, 1, NULL);
INSERT INTO uc_role VALUES ('683762809342787584', '销售人员', 'XSRY', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO uc_role VALUES ('683762880507543552', '销售经理', 'XSJL', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);
INSERT INTO uc_role VALUES ('683762925415956480', '销售总监', 'XSZJ', NULL, NULL, NULL, 1, '', NULL, 0, 0, NULL);



CREATE TABLE uc_role_menu (
  id INTEGER NOT NULL ,
  role_code NVARCHAR2(255)  ,
  menu_id INTEGER ,
  primary key (id)
) ;

-- ----------------------------
-- Records of uc_role_menu
-- ----------------------------
INSERT INTO uc_role_menu VALUES (1, '2', 41);
INSERT INTO uc_role_menu VALUES (2, '2', 2);
INSERT INTO uc_role_menu VALUES (3, '2', 15);
INSERT INTO uc_role_menu VALUES (4, '2', 16);
INSERT INTO uc_role_menu VALUES (5, '2', 17);
INSERT INTO uc_role_menu VALUES (6, '2', 3);
INSERT INTO uc_role_menu VALUES (7, '2', 19);
INSERT INTO uc_role_menu VALUES (8, '2', 20);
INSERT INTO uc_role_menu VALUES (9, '2', 21);
INSERT INTO uc_role_menu VALUES (10, '2', 31);
INSERT INTO uc_role_menu VALUES (11, '2', 32);
INSERT INTO uc_role_menu VALUES (12, '2', 46);
INSERT INTO uc_role_menu VALUES (13, '2', 43);
INSERT INTO uc_role_menu VALUES (14, '2', 47);
INSERT INTO uc_role_menu VALUES (15, '2', 48);
INSERT INTO uc_role_menu VALUES (16, '2', 53);
INSERT INTO uc_role_menu VALUES (17, '2', 56);
INSERT INTO uc_role_menu VALUES (18, '2', 100);
INSERT INTO uc_role_menu VALUES (19, '2', 102);
INSERT INTO uc_role_menu VALUES (20, '2', 103);
INSERT INTO uc_role_menu VALUES (21, '2', 107);
INSERT INTO uc_role_menu VALUES (22, '2', 108);
INSERT INTO uc_role_menu VALUES (23, '2', 121);
INSERT INTO uc_role_menu VALUES (24, '2', 122);
INSERT INTO uc_role_menu VALUES (25, '2', 123);
INSERT INTO uc_role_menu VALUES (26, '2', 125);
INSERT INTO uc_role_menu VALUES (27, '2', 120);
INSERT INTO uc_role_menu VALUES (28, '2', 4);
INSERT INTO uc_role_menu VALUES (29, '2', 23);
INSERT INTO uc_role_menu VALUES (30, '2', 24);
INSERT INTO uc_role_menu VALUES (31, '2', 25);
INSERT INTO uc_role_menu VALUES (32, '2', 26);
INSERT INTO uc_role_menu VALUES (33, '2', 5);
INSERT INTO uc_role_menu VALUES (34, '2', 6);
INSERT INTO uc_role_menu VALUES (35, '2', 7);
INSERT INTO uc_role_menu VALUES (36, '2', 8);
INSERT INTO uc_role_menu VALUES (37, '2', 9);
INSERT INTO uc_role_menu VALUES (38, '2', 10);
INSERT INTO uc_role_menu VALUES (39, '2', 11);
INSERT INTO uc_role_menu VALUES (40, '2', 12);
INSERT INTO uc_role_menu VALUES (41, '2', 14);
INSERT INTO uc_role_menu VALUES (42, '2', 27);
INSERT INTO uc_role_menu VALUES (43, '2', 36);
INSERT INTO uc_role_menu VALUES (44, '2', 37);
INSERT INTO uc_role_menu VALUES (45, '2', 38);
INSERT INTO uc_role_menu VALUES (46, '2', 39);
INSERT INTO uc_role_menu VALUES (47, '2', 40);
INSERT INTO uc_role_menu VALUES (48, '2', 124);
INSERT INTO uc_role_menu VALUES (49, '2', 135);
INSERT INTO uc_role_menu VALUES (50, '2', 126);
INSERT INTO uc_role_menu VALUES (51, '2', 127);
INSERT INTO uc_role_menu VALUES (52, '2', 128);
INSERT INTO uc_role_menu VALUES (53, '2', 129);
INSERT INTO uc_role_menu VALUES (54, '2', 130);
INSERT INTO uc_role_menu VALUES (55, '2', 132);
INSERT INTO uc_role_menu VALUES (56, '2', 133);
INSERT INTO uc_role_menu VALUES (57, '2', 134);
INSERT INTO uc_role_menu VALUES (58, 'renshibu', 41);
INSERT INTO uc_role_menu VALUES (59, 'renshibu', 2);
INSERT INTO uc_role_menu VALUES (60, 'renshibu', 15);
INSERT INTO uc_role_menu VALUES (61, 'renshibu', 16);
INSERT INTO uc_role_menu VALUES (62, 'renshibu', 17);
INSERT INTO uc_role_menu VALUES (63, 'renshibu', 3);
INSERT INTO uc_role_menu VALUES (64, 'renshibu', 19);
INSERT INTO uc_role_menu VALUES (65, 'renshibu', 20);
INSERT INTO uc_role_menu VALUES (66, 'renshibu', 21);
INSERT INTO uc_role_menu VALUES (67, 'renshibu', 31);
INSERT INTO uc_role_menu VALUES (68, 'renshibu', 32);
INSERT INTO uc_role_menu VALUES (69, 'renshibu', 46);
INSERT INTO uc_role_menu VALUES (70, 'renshibu', 43);
INSERT INTO uc_role_menu VALUES (71, 'renshibu', 47);
INSERT INTO uc_role_menu VALUES (72, 'renshibu', 48);
INSERT INTO uc_role_menu VALUES (73, 'renshibu', 53);
INSERT INTO uc_role_menu VALUES (74, 'renshibu', 56);
INSERT INTO uc_role_menu VALUES (75, 'renshibu', 100);
INSERT INTO uc_role_menu VALUES (76, 'renshibu', 102);
INSERT INTO uc_role_menu VALUES (77, 'renshibu', 103);
INSERT INTO uc_role_menu VALUES (78, 'renshibu', 107);
INSERT INTO uc_role_menu VALUES (79, 'renshibu', 108);
INSERT INTO uc_role_menu VALUES (80, 'renshibu', 121);
INSERT INTO uc_role_menu VALUES (81, 'renshibu', 122);
INSERT INTO uc_role_menu VALUES (82, 'renshibu', 123);
INSERT INTO uc_role_menu VALUES (83, 'renshibu', 125);
INSERT INTO uc_role_menu VALUES (84, 'renshibu', 110);
INSERT INTO uc_role_menu VALUES (85, 'renshibu', 111);
INSERT INTO uc_role_menu VALUES (86, 'renshibu', 112);
INSERT INTO uc_role_menu VALUES (87, 'renshibu', 113);
INSERT INTO uc_role_menu VALUES (88, 'renshibu', 126);
INSERT INTO uc_role_menu VALUES (89, 'renshibu', 127);
INSERT INTO uc_role_menu VALUES (90, 'renshibu', 128);
INSERT INTO uc_role_menu VALUES (91, 'renshibu', 129);
INSERT INTO uc_role_menu VALUES (92, 'renshibu', 130);
INSERT INTO uc_role_menu VALUES (93, 'renshibu', 132);
INSERT INTO uc_role_menu VALUES (94, 'renshibu', 133);
INSERT INTO uc_role_menu VALUES (95, 'renshibu', 134);
INSERT INTO uc_role_menu VALUES (123, 'shichangbu', 46);
INSERT INTO uc_role_menu VALUES (124, 'shichangbu', 43);
INSERT INTO uc_role_menu VALUES (125, 'shichangbu', 47);
INSERT INTO uc_role_menu VALUES (126, 'shichangbu', 48);
INSERT INTO uc_role_menu VALUES (127, 'shichangbu', 56);
INSERT INTO uc_role_menu VALUES (128, 'shichangbu', 100);
INSERT INTO uc_role_menu VALUES (129, 'shichangbu', 102);
INSERT INTO uc_role_menu VALUES (130, 'shichangbu', 103);
INSERT INTO uc_role_menu VALUES (131, 'shichangbu', 107);
INSERT INTO uc_role_menu VALUES (132, 'shichangbu', 108);
INSERT INTO uc_role_menu VALUES (133, 'shichangbu', 121);
INSERT INTO uc_role_menu VALUES (134, 'shichangbu', 122);
INSERT INTO uc_role_menu VALUES (135, 'shichangbu', 123);
INSERT INTO uc_role_menu VALUES (136, 'shichangbu', 125);
INSERT INTO uc_role_menu VALUES (137, 'shichangbu', 110);
INSERT INTO uc_role_menu VALUES (138, 'shichangbu', 111);
INSERT INTO uc_role_menu VALUES (139, 'shichangbu', 112);
INSERT INTO uc_role_menu VALUES (140, 'shichangbu', 113);
INSERT INTO uc_role_menu VALUES (141, 'shichangbu', 5);
INSERT INTO uc_role_menu VALUES (142, 'shichangbu', 6);
INSERT INTO uc_role_menu VALUES (143, 'shichangbu', 14);
INSERT INTO uc_role_menu VALUES (144, 'shichangbu', 27);
INSERT INTO uc_role_menu VALUES (145, 'shichangbu', 126);
INSERT INTO uc_role_menu VALUES (146, 'shichangbu', 127);
INSERT INTO uc_role_menu VALUES (147, 'shichangbu', 128);
INSERT INTO uc_role_menu VALUES (148, 'shichangbu', 129);
INSERT INTO uc_role_menu VALUES (149, 'shichangbu', 130);
INSERT INTO uc_role_menu VALUES (150, 'shichangbu', 132);
INSERT INTO uc_role_menu VALUES (151, 'shichangbu', 133);
INSERT INTO uc_role_menu VALUES (152, 'shichangbu', 134);
INSERT INTO uc_role_menu VALUES (226, 'XSRY', 158);
INSERT INTO uc_role_menu VALUES (227, 'XSRY', 46);
INSERT INTO uc_role_menu VALUES (228, 'XSRY', 43);
INSERT INTO uc_role_menu VALUES (229, 'XSRY', 47);
INSERT INTO uc_role_menu VALUES (230, 'XSRY', 48);
INSERT INTO uc_role_menu VALUES (231, 'XSRY', 100);
INSERT INTO uc_role_menu VALUES (232, 'XSRY', 102);
INSERT INTO uc_role_menu VALUES (233, 'XSRY', 103);
INSERT INTO uc_role_menu VALUES (234, 'XSRY', 107);
INSERT INTO uc_role_menu VALUES (235, 'XSRY', 108);
INSERT INTO uc_role_menu VALUES (236, 'XSRY', 121);
INSERT INTO uc_role_menu VALUES (237, 'XSRY', 122);
INSERT INTO uc_role_menu VALUES (238, 'XSRY', 123);
INSERT INTO uc_role_menu VALUES (239, 'XSRY', 125);
INSERT INTO uc_role_menu VALUES (240, 'XSRY', 144);
INSERT INTO uc_role_menu VALUES (241, 'XSJL', 157);
INSERT INTO uc_role_menu VALUES (242, 'XSJL', 110);
INSERT INTO uc_role_menu VALUES (243, 'XSJL', 111);
INSERT INTO uc_role_menu VALUES (244, 'XSJL', 112);
INSERT INTO uc_role_menu VALUES (245, 'XSJL', 113);
INSERT INTO uc_role_menu VALUES (246, 'XSJL', 158);
INSERT INTO uc_role_menu VALUES (247, 'XSJL', 46);
INSERT INTO uc_role_menu VALUES (248, 'XSJL', 43);
INSERT INTO uc_role_menu VALUES (249, 'XSJL', 47);
INSERT INTO uc_role_menu VALUES (250, 'XSJL', 48);
INSERT INTO uc_role_menu VALUES (251, 'XSJL', 100);
INSERT INTO uc_role_menu VALUES (252, 'XSJL', 102);
INSERT INTO uc_role_menu VALUES (253, 'XSJL', 103);
INSERT INTO uc_role_menu VALUES (254, 'XSJL', 107);
INSERT INTO uc_role_menu VALUES (255, 'XSJL', 108);
INSERT INTO uc_role_menu VALUES (256, 'XSJL', 121);
INSERT INTO uc_role_menu VALUES (257, 'XSJL', 122);
INSERT INTO uc_role_menu VALUES (258, 'XSJL', 123);
INSERT INTO uc_role_menu VALUES (259, 'XSJL', 125);
INSERT INTO uc_role_menu VALUES (260, 'XSJL', 144);
INSERT INTO uc_role_menu VALUES (261, 'XSJL', 160);
INSERT INTO uc_role_menu VALUES (262, 'XSJL', 126);
INSERT INTO uc_role_menu VALUES (263, 'XSJL', 127);
INSERT INTO uc_role_menu VALUES (264, 'XSJL', 128);
INSERT INTO uc_role_menu VALUES (265, 'XSJL', 129);
INSERT INTO uc_role_menu VALUES (266, 'XSJL', 130);
INSERT INTO uc_role_menu VALUES (267, 'XSJL', 132);
INSERT INTO uc_role_menu VALUES (268, 'XSJL', 133);
INSERT INTO uc_role_menu VALUES (269, 'XSJL', 134);
INSERT INTO uc_role_menu VALUES (270, 'XSZJ', 14);
INSERT INTO uc_role_menu VALUES (271, 'XSZJ', 157);
INSERT INTO uc_role_menu VALUES (272, 'XSZJ', 110);
INSERT INTO uc_role_menu VALUES (273, 'XSZJ', 111);
INSERT INTO uc_role_menu VALUES (274, 'XSZJ', 112);
INSERT INTO uc_role_menu VALUES (275, 'XSZJ', 113);
INSERT INTO uc_role_menu VALUES (276, 'XSZJ', 158);
INSERT INTO uc_role_menu VALUES (277, 'XSZJ', 46);
INSERT INTO uc_role_menu VALUES (278, 'XSZJ', 43);
INSERT INTO uc_role_menu VALUES (279, 'XSZJ', 47);
INSERT INTO uc_role_menu VALUES (280, 'XSZJ', 48);
INSERT INTO uc_role_menu VALUES (281, 'XSZJ', 100);
INSERT INTO uc_role_menu VALUES (282, 'XSZJ', 102);
INSERT INTO uc_role_menu VALUES (283, 'XSZJ', 103);
INSERT INTO uc_role_menu VALUES (284, 'XSZJ', 107);
INSERT INTO uc_role_menu VALUES (285, 'XSZJ', 108);
INSERT INTO uc_role_menu VALUES (286, 'XSZJ', 121);
INSERT INTO uc_role_menu VALUES (287, 'XSZJ', 122);
INSERT INTO uc_role_menu VALUES (288, 'XSZJ', 123);
INSERT INTO uc_role_menu VALUES (289, 'XSZJ', 125);
INSERT INTO uc_role_menu VALUES (290, 'XSZJ', 144);
INSERT INTO uc_role_menu VALUES (291, 'XSZJ', 159);
INSERT INTO uc_role_menu VALUES (292, 'XSZJ', 120);
INSERT INTO uc_role_menu VALUES (293, 'XSZJ', 27);
INSERT INTO uc_role_menu VALUES (294, 'XSZJ', 124);
INSERT INTO uc_role_menu VALUES (295, 'XSZJ', 135);
INSERT INTO uc_role_menu VALUES (296, 'XSZJ', 149);
INSERT INTO uc_role_menu VALUES (297, 'XSZJ', 150);
INSERT INTO uc_role_menu VALUES (298, 'XSZJ', 151);
INSERT INTO uc_role_menu VALUES (299, 'XSZJ', 152);
INSERT INTO uc_role_menu VALUES (300, 'XSZJ', 153);
INSERT INTO uc_role_menu VALUES (301, 'XSZJ', 155);
INSERT INTO uc_role_menu VALUES (302, 'XSZJ', 156);
INSERT INTO uc_role_menu VALUES (303, 'XSZJ', 160);
INSERT INTO uc_role_menu VALUES (304, 'XSZJ', 126);
INSERT INTO uc_role_menu VALUES (305, 'XSZJ', 127);
INSERT INTO uc_role_menu VALUES (306, 'XSZJ', 128);
INSERT INTO uc_role_menu VALUES (307, 'XSZJ', 129);
INSERT INTO uc_role_menu VALUES (308, 'XSZJ', 130);
INSERT INTO uc_role_menu VALUES (309, 'XSZJ', 132);
INSERT INTO uc_role_menu VALUES (310, 'XSZJ', 133);
INSERT INTO uc_role_menu VALUES (311, 'XSZJ', 134);
INSERT INTO uc_role_menu VALUES (312, 'XSZJ', 161);
INSERT INTO uc_role_menu VALUES (313, 'XSZJ', 145);
INSERT INTO uc_role_menu VALUES (314, 'XSZJ', 146);
INSERT INTO uc_role_menu VALUES (315, 'XSZJ', 147);

CREATE TABLE uc_user (
  id NVARCHAR2(64)  NOT NULL ,
  FULLNAME NVARCHAR2(255)  ,
  MOBILE NVARCHAR2(64)   ,
  ACCOUNT NVARCHAR2(255)   ,
  PASSWORD NVARCHAR2(64)   ,
  USER_NO NVARCHAR2(64)   ,
  salt NVARCHAR2(64)   ,
  JOB_NO NVARCHAR2(11)   ,
  JOB_LEVEL NVARCHAR2(255)  ,
  POST_LEVEL NVARCHAR2(255)  ,
  EMAIL NVARCHAR2(64)   ,
  ENTRY_DATE TIMESTAMP(6)  ,
  LEAVE_DATE TIMESTAMP(6)  ,
  PHOTO NVARCHAR2(255)  ,
  ADDRESS NVARCHAR2(255)   ,
  SEX INTEGER  ,
  ID_CARD NVARCHAR2(64)   ,
  PHONE NVARCHAR2(64)   ,
  NATION INTEGER  ,
  EDUCATION INTEGER  ,
  BIRTHDAY TIMESTAMP(6)  ,
  NOTIFY_TYPE NVARCHAR2(64)   ,
  CREATE_TIME TIMESTAMP(6)  ,
  CREATE_USER_NO NVARCHAR2(64)   ,
  UPDATE_TIME TIMESTAMP(6)  ,
  UPDATE_USER_NO NVARCHAR2(64)  ,
  CREATE_ORG_ID NVARCHAR2(64)   ,
  STATUS NUMBER(1,0),
  DESCRIPTION NVARCHAR2(512)   ,
  IS_DEL NUMBER(1,0),
  VERSION INTEGER  ,
  primary key (id)
) ;


INSERT INTO uc_user VALUES ('1', '王文', '13678293920', 'wangwen', '06ab098b1fd5fc5e02af489cee292721e1cf2549df5132001807a8e421189361', '010', 'LYdnupNJZm7Qh0n2uSDU', NULL, NULL, 1, '4.qq.com', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, NULL, 'wea', 0, 'aewe4', '', 0, 0, NULL, NULL, NULL, '1', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('10', '王胖子', '13789230120', 'wangpangzi', '80af243c46aef1409a466f3b15a8ff94a8ff7ec38fcf1fae8bb4c75382a911b0', '009', 'QJeNHisBSj0mpqb8uAnD', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('2', '赵六', '12323122334', 'zhaoliu', 'fea1a4eb39bbf9cd22bcdc8883cb6493605eb40d57b4bc97da3f074a5e62a425', '001', 'ddYfoInZXsI2DSlyfeeI', NULL, NULL, 1, '5.qq.com', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, NULL, '', 0, '', '', 0, 0, NULL, NULL, NULL, '1',to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('3', '赵云', '14323233445', 'zhaoyun', '08ff1e681e17751049b7787a64a96aa0d9cf9d7fa0395d7ab7374cdbe239f8d6', '002', 'BFG4dlXpS20brg6HcrL2', NULL, NULL, 1, '6.qq.com', NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, '1', NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('4', '李白', '123231321223', 'libai', 'becb622122c19d68ecc7f319dc59c50120c435f863773d25bb6f9d665b101964', '003', 'oKILbaPTO2gWwsku3fKJ', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('5', '貂蝉', '12342332343', 'diaocan', '6d59cfe38087a61b4a1826e4155788729ac66bd28d644da826630229acd232a3', '004', 'uYkGssxYyO7gGL2rQO2Z', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('6', '王飞', '14523234354', 'wangfei', '4cb1fb5316383ebd28ea3348cfa7fc3d3e199efb32097dcc699a970f8fc0baa7', '005', 'QqyMvjgMplNXJEpjz3NA', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('7', '马化腾', '13223435465', 'mahuateng', '7192aa5223f71f4cd00ff4cf8d6b01935d60b13f34fea03f0ec870ada6f0d2f1', '006', 'MQJh0M4TivOyONAyUrbB', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('8', '马云', '12343231212', 'mayun', '557e61c64a4e1805fb79ec6dc57e54808c66c4b0a146ab6d71862238ebfb08ab', '007', 'UejqbnneXr6bqcfyi9bG', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('8c2ae91e-5cda-46f2-b887-31df24912aa4', '张三', '13569121232', 'awe', '51946acfc288c384093019996f789a6be0a31947c5543707fa4f9b156d84d1ba', '011', '4TSzgZmRTQKzSeTAowrs', NULL, NULL, 1, '1.qq.com', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, 'awef', 0, 'awef1', '1312231223', NULL, 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), '1', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('9', '马塔分', '18912231232', 'matafen', 'd83a2308677dcfe0b5605ec5092520759302b2508b4c00c5a47fc04b1f469c88', '008', 'MkIJOwUJ0I8s7UoIDEh3', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('988a04ad-c19a-4e91-bd35-3a63ba481002', '朱晓明', '12319200303', 'PG03', 'd13d2478a949baa1e55efd1751c83ede0f203488519a908bd850a4a696c6d003', 'PG-03', 'nRiHsLX6nQXbSzbEBHqq', NULL, NULL, 1, '12350@qq.com', NULL, NULL, NULL, '', 0, '', '', 0, 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('9a32395a-aa87-4b97-8ece-33e324fe226d', '王五', '13121212323', 'aaa', 'fcd0c2e5229f5e9e7d1373e668590ce63c67964df56bb2e07a06111e0badbc2b', '012', 'HuNdP1Sr1eKaDZe6gwEO', NULL, NULL, 1, '2.qq.com', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, 'awef', 0, 'aewf2', '1232344334', 0, 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL,to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('9ef0df47-39bf-4252-bd82-ca6bcf555ba5', '刘小军', '13490190000', 'PG01', '15f5c5ba918fcb58434d086185253fd43870ef9c59a38dc2cb302592a7c29562', 'PG-01', 'ya8sAJ5mp1HeYYpQohEl', NULL, NULL, 1, '12312@pangubpm.com', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, NULL, '', 0, '', '', 0, 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('fae6ba0b-7350-4c9b-ba11-bd7083ce7398', '张文文', '', 'PG02', '25b39302fd55a5c96f00060d259e064ea46b8706a8b643442e0fff1d173998c6', 'PG-02', 'VGXERgzaAUSCGtUHPe6E', NULL, NULL, 1, '233443@qq.com', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, NULL, '', 0, '', '', 0, 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);
INSERT INTO uc_user VALUES ('super', '管理员', '13454542312', 'admin', '968c2699bb7d4a48ea3b679289543734d45fafefe95861537d1cb6196ed336a9', 'super', 'wnVuvcXmP3jPt5w0g74S', NULL, NULL, 1, '3.qq.com', to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, NULL, 'erga', 0, 'awef3', '', 0, 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), NULL, NULL, NULL, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'), 'super', NULL, 1, NULL, 0, 0);


CREATE TABLE A1_RE_PROC_INST_RESTART_LOG (
  ID number(20) NOT NULL  ,
  DEAD_PROC_INST_ID NVARCHAR2(64)  ,
  PROC_DEF_ID NVARCHAR2(64)  ,
  PROC_INST_ID NVARCHAR2(64)  ,
  ACTIVITY_ID NVARCHAR2(64)  NOT NULL ,
  OPERATE_TYPE NVARCHAR2(64)  NOT NULL ,
  STATUS varchar(2)  DEFAULT '0' ,
  CREATE_TIME TIMESTAMP(6) ,
  primary key (ID)
)  ;
CREATE TABLE PANGU_BPM_CMD_LOG (
  ID_ INTEGER NOT NULL ,
  name_ NVARCHAR2(255)   ,
  start_Time_ TIMESTAMP(6)  ,
  end_Time_ TIMESTAMP(6)  ,
  total_Time_ number(20) ,
  batch_id_ NVARCHAR2(255)   ,
  class_name_ NVARCHAR2(255)   ,
  command_Percent_age NVARCHAR2(64)  ,
  profile_session_ NVARCHAR2(255)  ,
  Average_database_time_ number(20) ,
  Average_execution_time_ number(20) ,
  Average_Database_Execution_ number(20) ,
  select_json_ BLOB,
  inserts_json_ BLOB,
  updates_json_ BLOB,
  delete_json_ BLOB,
  Total_Command_Time_ number(20) ,
  count_ number(20) ,
  primary key (ID_)
) ;
CREATE TABLE PANGU_WORKBENCH_TOPIC (
  id INTEGER NOT NULL ,
  name NVARCHAR2(255)  ,
  sub_title NVARCHAR2(255)  ,
  content NVARCHAR2(2000)  ,
  create_time TIMESTAMP(6) ,
  create_user_id INTEGER ,
  parent_id INTEGER ,
  view_count INTEGER ,
  descr NVARCHAR2(255)  ,
  is_del NUMBER(1,0) DEFAULT '0',
  cover_img_url NVARCHAR2(255)  ,
  is_root NUMBER(1,0) DEFAULT '0' ,
  rec_ver INTEGER ,
  type INTEGER  ,
  primary key (id)
)  ;

CREATE TABLE PANGU_DMN_HI_DEC_EXECUTION (
  ID NVARCHAR2(255)  NOT NULL ,
  DECISION_DEFINITION_ID NVARCHAR2(255)   ,
  DEPLOYMENT_ID NVARCHAR2(255)  ,
  START_TIME timestamp NOT NULL ,
  END_TIME TIMESTAMP(6) ,
  INSTANCE_ID NVARCHAR2(255)   ,
  EXECUTION_ID NVARCHAR2(255)   ,
  ACTIVITY_ID NVARCHAR2(255)   ,
  FAILED number(4)  ,
  TENANT_ID NVARCHAR2(64)   ,
  EXECUTION_JSON BLOB ,
  SCOPE_TYPE NVARCHAR2(255)   ,
  CATEGORY NVARCHAR2(255) ,
  primary key (ID)
)  ;
CREATE TABLE A1_RE_PRO_INS_MODEL_LOG (
  ID number(20) NOT NULL  ,
  PROC_INST_ID NVARCHAR2(64)  NOT NULL ,
  PROC_DEF_ID NVARCHAR2(64)    ,
  NODE_ID NVARCHAR2(64)   ,
  NODE_INFO NVARCHAR2(64)  NOT NULL ,
  NODE_TYPE NVARCHAR2(64)  NOT NULL ,
  PRE_NODE_ID NVARCHAR2(64)  NOT NULL ,
  NEXT_NODE_ID NVARCHAR2(64)  NOT NULL ,
  NAME NVARCHAR2(64)  NOT NULL ,
  CREATE_TIME TIMESTAMP(6) NOT NULL ,
  primary key (ID)
) ;
CREATE TABLE PANGU_FORM_BUS_M_COLUMN (
  ID NVARCHAR2(64)  NOT NULL ,
  DESCRIPTION NVARCHAR2(64)  ,
  COLUMN_KEY NVARCHAR2(64)   ,
  NAME NVARCHAR2(64)   ,
  FORMAT NVARCHAR2(64)   ,
  TABLE_ID NVARCHAR2(64)   ,
  DEFAULT_VALUE NVARCHAR2(255)   ,
  DATA_TYPE NVARCHAR2(64)   ,
  ATTR_LENGTH INTEGER  ,
  DECIMAL_LENGTH INTEGER  ,
  IS_REQUIRED NUMBER(1)  ,
  IS_PRIMARY NUMBER(1)  ,
  IS_DELETE NUMBER(1)  ,
  CREATE_BY NVARCHAR2(64)   ,
  CREATE_TIME TIMESTAMP(6) ,
  UPDATE_BY NVARCHAR2(64)  ,
  UPDATE_TIME TIMESTAMP(6) ,
  primary key (ID)
)  ;
 CREATE SEQUENCE pfb_sequence INCREMENT BY 1 -- 每次递增1
START WITH 1 -- 从1开始
nomaxvalue -- 没有最大值
minvalue 1 -- 最小值=1
NOCYCLE;-- 不循环
CREATE
	OR REPLACE TRIGGER pfb_trigger BEFORE INSERT ON PANGU_FORM_BUSINESS_MODEL FOR EACH ROW
BEGIN
	SELECT
		"pfb_sequence".nextval INTO : new.ID
	FROM
		dual;

END;

 CREATE SEQUENCE aftt_sequence INCREMENT BY 1 -- 每次递增1
START WITH 1
nomaxvalue
minvalue 1
NOCYCLE;



CREATE OR REPLACE TRIGGER testTable1_INS_TRG BEFORE INSERT ON A1_FLOW_TASK_TRAJECTORY FOR EACH ROW WHEN(NEW.ID IS NULL)
BEGIN
SELECT aftt_sequence.NEXTVAL INTO :NEW.ID FROM DUAL;
END;

 CREATE SEQUENCE afi_sequence INCREMENT BY 1 -- 每次递增1
START WITH 1
nomaxvalue
minvalue 1
NOCYCLE;
CREATE OR REPLACE TRIGGER afi_INS_TRG BEFORE INSERT ON A1_FLOW_INSTANCE FOR EACH ROW WHEN(NEW.ID IS NULL)
BEGIN
SELECT afi_sequence.NEXTVAL INTO :NEW.ID FROM DUAL;
END;


 CREATE SEQUENCE st_sequence INCREMENT BY 1 -- 每次递增1
START WITH 1
nomaxvalue
minvalue 1
NOCYCLE;
CREATE OR REPLACE TRIGGER st_TRG BEFORE INSERT ON SYS_TYPE FOR EACH ROW WHEN(NEW.ID_ IS NULL)
BEGIN
SELECT st_sequence.NEXTVAL INTO :NEW.ID_ FROM DUAL;
END;

INSERT INTO sys_dict VALUES ('2', '数据字典', 'dic', '0', 2, '0', 0, '1', 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'));
INSERT INTO sys_dict VALUES ('3', '业务订单', 'yewudingdan', '0', 2, '0', 0, '2222', 0, to_date('2020-02-17 10:46:59','yyyy-MM-dd HH:mi:ss'));





 CREATE SEQUENCE sm_sequence INCREMENT BY 1 -- 每次递增1
START WITH 1000
nomaxvalue
minvalue 1
NOCYCLE;
CREATE OR REPLACE TRIGGER sm_TRG BEFORE INSERT ON SYS_MENU FOR EACH ROW WHEN(NEW.MENU_ID IS NULL)
BEGIN
SELECT sm_sequence.NEXTVAL INTO :NEW.MENU_ID FROM DUAL;
END;



 CREATE SEQUENCE sc_sequence INCREMENT BY 1 -- 每次递增1
START WITH 1000
nomaxvalue
minvalue 1
NOCYCLE;
CREATE OR REPLACE TRIGGER sc_TRG BEFORE INSERT ON SYS_CONFIG FOR EACH ROW WHEN(NEW.ID IS NULL)
BEGIN
SELECT sc_sequence.NEXTVAL INTO :NEW.ID FROM DUAL;
END;





 CREATE SEQUENCE urm_sequence INCREMENT BY 1000 -- 每次递增1
START WITH 1000
nomaxvalue
minvalue 1
NOCYCLE;
CREATE OR REPLACE TRIGGER urm_TRG BEFORE INSERT ON UC_ROLE_MENU FOR EACH ROW WHEN(NEW.ID IS NULL)
BEGIN
SELECT sc_sequence.NEXTVAL INTO :NEW.ID FROM DUAL;
END;







ALTER SYSTEM SET "_ALLOW_LEVEL_WITHOUT_CONNECT_BY"=TRUE SCOPE=BOTH








