/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.cmmn.impl.handler;

import java.util.List;
import org.apache.http.client.HttpClient;
import org.flowable.cmmn.engine.impl.delegate.CmmnClassDelegate;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.impl.cfg.DelegateExpressionFieldInjectionMode;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.http.HttpRequest;
import org.flowable.http.HttpResponse;
import org.flowable.http.delegate.HttpRequestHandler;
import org.flowable.http.delegate.HttpResponseHandler;

public class DelegateExpressionHttpHandler
implements HttpRequestHandler,
HttpResponseHandler {
    private static final long serialVersionUID = 1L;
    protected Expression expression;
    protected final List<FieldExtension> fieldExtensions;

    public DelegateExpressionHttpHandler(Expression expression, List<FieldExtension> fieldDeclarations) {
        this.expression = expression;
        this.fieldExtensions = fieldDeclarations;
    }

    @Override
    public void handleHttpRequest(VariableContainer execution, HttpRequest httpRequest, HttpClient client) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression((Expression)this.expression, (VariableContainer)execution, this.fieldExtensions);
        if (!(delegate instanceof HttpRequestHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + HttpRequestHandler.class);
        }
        ((HttpRequestHandler)delegate).handleHttpRequest(execution, httpRequest, client);
    }

    @Override
    public void handleHttpResponse(VariableContainer execution, HttpResponse httpResponse) {
        Object delegate = DelegateExpressionHttpHandler.resolveDelegateExpression(this.expression, execution, this.fieldExtensions);
        if (!(delegate instanceof HttpResponseHandler)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + HttpResponseHandler.class);
        }
        ((HttpResponseHandler)delegate).handleHttpResponse(execution, httpResponse);
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public static Object resolveDelegateExpression(Expression expression, VariableContainer variableScope, List<FieldExtension> fieldExtensions) {
        Object delegate = expression.getValue(variableScope);
        if (fieldExtensions != null && fieldExtensions.size() > 0) {
            DelegateExpressionFieldInjectionMode injectionMode = CommandContextUtil.getProcessEngineConfiguration().getDelegateExpressionFieldInjectionMode();
            if (injectionMode == DelegateExpressionFieldInjectionMode.COMPATIBILITY) {
                CmmnClassDelegate.applyFieldExtensions(fieldExtensions, (Object)delegate, (VariableContainer)variableScope, (boolean)true);
            } else if (injectionMode == DelegateExpressionFieldInjectionMode.MIXED) {
                CmmnClassDelegate.applyFieldExtensions(fieldExtensions, (Object)delegate, (VariableContainer)variableScope, (boolean)false);
            }
        }
        return delegate;
    }
}

