/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.event.FlowableIdmEventType;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.delegate.event.impl.FlowableIdmEventBuilder;
import org.flowable.idm.engine.impl.GroupQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntity;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.data.GroupDataManager;

public class GroupEntityManagerImpl
extends AbstractEntityManager<GroupEntity>
implements GroupEntityManager {
    protected GroupDataManager groupDataManager;

    public GroupEntityManagerImpl(IdmEngineConfiguration idmEngineConfiguration, GroupDataManager groupDataManager) {
        super(idmEngineConfiguration);
        this.groupDataManager = groupDataManager;
    }

    @Override
    protected DataManager<GroupEntity> getDataManager() {
        return this.groupDataManager;
    }

    @Override
    public Group createNewGroup(String groupId) {
        GroupEntity groupEntity = (GroupEntity)this.groupDataManager.create();
        groupEntity.setId(groupId);
        groupEntity.setRevision(0);
        return groupEntity;
    }

    @Override
    public void delete(String groupId) {
        GroupEntity group = (GroupEntity)this.groupDataManager.findById(groupId);
        if (group != null) {
            this.getMembershipEntityManager().deleteMembershipByGroupId(groupId);
            if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createMembershipEvent(FlowableIdmEventType.MEMBERSHIPS_DELETED, groupId, null));
            }
            this.delete(group);
        }
    }

    @Override
    public GroupQuery createNewGroupQuery() {
        return new GroupQueryImpl(this.getCommandExecutor());
    }

    @Override
    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query) {
        return this.groupDataManager.findGroupByQueryCriteria(query);
    }

    @Override
    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        return this.groupDataManager.findGroupCountByQueryCriteria(query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return this.groupDataManager.findGroupsByUser(userId);
    }

    @Override
    public List<Group> findGroupsByNativeQuery(Map<String, Object> parameterMap) {
        return this.groupDataManager.findGroupsByNativeQuery(parameterMap);
    }

    @Override
    public long findGroupCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.groupDataManager.findGroupCountByNativeQuery(parameterMap);
    }

    @Override
    public boolean isNewGroup(Group group) {
        return ((GroupEntity)group).getRevision() == 0;
    }

    @Override
    public List<Group> findGroupsByPrivilegeId(String privilegeId) {
        return this.groupDataManager.findGroupsByPrivilegeId(privilegeId);
    }

    public GroupDataManager getGroupDataManager() {
        return this.groupDataManager;
    }

    public void setGroupDataManager(GroupDataManager groupDataManager) {
        this.groupDataManager = groupDataManager;
    }
}

