/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.flowable.osgi.BpmnTransformer;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnURLHandler
extends AbstractURLStreamHandlerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnURLHandler.class);
    private static String SYNTAX = "bpmn: bpmn-xml-uri";
    private URL bpmnXmlURL;

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: " + SYNTAX);
        }
        this.bpmnXmlURL = new URL(url.getPath());
        LOGGER.debug("BPMN xml URL is: [{}]", (Object)this.bpmnXmlURL);
        return new Connection(url);
    }

    public URL getBpmnXmlURL() {
        return this.bpmnXmlURL;
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                BpmnTransformer.transform(BpmnURLHandler.this.bpmnXmlURL, os);
                os.close();
                return new ByteArrayInputStream(os.toByteArray());
            }
            catch (Exception e) {
                LOGGER.error("Error opening spring xml url", (Throwable)e);
                throw (IOException)new IOException("Error opening spring xml url").initCause(e);
            }
        }
    }
}

