/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi.blueprint;

import java.util.ArrayList;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.de.odysseus.el.ExpressionFactoryImpl;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.javax.el.ArrayELResolver;
import org.flowable.common.engine.impl.javax.el.BeanELResolver;
import org.flowable.common.engine.impl.javax.el.CompositeELResolver;
import org.flowable.common.engine.impl.javax.el.CouldNotResolvePropertyELResolver;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.common.engine.impl.javax.el.ListELResolver;
import org.flowable.common.engine.impl.javax.el.MapELResolver;
import org.flowable.common.engine.impl.scripting.BeansResolverFactory;
import org.flowable.common.engine.impl.scripting.ScriptBindingsFactory;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.invocation.DefaultDelegateInterceptor;
import org.flowable.engine.impl.el.ProcessExpressionManager;
import org.flowable.engine.impl.scripting.VariableScopeResolverFactory;
import org.flowable.osgi.OsgiScriptingEngines;
import org.flowable.osgi.blueprint.BlueprintContextELResolver;
import org.flowable.osgi.blueprint.BlueprintELResolver;
import org.flowable.osgi.blueprint.ProcessEngineFactory;

public class ProcessEngineFactoryWithELResolver
extends ProcessEngineFactory {
    private BlueprintELResolver blueprintELResolver;
    private BlueprintContextELResolver blueprintContextELResolver;

    @Override
    public void init() throws Exception {
        ProcessEngineConfigurationImpl configImpl = (ProcessEngineConfigurationImpl)this.getProcessEngineConfiguration();
        configImpl.setExpressionManager((ExpressionManager)new BlueprintExpressionManager());
        ArrayList<Object> resolverFactories = configImpl.getResolverFactories();
        if (resolverFactories == null) {
            resolverFactories = new ArrayList<Object>();
            resolverFactories.add(new VariableScopeResolverFactory());
            resolverFactories.add(new BeansResolverFactory());
        }
        configImpl.setScriptingEngines((ScriptingEngines)new OsgiScriptingEngines(new ScriptBindingsFactory((AbstractEngineConfiguration)configImpl, resolverFactories)));
        super.init();
    }

    public void setBlueprintELResolver(BlueprintELResolver blueprintELResolver) {
        this.blueprintELResolver = blueprintELResolver;
    }

    public void setBlueprintContextELResolver(BlueprintContextELResolver blueprintContextELResolver) {
        this.blueprintContextELResolver = blueprintContextELResolver;
    }

    public class BlueprintExpressionManager
    extends ProcessExpressionManager {
        public BlueprintExpressionManager() {
            this.delegateInterceptor = new DefaultDelegateInterceptor();
            this.expressionFactory = new ExpressionFactoryImpl();
        }

        protected ELResolver createElResolver(VariableContainer variableContainer) {
            CompositeELResolver compositeElResolver = new CompositeELResolver();
            compositeElResolver.add(this.createVariableElResolver(variableContainer));
            if (ProcessEngineFactoryWithELResolver.this.blueprintContextELResolver != null) {
                compositeElResolver.add((ELResolver)ProcessEngineFactoryWithELResolver.this.blueprintContextELResolver);
            }
            compositeElResolver.add((ELResolver)ProcessEngineFactoryWithELResolver.this.blueprintELResolver);
            compositeElResolver.add((ELResolver)new BeanELResolver());
            compositeElResolver.add((ELResolver)new ArrayELResolver());
            compositeElResolver.add((ELResolver)new ListELResolver());
            compositeElResolver.add((ELResolver)new MapELResolver());
            compositeElResolver.add((ELResolver)new CouldNotResolvePropertyELResolver());
            return compositeElResolver;
        }
    }
}

