/*
 * Decompiled with CFR 0.152.
 */
package flowable;

import flowable.mappers.CustomMybatisMapper;
import org.flowable.common.engine.impl.cmd.CustomSqlExecution;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.impl.cmd.AbstractCustomSqlExecution;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    @Bean
    CommandLineRunner customMybatisMapper(final ManagementService managementService) {
        return new CommandLineRunner(){

            public void run(String ... args) throws Exception {
                String processDefinitionId = (String)managementService.executeCustomSql((CustomSqlExecution)new AbstractCustomSqlExecution<CustomMybatisMapper, String>(CustomMybatisMapper.class){

                    public String execute(CustomMybatisMapper customMybatisMapper) {
                        return customMybatisMapper.loadProcessDefinitionIdByKey("waiter");
                    }
                });
                LOGGER.info("Process definition id = {}", (Object)processDefinitionId);
            }
        };
    }

    @Bean
    CommandLineRunner customMybatisXmlMapper(final ManagementService managementService) {
        return new CommandLineRunner(){

            public void run(String ... args) throws Exception {
                String processDefinitionDeploymentId = (String)managementService.executeCommand((Command)new Command<String>(){

                    public String execute(CommandContext commandContext) {
                        return (String)CommandContextUtil.getDbSqlSession().selectOne("selectProcessDefinitionDeploymentIdByKey", (Object)"waiter");
                    }
                });
                LOGGER.info("Process definition deployment id = {}", (Object)processDefinitionDeploymentId);
            }
        };
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }
}

