/*
 * Decompiled with CFR 0.152.
 */
package flowable;

import flowable.Photo;
import flowable.PhotoRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
class PhotoService {
    private final RuntimeService runtimeService;
    private final TaskService taskService;
    private final PhotoRepository photoRepository;

    @Autowired
    public PhotoService(RuntimeService runtimeService, TaskService taskService, PhotoRepository photoRepository) {
        this.runtimeService = runtimeService;
        this.taskService = taskService;
        this.photoRepository = photoRepository;
    }

    public void processPhoto(Long photoId) {
        System.out.println("processing photo#" + photoId);
    }

    public void launchPhotoProcess(String ... photoLabels) {
        ArrayList<Photo> photos = new ArrayList<Photo>();
        for (String l : photoLabels) {
            Photo x = (Photo)this.photoRepository.save(new Photo(l));
            photos.add(x);
        }
        HashMap<String, ArrayList<Photo>> procVars = new HashMap<String, ArrayList<Photo>>();
        procVars.put("photos", photos);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("dogeProcess", procVars);
        List waitingExecutions = this.runtimeService.createExecutionQuery().activityId("wait").list();
        System.out.println("--> # executions = " + waitingExecutions.size());
        for (Execution execution : waitingExecutions) {
            this.runtimeService.trigger(execution.getId());
        }
        Task reviewTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
        this.taskService.complete(reviewTask.getId(), Collections.singletonMap("approved", true));
        long count = this.runtimeService.createProcessInstanceQuery().count();
        System.out.println("Proc count " + count);
    }
}

