/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.service.impl.BaseHistoricTaskLogEntryBuilderImpl;
import org.flowable.task.service.impl.util.CommandContextUtil;

public class HistoricTaskLogEntryBuilderImpl
extends BaseHistoricTaskLogEntryBuilderImpl
implements Command<Void> {
    protected CommandExecutor commandExecutor;

    public HistoricTaskLogEntryBuilderImpl(CommandExecutor commandExecutor, TaskInfo task) {
        super(task);
        this.commandExecutor = commandExecutor;
    }

    public HistoricTaskLogEntryBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public void create() {
        this.commandExecutor.execute((Command)this);
    }

    public Void execute(CommandContext commandContext) {
        if (StringUtils.isEmpty((CharSequence)this.getTaskId())) {
            throw new FlowableIllegalArgumentException("Empty taskId is not allowed for HistoricTaskLogEntry");
        }
        if (StringUtils.isEmpty((CharSequence)this.getUserId())) {
            this.userId(Authentication.getAuthenticatedUserId());
        }
        if (this.timeStamp == null) {
            this.timeStamp(CommandContextUtil.getTaskServiceConfiguration().getClock().getCurrentTime());
        }
        CommandContextUtil.getTaskServiceConfiguration(commandContext).getInternalHistoryTaskManager().recordHistoryUserTaskLog(this);
        return null;
    }
}

