/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.flowable.ui.admin.properties.FlowableAdminAppProperties;
import org.flowable.ui.admin.service.engine.AbstractEncryptingService;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppVersionClientService
extends AbstractEncryptingService {
    @Autowired
    protected FlowableClientService clientUtil;

    public AppVersionClientService(FlowableAdminAppProperties properties) {
        super(properties);
    }

    public String getEndpointTypeUsingEncryptedPassword(String contextRoot, String restRoot, String serverAddress, Integer port, String userName, String encryptedPassword) {
        String decryptedPassword = this.decrypt(encryptedPassword);
        return this.getEndpointType(contextRoot, restRoot, serverAddress, port, userName, decryptedPassword);
    }

    public String getEndpointType(String contextRoot, String restRoot, String serverAddress, Integer port, String userName, String password) {
        String result = null;
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(contextRoot, restRoot, serverAddress, port, "enterprise/app-version"));
        try {
            JsonNode jsonNode = this.clientUtil.executeRequest((HttpUriRequest)get, userName, password);
            if (jsonNode != null && jsonNode.has("type")) {
                result = jsonNode.get("type").asText();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

