/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.dto.ServerConfigRepresentation;
import org.flowable.ui.admin.properties.FlowableAdminAppProperties;
import org.flowable.ui.admin.repository.ServerConfigRepository;
import org.flowable.ui.admin.service.engine.AbstractEncryptingService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ServerConfigService
extends AbstractEncryptingService {
    protected final FlowableAdminAppProperties properties;
    @Autowired
    protected ServerConfigRepository serverConfigRepository;

    public ServerConfigService(FlowableAdminAppProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Transactional
    public void createDefaultServerConfigs() {
        List<ServerConfig> serverConfigs = this.getDefaultServerConfigs();
        for (ServerConfig serverConfig : serverConfigs) {
            this.save(serverConfig, true);
        }
    }

    @Transactional
    public void createCmmnDefaultServerConfig() {
        ServerConfig serverConfig = this.getDefaultServerConfig(EndpointType.CMMN);
        this.save(serverConfig, true);
    }

    @Transactional
    public void createAppDefaultServerConfig() {
        ServerConfig serverConfig = this.getDefaultServerConfig(EndpointType.APP);
        this.save(serverConfig, true);
    }

    @Transactional
    public ServerConfig findOne(String id) {
        return this.serverConfigRepository.get(id);
    }

    @Transactional
    public ServerConfig findOneByEndpointTypeCode(EndpointType endpointType) {
        List<ServerConfig> serverConfigs = this.serverConfigRepository.getByEndpointType(endpointType);
        if (serverConfigs == null) {
            throw new FlowableServiceException("No server config found");
        }
        if (serverConfigs.size() > 1) {
            throw new FlowableServiceException("Only one server config per endpoint type allowed");
        }
        return serverConfigs.get(0);
    }

    @Transactional
    public List<ServerConfigRepresentation> findAll() {
        return this.createServerConfigRepresentation(this.serverConfigRepository.getAll());
    }

    @Transactional
    public void save(ServerConfig serverConfig, boolean encryptPassword) {
        if (encryptPassword) {
            serverConfig.setPassword(this.encrypt(serverConfig.getPassword()));
        }
        this.serverConfigRepository.save(serverConfig);
    }

    public String getServerConfigDecryptedPassword(ServerConfig serverConfig) {
        return this.decrypt(serverConfig.getPassword());
    }

    protected List<ServerConfigRepresentation> createServerConfigRepresentation(List<ServerConfig> serverConfigs) {
        ArrayList<ServerConfigRepresentation> serversRepresentations = new ArrayList<ServerConfigRepresentation>();
        for (ServerConfig serverConfig : serverConfigs) {
            serversRepresentations.add(this.createServerConfigRepresentation(serverConfig));
        }
        return serversRepresentations;
    }

    protected ServerConfigRepresentation createServerConfigRepresentation(ServerConfig serverConfig) {
        ServerConfigRepresentation serverRepresentation = new ServerConfigRepresentation();
        serverRepresentation.setId(serverConfig.getId());
        serverRepresentation.setName(serverConfig.getName());
        serverRepresentation.setDescription(serverConfig.getDescription());
        serverRepresentation.setServerAddress(serverConfig.getServerAddress());
        serverRepresentation.setServerPort(serverConfig.getPort());
        serverRepresentation.setContextRoot(serverConfig.getContextRoot());
        serverRepresentation.setRestRoot(serverConfig.getRestRoot());
        serverRepresentation.setUserName(serverConfig.getUserName());
        serverRepresentation.setEndpointType(serverConfig.getEndpointType());
        return serverRepresentation;
    }

    public ServerConfig getDefaultServerConfig(EndpointType endpointType) {
        ServerConfig config = this.properties.getServerConfig().get((Object)endpointType);
        if (config == null) {
            throw new FlowableIllegalArgumentException("Configuration for '" + (Object)((Object)endpointType) + "' is missing.");
        }
        this.validateServerConfig(endpointType, config);
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setName(config.getName());
        serverConfig.setDescription(config.getDescription());
        serverConfig.setServerAddress(config.getServerAddress());
        serverConfig.setPort(config.getPort());
        serverConfig.setContextRoot(config.getContextRoot());
        serverConfig.setRestRoot(config.getRestRoot());
        serverConfig.setUserName(config.getUserName());
        serverConfig.setPassword(config.getPassword());
        serverConfig.setEndpointType(endpointType.getEndpointCode());
        return serverConfig;
    }

    protected void validateServerConfig(EndpointType type, ServerConfig config) {
        String endpointPrefixVariable = "flowable.admin.app.server-config." + type.name().toLowerCase();
        Assert.hasText((String)config.getName(), (String)(endpointPrefixVariable + ".name must be set"));
        Assert.hasText((String)config.getDescription(), (String)(endpointPrefixVariable + ".description must be set"));
        Assert.hasText((String)config.getServerAddress(), (String)(endpointPrefixVariable + ".server-address must be set"));
        Assert.notNull((Object)config.getPort(), (String)(endpointPrefixVariable + ".port must be set"));
        Assert.hasText((String)config.getContextRoot(), (String)(endpointPrefixVariable + ".context-root must be set"));
        Assert.hasText((String)config.getRestRoot(), (String)(endpointPrefixVariable + ".rest-root must be set"));
        Assert.hasText((String)config.getUserName(), (String)(endpointPrefixVariable + ".user-name must be set"));
        Assert.hasText((String)config.getPassword(), (String)(endpointPrefixVariable + ".password must be set"));
    }

    public List<ServerConfig> getDefaultServerConfigs() {
        ArrayList<ServerConfig> serverConfigs = new ArrayList<ServerConfig>();
        serverConfigs.add(this.getDefaultServerConfig(EndpointType.PROCESS));
        serverConfigs.add(this.getDefaultServerConfig(EndpointType.CMMN));
        serverConfigs.add(this.getDefaultServerConfig(EndpointType.APP));
        serverConfigs.add(this.getDefaultServerConfig(EndpointType.DMN));
        serverConfigs.add(this.getDefaultServerConfig(EndpointType.FORM));
        serverConfigs.add(this.getDefaultServerConfig(EndpointType.CONTENT));
        return serverConfigs;
    }
}

