/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.modeler.model.FormSaveRepresentation;
import org.flowable.ui.modeler.model.form.FormRepresentation;
import org.flowable.ui.modeler.service.FlowableFormService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/rest/form-models"})
public class FormResource {
    @Autowired
    protected FlowableFormService formService;

    @GetMapping(value={"/{formId}"}, produces={"application/json"})
    public FormRepresentation getForm(@PathVariable String formId) {
        return this.formService.getForm(formId);
    }

    @GetMapping(value={"/values"}, produces={"application/json"})
    public List<FormRepresentation> getForms(HttpServletRequest request) {
        String[] formIds = request.getParameterValues("formId");
        return this.formService.getForms(formIds);
    }

    @GetMapping(value={"/{formId}/history/{formHistoryId}"}, produces={"application/json"})
    public FormRepresentation getFormHistory(@PathVariable String formId, @PathVariable String formHistoryId) {
        return this.formService.getFormHistory(formId, formHistoryId);
    }

    @PutMapping(value={"/{formId}"}, produces={"application/json"})
    public FormRepresentation saveForm(@PathVariable String formId, @RequestBody FormSaveRepresentation saveRepresentation) {
        return this.formService.saveForm(formId, saveRepresentation);
    }
}

