/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.conf;

import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.FlowableEngineAgendaFactory;
import org.flowable.engine.impl.agenda.DebugFlowableEngineAgendaFactory;
import org.flowable.engine.impl.event.BreakpointJobHandler;
import org.flowable.engine.runtime.ProcessDebugger;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.asyncexecutor.DefaultDebuggerExecutionExceptionHandler;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.ui.task.conf.FlowableDebuggerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FlowableDebuggerProperties.class})
@ConditionalOnProperty(prefix="flowable.experimental.debugger", name={"enabled"}, havingValue="true")
@AutoConfigureBefore(value={ProcessEngineAutoConfiguration.class})
public class FlowableDebuggerConfiguration {
    @Bean
    public FlowableEngineAgendaFactory debuggerAgendaFactory(ProcessDebugger processDebugger) {
        DebugFlowableEngineAgendaFactory debugAgendaFactory = new DebugFlowableEngineAgendaFactory();
        debugAgendaFactory.setDebugger(processDebugger);
        return debugAgendaFactory;
    }

    @Bean
    public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> debuggerProcessEngineConfigurationConfigurer(FlowableEngineAgendaFactory agendaFactory) {
        return processEngineConfiguration -> {
            processEngineConfiguration.setEnableDatabaseEventLogging(true);
            processEngineConfiguration.setAgendaFactory(agendaFactory);
            processEngineConfiguration.addCustomJobHandler((JobHandler)new BreakpointJobHandler());
            List customAsyncRunnableExecutionExceptionHandlers = processEngineConfiguration.getCustomAsyncRunnableExecutionExceptionHandlers();
            ArrayList<Object> exceptionHandlers = customAsyncRunnableExecutionExceptionHandlers == null ? new ArrayList<DefaultDebuggerExecutionExceptionHandler>() : new ArrayList(customAsyncRunnableExecutionExceptionHandlers);
            exceptionHandlers.add(new DefaultDebuggerExecutionExceptionHandler());
            processEngineConfiguration.setCustomAsyncRunnableExecutionExceptionHandlers(exceptionHandlers);
        };
    }
}

