/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDefinitionQuery;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.task.model.runtime.ProcessInstanceRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableProcessInstanceQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableProcessInstanceQueryService.class);
    private static final int DEFAULT_PAGE_SIZE = 25;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected UserCache userCache;

    public ResultListDataRepresentation getProcessInstances(ObjectNode requestNode) {
        JsonNode stateNode;
        JsonNode appDefinitionKeyNode;
        HistoricProcessInstanceQuery instanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        User currentUser = SecurityUtils.getCurrentUserObject();
        instanceQuery.involvedUser(String.valueOf(currentUser.getId()));
        JsonNode processDefinitionIdNode = requestNode.get("processDefinitionId");
        if (processDefinitionIdNode != null && !processDefinitionIdNode.isNull()) {
            instanceQuery.processDefinitionId(processDefinitionIdNode.asText());
        }
        if ((appDefinitionKeyNode = requestNode.get("appDefinitionKey")) != null && !appDefinitionKeyNode.isNull()) {
            List appDefinitions = ((AppDefinitionQuery)this.appRepositoryService.createAppDefinitionQuery().appDefinitionKey(appDefinitionKeyNode.asText())).list();
            ArrayList<String> parentDeploymentIds = new ArrayList<String>();
            for (AppDefinition appDefinition : appDefinitions) {
                parentDeploymentIds.add(appDefinition.getDeploymentId());
            }
            List deployments = this.repositoryService.createDeploymentQuery().parentDeploymentIds(parentDeploymentIds).list();
            ArrayList<String> deploymentIds = new ArrayList<String>();
            for (Deployment deployment : deployments) {
                deploymentIds.add(deployment.getId());
            }
            if (deploymentIds.size() > 0) {
                instanceQuery.deploymentIdIn(deploymentIds);
            } else {
                return new ResultListDataRepresentation(new ArrayList());
            }
        }
        if ((stateNode = requestNode.get("state")) != null && !stateNode.isNull()) {
            String state = stateNode.asText();
            if ("running".equals(state)) {
                instanceQuery.unfinished();
            } else if ("completed".equals(state)) {
                instanceQuery.finished();
            } else if (!"all".equals(state)) {
                throw new BadRequestException("Illegal state filter value passed, only 'running', 'completed' or 'all' are supported");
            }
        } else {
            instanceQuery.unfinished();
        }
        JsonNode sortNode = requestNode.get("sort");
        if (sortNode != null && !sortNode.isNull()) {
            if ("created-desc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceStartTime().desc();
            } else if ("created-asc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceStartTime().asc();
            } else if ("ended-desc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceEndTime().desc();
            } else if ("ended-asc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceEndTime().asc();
            }
        } else {
            instanceQuery.orderByProcessInstanceStartTime().desc();
        }
        int page = 0;
        JsonNode pageNode = requestNode.get("page");
        if (pageNode != null && !pageNode.isNull()) {
            page = pageNode.asInt(0);
        }
        int size = 25;
        JsonNode sizeNode = requestNode.get("size");
        if (sizeNode != null && !sizeNode.isNull()) {
            size = sizeNode.asInt(25);
        }
        List instances = instanceQuery.listPage(page * size, size);
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertInstanceList(instances));
        if (page != 0 || instances.size() == size) {
            Long totalCount = instanceQuery.count();
            result.setTotal(Long.valueOf(totalCount.intValue()));
            result.setStart(Integer.valueOf(page * size));
        }
        return result;
    }

    protected List<ProcessInstanceRepresentation> convertInstanceList(List<HistoricProcessInstance> instances) {
        ArrayList<ProcessInstanceRepresentation> result = new ArrayList<ProcessInstanceRepresentation>();
        if (CollectionUtils.isNotEmpty(instances)) {
            for (HistoricProcessInstance processInstance : instances) {
                UserCache.CachedUser user;
                User userRep = null;
                if (processInstance.getStartUserId() != null && (user = this.userCache.getUser(processInstance.getStartUserId())) != null && user.getUser() != null) {
                    userRep = user.getUser();
                }
                ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
                ProcessInstanceRepresentation instanceRepresentation = new ProcessInstanceRepresentation(processInstance, (ProcessDefinition)procDef, procDef.isGraphicalNotationDefined(), userRep);
                result.add(instanceRepresentation);
            }
        }
        return result;
    }
}

