/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnActivityBehavior
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnActivityBehavior.class);

    public void performDefaultOutgoingBehavior(ActivityExecution activityExecution) {
        ActivityImpl activity = (ActivityImpl)activityExecution.getActivity();
        if (!(activity.getActivityBehavior() instanceof IntermediateCatchEventActivityBehavior)) {
            this.dispatchJobCanceledEvents(activityExecution);
        }
        this.performOutgoingBehavior(activityExecution, true, false, null);
    }

    public void performIgnoreConditionsOutgoingBehavior(ActivityExecution activityExecution) {
        this.performOutgoingBehavior(activityExecution, false, false, null);
    }

    protected void dispatchJobCanceledEvents(ActivityExecution activityExecution) {
        if (activityExecution instanceof ExecutionEntity) {
            List<JobEntity> jobs = ((ExecutionEntity)activityExecution).getJobs();
            for (JobEntity job : jobs) {
                if (!Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, job));
            }
            List<TimerJobEntity> timerJobs = ((ExecutionEntity)activityExecution).getTimerJobs();
            for (TimerJobEntity job : timerJobs) {
                if (!Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, job));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performOutgoingBehavior(ActivityExecution execution, boolean checkConditions, boolean throwExceptionIfExecutionStuck, List<ActivityExecution> reusableExecutions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Leaving activity '{}'", (Object)execution.getActivity().getId());
        }
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
        List<PvmTransition> outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        for (PvmTransition outgoingTransition : outgoingTransitions) {
            Expression skipExpression = outgoingTransition.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled(execution, skipExpression)) {
                Condition condition;
                if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && checkConditions && !condition.evaluate(outgoingTransition.getId(), execution)) continue;
                transitionsToTake.add(outgoingTransition);
                continue;
            }
            if (!SkipExpressionUtil.shouldSkipFlowElement(execution, skipExpression)) continue;
            transitionsToTake.add(outgoingTransition);
        }
        if (transitionsToTake.size() == 1) {
            execution.take((PvmTransition)transitionsToTake.get(0));
            return;
        } else if (transitionsToTake.size() >= 1) {
            execution.inactivate();
            if (reusableExecutions == null || reusableExecutions.isEmpty()) {
                execution.takeAll(transitionsToTake, Collections.singletonList(execution));
                return;
            } else {
                execution.takeAll(transitionsToTake, reusableExecutions);
            }
            return;
        } else if (defaultSequenceFlow != null) {
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw new ActivitiException("Default sequence flow '" + defaultSequenceFlow + "' could not be not found");
            execution.take(defaultTransition);
            return;
        } else {
            Object isForCompensation = execution.getActivity().getProperty("isForCompensation");
            if (isForCompensation != null && ((Boolean)isForCompensation).booleanValue()) {
                if (execution instanceof ExecutionEntity) {
                    Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution);
                }
                InterpretableExecution parentExecution = (InterpretableExecution)execution.getParent();
                ((InterpretableExecution)execution).remove();
                parentExecution.signal("compensationDone", null);
                return;
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No outgoing sequence flow found for {}. Ending execution.", (Object)execution.getActivity().getId());
                }
                execution.end();
                if (!throwExceptionIfExecutionStuck) return;
                throw new ActivitiException("No outgoing sequence flow of the inclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process");
            }
        }
    }
}

