/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class GetTasksLocalVariablesCmd
implements Command<List<VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> taskIds;

    public GetTasksLocalVariablesCmd(Set<String> taskIds) {
        this.taskIds = taskIds;
    }

    @Override
    public List<VariableInstance> execute(CommandContext commandContext) {
        if (this.taskIds == null) {
            throw new ActivitiIllegalArgumentException("taskIds is null");
        }
        if (this.taskIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Set of taskIds is empty");
        }
        ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
        List<VariableInstanceEntity> entities = commandContext.getVariableInstanceEntityManager().findVariableInstancesByTaskIds(this.taskIds);
        for (VariableInstanceEntity entity : entities) {
            entity.getValue();
            instances.add(entity);
        }
        return instances;
    }
}

