/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.Plugin;

public class PluginRegister {
    private static final Log LOG = LogFactory.getLog(PluginRegister.class);
    private final List<Plugin> REGISTERED_PLUGINS = new ArrayList<Plugin>();
    private final ClassLoader CLASS_LOADER = this.getClass().getClassLoader();
    private boolean hasRegisteredPlugins;

    public <T extends Plugin> T getPlugin(Class<T> clazz) {
        return (T)((Plugin)this.getPlugins().stream().filter(p -> p.getClass().getCanonicalName().equals(clazz.getCanonicalName())).findFirst().orElse(null));
    }

    public <T extends Plugin> List<T> getPlugins(Class<T> clazz) {
        return this.getPlugins().stream().filter(clazz::isInstance).sorted().collect(Collectors.toList());
    }

    public <T extends Plugin> List<T> getLicensedPlugins(Class<T> clazz, Configuration configuration) {
        return this.getPlugins().stream().filter(clazz::isInstance).filter(p -> p.isLicensed(configuration)).sorted().collect(Collectors.toList());
    }

    public <T extends Plugin> T getLicensedPlugin(String className, Configuration configuration) {
        return (T)((Plugin)this.getPlugins().stream().filter(p -> p.isLicensed(configuration)).filter(p -> p.getClass().getSimpleName().equals(className)).sorted().findFirst().orElse(null));
    }

    private List<Plugin> getPlugins() {
        this.registerPlugins();
        return Collections.unmodifiableList(this.REGISTERED_PLUGINS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerPlugins() {
        List<Plugin> list = this.REGISTERED_PLUGINS;
        synchronized (list) {
            if (this.hasRegisteredPlugins) {
                return;
            }
            for (Plugin plugin : ServiceLoader.load(Plugin.class, this.CLASS_LOADER)) {
                if (!plugin.isEnabled()) continue;
                this.REGISTERED_PLUGINS.add(plugin);
            }
            this.hasRegisteredPlugins = true;
        }
    }

    public PluginRegister getCopy() {
        PluginRegister copy = new PluginRegister();
        copy.REGISTERED_PLUGINS.clear();
        copy.REGISTERED_PLUGINS.addAll(this.getPlugins().stream().map(Plugin::copy).toList());
        copy.hasRegisteredPlugins = true;
        return copy;
    }
}

