/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationExecutor;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.Pair;

public class SqlMigrationResolver
implements MigrationResolver {
    private final Database database;
    private final ResourceProvider resourceProvider;
    private final SqlStatementBuilderFactory sqlStatementBuilderFactory;
    private final Configuration configuration;

    public SqlMigrationResolver(Database database, ResourceProvider resourceProvider, SqlStatementBuilderFactory sqlStatementBuilderFactory, Configuration configuration) {
        this.database = database;
        this.resourceProvider = resourceProvider;
        this.sqlStatementBuilderFactory = sqlStatementBuilderFactory;
        this.configuration = configuration;
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        String separator = this.configuration.getSqlMigrationSeparator();
        String[] suffixes = this.configuration.getSqlMigrationSuffixes();
        this.addMigrations(migrations, this.configuration.getSqlMigrationPrefix(), separator, suffixes, false);
        this.addMigrations(migrations, this.configuration.getRepeatableSqlMigrationPrefix(), separator, suffixes, true);
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    private void addMigrations(List<ResolvedMigration> migrations, String prefix, String separator, String[] suffixes, boolean repeatable) {
        for (LoadableResource resource : this.resourceProvider.getResources(prefix, suffixes)) {
            String filename = resource.getFilename();
            if (SqlMigrationResolver.isSqlCallback(filename, separator, suffixes)) continue;
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(filename, prefix, separator, suffixes, repeatable);
            ResolvedMigrationImpl migration = new ResolvedMigrationImpl();
            migration.setVersion(info.getLeft());
            migration.setDescription(info.getRight());
            migration.setScript(resource.getRelativePath());
            SqlScript sqlScript = new SqlScript(this.sqlStatementBuilderFactory, resource, this.configuration.isMixed());
            int checksum = resource.checksum();
            migration.setChecksum(checksum);
            migration.setType(MigrationType.SQL);
            migration.setPhysicalLocation(resource.getAbsolutePathOnDisk());
            migration.setExecutor(new SqlMigrationExecutor(this.database, sqlScript));
            migrations.add(migration);
        }
    }

    static boolean isSqlCallback(String filename, String separator, String ... suffixes) {
        for (String suffix : suffixes) {
            String baseName = filename.substring(0, filename.length() - suffix.length());
            int index = baseName.indexOf(separator);
            if (index >= 0) {
                baseName = baseName.substring(0, index);
            }
            if (Event.fromId(baseName) == null) continue;
            return true;
        }
        return false;
    }
}

