/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api;

import org.flywaydb.core.extensibility.MigrationType;

public enum CoreMigrationType implements MigrationType
{
    SCHEMA(true, false, false),
    BASELINE(true, false, true),
    DELETE(true, false, false),
    SQL(false, false, false),
    JDBC(false, false, false),
    SCRIPT(false, false, false),
    SCRIPT_BASELINE(false, false, true),
    UNDO_SCRIPT(false, true, false),
    CUSTOM(false, false, false);

    private final boolean synthetic;
    private final boolean undo;
    private final boolean baseline;

    public static MigrationType fromString(String migrationType) {
        if ("SPRING_JDBC".equals(migrationType)) {
            return JDBC;
        }
        return CoreMigrationType.valueOf(migrationType);
    }

    private CoreMigrationType(boolean synthetic, boolean undo, boolean baseline) {
        this.synthetic = synthetic;
        this.undo = undo;
        this.baseline = baseline;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public boolean isUndo() {
        return this.undo;
    }

    @Override
    public boolean isBaseline() {
        return this.baseline;
    }
}

