/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command.clean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class CleanModeConfigurationExtension
implements ConfigurationExtension {
    private static final String CLEAN_MODE = "flyway.plugins.clean.mode";
    private static final String CLEAN_SCHEMAS_EXCLUDE = "flyway.plugins.clean.schemas.exclude";
    private Mode cleanMode = Mode.DEFAULT;
    private List<String> cleanSchemasExclude = new ArrayList<String>();

    @Override
    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        this.cleanMode = Mode.fromString(configuration.getOrDefault(CLEAN_MODE, this.cleanMode.toString()));
        String cleanSchemasExcludeString = configuration.getOrDefault(CLEAN_SCHEMAS_EXCLUDE, null);
        if (cleanSchemasExcludeString != null) {
            this.cleanSchemasExclude = Arrays.asList(cleanSchemasExcludeString.split(","));
        }
        configuration.remove(CLEAN_MODE);
        configuration.remove(CLEAN_SCHEMAS_EXCLUDE);
    }

    @Override
    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_CLEAN_MODE": {
                return CLEAN_MODE;
            }
            case "FLYWAY_PLUGINS_CLEAN_SCHEMAS_EXCLUDE": {
                return CLEAN_SCHEMAS_EXCLUDE;
            }
        }
        return null;
    }

    public void setCleanSchemasExclude(String ... cleanSchemasExclude) {
        this.cleanSchemasExclude = Arrays.asList(cleanSchemasExclude);
    }

    public Mode getCleanMode() {
        return this.cleanMode;
    }

    public List<String> getCleanSchemasExclude() {
        return this.cleanSchemasExclude;
    }

    public void setCleanMode(Mode cleanMode) {
        this.cleanMode = cleanMode;
    }

    public static enum Mode {
        DEFAULT,
        SCHEMA,
        ALL;


        public static Mode fromString(String string) {
            return Mode.valueOf(string.toUpperCase());
        }
    }
}

