/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignExceptionEndPoints;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public final class ForeignException
extends RuntimeException {
    static final byte UNDEFINED = 0;
    static final byte HOST_TO_GUEST = 1;
    static final byte GUEST_TO_HOST = 2;
    private static final ThreadLocal<ForeignException> pendingException = new ThreadLocal();
    private static final JNIMethodResolver CreateForeignException = new JNIMethodResolver("createForeignException", "([B)Ljava/lang/Throwable;");
    private static final JNIMethodResolver ToByteArray = new JNIMethodResolver("toByteArray", "(Lorg/graalvm/nativebridge/ForeignException;)[B");
    private static final ForeignException MARSHALLING_FAILED = new ForeignException(null, 0, false);
    private static volatile JNICalls jniCalls;
    private final byte kind;
    private final byte[] rawData;

    private ForeignException(byte[] rawData, byte kind, boolean writableStackTrace) {
        super(null, null, true, writableStackTrace);
        this.rawData = rawData;
        this.kind = kind;
    }

    public void throwUsingJNI(JNI.JNIEnv env) {
        JNIUtil.Throw((JNI.JNIEnv)env, (JNI.JThrowable)ForeignException.callCreateForeignException(env, JNIUtil.createHSArray((JNI.JNIEnv)env, (byte[])this.rawData)));
    }

    public RuntimeException throwOriginalException(BinaryMarshaller<? extends Throwable> marshaller) {
        try {
            if (this.rawData == null) {
                throw new RuntimeException("Failed to marshall foreign throwable.");
            }
            BinaryInput in = BinaryInput.create(this.rawData);
            Throwable t = marshaller.read(in);
            throw ForeignException.silenceException(RuntimeException.class, t);
        }
        catch (Throwable throwable) {
            ForeignException.clearPendingException();
            throw throwable;
        }
    }

    public static StackTraceElement[] mergeStackTrace(StackTraceElement[] foreignExceptionStack) {
        if (foreignExceptionStack.length == 0) {
            return foreignExceptionStack;
        }
        ForeignException localException = pendingException.get();
        if (localException != null) {
            switch (localException.kind) {
                case 1: {
                    return JNIExceptionWrapper.mergeStackTraces((StackTraceElement[])localException.getStackTrace(), (StackTraceElement[])foreignExceptionStack, (boolean)false);
                }
                case 2: {
                    return JNIExceptionWrapper.mergeStackTraces((StackTraceElement[])foreignExceptionStack, (StackTraceElement[])localException.getStackTrace(), (boolean)true);
                }
            }
            throw new IllegalStateException("Unsupported kind " + localException.kind);
        }
        return foreignExceptionStack;
    }

    public static ForeignException forThrowable(Throwable exception, BinaryMarshaller<? super Throwable> marshaller) {
        try {
            BinaryOutput.ByteArrayBinaryOutput out = BinaryOutput.ByteArrayBinaryOutput.create(marshaller.inferSize(exception));
            marshaller.write(out, exception);
            return new ForeignException(out.getArray(), 0, false);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return MARSHALLING_FAILED;
        }
    }

    public static JNICalls getJNICalls() {
        JNICalls res = jniCalls;
        if (res == null) {
            jniCalls = res = ForeignException.createJNICalls();
        }
        return res;
    }

    byte[] toByteArray() {
        return this.rawData;
    }

    static ForeignException create(byte[] rawData, byte kind) {
        ForeignException exception = new ForeignException(rawData, kind, true);
        pendingException.set(exception);
        return exception;
    }

    private static void clearPendingException() {
        pendingException.set(null);
    }

    private static <T extends Throwable> T silenceException(Class<T> type, Throwable t) throws T {
        throw t;
    }

    private static JNICalls createJNICalls() {
        return JNICalls.createWithExceptionHandler(context -> {
            if (ForeignException.class.getName().equals(context.getThrowableClassName())) {
                JNI.JNIEnv env = context.getEnv();
                byte[] marshalledData = JNIUtil.createArray((JNI.JNIEnv)env, (JNI.JByteArray)ForeignException.callToByteArray(env, (JNI.JObject)context.getThrowable()));
                throw ForeignException.create(marshalledData, (byte)2);
            }
            context.throwJNIExceptionWrapper();
        });
    }

    private static JNI.JThrowable callCreateForeignException(JNI.JNIEnv env, JNI.JByteArray rawValue) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject((JNI.JObject)rawValue);
        return (JNI.JThrowable)JNICalls.getDefault().callStaticJObject(env, CreateForeignException.getEntryPoints(env), (JNICalls.JNIMethod)CreateForeignException.resolve(env), args);
    }

    private static JNI.JByteArray callToByteArray(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (JNI.JByteArray)JNICalls.getDefault().callStaticJObject(env, ToByteArray.getEntryPoints(env), (JNICalls.JNIMethod)ToByteArray.resolve(env), args);
    }

    private static final class JNIMethodResolver
    implements JNICalls.JNIMethod {
        private final String methodName;
        private final String methodSignature;
        private volatile JNI.JClass entryPointsClass;
        private volatile JNI.JMethodID methodId;

        JNIMethodResolver(String methodName, String methodSignature) {
            this.methodName = methodName;
            this.methodSignature = methodSignature;
        }

        JNIMethodResolver resolve(JNI.JNIEnv jniEnv) {
            JNI.JMethodID res = this.methodId;
            if (res.isNull()) {
                JNI.JClass entryPointClass = this.getEntryPoints(jniEnv);
                try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)this.methodName);
                     CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)this.methodSignature);){
                    res = JNIUtil.GetStaticMethodID((JNI.JNIEnv)jniEnv, (JNI.JClass)entryPointClass, (CCharPointer)name.get(), (CCharPointer)sig.get());
                    if (res.isNull()) {
                        throw new InternalError("No such method: " + this.methodName);
                    }
                    this.methodId = res;
                }
            }
            return this;
        }

        JNI.JClass getEntryPoints(JNI.JNIEnv env) {
            JNI.JClass res = this.entryPointsClass;
            if (res.isNull()) {
                this.entryPointsClass = res = JNIClassCache.lookupClass(env, ForeignExceptionEndPoints.class);
            }
            return res;
        }

        public JNI.JMethodID getJMethodID() {
            return this.methodId;
        }

        public String getDisplayName() {
            return this.methodName;
        }
    }
}

