/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSInputStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSOutputStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.HSProcess;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

final class HSProcessGen {
    HSProcessGen() {
    }

    static HSProcess createNativeToHS(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
        return new StartPoint(hSPolyglotObject, jNIEnv);
    }

    private static final class StartPoint
    extends HSProcess {
        private static final BinaryMarshaller<ProcessHandle> processHandleMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<TimeUnit> timeUnitMarshaller;
        final JNIData jniMethods_;

        StartPoint(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
            super(hSPolyglotObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public int waitFor() throws InterruptedException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.waitFor1Method, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean waitFor(long l2, TimeUnit timeUnit) throws InterruptedException {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = timeUnitMarshaller.inferSize((Object)timeUnit);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        timeUnitMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)timeUnit);
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.delegate.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setLong(l2);
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.waitFor2Method, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        @Override
        public int exitValue() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.exitValueMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void destroy() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.destroyMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean supportsNormalTermination() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.supportsNormalTerminationMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isAlive() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isAliveMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long pid() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.pidMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProcessHandle toHandle() {
            ProcessHandle processHandle;
            block6: {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                JNI.JByteArray jByteArray = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toHandleMethod, jValue);
                int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                try {
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                    processHandle = (ProcessHandle)processHandleMarshaller.read(binaryInput);
                    if (cCharPointer2 == cCharPointer) break block6;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free((PointerBase)cCharPointer2);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer2);
            }
            return processHandle;
        }

        @Override
        public Process destroyForcibly() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.destroyForciblyMethod, jValue);
                return jObject.isNonNull() ? HSProcessGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public InputStream getInputStream() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getInputStreamMethod, jValue);
                return jObject.isNonNull() ? HSInputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public InputStream getErrorStream() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getErrorStreamMethod, jValue);
                return jObject.isNonNull() ? HSInputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public OutputStream getOutputStream() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getOutputStreamMethod, jValue);
                return jObject.isNonNull() ? HSOutputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            processHandleMarshaller = jNIConfig.lookupMarshaller(ProcessHandle.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            timeUnitMarshaller = jNIConfig.lookupMarshaller(TimeUnit.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod waitFor1Method;
            final JNICalls.JNIMethod waitFor2Method;
            final JNICalls.JNIMethod exitValueMethod;
            final JNICalls.JNIMethod destroyMethod;
            final JNICalls.JNIMethod supportsNormalTerminationMethod;
            final JNICalls.JNIMethod isAliveMethod;
            final JNICalls.JNIMethod pidMethod;
            final JNICalls.JNIMethod toHandleMethod;
            final JNICalls.JNIMethod destroyForciblyMethod;
            final JNICalls.JNIMethod getInputStreamMethod;
            final JNICalls.JNIMethod getErrorStreamMethod;
            final JNICalls.JNIMethod getOutputStreamMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.waitFor1Method = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"waitFor", (String)"(Ljava/lang/Process;)I");
                this.waitFor2Method = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"waitFor", (String)"(Ljava/lang/Process;J[B)Z");
                this.exitValueMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"exitValue", (String)"(Ljava/lang/Process;)I");
                this.destroyMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"destroy", (String)"(Ljava/lang/Process;)V");
                this.supportsNormalTerminationMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"supportsNormalTermination", (String)"(Ljava/lang/Process;)Z");
                this.isAliveMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isAlive", (String)"(Ljava/lang/Process;)Z");
                this.pidMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"pid", (String)"(Ljava/lang/Process;)J");
                this.toHandleMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"toHandle", (String)"(Ljava/lang/Process;)[B");
                this.destroyForciblyMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"destroyForcibly", (String)"(Ljava/lang/Process;)Ljava/lang/Process;");
                this.getInputStreamMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getInputStream", (String)"(Ljava/lang/Process;)Ljava/io/InputStream;");
                this.getErrorStreamMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getErrorStream", (String)"(Ljava/lang/Process;)Ljava/io/InputStream;");
                this.getOutputStreamMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"getOutputStream", (String)"(Ljava/lang/Process;)Ljava/io/OutputStream;");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<ProcessHandle> processHandleMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<TimeUnit> timeUnitMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static int waitFor(Process process) {
            try {
                int n2 = process.waitFor();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean waitFor(Process process, long l2, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                TimeUnit timeUnit = (TimeUnit)((Object)timeUnitMarshaller.read(binaryInput));
                boolean bl = process.waitFor(l2, timeUnit);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int exitValue(Process process) {
            try {
                int n2 = process.exitValue();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void destroy(Process process) {
            try {
                process.destroy();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean supportsNormalTermination(Process process) {
            try {
                boolean bl = process.supportsNormalTermination();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isAlive(Process process) {
            try {
                boolean bl = process.isAlive();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long pid(Process process) {
            try {
                long l2 = process.pid();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] toHandle(Process process) {
            try {
                ProcessHandle processHandle = process.toHandle();
                int n2 = processHandleMarshaller.inferSize((Object)processHandle);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                processHandleMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)processHandle);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Process destroyForcibly(Process process) {
            try {
                Process process2 = process.destroyForcibly();
                return process2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static InputStream getInputStream(Process process) {
            try {
                InputStream inputStream = process.getInputStream();
                return inputStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static InputStream getErrorStream(Process process) {
            try {
                InputStream inputStream = process.getErrorStream();
                return inputStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static OutputStream getOutputStream(Process process) {
            try {
                OutputStream outputStream = process.getOutputStream();
                return outputStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            processHandleMarshaller = jNIConfig.lookupMarshaller(ProcessHandle.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            timeUnitMarshaller = jNIConfig.lookupMarshaller(TimeUnit.class, new Class[0]);
        }
    }
}

