/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSSeekableByteChannel;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

final class HSSeekableByteChannelGen {
    HSSeekableByteChannelGen() {
    }

    static HSSeekableByteChannel createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSSeekableByteChannel {
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithReadOnlyMarshaller;
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithWriteOnlyMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public boolean isOpen() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isOpenMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.closeMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long position() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.position1Method, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public SeekableByteChannel position(long l2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.position2Method, jValue);
                return jObject.isNonNull() ? HSSeekableByteChannelGen.createNativeToHS(jNIEnv, jObject) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long size() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.sizeMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public SeekableByteChannel truncate(long l2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                JNI.JObject jObject = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.truncateMethod, jValue);
                return jObject.isNonNull() ? HSSeekableByteChannelGen.createNativeToHS(jNIEnv, jObject) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            int n2;
            block17: {
                int n3;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)512);
                int n4 = 4 + byteBufferWithReadOnlyMarshaller.inferSize((Object)byteBuffer);
                if (n4 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n4);
                    n3 = n4;
                } else {
                    cCharPointer = cCharPointer2;
                    n3 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n3, (boolean)false);){
                        byteBufferWithReadOnlyMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)byteBuffer);
                        int n5 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)Math.max(n5, n3));
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n5, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n6 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n3 < n6) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n6);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n6, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n6);
                    int n7 = binaryInput.readInt();
                    byteBufferWithReadOnlyMarshaller.readUpdate(binaryInput, (Object)byteBuffer);
                    n2 = n7;
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            int n2;
            block17: {
                int n3;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)512);
                int n4 = 4 + byteBufferWithWriteOnlyMarshaller.inferSize((Object)byteBuffer);
                if (n4 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n4);
                    n3 = n4;
                } else {
                    cCharPointer = cCharPointer2;
                    n3 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n3, (boolean)false);){
                        byteBufferWithWriteOnlyMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)byteBuffer);
                        int n5 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)Math.max(n5, n3));
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n5, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.writeMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n6 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n3 < n6) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n6);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n6, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n6);
                    int n7 = binaryInput.readInt();
                    byteBufferWithWriteOnlyMarshaller.readUpdate(binaryInput, (Object)byteBuffer);
                    n2 = n7;
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return n2;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferWithReadOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[]{PolyglotJNIConfig.ReadOnly.class});
            byteBufferWithWriteOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[]{PolyglotJNIConfig.WriteOnly.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod isOpenMethod;
            final JNICalls.JNIMethod closeMethod;
            final JNICalls.JNIMethod position1Method;
            final JNICalls.JNIMethod position2Method;
            final JNICalls.JNIMethod sizeMethod;
            final JNICalls.JNIMethod truncateMethod;
            final JNICalls.JNIMethod readMethod;
            final JNICalls.JNIMethod writeMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.isOpenMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isOpen", (String)"(Ljava/nio/channels/SeekableByteChannel;)Z");
                this.closeMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"close", (String)"(Ljava/nio/channels/SeekableByteChannel;)V");
                this.position1Method = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"position", (String)"(Ljava/nio/channels/SeekableByteChannel;)J");
                this.position2Method = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"position", (String)"(Ljava/nio/channels/SeekableByteChannel;J)Ljava/nio/channels/SeekableByteChannel;");
                this.sizeMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"size", (String)"(Ljava/nio/channels/SeekableByteChannel;)J");
                this.truncateMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"truncate", (String)"(Ljava/nio/channels/SeekableByteChannel;J)Ljava/nio/channels/SeekableByteChannel;");
                this.readMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"read", (String)"(Ljava/nio/channels/SeekableByteChannel;[B)[B");
                this.writeMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"write", (String)"(Ljava/nio/channels/SeekableByteChannel;[B)[B");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithReadOnlyMarshaller;
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithWriteOnlyMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static boolean isOpen(SeekableByteChannel seekableByteChannel) {
            try {
                boolean bl = seekableByteChannel.isOpen();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void close(SeekableByteChannel seekableByteChannel) {
            try {
                seekableByteChannel.close();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long position(SeekableByteChannel seekableByteChannel) {
            try {
                long l2 = seekableByteChannel.position();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static SeekableByteChannel position(SeekableByteChannel seekableByteChannel, long l2) {
            try {
                SeekableByteChannel seekableByteChannel2 = seekableByteChannel.position(l2);
                return seekableByteChannel2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long size(SeekableByteChannel seekableByteChannel) {
            try {
                long l2 = seekableByteChannel.size();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static SeekableByteChannel truncate(SeekableByteChannel seekableByteChannel, long l2) {
            try {
                SeekableByteChannel seekableByteChannel2 = seekableByteChannel.truncate(l2);
                return seekableByteChannel2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] read(SeekableByteChannel seekableByteChannel, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                ByteBuffer byteBuffer = (ByteBuffer)byteBufferWithReadOnlyMarshaller.read(binaryInput);
                int n2 = seekableByteChannel.read(byteBuffer);
                int n3 = 4 + byteBufferWithReadOnlyMarshaller.inferUpdateSize((Object)byteBuffer);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n3 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n3) : BinaryOutput.create((byte[])byArray);
                byteArrayBinaryOutput.writeInt(n2);
                byteBufferWithReadOnlyMarshaller.writeUpdate((BinaryOutput)byteArrayBinaryOutput, (Object)byteBuffer);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] write(SeekableByteChannel seekableByteChannel, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                ByteBuffer byteBuffer = (ByteBuffer)byteBufferWithWriteOnlyMarshaller.read(binaryInput);
                int n2 = seekableByteChannel.write(byteBuffer);
                int n3 = 4 + byteBufferWithWriteOnlyMarshaller.inferUpdateSize((Object)byteBuffer);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n3 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n3) : BinaryOutput.create((byte[])byArray);
                byteArrayBinaryOutput.writeInt(n2);
                byteBufferWithWriteOnlyMarshaller.writeUpdate((BinaryOutput)byteArrayBinaryOutput, (Object)byteBuffer);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferWithReadOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[]{PolyglotJNIConfig.ReadOnly.class});
            byteBufferWithWriteOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[]{PolyglotJNIConfig.WriteOnly.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

