/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSSourcePredicate;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.function.Predicate;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

final class HSSourcePredicateGen {
    HSSourcePredicateGen() {
    }

    static HSSourcePredicate createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSSourcePredicate {
        private static final BinaryMarshaller<Object> objectWithSourceReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithSourceReceiverMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithSourceReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.testMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithSourceReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.SourceReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod testMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.testMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"test", (String)"(Ljava/util/function/Predicate;[B)Z");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Object> objectWithSourceReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static boolean test(Predicate<Object> predicate, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithSourceReceiverMarshaller.read(binaryInput);
                boolean bl = predicate.test(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithSourceReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.SourceReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

