/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lucene.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.lucene.Indexed;
import org.hibernate.lucene.store.DirectoryProvider;
import org.hibernate.lucene.store.FSDirectoryProvider;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryProviderFactory {
    public List<DirectoryProvider<?>> providers = new ArrayList();
    private static String LUCENE_PREFIX = "hibernate.lucene.";
    private static String LUCENE_DEFAULT = LUCENE_PREFIX + "default.";
    private static String DEFAULT_DIRECTORY_PROVIDER = FSDirectoryProvider.class.getName();

    public DirectoryProvider<?> createDirectoryProvider(Class<?> entity, Configuration cfg) {
        Properties indexProps = DirectoryProviderFactory.getDirectoryProperties(cfg, entity);
        String className = indexProps.getProperty("directory_provider");
        if (StringHelper.isEmpty((String)className)) {
            className = DEFAULT_DIRECTORY_PROVIDER;
        }
        DirectoryProvider provider = null;
        try {
            Class directoryClass = ReflectHelper.classForName((String)className, DirectoryProviderFactory.class);
            provider = (DirectoryProvider)directoryClass.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instanciate directory provider: " + className, (Throwable)e);
        }
        provider.initialize(entity, cfg, indexProps);
        int index = this.providers.indexOf(provider);
        if (index != -1) {
            return this.providers.get(index);
        }
        this.providers.add(provider);
        return provider;
    }

    private static Properties getDirectoryProperties(Configuration cfg, Class<?> entity) {
        Properties props = cfg.getProperties();
        String indexName = LUCENE_PREFIX + DirectoryProviderFactory.getTypeName(entity);
        Properties indexProps = new Properties();
        Properties indexSpecificProps = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(LUCENE_DEFAULT)) {
                indexProps.setProperty(key.substring(LUCENE_DEFAULT.length()), (String)entry.getValue());
                continue;
            }
            if (!key.startsWith(indexName)) continue;
            indexSpecificProps.setProperty(key.substring(indexName.length()), (String)entry.getValue());
        }
        indexProps.putAll((Map<?, ?>)indexSpecificProps);
        return indexProps;
    }

    public static String getTypeName(Class<?> clazz) {
        String name = clazz.getAnnotation(Indexed.class).index();
        return "".equals(name) ? clazz.getName() : name;
    }
}

