/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class InAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private Object[] values;

    public InAuditExpression(PropertyNameGetter propertyNameGetter, Object[] values) {
        this.propertyNameGetter = propertyNameGetter;
        this.values = values;
    }

    @Override
    public void addToQuery(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(auditCfg, versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(auditCfg, entityName, propertyName);
        parameters.addWhereWithParams(propertyName, "in (", this.values, ")");
    }
}

