/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache;

import java.util.EnumSet;
import java.util.Set;
import javax.cache.Cache;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.jcache.JCacheRegion;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cache.spi.access.AccessType;

public class JCacheTransactionalDataRegion
extends JCacheRegion
implements TransactionalDataRegion {
    private static final Set<AccessType> SUPPORTED_ACCESS_TYPES = EnumSet.of(AccessType.READ_ONLY, AccessType.NONSTRICT_READ_WRITE, AccessType.READ_WRITE);
    private final CacheDataDescription metadata;
    private final SessionFactoryOptions options;

    public JCacheTransactionalDataRegion(Cache<Object, Object> cache, CacheDataDescription metadata, SessionFactoryOptions options) {
        super(cache);
        this.metadata = metadata;
        this.options = options;
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    protected void throwIfAccessTypeUnsupported(AccessType accessType) {
        if (!this.supportedAccessTypes().contains(accessType)) {
            throw new UnsupportedOperationException("JCacheTransactionalDataRegion doesn't support " + accessType);
        }
    }

    protected Set<AccessType> supportedAccessTypes() {
        return SUPPORTED_ACCESS_TYPES;
    }

    public void clear() {
        this.cache.removeAll();
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public void remove(Object key) {
        this.cache.remove(key);
    }

    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public boolean putIfAbsent(Object key, Object value) {
        return this.cache.putIfAbsent(key, value);
    }

    public boolean replace(Object key, Object expected, Object value) {
        return this.cache.replace(key, expected, value);
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.options;
    }
}

