/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.TypeKindVisitor6;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;
import org.hibernate.validator.ap.util.ConstraintHelper;

public class CrossParameterConstraintCheck
extends AbstractConstraintCheck {
    private final AnnotationApiHelper annotationApiHelper;
    private final ConstraintHelper constraintHelper;
    private final Types typeUtils;

    public CrossParameterConstraintCheck(AnnotationApiHelper annotationApiHelper, ConstraintHelper constraintHelper, Types typeUtils) {
        this.annotationApiHelper = annotationApiHelper;
        this.constraintHelper = constraintHelper;
        this.typeUtils = typeUtils;
    }

    @Override
    public Set<ConstraintCheckIssue> checkAnnotationType(TypeElement element, AnnotationMirror annotation) {
        if (!this.constraintHelper.isConstraintAnnotation(element)) {
            return Collections.emptySet();
        }
        DeclaredType elementType = element.asType().accept(new TypeKindVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        Set<ConstraintHelper.AnnotationProcessorValidationTarget> targets = this.constraintHelper.getSupportedValidationTargets(elementType);
        if (!targets.contains((Object)ConstraintHelper.AnnotationProcessorValidationTarget.PARAMETERS)) {
            return Collections.emptySet();
        }
        ConstraintHelper.ConstraintCheckResult res = this.constraintHelper.checkCrossParameterTypes(elementType);
        if (res == ConstraintHelper.ConstraintCheckResult.MULTIPLE_VALIDATORS_FOUND) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "CROSS_PARAMETER_CONSTRAINT_MULTIPLE_VALIDATORS", element.getSimpleName().toString()));
        }
        if (res == ConstraintHelper.ConstraintCheckResult.DISALLOWED) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "CROSS_PARAMETER_CONSTRAINT_VALIDATOR_HAS_INVALID_TYPE", element.getSimpleName()));
        }
        ExecutableElement validationAppliesTo = this.getValidationAppliesToMethod(element);
        if (validationAppliesTo == null && targets.size() > 1) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "CROSS_PARAMETER_VALIDATION_APPLIES_TO_REQUIRED", element.getSimpleName()));
        }
        if (validationAppliesTo != null) {
            if (!this.checkValidationAppliesToReturnType(validationAppliesTo)) {
                return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "CROSS_PARAMETER_VALIDATION_APPLIES_TO_MUST_HAVE_CONSTRAINT_TARGET_RETURN_TYPE", element.getSimpleName()));
            }
            if (!this.checkValidationAppliesToDefaultValue(validationAppliesTo)) {
                return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "CROSS_PARAMETER_VALIDATION_APPLIES_TO_MUST_HAVE_IMPLICIT_DEFAULT_VALUE", element.getSimpleName()));
            }
        }
        return Collections.emptySet();
    }

    private boolean checkValidationAppliesToReturnType(ExecutableElement validationAppliesToMethod) {
        final DeclaredType constraintTargetType = this.annotationApiHelper.getDeclaredTypeByName("javax.validation.ConstraintTarget");
        return validationAppliesToMethod.getReturnType().accept(new TypeKindVisitor6<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Void p) {
                if (CrossParameterConstraintCheck.this.typeUtils.isSameType(constraintTargetType, t)) {
                    return true;
                }
                return false;
            }
        }, null);
    }

    private boolean checkValidationAppliesToDefaultValue(ExecutableElement validationAppliesToMethod) {
        final DeclaredType constraintTargetType = this.annotationApiHelper.getDeclaredTypeByName("javax.validation.ConstraintTarget");
        return validationAppliesToMethod.getDefaultValue().accept(new SimpleAnnotationValueVisitor6<Boolean, Void>(){

            @Override
            public Boolean visitEnumConstant(VariableElement c, Void p) {
                if (CrossParameterConstraintCheck.this.typeUtils.isSameType(constraintTargetType, c.asType())) {
                    return c.getSimpleName().contentEquals("IMPLICIT");
                }
                return false;
            }
        }, null);
    }

    private ExecutableElement getValidationAppliesToMethod(Element annotation) {
        for (Element element : annotation.getEnclosedElements()) {
            ExecutableElement method = element.accept(new ElementKindVisitor6<ExecutableElement, Void>(){

                @Override
                public ExecutableElement visitExecutableAsMethod(ExecutableElement e, Void p) {
                    if (e.getSimpleName().contentEquals("validationAppliesTo")) {
                        return e;
                    }
                    return null;
                }
            }, null);
            if (method == null) continue;
            return method;
        }
        return null;
    }
}

