/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.classchecks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.classchecks.AbstractClassCheck;
import org.hibernate.validator.ap.classchecks.MethodInheritanceTree;
import org.hibernate.validator.ap.util.ConstraintHelper;

public abstract class AbstractMethodOverrideCheck
extends AbstractClassCheck {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final Elements elementUtils;
    private final Types typeUtils;
    protected ConstraintHelper constraintHelper;

    public AbstractMethodOverrideCheck(Elements elementUtils, Types typeUtils, ConstraintHelper constraintHelper) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.constraintHelper = constraintHelper;
    }

    @Override
    public Set<ConstraintCheckIssue> checkMethod(ExecutableElement currentMethod) {
        if (!this.needToPerformAnyChecks(currentMethod)) {
            return Collections.emptySet();
        }
        MethodInheritanceTree overriddenMethodsTree = this.findAllOverriddenElements(currentMethod);
        if (!overriddenMethodsTree.hasOverriddenMethods()) {
            return Collections.emptySet();
        }
        return this.checkMethodInternal(currentMethod, overriddenMethodsTree);
    }

    protected abstract Set<ConstraintCheckIssue> checkMethodInternal(ExecutableElement var1, MethodInheritanceTree var2);

    protected abstract boolean needToPerformAnyChecks(ExecutableElement var1);

    private MethodInheritanceTree findAllOverriddenElements(ExecutableElement overridingMethod) {
        TypeElement currentTypeElement = this.getEnclosingTypeElement(overridingMethod);
        MethodInheritanceTree.Builder methodInheritanceTreeBuilder = new MethodInheritanceTree.Builder(overridingMethod);
        this.collectOverriddenMethods(overridingMethod, currentTypeElement, methodInheritanceTreeBuilder);
        return methodInheritanceTreeBuilder.build();
    }

    private void collectOverriddenMethods(ExecutableElement overridingMethod, TypeElement currentTypeElement, MethodInheritanceTree.Builder methodInheritanceTreeBuilder) {
        if (this.isJavaLangObjectOrNull(currentTypeElement)) {
            return;
        }
        this.collectOverriddenMethodsInInterfaces(overridingMethod, currentTypeElement, methodInheritanceTreeBuilder);
        TypeElement superclassTypeElement = (TypeElement)this.typeUtils.asElement(currentTypeElement.getSuperclass());
        if (superclassTypeElement == null) {
            return;
        }
        ExecutableElement overriddenMethod = this.getOverriddenMethod(overridingMethod, superclassTypeElement);
        if (overriddenMethod != null) {
            methodInheritanceTreeBuilder.addOverriddenMethod(overridingMethod, overriddenMethod);
            overridingMethod = overriddenMethod;
        }
        this.collectOverriddenMethods(overridingMethod, superclassTypeElement, methodInheritanceTreeBuilder);
    }

    private void collectOverriddenMethodsInInterfaces(ExecutableElement overridingMethod, TypeElement currentTypeElement, MethodInheritanceTree.Builder methodInheritanceTreeBuilder) {
        for (TypeMirror typeMirror : currentTypeElement.getInterfaces()) {
            ExecutableElement newOverridingMethod;
            TypeElement interfaceTypeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
            ExecutableElement overriddenMethod = this.getOverriddenMethod(overridingMethod, interfaceTypeElement);
            if (overriddenMethod != null) {
                methodInheritanceTreeBuilder.addOverriddenMethod(overridingMethod, overriddenMethod);
                newOverridingMethod = overriddenMethod;
            } else {
                newOverridingMethod = overridingMethod;
            }
            this.collectOverriddenMethodsInInterfaces(newOverridingMethod, interfaceTypeElement, methodInheritanceTreeBuilder);
        }
    }

    private ExecutableElement getOverriddenMethod(ExecutableElement currentMethod, TypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        TypeElement enclosingTypeElement = this.getEnclosingTypeElement(currentMethod);
        for (Element element : this.elementUtils.getAllMembers(typeElement)) {
            if (!element.getKind().equals((Object)ElementKind.METHOD) || !this.elementUtils.overrides(currentMethod, (ExecutableElement)element, enclosingTypeElement)) continue;
            return (ExecutableElement)element;
        }
        return null;
    }

    private TypeElement getEnclosingTypeElement(ExecutableElement currentMethod) {
        return (TypeElement)this.typeUtils.asElement(currentMethod.getEnclosingElement().asType());
    }

    protected String getEnclosingTypeElementQualifiedName(ExecutableElement currentMethod) {
        return this.getEnclosingTypeElement(currentMethod).getQualifiedName().toString();
    }

    private boolean isJavaLangObjectOrNull(TypeElement typeElement) {
        return typeElement == null || JAVA_LANG_OBJECT.contentEquals(typeElement.getQualifiedName());
    }
}

