/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.community.dialect.MySQLLegacyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.MySQLSqlAstTranslator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class MySQLLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public MySQLLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    protected void visitRecursivePath(Expression recursivePath, int sizeEstimate) {
        if (sizeEstimate == -1) {
            super.visitRecursivePath(recursivePath, sizeEstimate);
        } else {
            this.appendSql("cast(");
            recursivePath.accept((SqlAstWalker)this);
            this.appendSql(" as char(");
            this.appendSql(sizeEstimate);
            this.appendSql("))");
        }
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected String getForShare(int timeoutMillis) {
        return this.getDialect().getVersion().isSameOrAfter(8) ? " for share" : " lock in share mode";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        if (this.getDialect().getVersion().isSameOrAfter(8)) {
            super.visitQueryPartTableReference(tableReference);
        } else {
            this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonDistinctOperator(lhs, operator, rhs);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitLikePredicate(LikePredicate likePredicate) {
        if (this.getDialect().getVersion().isSameOrAfter(8, 0, 24)) {
            super.visitLikePredicate(likePredicate);
            if (!this.getDialect().isNoBackslashEscapesEnabled() && likePredicate.getEscapeCharacter() == null) {
                this.appendSql(" escape ''");
            }
        } else {
            if (likePredicate.isCaseSensitive()) {
                likePredicate.getMatchExpression().accept((SqlAstWalker)this);
                if (likePredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" like ");
                this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.getDialect().isNoBackslashEscapesEnabled());
            } else {
                this.appendSql(this.getDialect().getLowercaseFunction());
                this.appendSql('(');
                likePredicate.getMatchExpression().accept((SqlAstWalker)this);
                this.appendSql(')');
                if (likePredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" like ");
                this.appendSql(this.getDialect().getLowercaseFunction());
                this.appendSql('(');
                this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.getDialect().isNoBackslashEscapesEnabled());
                this.appendSql(')');
            }
            if (likePredicate.getEscapeCharacter() != null) {
                this.appendSql(" escape ");
                likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
            }
        }
    }

    public boolean supportsRowValueConstructorSyntaxInSet() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getDialect().getVersion().isSameOrAfter(5, 7);
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected boolean supportsIntersect() {
        return false;
    }

    protected boolean supportsDistinctFromPredicate() {
        return true;
    }

    protected boolean supportsSimpleQueryGrouping() {
        return this.getDialect().getVersion().isSameOrAfter(8);
    }

    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    protected boolean supportsWithClause() {
        return this.getDialect().getVersion().isSameOrAfter(8);
    }

    protected String getFromDual() {
        return " from dual";
    }

    protected String getFromDualForSelectOnly() {
        return this.getDialect().getVersion().isSameOrAfter(8) ? "" : this.getFromDual();
    }

    public MySQLLegacyDialect getDialect() {
        return (MySQLLegacyDialect)DialectDelegateWrapper.extractRealDialect((Dialect)super.getDialect());
    }

    public void visitCastTarget(CastTarget castTarget) {
        String sqlType = MySQLSqlAstTranslator.getSqlType((CastTarget)castTarget, (SessionFactoryImplementor)this.getSessionFactory());
        if (sqlType != null) {
            this.appendSql(sqlType);
        } else {
            super.visitCastTarget(castTarget);
        }
    }

    protected void renderStringContainsExactlyPredicate(Expression haystack, Expression needle) {
        haystack.accept((SqlAstWalker)this);
        this.appendSql(" like concat('%',replace(replace(replace(");
        needle.accept((SqlAstWalker)this);
        this.appendSql(",'~','~~'),'?','~?'),'%','~%'),'%') escape '~'");
    }
}

