/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.license.maven.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class DependencyMatcher {
    private final Log logger;
    private final List<Pattern> patterns;
    private static final Pattern GATC = Pattern.compile("^([^:]+):([^:]+)((:([^:]+))?:([^:]+))?$");

    public DependencyMatcher(Log logger, List<String> globs) throws MojoExecutionException {
        this.logger = logger;
        if (globs != null) {
            this.patterns = new ArrayList<Pattern>(globs.size());
            for (String glob : globs) {
                this.patterns.add(DependencyMatcher.createPattern(glob));
            }
        } else {
            this.patterns = null;
        }
    }

    public boolean isMatch(Dependency dependency) {
        if (this.patterns != null) {
            String s = this.gatc(dependency);
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(s).matches()) continue;
                this.logger.debug((CharSequence)(dependency.getArtifactId() + " matches " + pattern.pattern()));
                return true;
            }
        }
        return false;
    }

    private static Pattern createPattern(String glob) throws MojoExecutionException {
        Matcher matcher = GATC.matcher(glob);
        if (!matcher.matches()) {
            throw new MojoExecutionException(glob + " does not match groupId:artifactId[[:type]:classifier]");
        }
        StringBuilder sb = new StringBuilder(128);
        DependencyMatcher.globToRegex(sb, matcher.group(1));
        DependencyMatcher.globToRegex(sb, matcher.group(2));
        DependencyMatcher.globToRegex(sb, matcher.group(5));
        DependencyMatcher.globToRegex(sb, matcher.group(6));
        return Pattern.compile(sb.append('$').toString());
    }

    private static void globToRegex(StringBuilder dst, String src) {
        if (dst.length() == 0) {
            dst.append('^');
        } else {
            dst.append(':');
        }
        if (src == null) {
            dst.append(".*");
        } else {
            block6: for (int i = 0; i < src.length(); ++i) {
                char c = src.charAt(i);
                switch (c) {
                    case '\\': {
                        dst.append(c);
                        dst.append(src.charAt(++i));
                        continue block6;
                    }
                    case '.': {
                        dst.append("\\.");
                        continue block6;
                    }
                    case '?': {
                        dst.append('.');
                        continue block6;
                    }
                    case '*': {
                        dst.append(".*");
                        continue block6;
                    }
                    default: {
                        dst.append(c);
                    }
                }
            }
        }
    }

    private String gatc(Dependency dependency) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(dependency.getGroupId()).append(':').append(dependency.getArtifactId()).append(':').append(dependency.getType()).append(':');
        String classifier = dependency.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            sb.append(classifier);
        }
        return sb.toString();
    }
}

