/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.DToA;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;

final class NativeNumber
extends ScriptableObject {
    private static final long serialVersionUID = 3504516769741512101L;
    public static final double MAX_SAFE_INTEGER = 9.007199254740991E15;
    private static final String CLASS_NAME = "Number";
    private static final int MAX_PRECISION = 100;
    private static final double MIN_SAFE_INTEGER = -9.007199254740991E15;
    private static final double EPSILON = 2.220446049250313E-16;
    private final double doubleValue;

    static void init(Scriptable scope, boolean sealed) {
        Object parseInt;
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 1, NativeNumber::js_constructorFunc, NativeNumber::js_constructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.setPrototypeScriptable(new NativeNumber(0.0));
        int propAttr = 7;
        constructor.defineProperty("NaN", (Object)ScriptRuntime.NaNobj, 7);
        constructor.defineProperty("POSITIVE_INFINITY", (Object)ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        constructor.defineProperty("NEGATIVE_INFINITY", (Object)ScriptRuntime.wrapNumber(Double.NEGATIVE_INFINITY), 7);
        constructor.defineProperty("MAX_VALUE", (Object)ScriptRuntime.wrapNumber(Double.MAX_VALUE), 7);
        constructor.defineProperty("MIN_VALUE", (Object)ScriptRuntime.wrapNumber(Double.MIN_VALUE), 7);
        constructor.defineProperty("MAX_SAFE_INTEGER", (Object)ScriptRuntime.wrapNumber(9.007199254740991E15), 7);
        constructor.defineProperty("MIN_SAFE_INTEGER", (Object)ScriptRuntime.wrapNumber(-9.007199254740991E15), 7);
        constructor.defineProperty("EPSILON", (Object)ScriptRuntime.wrapNumber(2.220446049250313E-16), 7);
        constructor.defineConstructorMethod(scope, "isFinite", 1, NativeNumber::js_isFinite, 2, 3);
        constructor.defineConstructorMethod(scope, "isNaN", 1, NativeNumber::js_isNaN, 2, 3);
        constructor.defineConstructorMethod(scope, "isInteger", 1, NativeNumber::js_isInteger, 2, 3);
        constructor.defineConstructorMethod(scope, "isSafeInteger", 1, NativeNumber::js_isSafeInteger, 2, 3);
        Object parseFloat = ScriptRuntime.getTopLevelProp(constructor, "parseFloat");
        if (parseFloat instanceof Function) {
            constructor.defineProperty("parseFloat", parseFloat, 2);
        }
        if ((parseInt = ScriptRuntime.getTopLevelProp(constructor, "parseInt")) instanceof Function) {
            constructor.defineProperty("parseInt", parseInt, 2);
        }
        constructor.definePrototypeMethod(scope, "toString", 1, NativeNumber::js_toString, 2, 3);
        constructor.definePrototypeMethod(scope, "toLocaleString", 0, NativeNumber::js_toString, 2, 3);
        constructor.definePrototypeMethod(scope, "toSource", 0, NativeNumber::js_toSource, 2, 3);
        constructor.definePrototypeMethod(scope, "valueOf", 0, (lcx, lscope, thisObj, args) -> NativeNumber.toSelf((Scriptable)thisObj).doubleValue, 2, 3);
        constructor.definePrototypeMethod(scope, "toFixed", 1, NativeNumber::js_toFixed, 2, 3);
        constructor.definePrototypeMethod(scope, "toExponential", 1, NativeNumber::js_toExponential, 2, 3);
        constructor.definePrototypeMethod(scope, "toPrecision", 1, NativeNumber::js_toPrecision, 2, 3);
        ScriptableObject.defineProperty(scope, CLASS_NAME, constructor, 2);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
    }

    NativeNumber(double number) {
        this.doubleValue = number;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static Scriptable js_constructor(Context cx, Scriptable scope, Object[] args) {
        double val = args.length > 0 ? ScriptRuntime.toNumeric(args[0]).doubleValue() : 0.0;
        return new NativeNumber(val);
    }

    private static Object js_constructorFunc(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return args.length > 0 ? ScriptRuntime.toNumeric(args[0]).doubleValue() : 0.0;
    }

    private static Object js_toFixed(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int precisionMin = 0;
        double value = NativeNumber.toSelf((Scriptable)thisObj).doubleValue;
        return NativeNumber.num_to(value, args, 2, 2, precisionMin, 0);
    }

    private static Object js_toExponential(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double value = NativeNumber.toSelf((Scriptable)thisObj).doubleValue;
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            if (value >= 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        return NativeNumber.num_to(value, args, 1, 3, 0, 1);
    }

    private static Object js_toPrecision(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double value = NativeNumber.toSelf((Scriptable)thisObj).doubleValue;
        if (args.length == 0 || Undefined.isUndefined(args[0])) {
            return ScriptRuntime.numberToString(value, 10);
        }
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            if (value >= 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        return NativeNumber.num_to(value, args, 0, 4, 1, 0);
    }

    private static NativeNumber toSelf(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeNumber.class);
    }

    private static Object js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int base = args.length == 0 || Undefined.isUndefined(args[0]) ? 10 : ScriptRuntime.toInt32(args[0]);
        return ScriptRuntime.numberToString(NativeNumber.toSelf((Scriptable)thisObj).doubleValue, base);
    }

    private static Object js_toSource(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return "(new Number(" + ScriptRuntime.toString(NativeNumber.toSelf((Scriptable)thisObj).doubleValue) + "))";
    }

    private static Number argToNumber(Object[] args) {
        if (args.length > 0 && args[0] instanceof Number) {
            return (Number)args[0];
        }
        return null;
    }

    public String toString() {
        return ScriptRuntime.numberToString(this.doubleValue, 10);
    }

    private static String num_to(double val, Object[] args, int zeroArgMode, int oneArgMode, int precisionMin, int precisionOffset) {
        int precision;
        if (args.length == 0) {
            precision = 0;
            oneArgMode = zeroArgMode;
        } else {
            double p = ScriptRuntime.toInteger(args[0]);
            if (p < (double)precisionMin || p > 100.0) {
                String msg = ScriptRuntime.getMessageById("msg.bad.precision", ScriptRuntime.toString(args[0]));
                throw ScriptRuntime.rangeError(msg);
            }
            precision = ScriptRuntime.toInt32(p);
        }
        StringBuilder sb = new StringBuilder();
        DToA.JS_dtostr(sb, oneArgMode, precision + precisionOffset, val);
        return sb.toString();
    }

    private static Object js_isFinite(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Number n = NativeNumber.argToNumber(args);
        return n == null ? Boolean.FALSE : NativeNumber.isFinite(n);
    }

    static Object isFinite(Object val) {
        double nd = ScriptRuntime.toNumber(val);
        return ScriptRuntime.wrapBoolean(!Double.isInfinite(nd) && !Double.isNaN(nd));
    }

    private static Object js_isNaN(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Number val = NativeNumber.argToNumber(args);
        if (val == null) {
            return false;
        }
        if (val instanceof Double) {
            return ((Double)val).isNaN();
        }
        double d = val.doubleValue();
        return Double.isNaN(d);
    }

    private static Object js_isInteger(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Number val = NativeNumber.argToNumber(args);
        if (val == null) {
            return false;
        }
        if (val instanceof Double) {
            return NativeNumber.isDoubleInteger((Double)val);
        }
        return NativeNumber.isDoubleInteger(val.doubleValue());
    }

    private static Object js_isSafeInteger(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Number val = NativeNumber.argToNumber(args);
        if (val == null) {
            return false;
        }
        if (val instanceof Double) {
            return NativeNumber.isDoubleSafeInteger((Double)val);
        }
        return NativeNumber.isDoubleSafeInteger(val.doubleValue());
    }

    private static boolean isDoubleInteger(Double d) {
        return !d.isInfinite() && !d.isNaN() && Math.floor(d) == d;
    }

    private static boolean isDoubleInteger(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d) && Math.floor(d) == d;
    }

    private static boolean isDoubleSafeInteger(Double d) {
        return NativeNumber.isDoubleInteger(d) && d <= 9.007199254740991E15 && d >= -9.007199254740991E15;
    }

    private static boolean isDoubleSafeInteger(double d) {
        return NativeNumber.isDoubleInteger(d) && d <= 9.007199254740991E15 && d >= -9.007199254740991E15;
    }
}

