/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.ast;

import org.htmlunit.corejs.javascript.ast.AbstractObjectProperty;
import org.htmlunit.corejs.javascript.ast.AstNode;
import org.htmlunit.corejs.javascript.ast.NodeVisitor;

public class ObjectProperty
extends AbstractObjectProperty {
    private AstNode key;
    private AstNode value;
    private boolean shorthand;

    public void setNodeType(int nodeType) {
        if (nodeType != 117 && nodeType != 166 && nodeType != 167 && nodeType != 178) {
            throw new IllegalArgumentException("invalid node type: " + nodeType);
        }
        this.setType(nodeType);
    }

    public ObjectProperty() {
        this.type = 117;
    }

    public ObjectProperty(int pos) {
        super(pos);
        this.type = 117;
    }

    public void setKeyAndValue(AstNode key, AstNode value) {
        this.assertNotNull(key);
        this.assertNotNull(value);
        this.key = key;
        this.value = value;
        int beg = key.getPosition();
        int end = value.getPosition() + value.getLength();
        this.setBounds(beg, end);
        this.setLineColumnNumber(key.getLineno(), key.getColumn());
        key.setParent(this);
        value.setParent(this);
    }

    public void setIsGetterMethod() {
        this.type = 166;
    }

    public boolean isGetterMethod() {
        return this.type == 166;
    }

    public void setIsSetterMethod() {
        this.type = 167;
    }

    public boolean isSetterMethod() {
        return this.type == 167;
    }

    public void setIsNormalMethod() {
        this.type = 178;
    }

    public boolean isNormalMethod() {
        return this.type == 178;
    }

    public boolean isMethod() {
        return this.isGetterMethod() || this.isSetterMethod() || this.isNormalMethod();
    }

    public AstNode getKey() {
        return this.key;
    }

    public AstNode getValue() {
        return this.value;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth + 1));
        if (this.isGetterMethod()) {
            sb.append("get ");
        } else if (this.isSetterMethod()) {
            sb.append("set ");
        }
        sb.append(this.key.toSource(this.getType() == 117 ? 0 : depth));
        if (!this.shorthand) {
            if (this.type == 117) {
                sb.append(": ");
            }
            sb.append(this.value.toSource(this.getType() == 117 ? 0 : depth + 1));
        }
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            this.key.visit(v);
            this.value.visit(v);
        }
    }
}

