/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.PolarionJUnitTest;
import org.infinispan.commons.test.PolarionJUnitXMLWriter;
import org.infinispan.commons.test.TestSuiteProgress;
import org.infinispan.commons.test.skip.OS;

class RunningTestsRegistry {
    private static final long MAX_TEST_SECONDS = Long.parseUnsignedLong(System.getProperty("infinispan.test.maxTestSeconds", "300"));
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "RunningTestsRegistry-Worker"));
    private static final Map<Thread, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap();

    RunningTestsRegistry() {
    }

    static void unregisterThreadWithTest() {
        ScheduledFuture<?> killTask = scheduledTasks.remove(Thread.currentThread());
        if (killTask != null) {
            killTask.cancel(false);
        }
    }

    static void registerThreadWithTest(String testName, String simpleName) {
        Thread testThread = Thread.currentThread();
        ScheduledFuture<?> future = executor.schedule(() -> RunningTestsRegistry.killLongTest(testThread, testName, simpleName), MAX_TEST_SECONDS, TimeUnit.SECONDS);
        scheduledTasks.put(testThread, future);
    }

    private static void killLongTest(Thread testThread, String testName, String simpleName) {
        RuntimeException exception = new RuntimeException(String.format("Test timed out after %d seconds", MAX_TEST_SECONDS));
        exception.setStackTrace(testThread.getStackTrace());
        TestSuiteProgress.fakeTestFailure(testName, exception);
        RunningTestsRegistry.writeJUnitReport(testName, exception);
        List<String> pids = RunningTestsRegistry.collectChildProcesses();
        String safeTestName = simpleName.replaceAll("[^a-zA-Z0-9=]", "_");
        RunningTestsRegistry.dumpThreads(safeTestName, pids);
        RunningTestsRegistry.killTest(testThread, pids);
    }

    private static void writeJUnitReport(String testName, RuntimeException exception) {
        try {
            File reportsDir = new File("target/surefire-reports");
            if (!reportsDir.exists() && !reportsDir.mkdirs()) {
                throw new IOException("Cannot create report directory " + reportsDir.getAbsolutePath());
            }
            PolarionJUnitXMLWriter writer = new PolarionJUnitXMLWriter(new File(reportsDir, "TEST-" + testName + "-Timeout.xml"));
            String property = System.getProperty("infinispan.modulesuffix");
            String moduleName = property != null ? property.substring(1) : "";
            writer.start(moduleName, 1L, 0L, 1L, 0L, false);
            writer.writeTestCase(new PolarionJUnitTest("Timeout", testName, exception));
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reporting thread leaks", e);
        }
    }

    private static List<String> collectChildProcesses() {
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            String ppid = jvmName.split("@")[0];
            ArrayList<String> pids = new ArrayList<String>(Collections.singletonList(ppid));
            for (int index = 0; index < pids.size(); ++index) {
                String pid = (String)pids.get(index);
                if (OS.getCurrentOs() == OS.WINDOWS) continue;
                Process ps = new ProcessBuilder(new String[0]).command("ps", "-o", "pid=,comm=", "--ppid", pid).start();
                try (BufferedReader psOutput = new BufferedReader(new InputStreamReader(ps.getInputStream()));){
                    psOutput.lines().forEach(line -> {
                        String[] pidAndCommand = line.trim().split("\\s+");
                        if (!"ps".equals(pidAndCommand[1])) {
                            pids.add(pidAndCommand[0]);
                        }
                    });
                }
                ps.waitFor(10L, TimeUnit.SECONDS);
            }
            return pids;
        }
        catch (Exception e) {
            System.err.println("Error collecting child processes:");
            e.printStackTrace(System.err);
            return Collections.emptyList();
        }
    }

    private static void dumpThreads(String safeTestName, List<String> pids) {
        block11: {
            try {
                String extension = OS.getCurrentOs() == OS.WINDOWS ? ".exe" : "";
                String javaHome = System.getProperty("java.home");
                File jstackFile = new File(javaHome, "bin/jstack" + extension);
                if (!jstackFile.canExecute()) {
                    jstackFile = new File(javaHome, "../bin/jstack" + extension);
                }
                LocalDateTime now = LocalDateTime.now();
                if (jstackFile.canExecute() && !pids.isEmpty()) {
                    for (String pid : pids) {
                        File dumpFile = new File(String.format("threaddump-%1$s-%2$tY%2$tm%2$td-%2$tH%2$tM-%3$s.log", safeTestName, now, pid));
                        System.err.printf("Dumping threads of process %s to %s%n", pid, dumpFile.getAbsolutePath());
                        Process jstack = new ProcessBuilder(new String[0]).command(jstackFile.getAbsolutePath(), "-l", pid).redirectOutput(dumpFile).start();
                        jstack.waitFor(10L, TimeUnit.SECONDS);
                    }
                    break block11;
                }
                File dumpFile = new File(String.format("threaddump-%1$s-%2$tY%2$tm%2$td-%2$tH%2$tM.log", safeTestName, now));
                System.err.printf("Cannot find jstack in %s, programmatically dumping thread stacks of testsuite process to %s%n", javaHome, dumpFile.getAbsolutePath());
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                try (PrintWriter writer = new PrintWriter(new FileWriter(dumpFile));){
                    ThreadInfo[] threads;
                    writer.printf("%1$tF %1$tT\nTest thread dump:%n%n", now);
                    for (ThreadInfo thread : threads = threadMXBean.dumpAllThreads(true, true)) {
                        RunningTestsRegistry.dumpThread(writer, thread);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error dumping threads:");
                e.printStackTrace(System.err);
            }
        }
    }

    private static void killTest(Thread testThread, List<String> pids) {
        try {
            testThread.interrupt();
            System.err.printf("Interrupted thread %s (%d).%n", testThread.getName(), testThread.getId());
            testThread.join(TimeUnit.SECONDS.toMillis(1L));
            if (testThread.isAlive()) {
                Process kill;
                ArrayList<String> command;
                if (OS.getCurrentOs() == OS.WINDOWS) {
                    command = new ArrayList<String>(Arrays.asList("taskkill", "/t", "/f"));
                    for (String pid : pids) {
                        command.add("/pid");
                        command.add(pid);
                    }
                    kill = new ProcessBuilder(new String[0]).command(command).start();
                } else {
                    command = new ArrayList<String>(Collections.singletonList("kill"));
                    command.addAll(pids);
                    kill = new ProcessBuilder(new String[0]).command(command).start();
                }
                kill.waitFor(10L, TimeUnit.SECONDS);
                if (kill.exitValue() == 0) {
                    System.err.printf("Killed processes %s%n", String.join((CharSequence)" ", pids));
                } else {
                    System.err.printf("Failed to kill processes, exit code %d from command %s\n", kill.exitValue(), command);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error killing test:");
            e.printStackTrace(System.err);
        }
    }

    private static void dumpThread(PrintWriter writer, ThreadInfo thread) {
        writer.printf("\"%s\" #%s prio=0 tid=0x%x nid=NA %s%n", thread.getThreadName(), thread.getThreadId(), thread.getThreadId(), thread.getThreadState().toString().toLowerCase());
        writer.printf("   java.lang.Thread.State: %s%n", new Object[]{thread.getThreadState()});
        LockInfo blockedLock = thread.getLockInfo();
        StackTraceElement[] s = thread.getStackTrace();
        MonitorInfo[] monitors = thread.getLockedMonitors();
        for (int i = 0; i < s.length; ++i) {
            StackTraceElement ste = s[i];
            writer.printf("\tat %s\n", ste);
            if (i == 0 && blockedLock != null) {
                boolean parking = ste.isNativeMethod() && ste.getMethodName().equals("park");
                writer.printf("\t- %s <0x%x> (a %s)%n", RunningTestsRegistry.blockedState(thread, blockedLock, parking), blockedLock.getIdentityHashCode(), blockedLock.getClassName());
            }
            if (monitors == null) continue;
            MonitorInfo[] monitorInfoArray = monitors;
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo monitor = monitorInfoArray[j];
                if (monitor.getLockedStackDepth() != i) continue;
                writer.printf("\t- locked <0x%x> (a %s)%n", monitor.getIdentityHashCode(), monitor.getClassName());
            }
        }
        writer.println();
        LockInfo[] synchronizers = thread.getLockedSynchronizers();
        if (synchronizers != null && synchronizers.length > 0) {
            writer.print("\n   Locked ownable synchronizers:\n");
            for (LockInfo synchronizer : synchronizers) {
                writer.printf("\t- <0x%x> (a %s)%n", synchronizer.getIdentityHashCode(), synchronizer.getClassName());
            }
            writer.println();
        }
    }

    private static String blockedState(ThreadInfo thread, LockInfo blockedLock, boolean parking) {
        String state = blockedLock != null ? (thread.getThreadState().equals((Object)Thread.State.BLOCKED) ? "waiting to lock" : (parking ? "parking to wait for" : "waiting on")) : null;
        return state;
    }
}

