/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;

class StreamCorrelatorHandler
extends ChannelDuplexHandler {
    public static final AsciiString STREAM_ID_HEADER = HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text();
    private Integer streamId;

    StreamCorrelatorHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            this.streamId = request.headers().getInt((CharSequence)STREAM_ID_HEADER);
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (this.streamId != null) {
                response.headers().add((CharSequence)STREAM_ID_HEADER, (Object)this.streamId);
            }
        }
        ctx.write(msg, promise);
    }
}

