/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.distribution;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.rest.distribution.NodeDataDistribution;

@ProtoTypeId(value=6002)
public class KeyDistributionInfo
implements JsonSerialization,
NodeDataDistribution {
    private final String name;
    private final boolean primary;
    private final List<String> addresses;

    @ProtoFactory
    public KeyDistributionInfo(String name, boolean primary, List<String> addresses) {
        this.name = name;
        this.primary = primary;
        this.addresses = addresses;
    }

    @Override
    @ProtoField(value=1)
    public String name() {
        return this.name;
    }

    @ProtoField(value=2, defaultValue="false")
    public boolean primary() {
        return this.primary;
    }

    @Override
    @ProtoField(value=3, collectionImplementation=ArrayList.class)
    public List<String> addresses() {
        return this.addresses;
    }

    public Json toJson() {
        return Json.object().set("node_name", (Object)this.name).set("primary", (Object)this.primary).set("node_addresses", Json.array((Object[])this.addresses.toArray()));
    }

    public static KeyDistributionInfo resolve(AdvancedCache<?, ?> cache, boolean primary) {
        CacheManagerInfo manager = cache.getCacheManager().getCacheManagerInfo();
        return new KeyDistributionInfo(manager.getNodeName(), primary, manager.getPhysicalAddressesRaw());
    }
}

