/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks;

import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;
import org.infinispan.security.Security;
import org.infinispan.server.tasks.ServerTaskEngine;
import org.infinispan.server.tasks.ServerTaskRunner;
import org.infinispan.server.tasks.ServerTaskWrapper;
import org.infinispan.tasks.TaskContext;

public class LocalServerTaskRunner
implements ServerTaskRunner {
    private final ServerTaskEngine serverTaskEngine;

    public LocalServerTaskRunner(ServerTaskEngine serverTaskEngine) {
        this.serverTaskEngine = serverTaskEngine;
    }

    @Override
    public <T> CompletableFuture<T> execute(String taskName, TaskContext context) {
        ServerTaskWrapper task = this.serverTaskEngine.getTask(taskName);
        try {
            return CompletableFuture.completedFuture(Security.doAs((Subject)context.subject(), task, (Object)context));
        }
        catch (Exception e) {
            CompletableFuture finishedWithException = new CompletableFuture();
            finishedWithException.completeExceptionally(e);
            return finishedWithException;
        }
    }
}

