/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.RealmReadinessFilter;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;

public class RedirectReadinessFilter
extends RealmReadinessFilter {
    private final String redirectTo;

    RedirectReadinessFilter(SecurityRealm securityRealm, String redirectTo) {
        super(securityRealm);
        this.redirectTo = redirectTo;
    }

    @Override
    void rejectRequest(HttpExchange exchange) throws IOException {
        Headers responseHeaders = exchange.getResponseHeaders();
        responseHeaders.add("Location", DomainUtil.constructUrl(exchange, this.redirectTo));
        exchange.sendResponseHeaders(307, 0L);
        exchange.close();
    }

    public String description() {
        return HttpServerMessages.MESSAGES.redirectReadinessFilter();
    }
}

