/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.context.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.context.variable.VariableViolationException;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.AbstractContextInstance;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;

public class VariableScopeInstance
extends AbstractContextInstance {
    private static final long serialVersionUID = 510L;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private transient String variableIdPrefix = null;
    private transient String variableInstanceIdPrefix = null;

    @Override
    public String getContextType() {
        return "VariableScope";
    }

    public Object getVariable(String name) {
        Object value = this.variables.get(name);
        if (value != null) {
            return value;
        }
        if ("processInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getId();
        }
        if ("parentProcessInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getParentProcessInstanceId();
        }
        if (this.getProcessInstance() != null && this.getProcessInstance().getKnowledgeRuntime() != null) {
            value = this.getProcessInstance().getKnowledgeRuntime().getGlobal(name);
            if (value != null) {
                return value;
            }
            Collection caseFiles = this.getProcessInstance().getKnowledgeRuntime().getObjects((ObjectFilter)new ClassObjectFilter(CaseData.class));
            if (caseFiles.size() == 1) {
                String lookUpName;
                CaseData caseFile = (CaseData)caseFiles.iterator().next();
                String string = lookUpName = name.startsWith("caseFile_") ? name.replaceFirst("caseFile_", "") : name;
                if (caseFile != null) {
                    return caseFile.getData(lookUpName);
                }
            }
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public void setVariable(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The name of a variable may not be null!");
        }
        Object oldValue = this.getVariable(name);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue != null && !oldValue.equals(value) && this.getVariableScope().isReadOnly(name)) {
            throw new VariableViolationException(this.getProcessInstance().getId(), name, "Variable '" + name + "' is already set and is marked as read only");
        }
        ProcessEventSupport processEventSupport = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getProcessEventSupport();
        processEventSupport.fireBeforeVariableChanged((this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, value, this.getVariableScope().tags(name), (ProcessInstance)this.getProcessInstance(), (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        this.internalSetVariable(name, value);
        processEventSupport.fireAfterVariableChanged((this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, value, this.getVariableScope().tags(name), (ProcessInstance)this.getProcessInstance(), (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
    }

    public void internalSetVariable(String name, Object value) {
        if (name.startsWith("caseFile_")) {
            String nameInCaseFile = name.replaceFirst("caseFile_", "");
            Collection caseFiles = this.getProcessInstance().getKnowledgeRuntime().getObjects((ObjectFilter)new ClassObjectFilter(CaseData.class));
            if (caseFiles.size() == 1) {
                CaseData caseFile = (CaseData)caseFiles.iterator().next();
                FactHandle factHandle = this.getProcessInstance().getKnowledgeRuntime().getFactHandle((Object)caseFile);
                if (value == null) {
                    caseFile.remove(nameInCaseFile);
                } else {
                    caseFile.add(nameInCaseFile, value);
                }
                if (this.getProcessInstance().getState() != 0) {
                    this.getProcessInstance().getKnowledgeRuntime().update(factHandle, (Object)caseFile);
                    ((KieSession)this.getProcessInstance().getKnowledgeRuntime()).fireAllRules();
                }
                return;
            }
        }
        this.variables.put(name, value);
    }

    public VariableScope getVariableScope() {
        return (VariableScope)this.getContext();
    }

    @Override
    public void setContextInstanceContainer(ContextInstanceContainer contextInstanceContainer) {
        super.setContextInstanceContainer(contextInstanceContainer);
        for (Variable variable : this.getVariableScope().getVariables()) {
            if (variable.getValue() == null) continue;
            this.setVariable(variable.getName(), variable.getValue());
        }
        if (contextInstanceContainer instanceof CompositeContextNodeInstance) {
            this.variableIdPrefix = ((Node)((CompositeContextNodeInstance)contextInstanceContainer).getNode()).getUniqueId();
            this.variableInstanceIdPrefix = ((CompositeContextNodeInstance)contextInstanceContainer).getUniqueId();
        }
    }

    public void enforceRequiredVariables() {
        VariableScope variableScope = this.getVariableScope();
        for (Variable variable : variableScope.getVariables()) {
            String name = variable.getName();
            if (!variableScope.isRequired(name)) continue;
            if (name.startsWith("caseFile_")) {
                if (this.findCaseData(name)) continue;
                throw new VariableViolationException(this.getProcessInstance().getId(), name, "Case file item '" + name + "' is required but not set");
            }
            if (this.hasData(this.variables.get(name))) continue;
            throw new VariableViolationException(this.getProcessInstance().getId(), name, "Variable '" + name + "' is required but not set");
        }
    }

    protected boolean findCaseData(String name) {
        CaseData caseData;
        boolean found = false;
        String nameInCaseFile = name.replaceFirst("caseFile_", "");
        Collection caseFiles = this.getProcessInstance().getKnowledgeRuntime().getObjects((ObjectFilter)new ClassObjectFilter(CaseData.class));
        if (caseFiles.size() == 1 && this.hasData((caseData = (CaseData)caseFiles.iterator().next()).getData(nameInCaseFile))) {
            found = true;
        }
        return found;
    }

    private boolean hasData(Object data) {
        return data != null && (!(data instanceof CharSequence) || !data.toString().trim().isEmpty());
    }

    public void setDefaultValues(VariableScope variableScope, VariableScopeInstance variableScopeInstance) {
        if (variableScope != null) {
            for (Variable variable : variableScope.getVariables()) {
                String name = variable.getName();
                Object defaultValue = variable.getMetaData("defaultValue");
                if (variableScopeInstance.getVariable(name) != null || defaultValue == null) continue;
                variableScopeInstance.setVariable(name, variable.getType().readValue(defaultValue.toString()));
            }
        }
    }
}

